/**
 * Copyright (c) 2008-2009, Opera Software ASA
 * All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of Opera Software ASA nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY OPERA SOFTWARE ASA AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL OPERA SOFTWARE ASA AND CONTRIBUTORS BE LIABLE FOR ANYs
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

onload = function() {
  var __name__ = "operawidget";
  var __version__ = [3, 21, 0]; // [<major>, <minor>, <revision>]
  
  var twitter = TwitterApi({
    source: __name__,
    format: "xml"
  });
  
  var ANIMATION_SPEED = 300;
  var GOOGLE_MAPS_KEY = "ABQIAAAAdagxvi0_xm0taq1ZsKwkIhQqxKUu_D6fG104whRj1tL6Vala4RTRzMZikKFkEn8Bn9Sf6dmx1ThD9Q";
  
  var refreshTimeout = null;
  var device = testMedia();
  var notifyOnNewTweet = true;
  
  var latLon = widget.preferenceForKey("latLon") || "";
  var location = widget.preferenceForKey("location") || "";
  var username = widget.preferenceForKey("username") || "";
  var password = widget.preferenceForKey("password") || "";
  var activetab = widget.preferenceForKey("activetab") || "friends";
  var updateInterval = widget.preferenceForKey("update-interval") || 10; // Minutes
  var tweetsDisplayed = widget.preferenceForKey("tweets-displayed") || 20;
  
  // If this preference is not set, it's the first time the widget is opened
  if (!widget.preferenceForKey("activetab")) {
    $("#signup").show();
  }
  
  // Initial setup
  if (device == "mobile") {
    widgetResize(screen.availWidth, screen.availHeight);
    jQuery.fx.off = true; // disable animations on devices with limited resources
  }
  
  $("#chars").text(TwitterApi.MAX_CHARS);
  $("#main").attr("class", activetab);
  
  $("#username").val(username).focus();
  $("#password").val(Base64.decode(password));
  
  setLocation(location);
  
  if (widget.preferenceForKey("images-disabled") == "true") {
    $("body").addClass("images-disabled");
    $("#image-switch").removeAttr("checked");
  }
  
  if (widget.preferenceForKey("notify-on-new-tweets") == "false") {
    notifyOnNewTweet = false;
    $("#notify-on-new-tweets").removeAttr("checked");
  }
  
  $("#update-interval option[value=" + updateInterval + "]").attr("selected", true);
  $("#tweets-displayed option[value=" + tweetsDisplayed + "]").attr("selected", true);
  
  // Auto login
  if ($.trim($("#username").val()) != "" && $.trim($("#password").val()) != "") {
    login();
  }
  else {
    $("#clear-credentials").hide();
    $("body").addClass("config-active");
  }
  
  
  //////////////////////////////////////////////////////////////////////////////
  // Event listeners
  //////////////////////////////////////////////////////////////////////////////
  
  $(window).keydown(function(e) {
    if (e.which == 27 /* Esc */) hideTweetInput();
  });
  
  $("#doing").keypress(keySubmit);
  
  $("#doing").bind("keyup keypress change focus", checkLength);
  
  $("#navigation button").click(function(event) {
    $("#main").attr("class", this.id);
  });
  
  $("#user, #replies, #friends, #direct").click(function(event) {
    updateTimeline(this.id);
  });
  
  $("#search").click(function(event) {
    abortCurrentRequest();
    addSearchForm();
    showSearchTrends()
  });
  
  $("#near").click(function(event) {
    showNearbyTweets(widget.preferenceForKey("latLon"));
  });
  
  $("#close").click(function(event) {
    window.close();
  });
  
  $("#no").click(function(event) {
    $("#confirm").hide();
  });
  
  $("#update").click(function(event) {
    postTweet($("#doing").val());
  });
  
  $("#login-form").submit(function(event) {
    event.preventDefault();  
    if ($.trim($("#username").val()) === "" || $("#password").val() === "") {
      if($.trim($("#username").val()) == "") $("#username").focus(); else $("#password").focus();
	  $("#login-status").addClass("error");
      showError($("#login-status"), 401);
    }
    else if ($("#username").val() == widget.preferenceForKey("username") &&
        Base64.encode($("#password").val()) == widget.preferenceForKey("password") &&
        $("body").hasClass("logged-in"))
    {
      $("body").removeClass("loading").removeClass("config-active");
      $("#main").show();
      $("#login").removeAttr("disabled");
    }
    else {
      login();
    }
    resizeContent();
  });
  
  $("#config-switch").mousedown(function(event) { // workaround, click borks on Windows for some reason
    $("body").addClass("config-active");
    $("#main").hide();
    resizeContent();
  });
  
  $("#close").click(function(event) { window.close(); });
  
  $("#post").click(function(event) {
    showTweetInput();
  });
  
  $("#cancel").click(function(event) {
    hideTweetInput();
  });
  
  $("#image-switch").change(function(event) {
    widget.setPreferenceForKey(!$(this).is(":checked"), "images-disabled");
    $("body")[$(this).is(":checked") ? "removeClass" : "addClass"]("images-disabled");
  });
  
  $("#notify-on-new-tweets").change(function(event) {
    widget.setPreferenceForKey($(this).is(":checked"), "notify-on-new-tweets");
    notifyOnNewTweet = $(this).is(":checked");
  });
  
  $("#update-interval").change(function(event) {
    clearTimeout(refreshTimeout);
    updateInterval = parseInt(this.value);
    widget.setPreferenceForKey(updateInterval, "update-interval");
    refreshTimeline();
  });
  
  $("#tweets-displayed").change(function(event) {
    tweetsDisplayed = parseInt(this.value);
    widget.setPreferenceForKey(tweetsDisplayed, "tweets-displayed");
    updateTimeline();
  });
  
  $("#location-option").change(function(event) {
    widget.setPreferenceForKey(this.value, "location");
    widget.setPreferenceForKey("", "latLon");
  });
  
  $("#clear").click(function(event) {
    event.preventDefault();
    widget.setPreferenceForKey("", "username");
    widget.setPreferenceForKey("", "password");
    window.location.reload(); // prevent information leakage
  });
  
  $(".trash").live("click", function(event) {
    event.preventDefault();
    confirmDestroy(this.getAttribute("data-entryid"));
  });
  
  $(".reply").live("click", function(event) {
    event.preventDefault();
    replyTo(this.getAttribute("data-username"), this.getAttribute("data-replyto-id"));
  });
  
  $(".dm").live("click", function(event) {
    event.preventDefault();
    directMessage(this.getAttribute("data-username"));
  });
  
  $(".rt").live("click", function(event) {
    event.preventDefault();
    retweet(this.getAttribute("data-username"), this.getAttribute("data-text"));
  });
  
  $(".tweet a.external").live("click", function(event) {
    event.preventDefault();
    widget.openURL(this.href);
  });
  
  $(".inreplyto").live("click", function(event) {
    event.preventDefault();
    showSingleTweet(this.getAttribute("data-id"));
    clearTimeout(refreshTimeout);
  });
  
  $(".replytoname a").live("click", function(event) {
    event.preventDefault();
    showUserTimeline(this.textContent);
  });
  
  $(".hashtag").live("click", function(event) {
    event.preventDefault();
    $("#main").attr("class", "search");
    search(this.textContent);
  });
  
  $("#timeline .profile img").live("click", function(event) {
    event.preventDefault();
    showUserTimeline(this.alt);
  });
  
  $(".trending-topic").live("click", function(event) {
    event.preventDefault();
    search(decodeURIComponent(this.textContent));
  });
  
  //var num = 1;
  //$("#timeline").scroll(function(event) {
  //  if ($(this).scrollTop() + $(this)[0].clientHeight > $(this)[0].scrollHeight - 100) {
  //    twitter.friendsTimeline(function(req) {
  //      var obj = xmlToJson(req.responseXML);
  //      var html = [];
  //      obj.forEach(function(entry) {
  //        html.push(formatEntry(entry.in_reply_to_user_id, entry.in_reply_to_status_id, entry.user.screen_name, entry.user.profile_image_url, entry.text, entry.created_at, entry.id));
  //      })
  //      $("#timeline").append(html.join(""));
  //    },
  //    function(error, req) {}, ++num);
  //  }
  //});
  
  
  
  //////////////////////////////////////////////////////////////////////////////
  // Functions
  //////////////////////////////////////////////////////////////////////////////
  
  function login() {
    widget.setPreferenceForKey($("#username").val(), "username");
    widget.setPreferenceForKey(Base64.encode($("#password").val()), "password");
    
    if ($("#username").val() == "" && $("#password").val() == "") return;
    
    $("#status-text").html($("#msg-login").html());
    $("body").removeClass("config-active").removeClass("logged-in").addClass("loading");
    $("#signup").hide();
    $("#status").show();
    $("#done").blur();
    
    twitter.login($("#username").val(), $("#password").val(), function(req) {
      if (req.status == 200) {
        $("#status").fadeOut(ANIMATION_SPEED, function() {
          $("body").removeClass("loading").addClass("logged-in");
          $("#main").fadeIn(ANIMATION_SPEED);
          $("#login-status").removeClass("error");
          
          getLatestTweet();
          updateTimeline();
          checkForUpdate(); // Gimme
        });
        
        return;
      }
      else if (req.status == 401) {
        widget.setPreferenceForKey("", "password"); // not the best solution
      }
      $("body").addClass("config-active").removeClass("loading");
      $("#status").hide();
      $("#login-status").addClass("error");
      showError($("#login-status"), req.status);
    },
    function(error, req) {
      log("Could not contact twitter.com.\n" + error);
      showError($("#status-text"), req.status);
    });
  }
  
  
  /**
   *  Posts a tweet
   *
   *  @param {String} tweet The text to post
   */
  function postTweet(tweet) {
    if ($.trim(tweet).length < 1) return;
    
    $("#timeline")[0].innerHTML = $("#msg-posting").html();
    $("#update").attr("disabled", "disabled").blur();
    var inReplyTo = arguments.callee.inReplyTo || null;
    
    twitter.update(tweet, inReplyTo, function(req) {
      if (req.status == 200) {
        setLatestTweet(xmlToJson(req.responseXML)[0].text);
        hideTweetInput();
      }
      else {
        showError($("#timeline"), req.status);
        $("#update").removeAttr("disabled");
      }
      
      updateTimeline();
    },
    function(error, req) {
      showError($("#timeline"), req.status);
      $("#update").removeAttr("disabled");
    });
  }
  
  
  /**
   *  Sets the latest tweet to be shown
   *
   *  @param {String} text The text to be shown
   */
  function setLatestTweet(text) {
    $("#latest-tweet").html(processLatestTweet(text) || "");
  }
  
  
  function showTweetInput(text) {
    $("#update").attr("disabled", "disabled");
    $("#doing").val(text || "");
    checkLength(); // Update char counter before it becomes visible
    $("#latest").fadeOut(ANIMATION_SPEED, function() {
      $("#status-update").fadeIn(ANIMATION_SPEED, function() {
        var length = $("#doing").val().length;
        $("#doing").focus().get(0).setSelectionRange(length, length);
      });
    });
  }
  
  
  function hideTweetInput() {
    postTweet.inReplyTo = null; // Reset this if the user cancels the reply
    $("#status-update").fadeOut(ANIMATION_SPEED, function() {
      $("#latest").fadeIn(ANIMATION_SPEED);
      $("#doing").val("");
      $("#chars").text(TwitterApi.MAX_CHARS);
    });
  }
  
  
  /**
   *  Fetches the specified timeline, or the current timeline if none is given
   *
   *  @param {String} timeline The name of the timeline to show
   *  @param {Boolean} skipIndicator True if the loading indicator should be
   *                                 shown while updating, or false otherwise
   */
  function updateTimeline(timeline, skipIndicator) {
    timeline = timeline || (twitter[$("#main").attr("class") + "Timeline"] && $("#main").attr("class")) || "friends";
    
    widget.setPreferenceForKey(timeline, "activetab");
    $("#main").attr("class", timeline);
    
    if (!skipIndicator) $("#timeline").addClass("loading").show();
    
    twitter[timeline + "Timeline"](
      function(req) {
        renderTimeline(req);
      },
      function(error, req) {
        showError($("#timeline"), req.status);
      },
      {count: tweetsDisplayed}
    );
  }
  
  
  /**
   *  Fetches the latest tweet and shows it
   */
  function getLatestTweet() {
    makeRequest.currentRequest = null; // don't abort the current request
    twitter.userTimeline(function(req) {
      // TODO: clean up this mess
      try {
        var tweet = xmlToJson(req.responseXML);
        
        if (tweet[0]) {
          $("#latest .profile img").attr("src", tweet[0].user.profile_image_url);
          setLatestTweet(processLatestTweet(tweet[0].text));
        }
        else {
          setLatestTweet("");
        }
      }
      catch (ex) {
        setLatestTweet("");
      }
    },
    function(req, error) {
      /**/
    },
    {page: 1, count: tweetsDisplayed});
    
    makeRequest.currentRequest = null; // prevent this request from being aborted
  }
  
  
  /**
   *  Processes a tweet and chops it off if too long
   *
   *  @param {String} text The text to process
   */
  function processLatestTweet(text) {
    text = text || "";
    var len = device == "screen" ? 80 : 50;
    if (text.length > len) {
      text = text.slice(0, len).replace(/</g, '&lt;').replace(/(\S{20})/g, '$1&shy;') + "…";
    }
    return text.replace(/(\S{20})/g, '$1&shy;')
  }
  
  
  /**
   *  
   */
  function xmlToJson(xmlDoc) {
    var entries = [];
    var type = xmlDoc.documentElement.tagName;
    var itemName = (type == "direct-messages") ? "direct_message" : "status";
    var userItemName = (type == "direct-messages") ? "sender" : "user";
    var properties = ["created_at", "id", "text", "in_reply_to_status_id", "in_reply_to_user_id", "in_reply_to_screen_name"];
    var userProperties = ["id", "name", "screen_name", "profile_image_url"];
    
    entries.type = itemName;
    
    var items = xmlDoc.getElementsByTagName(itemName);
    for (var i = 0, item; item = items[i]; i++) {
      var obj = { user: {} };
      
      properties.forEach(function(prop) {
        var elements = item.getElementsByTagName(prop);
        if (elements[0]) obj[prop] = elements[0].textContent;
      });
      
      var user = item.getElementsByTagName(userItemName)[0];
      
      userProperties.forEach(function(prop) {
        var elements = user.getElementsByTagName(prop);
        if (elements[0]) obj.user[prop] = elements[0].textContent;
      });
      
      entries.push(obj);
    }
    
    return entries;
  }
  
  
  /**
   *  
   */
  function renderTimeline(req) {
    var entries = null;
    
    try {
      entries = xmlToJson(req.responseXML);
    }
    catch (ex) {
      log("There was an error parsing the response! Response:\n" + req.responseText);
    }
    
    // if we get a string, there was an error
    if (req.responseXML && req.responseXML.documentElement === null) {
      showError($("#timeline"), { status: 0 });
    }
    else if (entries && entries.length > 0) {
      var content = [];
      
      entries.forEach(function(entry) {
        content.push(
          formatEntry(entry.in_reply_to_screen_name,
                      entry.in_reply_to_status_id,
                      entry.user.screen_name,
                      entry.user.profile_image_url,
                      entry.text,
                      entry.created_at,
                      entry.id,
                      entries.type
          )
        );
      });
      
      $("#timeline").removeClass("loading")[0].innerHTML = content.join("");
      resizeContent();

      var lastTweetId = parseInt(entries[0].id, 10);
      if (lastTweetId > widget.preferenceForKey("last-tweet-id")) {
        widget.setPreferenceForKey(lastTweetId, "last-tweet-id");
        if (notifyOnNewTweet) widget.getAttention();
      }
    }
    else if (entries && entries.length == 0) {
      $("#timeline").html(msgs.noentries).removeAttr("class"); 
    }
    else {
      showError($("#timeline"), req.status);
    }
    
    refreshTimeline();
  }
  
  
  /**
   *  Show the timeline of a single user
   *
   *  @param {String} user The name of the user
   */
  function showUserTimeline(user) {
    $("#timeline").addClass("loading").show();
    $("#main").removeAttr("class");
    
    twitter.userTimeline(
      function(req) {
        if (req.status == 401) {
          // TODO: make this better
          $("#timeline").removeClass("loading").html("<p>" + $("#msg-protectedUpdates").text() + "</p>");
          return;
        }
        renderTimeline(req);
        clearTimeout(refreshTimeout);
      },
      function(error, req) {
        showError($("#timeline"), req.status);
      },
      {count: tweetsDisplayed, id: user}
    );
  }
  
  
  /**
   *  Show a single tweet
   *
   *  @param {int} id The id of the tweet to show
   */
  function showSingleTweet(id) {
    $("#timeline").addClass("loading");
    $("#main").removeAttr("class");
    
    twitter.show(id, function(req) {
      renderTimeline(req);
    },
    function(error, req) {
      showError($("#timeline"), req.status);
    });
  }
  
  
  /**
   *  Refreshes the timeline periodically unless manual updates are set
   */
  function refreshTimeline() {
    if (updateInterval !== 0) {
      if (refreshTimeout) clearTimeout(refreshTimeout);
      refreshTimeout = setTimeout(function() {
        updateTimeline(null, true);
        getLatestTweet();
      }, 1000*60*updateInterval);
    }
  }
  
  
  function addSearchForm() {
    // TODO: clean this up
    $("#timeline")[0].innerHTML = 
      "<form id='twitter-search'>" +
        "<p><input id='search-query'> <button type='submit' id='search-go'>" +
          $("#msg-searchGo").html() +
        "</button></p>" +
      "</form>";
    
    $("#search-query").focus();
    
    $("#twitter-search").submit(function(event) {
      $("#timeline").addClass("loading");
      search($("#search-query").val());
    });
    
    clearTimeout(refreshTimeout);
  }
  
  
  function search(query) {
    $("#timeline").addClass("loading");
    
    twitter.search(query, function(req) {
        showSearchResults(req);
      },
      function(error, req) {
        showError($("#timeline"), req.status);
    },
    {count: tweetsDisplayed});
  }
  
  
  function showSearchTrends() {
    $("#timeline").append("<h2>Popular searches right now</h2>" +
                          "<p id='trends'>Loading trends...</p>");
    
    twitter.getTrends(function(req) {
      try {
        var result = eval("(" + req.responseText + ")");
      }
      catch (error) {
        $("#trends").html("Could not get trends.")
        return;
      }
      
      var trends = result.trends;
      if (trends && trends.length) {
        var content = [];
        trends.forEach(function(trend) {
          content.push("<a class='trending-topic' href='" + trend.url + "'>" + trend.name + "</a>");
        });
        $("#trends").html(content.join(", "));
      }
      else {
        $("#trends").html("Could not get trends.");
      }
    },
    function() {
      $("#trends").html("Could not get trends.");
    });
  }
  
  
  function showSearchResults(req) {
    var result = null;
    var entries = null;
    
    try {
      result = eval("(" + req.responseText + ")");
      entries = result.results;
    }
    catch (ex) {
      log("There was an error!"); // TODO: a little more informative
    }
    
    addSearchForm();
    
    $("#search-query").val(decodeURIComponent(((result && result.query) || "").replace(/\+/g, " ") || ""));
    
    if (entries && entries.length > 0) {
      var content = [];
      
      entries.forEach(function(entry) {
        content.push(
          formatEntry('',
                      '',
                      entry.from_user,
                      entry.profile_image_url,
                      entry.text.replace(/&amp;#/g, "&#"), // NCRs are double escaped
                      entry.created_at,
                      entry.id
          )
        );
      });
      
      $("#search-query").blur();
      $("#timeline").append(content.join(""));
      $("#timeline").removeClass("loading");
    }
    else if (entries && entries.length === 0) {
      $("#timeline").append(msgs.noentries).removeAttr("class"); 
    }
    else {
      showError($("#timeline"), req.status);
    }
  }
  
  
  /**
   *  Format a single entry, and return the resulting markup
   */
  function formatEntry(replyto, replyid, username, profile_img, text, created_at, id, type) {
    // FIXME: this is very messy. Templates are nice.
    var processedText = text.replace(/</g, '&lt;').linkify();
    return [
      '<div class="entry ', (replyto == $("#username").val() ? 'to-me' : ''), ' ',
                            (username == $("#username").val() ? 'from-me' : ''), '">',
        '<p class="profile">',
          '<a href="http://twitter.com/', username, '">',
            '<img src="', profile_img.replace("http://static.twitter.com/images/default_profile_normal.png", "images/default_profile_bigger.png"), '" alt="', username ,'">',
          '</a>',
        '</p>',
        '<p class="text">',
          '<a class="name" href="http://twitter.com/', username, '">',
            username,
          '</a> ',
          '<span class="tweet">',
            processedText,
          '</span>',
          '<span class="status-line">',
            (type != "direct_message" ? ('<a href="http://twitter.com/' + username + '/statuses/' + id + '" class="time">' + new Date(created_at).toAge() + '</a> ') : new Date(created_at).toAge()),
            '<a href="http://twitter.com/', replyto, '/statuses/', replyid,
              '" class="inreplyto" data-id="', replyid ,'">',
              (replyto ? 'to ' + (replyto.toLowerCase() == $("#username").val().toLowerCase() ? 'you' : replyto) : ''),
            '</a> <span>·</span> ',
            '<a href="" class="reply" data-username="', username, '" data-replyto-id="', id,'">',
              'reply',
            '</a> <span>·</span> ',
            '<a href="" class="dm" data-username="', username, '">',
              (type != "direct_message" ? 'dm' : 'reply'),
            '</a> <span>·</span> ',
            '<a href="" class="rt" data-username="', username, '" data-text="', text,'">',
              'rt',
            '</a> <span>·</span> ',
            '<a href="" class="trash" data-entryid="', id, '">',
              'delete',
            '</a>',
          '</span>',
        '</p>',
      '</div>'
    ].join("");
  }
  
  
  /**
   *  Show confirm dialog before deleting a tweet
   */
  function confirmDestroy(id) {
    showDialog($("#confirm-text").text(), $("#yes").text(), $("#no").text());
    
    $("#yes").click(function() {
      $("#confirm").hide();
      $("#timeline")[0].innerHTML = $("#msg-deleting").html();
      twitter.destroy(id, function(req) {
        // This is a hack to prevent deleted tweets to not stick around in the API data.
        twitter.endSession(function() {
          updateTimeline();
          getLatestTweet();
        });
        makeRequest.currentRequest = null; // prevent this request from being aborted
      });
      makeRequest.currentRequest = null; // prevent this request from being aborted
    });
    
    return false;
  }
  
  
  /**
   *  Set the username when replying, and set the in-reply to tweet id
   *
   *  @param {String} user The user for which this tweet is a reply to
   *  @param {int} id The id for which this tweet is a reply to
   */
  function replyTo(user, id) {
    showTweetInput("@" + user + " ");
    postTweet.inReplyTo = id;
  }
  
  
  /**
   *  Set the direct message text ("d <username>")
   *
   *  @param {String} user The receiver for the direct message
   */
  function directMessage(user) {
    showTweetInput("d " + user + " ");
    postTweet.inReplyTo = null;
  }
  
  
  function retweet(user, text) {
    showTweetInput("RT @" + user + " " + text);
  }
  
  
  /**
   *  Show remaining characters, and disable the tweet button if too few or too
   *  many characters are provided
   */
  function checkLength() {
    var length = $("#doing").val().length;
    var maxChars = TwitterApi.MAX_CHARS;
    var remaining = maxChars - length;
    
    $("#chars").text(remaining >= 0 ? remaining : "−" + -remaining) // use a real minus sign
               .attr("class", remaining > 10 ? "" : "few");
    
    $("#update").attr("disabled", (length < 1 || length > maxChars));
  }
  
  
  /**
   *  Update the location preference, and set the correct location in the config
   *  page
   *
   *  @param {String} location The location to set
   */
  function setLocation(location) {
    widget.setPreferenceForKey(location, "location");
    $("#location-option").val(location);
  }
  
  
  /**
   *  Find the longitude and latitude for a specified location and save it
   *  as a preference "latLon"
   *
   *  @param {String} location The location for which to find latitude and
   *                           longitude
   */
  function setLatLon(location) {
    $("#timeline").addClass("loading");
    
    makeRequest({
      method: "GET",
      url: "http://maps.google.com/maps/geo?key=" + GOOGLE_MAPS_KEY +
           "&q=" + encodeURIComponent(location),
      callback: function(req) {
        try {
          var data = eval("(" + req.responseText + ")");
          var lon = data.Placemark[0].Point.coordinates[0];
          var lat = data.Placemark[0].Point.coordinates[1];
          var latLon = lat + "," + lon;
          widget.setPreferenceForKey(latLon, "latLon");
          showNearbyTweets(latLon);
        }
        catch(ex) {
          addLocationSearchField();
          $("#timeline").removeClass("loading").append("<p>" + "Could not find location." + "</p>");
          widget.setPreferenceForKey("", "location");
        }
      }
    });
  }
  
  
  /**
   *  Shows nearby tweets (taken from the users' profile)
   *
   *  @param {String} latLon The locations latitude and longitude formatted as
   *                         "<lat>,<lon>"
   *  @param {String} radius The radius for the search specified as
   *                         "<int><unit>" where unit is "km" or "mi"
   */
  function showNearbyTweets(latLon, radius) {
    radius = radius || "10km";
    
    if (latLon) {
      $("#timeline").addClass("loading");
      
      twitter.search("?geocode=" + latLon + "," + radius, function(req) {
          showSearchResults(req);
        },
        function(error, req) {
          showError($("#timeline"), req.status);
        },
        {count: tweetsDisplayed}
      );
    }
    else {
      if (!widget.preferenceForKey("location")) {
        addLocationSearchField();
        $("#timeline").append(
          "<h2>Search for a location</h2>" +
          "<p>Find tweets from people that are nearby. You can change the location in settings.</p>");
      }
      else {
        setLatLon(widget.preferenceForKey("location"));
      }
    }
    
    clearTimeout(refreshTimeout);
  }
  
  
  function addLocationSearchField() {
    $("#timeline")[0].innerHTML = 
      "<form id='location-search'>" +
        "<p><input id='location'> <button type='submit' id='location-go'>" +
          $("#msg-searchGo").html() +
        "</button></p>" +
      "</form>";
      
    $("#location").focus();
    
    $("#location-search").submit(function(event) {
      event.preventDefault();
      setLocation($("#location").val());
      setLatLon($("#location").val());
    });
  }
  
  
  function abortCurrentRequest() {
    if (makeRequest.currentRequest) makeRequest.currentRequest.abort();
    $("#timeline").removeClass("loading");
  }
  
  
  // Submit on Ctrl-Enter
  function keySubmit(event) {
    if (event.ctrlKey && event.which == 13) postTweet($("#doing").val());
  }
  
  
  function showDialog(confirmText, yes, no) {
    $("#confirm-text").html(confirmText);
    $("#yes").html(yes);
    $("#no").html(no);
    $("#confirm").show();
  }
  
  
  function showError(el, status) {
    $("#timeline").removeClass("loading");
    // Accessing req when it doesn't exist throws an exception under certain
    // circumstances
    try {
      el.html(msgs[status] || msgs["generic"]);
      // TODO: link to http://status.twitter.com/
      log("Twitter widget:\nStatus code: " + status)
    }
    catch (ex) {
      el.html(msgs.generic);
    }
    
    clearTimeout(refreshTimeout);
  }
  
  
  /**
   *  Check if a new version of the widget is available
   */
  function checkForUpdate() {
    makeRequest({
      method: "GET",
      url: "http://widgets.opera.com/widget/doap/7206/",
      callback: parseForVersion,
      errorCallback: function() { return false; }
    });
    
    function parseForVersion(req) {
      var doc = req.responseXML;
      var newestVersion = doc.getElementsByTagNameNS("http://usefulinc.com/ns/doap#", "revision")[0].textContent;
      var parts = newestVersion.split(".");
      
      if (__version__[0] <= parseFloat(parts[0]) && // Compare major version
          __version__[1] <  parseFloat(parts[1]))   // Compare minor version
      {
        widget.showNotification($("#msg-newVersion").html(), function() {
          widget.openURL("http://widgets.opera.com/widget/download/7206/");  
        });
      }
    }
  }

  var msgs = {
    0: "status0",
    400: "status400",
    401: "status401",
    // 403 and 404 should not normally happen from the widget, unless the API
    // is changed, or there are some server problems
    403: "generic",
    404: "generic",
    500: "status50",
    502: "status500",
    503: "status503",
    noentries: "noEntries",
    generic: "generic"
  };

  for(var msg in msgs) {
    msgs[msg] = $("#msg-"+msgs[msg]).html();
  }  
  
  function widgetResize(width, height) {
    var zoom = (device == "mobile") ? window.innerWidth / document.documentElement.offsetWidth : 1;
    window.resizeTo(width * zoom, height * zoom);
    var compensation = device == "screen" ? 133 : 105; // magic numbers FTW!!
    $("#timeline").height(height - compensation - 12);
  }
  
  function resizeContent() {
    if (device == "screen") return;
    var zoom = window.innerWidth / document.documentElement.offsetWidth,
        height = window.innerHeight / zoom;
    
    $("#timeline").height(height - $("#timeline").offset().top - $("#resize-handle")[0].offsetHeight);
    $("#config").height(height - $("#config").offset().top - $("#resize-handle")[0].offsetHeight);
  }
  
  if (device == "mobile") {
    document.getElementById("resize-handle").style.display = "none";
    var zoom = window.innerWidth / document.documentElement.offsetWidth;
    // Fix window size on resize
    widget.addEventListener("resize", function() {
      zoom = window.innerWidth / document.documentElement.offsetWidth;
      widgetResize(screen.availWidth / zoom, screen.availHeight / zoom);
      resizeContent();
    }, false);
    widgetResize(screen.availWidth / zoom, screen.availHeight / zoom);
    
    // This needs cleaning up
    widget.addEventListener("widgetmodechange", function() {
      if (this.widgetMode == "docked") {
        var dock = document.getElementById("dock");
        dock.style.display = "block";
        if(document.getElementById("timeline").innerHTML != "") {
          if(screen.availWidth < 200){
            dock.innerHTML = document.getElementById("profile-image").innerHTML;
          }
          else {
            dock.innerHTML = document.getElementById("timeline").innerHTML;
          }
        }
        else if(screen.availWidth < 200) {
          dock.innerHTML = "<img src='images/logo.png' alt='twitter'>";
        }
        document.getElementById("widgetWrapper").style.display = "none";
      }
      else {
          document.getElementById("dock").style.display = "none";
          document.getElementById("widgetWrapper").style.display = "block";
      }
    }, false);
  }
  
  
  /** Helper for controlling window resize
   * @Author Benjamin "ICantDrink" Joffe
   */
  (function() {
    if (device !== "screen") return;
    
    var ResizeConfig = {
      MinWidth  : 350,
      MinHeight : 500
    };
    
    var width = parseInt(widget.preferenceForKey('width'), 10) || ResizeConfig.MinWidth;
    var height = parseInt(widget.preferenceForKey('height'), 10) || ResizeConfig.MinHeight;
    
    var timeout = 0;
    function resizeWindow() {
      timeout = 0; // clearit.
      width = Math.max(width, ResizeConfig.MinWidth);
      height = Math.max(height, ResizeConfig.MinHeight);
      
      widgetResize(width, height);
    }
    
    window.addEventListener("resize", function(event) {
      if(!timeout) {
        widgetResize(width, height);
        resizeContent();
      }
    }, false);
    
    window.onscroll = function() {
      //window.scrollTo(0,0);
    };
    
    resizeWindow();
    
    function drag(e0, x, y) {
      e0.preventDefault(); // Prevent text selection
      
      var width0 = width;
      var height0 = height;
      document.addEventListener('mousemove', mousemove, false);
      document.addEventListener('mouseup',   mouseup, false);
      
      function mousemove(e1) {
          if (x === 1) {
            width = Math.round(Math.min(screen.availWidth, e1.clientX/e0.clientX*width0));
          }
          if (y === 1) {
            height = Math.round(Math.min(screen.availHeight, e1.clientY/e0.clientY*height0));
          }
          
          if (!timeout) {
            timeout = setTimeout(resizeWindow, 1);
          }
      };
      
      function mouseup(e) {
          document.removeEventListener('mousemove', mousemove, false);
          document.removeEventListener('mouseup'  , mouseup  , false);
          
          widget.setPreferenceForKey(window.innerWidth,'width');
          widget.setPreferenceForKey(window.innerHeight,'height');
      }
    };
    
    document.getElementById('resize-handle').onmousedown = function(e) {
      drag(e, 1, 1);
    };
    
    document.onmouseup = function() {
      document.onmousemove = null;
    };
  })();
}

function log() {
  //var debug = true;
  //if (opera && opera.postError) opera.postError.apply(opera, arguments);
}

