/**
 * Copyright (c) 2007-2009, Opera Software ASA
 * All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of Opera Software ASA nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY OPERA SOFTWARE ASA AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL OPERA SOFTWARE ASA AND CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

function makeRequest(parameters, abort) {
  var currentRequest = arguments.callee.currentRequest;
  if (currentRequest && abort) {
    currentRequest.abort();
  }
  
  var request = new XMLHttpRequest();
  arguments.callee.currentRequest = request;
  
  request.open(parameters.method, parameters.url, (parameters.async || true),
    (parameters.username || null), (parameters.password || null));
  
  if (parameters.callback) {
    request.onreadystatechange = function() {
      if (this.readyState && this.readyState == 4) {
        parameters.callback(this);
      }
    };
  }
  
  if (parameters.headers) {
    for (var header in parameters.headers) {
      request.setRequestHeader(header, parameters.headers[header]);
    }
  }
  
  // Temporary workarounds for Opera 10
  request.setRequestHeader("Accept-Language", "en");
  if (parameters.username && parameters.password) {
    request.setRequestHeader("Authorization", "Basic " + Base64.encode(parameters.username + ":" + parameters.password));
  }
  
  try {
    var data = parameters.data || null;
    request.send(data);
  }
  catch (error) {
    if (parameters.errorCallback) {
        try {
            parameters.errorCallback(error, request)
        }
        catch (e) {
            parameters.errorCallback(error, { status: 0 });
        }
    }
    else {
        log(error)
    }
  }
}
