// utCzAWEj2aDbEjz4ngrKXNu9ZFRCqyAqurObPIjDnWKkWKhLqUcvwrm51ojT+MJyJw7zOi2/IF6+tGy0iI0SMnLNalZFL3BLsCKlBdfwryNkzNzILwJ7TGUY9ZZ6FZwim9x/m5es14J9mymqvhID4sMBVfykeIAYekijsV18X+kM0/Zx6Kr8DOdivVAzEpkzruaUTWc2WD3/VjZiRhcvLm4rMxqlZ5IvFANsf2U+q30d1e9tZeXjsb1s/PuxDQ2wJyVgzKhgMAaQ9CUzQfta/597LdKXaKmjks2gw8Yo0MySTlDeZ1tNGDOfpE9s409NOugE/pQga6dqhAbTqsvcqA==
/**
** Copyright (C) 2000-2011 Opera Software AS.  All rights reserved.
**
** This file is part of the Opera web browser.
**
** This script patches sites to work better with Opera
** For more information see http://www.opera.com/docs/browserjs/
**
** If you have comments on these patches (for example if you are the webmaster
** and want to inform us about a fixed site that no longer needs patching) please
** report issues through the bug tracking system
** https://bugs.opera.com/
**
** DO NOT EDIT THIS FILE! It will not be used by Opera if edited.
**/
// Generic fixes (mostly)
(function(opera){
	if(!opera || (opera&&opera._browserjsran))return;
	opera._browserjsran=true;
	var bjsversion=' Opera Desktop 11.10 core 2.8.99, March 10, 2011 ';
	// variables and utility functions
	var navRestore = {}; // keep original navigator.* values
	var shouldRestore = false;
	var hostname = location.hostname; // caching some strings for performance
	var href = location.href;
	var pathname=location.pathname;
	var fixed = false; // magic fixes need only run once
	if(!opera.postError)opera.postError=function(){}; // handling versions w/o error console
	// Storing function references
	var postError = opera.postError,
	call = Function.prototype.call,
	indexOf=String.prototype.indexOf,
	lastIndexOf=String.prototype.lastIndexOf,
	replace=String.prototype.replace,
	match=String.prototype.match,
	toLowerCase=String.prototype.toLowerCase,
	getAttribute=Element.prototype.getAttribute,
	setAttribute=Element.prototype.setAttribute,
	insertBefore=Node.prototype.insertBefore,
	insertAdjacentHTML=Element.prototype.insertAdjacentHTML,
	defineMagicVariable=opera.defineMagicVariable,
	defineMagicFunction=opera.defineMagicFunction,
	version=opera.version,
	getElementById=Document.prototype.getElementById,
	appendChild=Node.prototype.appendChild,
	removeChild=Node.prototype.removeChild,
	replaceChild=Node.prototype.replaceChild,
	evaluate=Document.prototype.evaluate,
	getElementsByTagName=Document.prototype.getElementsByTagName,
	createElement=Document.prototype.createElement,
	createEvent=Document.prototype.createEvent,
	dispatchEvent=Document.prototype.dispatchEvent,
	initEvent=Event.prototype.initEvent,
	createTextNode=Document.prototype.createTextNode,
	stopPropagation=Event.prototype.stopPropagation,
	preventDefault=Event.prototype.preventDefault,
	getComputedStyle=window.getComputedStyle,
	slice=Array.prototype.slice,
	shift=Array.prototype.shift,
	setTimeout=window.setTimeout,
	removeAttribute=Element.prototype.removeAttribute,
	addEventListener=Document.prototype.addEventListener,
	isNaN=window.isNaN,
	RegExp=window.RegExp,
	unescape=window.unescape,
	func_toString=Function.prototype.toString,
	parseFloat=window.parseFloat,
	random=Math.random;
	var opera_version = parseFloat.call(window,opera.version());
	var tinyMCEVersionInfo={};


	// Utility functions

	function addCssToDocument(cssText, doc, mediaType){
		getElementsByTagName.call=addEventListener.call=createElement.call=createTextNode.call=insertBefore.call=setAttribute.call=appendChild.call=version.call=call;
		doc = doc||document;
		mediaType = mediaType||'';
		addCssToDocument.styleObj=addCssToDocument.styleObj||{};
		var styles = addCssToDocument.styleObj[mediaType];
		if(!styles){
			var head = getElementsByTagName.call(doc, "head")[0];
			if( !head ){
				var docEl = getElementsByTagName.call(doc, "html")[0];
				if(!docEl){
					// :S this shouldn't happen - see if document hasn't loaded
					addEventListener.call(doc, opera&&version.call(opera)>=9?'DOMContentLoaded':'load',
					function(){ addCssToDocument(cssText, doc); },false);
					return;
				}
				head = createElement.call(doc, "head");
				if(head) insertBefore.call(docEl, head,docEl.firstChild);
				else head = docEl;
			}
			addCssToDocument.styleObj[mediaType] = styles = createElement.call(doc, "style");
			setAttribute.call(styles, "type","text/css");
			if(mediaType)setAttribute.call(styles, "media", mediaType);
			appendChild.call(styles, createTextNode.call(doc,' '));
			appendChild.call(head, styles)
		}
		styles.firstChild.nodeValue += cssText+"\n";
		return true;
	}

	function addPreprocessHandler( search, replacement, onceonly, conditional ){
		// adding event handler for script pre-processing if required
		var handler=function(e){
			indexOf.call=replace.call=removeEventListener.call=call; /* also needs anything used inside conditional! */
			if( conditional && ! conditional(e.element) ){return;}
			e.element.text=replace.call( e.element.text, search, replacement );
			if(onceonly){
				removeEventListener.call(opera, 'BeforeScript', arguments.callee, false);
			}
		}
		opera.addEventListener('BeforeScript', handler , false);
		return handler;
	}

function avoidDocumentWriteAbuse(contentRegexp){
	var dw=document.write;
	contentRegexp = contentRegexp || /(^<img .*?width=("|)1("|)\s+height=("|)1("|)\s+border=("|)0("|)\s+alt="".*?>$|^\[object Object\]$)/i;
	document.write=function( s ){
		if( String(s).match( contentRegexp ) ){
			opera.postError('Warning: scripts on '+window.location+' were changed by the s_code patch. See browser.js for details.');
		}else{//opera.postError(arguments);
			dw.apply(document, arguments);
		}
	};
}
function enableRedefiningParent(){
	var parentVar;
	opera.defineMagicVariable('parent',
		function (){ return parentVar },
		function(value){ parentVar = value });
}
	function fakeCSSFilters(){ // faking support for some of the common filters so that using them won't stop the script
		var filterObj={apply:function(){}, play:function(){}, Apply:function(){}, Play:function(){}}; // some of the common functions
		HTMLElement.prototype.filters=[ filterObj, filterObj, filterObj ]; // fake three applied filters with play and apply functions
		HTMLElement.prototype.filters['blendTrans']=filterObj; // we also fake a named blendTrans filter
	}

	function fixCoolmenus(name){
		if(fixed){return;}fixed=true;
		defineMagicVariable.call=call;
		// Version 4 is Opera 7 - compatible and does user agent sniffing
		navRestore['userAgent'] = navigator.userAgent;
		navigator.userAgent +=' msie 6';
		shouldRestore = true;
		defineMagicVariable.call(opera, 'bw', function(o){
			// we need to override yet some more browser detection, and disable CSS filters
			// usedom must be 0 to make frameset menus work
			o.filter=o.op7=o.op=o.usedom=o.ns6=0;
			o.ie=o.ie6=1;
			return o}, function(o){return o});
		addPreprocessHandler(  'this.win.document.body.appendChild(oNS)',  'try{this.win.document.body.appendChild(oNS)}catch(e){oNS=this.win.document.body.appendChild(this.win.document.importNode(oNS, true))}' );
		addPreprocessHandler(  'oNS.appendChild(oNS2)',  'try{oNS.appendChild(oNS2);}catch(e){oNS2=oNS.appendChild(oNS.document.importNode(oNS2, true));}' );
	}

	function fixHVMenu(name){
		if(fixed){return;}fixed=true;
		defineMagicVariable.call=match.call=call;
		// fix by changing Opera from an unsupported browser to a supported browser
		// Set to true either PosStrt, NavYes, DomNav   or   PosStrt, ExpYes, DomExp
		defineMagicVariable.call(opera, 'PosStrt', function(){ return true }, null);
		defineMagicVariable.call(opera, 'NavYes', function(){ return true }, null);
		defineMagicVariable.call(opera, 'DomNav', function(){ return true }, null);
		// if Opera >= 9.5, load events are sent to document and not to body - make sure script doesn't set body.onload
		defineMagicVariable.call(opera, 'Trigger', function(obj){if(obj===document||obj===document.body) return window; return obj; }, null);
		// Tell the script that CSS filters are not supported.
		defineMagicVariable.call(opera, 'Fltr', function(){ return false; }, function(){ return });
		// More recent versions look for 'opera 7' in navigator.userAgent and some do not use the variable names above
		if(  match.call(name, /var\.js$/) || match.call(name, /compact\.js$/) ){
			navRestore['userAgent'] = navigator.userAgent;
			navigator.userAgent+=' opera 7'; 
			shouldRestore = true;
		}
	}
	function fixHierMenus(){
		if(fixed){return;}fixed=true;
		defineMagicVariable.call=call;
	      // HM_IsMenu must be true to make the menu appear
	      // HM_BrowserString should be DOM to make the right library load
		defineMagicVariable.call(opera, 'HM_IsMenu', function(){ return true}, function(){ return true });
		if(!document.all)defineMagicVariable.call(opera, 'HM_IE', function(){ return true}, function(){ return true });
		defineMagicVariable.call(opera, 'HM_BrowserString', function(){ return 'DOM'}, function(){ return 'DOM' });
		if(HTMLBodyElement.prototype.__defineGetter__)HTMLBodyElement.prototype.__defineGetter__('clientHeight', function(){return this.ownerDocument.documentElement.clientHeight;}); // PATCH-33
	}

function fixIFrameSSIscriptII(funcName, iFrameId){
	if(typeof funcName==='string'&&!arguments.callee[funcName]){
		var overrideFn = function (a,b,frameid){
			frameid = frameid|| iFrameId;
			var currentfr=document.getElementById(frameid);
			if (currentfr){
				try{
					currentfr.height = currentfr.contentDocument.documentElement.scrollHeight;
				}catch(e){}
				currentfr.style.display='block';
				if(!arguments.callee._listenerAdded){
					currentfr.addEventListener("load", function(e){ overrideFn(0,0,e.target.id); }, false);
					arguments.callee._listenerAdded=true;
				}
			}
		}
		opera.defineMagicFunction(funcName, overrideFn);
		fixIFrameSSIscriptII[funcName]=1;//remember that we fixed this already
	}
}
function fixLiknoAllWebMenus(ev){
	indexOf.call=match.call=defineMagicVariable.call=postError.call=removeEventListener.call=appendChild.call=createElement.call=preventDefault.call=replace.call=call;
	if(fixed)return; fixed=true;
	if( indexOf.call(ev.element.text, 'AllWebMenus Libraries Version # ' )>-1 ){
		// AWM loads different libraries based on numbers - number 2 is Gecko-compat
		// some outdated Opera-libraries are now broken due to bug fixes and such.
		var awmVersion = parseInt(match.call(ev.element.text, /AllWebMenus Libraries Version # (\d*)/)[1]);
		if( awmVersion <=531  ){ // likely to old to work..
			defineMagicVariable.call(opera,   'scriptNo', function(){return 2}, null);
			defineMagicVariable.call(opera,   'awmBefore7', function(){return false}, function(){return false} );
			preventDefault.call(ev); // don't run this script
			var script = appendChild.call(document.body, createElement.call(document, 'script')); // create another one..
			script.src = replace.call(ev.element.src, /awmlib\d*\.js/, 'awmlib2.js'); // and load a more suitable version
			postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (AllWebMenus fix). See browser.js for details.');
		}
		removeEventListener.call(opera, 'BeforeScript', arguments.callee, false );
	}
}
	function fixMilonicMenu(name){ 	// gotcha: must be called with script.src as argument
		if(fixed){return;}fixed=true;
		defineMagicVariable.call=defineMagicFunction.call=addEventListener.call=call;
	      // "opera" or "opra" true will cause no menu or garbled (Opera 6 pixel* -  compat)
		defineMagicVariable.call(opera, 'opera', function(){ return false }, function(){});
		defineMagicVariable.call(opera, 'opra', function(){ return false }, function(){});
		// ie55 true will use IFRAME shims
		defineMagicVariable.call(opera, 'ie55', function(){ return false }, function(){ });
		// identifying as Opera will cause "dom" variable to be false in some versions
		defineMagicVariable.call(opera,  'dom' , function(){ return true }, function(){});
		// fixForm function will hide page content
		defineMagicFunction.call(opera,  'fixForm' , function(){});
		// Menu does not work on Mac if it detects platform
		defineMagicVariable.call(opera, 'mac', function(){ return false }, function(){ });
		// bug 330958
		if(!window.scrollX){
			opera.defineMagicVariable('scrollY', function(){ return document.body.scrollTop;}, null);
			opera.defineMagicVariable('scrollX', function(){ return document.body.scrollLeft;}, null);
		}
	}

function fixOpenCube(name){// IMPORTANT gotcha: the fixOpenCube and fixHVMenu functions must be called with an appropriate string argument
	if(fixed)return;
	match.call=addEventListener.call=defineMagicVariable.call=indexOf.call=call;
	// OpenCube menu
	window.vxml = window.vxml||{}; // to fix semi-opera-detection
	//Some versions try to call a function q99 which is only defined in the Opera library
	addEventListener.call(window, 'load', function(){ if(typeof q99=='undefined')window.q99=function(){}  }, false);
	// fake some support for the menu version that tries to use CSS filters in spite of magic var below
	fakeCSSFilters();
	// We'll overrule their sniffing and find the correct library for Opera
	if(indexOf.call(navigator.appVersion, 'Mac')!=-1){
		// They don't seem to like Macs.. see 356184
		navigator.appVersion = replace.call( navigator.appVersion, 'Mac', 'M A C' );
		addEventListener.call(opera, 'AfterExternalScript', function(){
			replace.call = removeEventListener.call = call;
			navigator.appVersion = replace.call( navigator.appVersion, 'M A C', 'Mac' );
			removeEventListener.call(opera, 'AfterExternalScript', arguments.callee, false);
		}, false);
		// some variables are uninitialized
		q20=q21=[];
	}
	if(match.call(name, /dqm_script\d*\.js$/)){
		defineMagicVariable.call(opera, 'brn', function(val){ return 'ie' }, function(val){ return 'ie' });
		defineMagicVariable.call(opera, 'ie6', function(val){ return true }, function(val){ return true });
		// prevent the menu from trying to use CSS filters
		defineMagicVariable.call(opera, 'DQM_sub_menu_effect',  function(){return 'none';}, null);
		if(document.evaluate){ // we have an event transparency problem on some sites, see for example bug 239622
			addEventListener.call(window, 'load', function(){
				var nodes=document.evaluate( '//a/child::img[substring(@id, 0, 4)=\'qmim\']', document.body,null,XPathResult.ORDERED_NODE_ITERATOR_TYPE,null ),node;
				while( node=nodes.iterateNext()){
					node.parentElement.parentElement.replaceChild(node, node.parentElement );
				};
			}, false);
		}
		fixed=true;
		return true;
	}else if(indexOf.call(name, 'dqm_loader.js')>-1){
		defineMagicVariable.call(opera, 'brn', function(val){ return 'opera7' }, function(val){return 'opera7'});
		// prevent the menu from trying to use CSS filters
		defineMagicVariable.call(opera, 'DQM_sub_menu_effect',  function(){return 'none';}, null);
		fixed=true;
		return true;
	}else if(indexOf.call(name, 'dnm_script.js')>-1){ // very old version.. 153257
		defineMagicVariable.call(opera, 'ie5', function(val){ return true }, function(val){ return true });
		defineMagicVariable.call(opera, 'ns5', function(val){ return true }, function(val){ return true });
	}
}

	function fixSoThinkMenus(){
		if(fixed){return;}fixed=true;
		defineMagicVariable.call=addEventListener.call=call;
		defineMagicVariable.call(opera, 'nOP',function(){return false;},null);
		defineMagicVariable.call(opera, 'nIE',function(){return false;},null);
		defineMagicVariable.call(opera, 'nNN6',function(){return true;},null);
		addEventListener.call(window, 'load', function(e){ if(window.st_onload)st_onload(e); }, false );//PATCH-55
	}

	function fixTransmenus(){
		// Fixing bugs in menu script from http://www.youngpup.net/2004/transmenus/ 
		// Credits xErath and Andrew Gregory
		opera.addEventListener('BeforeScript', function(ev) {
			indexOf.call=replace.call=removeEventListener.call=call;
			var js = ev.element.text;
			if (indexOf.call(js, "TransMenu")!=-1) {
				js = replace.call(js, /return\s+r(\b)/,"return true$1");
				js = replace.call(js, /mac/g,"xpto");
				js = replace.call(js, "el.scrollLeft", "0");
				js = replace.call(js, "el.scrollTop", "0");
				ev.element.text = js;
				removeEventListener.call(opera, 'BeforeScript', arguments.callee, false);
			}
		}, false);
	}

	function fixUDM(name){
		if(fixed){return;}fixed=true;
		defineMagicVariable.call=call;
		// If the menu is a 3.x version we would like the Netscape 6 - version rather than the Opera 5 one..
		defineMagicVariable.call(opera, 'op5',function () { return 0; },null);
		defineMagicVariable.call(opera, 'ns6',function () { return 1; },null);

		// certain versions break if insertRule throws exceptions. Also see bug 242411.
		// Better fake missing support for DOM2Style then..
		defineMagicVariable.call(opera, 'um', function(o){ o.ss=false; o.o7=false; return o; }, null);
    }

function ignoreCancellationOfCertainKeyEvents(type, list){
	opera.addEventListener( 'BeforeEventListener.'+type, function(e){
		preventDefault.call=call;
		if( e.event.keyCode in list ){
			preventDefault.call(e);
		}
	},false );
}
function ignoreRequiredAttributes(){
	document.addEventListener('invalid', function(e){
		if( e.target.validity.valueMissing){
			e.target.removeAttribute('required');
			e.preventDefault();
			opera.postError('Warning: overriding built-in "required" attribute validation on page. See browser.js for details.');
		}
	},true);
}
function sendOperaEvent(name, target){
	initEvent.call=createEvent.call=dispatchEvent.call=call;
	var evt=createEvent.call(document, 'Event');
	initEvent.call(evt, name, false, false);
	evt.element=target;
	dispatchEvent.call(opera, evt);
}
function setTinyMCEVersion(e){
	if(tinyMCEVersionInfo.majorVersion)return; // already found it
	indexOf.call=match.call=call;
	// look at source code
	if( e && indexOf.call(e.element.text, 'majorVersion' )>-1  ){
		if(match.call(e.element.text, /majorVersion\s*[:=]+\s*["']?(\d)/)){ tinyMCEVersionInfo.majorVersion=RegExp.$1; }
		if(match.call(e.element.text, /minorVersion\s*[:=]+\s*["']?(\d(\.\d|))/)){ tinyMCEVersionInfo.minorVersion=RegExp.$1; }
	}
	// if an instance has already been created, we can read version info from it...
	var tinyInstance='tinyMCE' in window?window.tinyMCE : 'tinymce' in window ? window.tinymce : 'tiny_mce' in window ?  window.tiny_mce : null;
	if(tinyInstance&&tinyInstance.majorVersion)tinyMCEVersionInfo={ majorVersion:tinyInstance.majorVersion, minorVersion:tinyInstance.minorVersion };
}






	// Sending an extra onreadystatechange causes some ad scripts to eat memory
// The required attribute does not take the value false according to WebForms2 - remove "required=false" from form elements
// lines reversed on enter by workaround against old Opera bug
// TinyMCE 2.x uses document.selection in Opera
// no code in TinyMCE 2.x HTML source editor because it expects a different order of load events
// Generic JS library patches
// Prevent unsolicited access to Java's deploymenttoolkit
// Jive forum software doesn't work in Opera
// Hide broken implementation of showModalDialog to make object detection reliable
// Remove non-functional addEventListener from XHR objects
// PDF security patch
// Disable sniffing in old HTMLArea editors
// Asia-region Generic Patches
// Disable HTMLElement.removeNode support, compat experiment
// TinyMCE double IFRAME init problem, some versions
			// PATCH-177, Sending an extra onreadystatechange causes some ad scripts to eat memory
	opera.addEventListener( 'BeforeEventListener.readystatechange', function(e){
		var element=e.event.target;
		preventDefault.call=random.call=postError.call=call;
		var elId=element.sourceIndex;
		if(!elId)element.__operaReadyStateFakeID__=elId=element.__operaReadyStateFakeID__||random.call(Math);
		if( element.readyState == 'loaded' && element.tagName == 'SCRIPT' ){
			if( e.listener['__operaReadyStateAlreadyCalled'+elId+'__'] ) {
				preventDefault.call(e);
				postError.call(opera, 'Opera applied workaround against double readystate events. See browser.js for details');
			} else {
				e.listener['__operaReadyStateAlreadyCalled'+elId+'__']  = true;
			}
		}
	}, false);
			// 305669, The required attribute does not take the value false according to WebForms2 - remove "required=false" from form elements
	window.addEventListener('load', function(){
		try{var obj = document.evaluate( '//input[translate(@required, "FALSE", "false")="false"]', document.documentElement, null, XPathResult.UNORDERED_NODE_SNAPSHOT_TYPE, null ), el, i=0 ;
		while(el=obj.snapshotItem(i)){el.removeAttribute('required');i++;}}catch(e){}
	}, false);
			// DSK-223254, lines reversed on enter by workaround against old Opera bug
	opera.addEventListener('bjsOnTinyMCEScript', function(e){
		if(tinyMCEVersionInfo.majorVersion<3 || ( tinyMCEVersionInfo.majorVersion==3 && (parseInt(tinyMCEVersionInfo.minorVersion)==0 || tinyMCEVersionInfo.minorVersion=='X' /*X: see CORE-15898*/ ))){
			e.element.text = e.element.text.replace( /if\s*\((tinyMCE\.|)isOpera\)\s*\{(\s*(\w{1,}\.normalize\(\);|)\s*\w{1,}\.insertNode\(\s*\w{1,}\s*\);)/g , 'if(false){$2' );
			e.element.text = e.element.text.replace( /if\([\w\.]+\)\{(\w+)\.insertNode\((\w+)\);\1\.insertNode\((\w+)\)\}else\{\1\.insertNode\(\3\);\1.insertNode\(\2\)/g , function(str){ return str.replace( /if\([\w\.]\)/, 'if(false)' ) } ); // PATCH-248
		}
	}, false);
	
			// PATCH-204, TinyMCE 2.x uses document.selection in Opera
	opera.addEventListener('bjsOnTinyMCEInstance', function(e){
		if(!document.selection && tinyMCEVersionInfo&&tinyMCEVersionInfo.majorVersion<3){
			var doc=e.element.contentDocument;
			doc.selection={};
			doc.selection.__defineGetter__('type', function(){ if(doc.getSelection())return 'Text'; return 'None'; });
			doc.selection.createRange=function(){var rng=window.getSelection().getRangeAt(0);rng.__defineGetter__('text', function(){return doc.getSelection();});return rng;}
		}
	}, false);
			// DSK-199930, no code in TinyMCE 2.x HTML source editor because it expects a different order of load events
	opera.addEventListener('bjsOnTinyMCEScript', function(e){
		if( e.element.src.indexOf('popup')>-1 && ( (tinyMCEVersionInfo&&tinyMCEVersionInfo.majorVersion<3&&tinyMCEVersionInfo.minorVersion<1.3)||!tinyMCEVersionInfo.majorVersion) ){
			var name=tinyMCEVersionInfo.minorVersion==0?'TinyMCEPopup':'TinyMCE_Popup';//sigh..
			opera.defineMagicVariable(name, function(o){
				o.prototype.resizeToInnerSize=function(){};
				o.prototype.executeOnLoad=function(str){eval(str);}
				return o;
			}, null);
		}
	}, false);
	
			// PATCH-139, Generic JS library patches
	// Use an event listener to detect specific scripts
	opera.addEventListener( 'BeforeExternalScript', function(ev){
		match.call=replace.call=indexOf.call=toLowerCase.call=postError.call=addEventListener.call=removeEventListener.call=version.call=parseFloat.call=call;
		
		var name=ev.element.src; 
		if( !name ){ return; } // no fixes required for SCRIPT xlink:href so far..
		name=toLowerCase.call(name );// toLowerCase fixes sangjatten.se
	      if ( indexOf.call(name, 'dqm_')>-1 || indexOf.call(name, 'dnm_')>-1 || indexOf.call(name, 'cbrowser_opera.js')>-1 ){ 
			// OpenCube menu
			if(fixOpenCube(name)){
				postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (OpenCube fix). See browser.js for details.');
			}
			return;
	      }else if(  indexOf.call(name, 'hm_loader')>-1  ){ 
			// HierMenus menu
			// If we apply this fix to version 6.x the menu breaks.
			// HM support recommends checking that HM_BrowserVersion is not defined
			addEventListener.call(opera, 'BeforeScript', function(ev){ 
				match.call=removeEventListener.call=postError.call=call;
				if( ev.element.text && ! match.call(ev.element.text, /hm_browserversion/i) ){
					fixHierMenus(name);
					postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (HierMenus fix). See browser.js for details.');
				}
				removeEventListener.call(opera, 'BeforeScript', arguments.callee, false);
			}, false);
			return;
	      }else if(  indexOf.call(name, 'mmenu')>-1 || indexOf.call(name, 'milonic')>-1  ){ 
			// Milonic menu
			fixMilonicMenu(name);
			postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Milonic fix). See browser.js for details.');
			return;
		
	      }else if(  match.call(name, /menu(\d*_(script|com|build|var|program|compact)|e)\.js$/)  ){ 
			// HV menu
			fixHVMenu(name);
			postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (HVMenu fix). See browser.js for details.');
			return;
	      }else if(  match.call(name, /coolmenus\d?.js$/)   ){ 
			// coolmenus menu
			fixCoolmenus(name);
			postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Coolmenus fix). See browser.js for details.');
			return;
	      }else if(  match.call(name, /udm[_-]/)  || (  match.call(name, /(sniffer|control)\.js$/)   )    ){ 
			// UDM menu
			addEventListener.call(opera, 'BeforeScript', function(ev){
				match.call=postError.call=call;
				if( match.call(name, /udm[_-]/)  || indexOf.call(ev.element.text, 'UDM')>-1 || indexOf.call(ev.element.text, 'um.ov=um.ov.split(/opera[\\/ ]7./);um.ov=um.pi(um.ov[1].charAt(0));')>-1 ){
					fixUDM(name);
					postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (UDM fix). See browser.js for details.');
				}
			}, false);
			return;
	      }else if(  indexOf.call(name, 'dynapi/api/browser.js')>-1  || indexOf.call(name, 'dynlayer.js')>-1  ){
			navRestore['appName'] = navigator.appName;
			navigator.appName = 'Microsoft Internet Explorer';
			shouldRestore = true;
			postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (DynAPI fix). See browser.js for details.');
		}else if(  match.call(name, /stm(\d+|_menu).js$/)  ){
			fixSoThinkMenus();
			postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (SoThink fix). See browser.js for details.');
		}else if( indexOf.call(name, 'transmenu')>-1 ){
			fixTransmenus();
			postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Transmenu fix). See browser.js for details.');
		}else if( indexOf.call(name, 'xaramenu')>-1 ){
			addPreprocessHandler( new RegExp('if\\(navigator.userAgent.indexOf\\(\'Opera\'\\)!=-1\\)\\s*NS4=1;', ''), 'if(navigator.userAgent.indexOf(\'Opera\')!=-1){IE5=1;NS6=0;}');
			postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Xaramenu fix). See browser.js for details.');
		}else if( parseFloat.call(window, version.call())<9.5 && indexOf.call(name, '/novell/webaccess/images/msglist.js')>-1){ // Bug 92454, workaround for NWA
			defineMagicFunction.call(opera, 'fixContentHeight',
				function(oF, oT){
					document.documentElement.clientHeight=window.innerHeight;
					oF.apply(oT, slice.call(arguments, 2));
			});
			postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Height function fix). See browser.js for details');
		}else if( indexOf.call(name, 'awmlib')>-1 ){
				opera.addEventListener('BeforeScript', fixLiknoAllWebMenus, false);
		}else if( indexOf.call( name, 'tiny_mce' )>-1 && 'designMode' in document && !fixed){
				postError.call(opera, 'TinyMCE detected. Various fixes applied. See browser.js for details');
				addEventListener.call(opera, 'BeforeScript', function(e){
					indexOf.call=removeEventListener.call=call;
					if( indexOf.call(e.element.src, 'tiny_mce'>-1) ){
						setTinyMCEVersion(e);
						sendOperaEvent( 'bjsOnTinyMCEScript', e.element );
					}
				}, false);
				addEventListener.call(opera, 'BeforeEvent.load', function(e){
					match.call=call;
					if( match.call(e.event.target.tagName, /iframe/i) && ( match.call(e.event.target.name, /^mce_editor_\d/ ) || match.call(e.event.target.id, /^mce_editor_\d/ ))){
						setTinyMCEVersion();
						sendOperaEvent('bjsOnTinyMCEInstance', e.event.target);
					}
				}, false);
				fixed=true;
		}else if(indexOf.call(name, 'dev.virtualearth.net/mapcontrol/mapcontrol.ashx')>-1 && window.SVGDocument){
			navRestore.userAgent = navigator.userAgent;
			navigator.userAgent+='KHTML';//356736
			shouldRestore=true;
		}else if(indexOf.call(name,'s_code')>-1||indexOf.call(name,'omniture')>-1){//PATCH-59
			avoidDocumentWriteAbuse();
		}else if(indexOf.call(name,'setdomain.js')>-1){//PATCH-128
			navRestore.userAgent = navigator.userAgent;
			navigator.userAgent+=' Gecko';
			shouldRestore=true;
		}else if(indexOf.call(name,'connect.facebook.net')>-1 && indexOf.call(name,'all.js')>-1){ 
				var win_attachEvent=window.attachEvent;
				if( window.fbAsyncInit ){
					var origFBAsyncInit=window.fbAsyncInit;
					window.fbAsyncInit=function(){
						window.attachEvent=undefined;
						origFBAsyncInit.call(null);
						window.attachEvent=win_attachEvent;
					}
				}else{
					window.attachEvent=undefined; 
					addEventListener.call(opera, 'AfterScript', function(e){
						window.attachEvent=win_attachEvent;
						removeEventListener.call(opera, 'AfterScript', arguments.callee, false);
					}, false);
				}
			}
		if( typeof window._jive_plain_quote_text!='undefined' ){ // Jive forum embeds TinyMCE, possibly outdated versions - PATCH-248
			opera.addEventListener('BeforeScript', function(e){
				indexOf.call=removeEventListener=call;
				if(indexOf.call(e.element.text, 'tinymce=')>-1){
					setTinyMCEVersion(e);
					sendOperaEvent( 'bjsOnTinyMCEScript', e.element );
					removeEventListener.call(opera, 'BeforeScript',arguments.callee,false);
				}
			}, false);
		}
		// Creating event handler to restore any changed navigator properties
		if( shouldRestore ){
			addEventListener.call(opera, 'AfterExternalScript', 
				function(ev){
					removeEventListener.call=call;
					var prop;
					for(prop in navRestore) navigator[prop]=navRestore[prop];
					removeEventListener.call(opera, 'AfterExternalScript', arguments.callee, false);
				}
			, false);
		}
	}, false);
			// PATCH-230, Prevent unsolicited access to Java's deploymenttoolkit
	HTMLObjectElement.prototype.__defineGetter__('installJRE', function(){opera.postError('browser.js prevented page from calling method installJRE on object');} );
	HTMLEmbedElement.prototype.__defineGetter__('installJRE', function(){opera.postError('browser.js prevented page from calling method installJRE on embed');} );
			// PATCH-248, Jive forum software doesn't work in Opera
	opera.defineMagicVariable('jive', null, function(obj){
		navigator.userAgent='Mozilla/5.0 (Windows; U; Windows NT 5.1; rv:1.9.2) Gecko/20100115 Firefox/3.6';
		opera.postError('Opera has modified the JavaScript on '+hostname+' (Jive forums fix). See browser.js for details');
		return obj;
	});
			// PATCH-261, Hide broken implementation of showModalDialog to make object detection reliable
	delete showModalDialog;
			// PATCH-272, Remove non-functional addEventListener from XHR objects
	delete XMLHttpRequest.prototype.addEventListener;
			// 246299, PDF security patch
	opera.addEventListener('BeforeJavaScriptURL', function( e ){
		unescape.call=toLowerCase.call=indexOf.call=preventDefault.call=call;
		var pathname=unescape.call(self, toLowerCase.call(self.location.pathname));
		var hash=unescape.call(self, toLowerCase.call(self.location.hash));
		if( /*indexOf.call(pathname, '.pdf')>-1 &&*/ hash  &&  indexOf.call(hash, 'javascript:')>-1   ) preventDefault.call(e);
	}, false);
			// PATCH-298, Disable sniffing in old HTMLArea editors
	opera.defineMagicVariable('HTMLArea', null, function(obj){
		obj.__defineGetter__('is_gecko', function(){return true});
		obj.__defineSetter__('is_gecko', function(){});
		obj.__defineGetter__('checkSupportedBrowser', function(){return function(){return true;}});
		obj.__defineSetter__('checkSupportedBrowser', function(){});
		var onloadmethod;
		obj.__defineSetter__('onload', function(func){ onloadmethod=func;});
		obj.__defineGetter__('onload', function(){ return function(){ try{ onloadmethod.call(this);}catch(e){ var instance=this; setTimeout(function(){instance.onload();}, 150); }}});
		opera.postError('Opera has modified the JavaScript on '+hostname+' (HTMLArea fix). See browser.js for details');
		return obj;
	});
	
			// PATCH-138, Asia-region Generic Patches
	opera.addEventListener('BeforeExternalScript',function(ev){
		var name=ev.element.src; 
		if(!name){return;}
		if(name.indexOf('api.e-map.ne.jp/jsapi.cgi?')!=-1){
			// Zenrin Datacom E-Map API, PATCH-115
			if (!Event.prototype.__lookupGetter__('layerX')&&!Event.prototype.__lookupGetter__('layerY')) {
				Event.prototype.__defineGetter__('layerX',function(){ return this.offsetX; });
				Event.prototype.__defineGetter__('layerY',function(){ return this.offsetY; });
			}
			ev.element.src += '&force=1';
		}else if((name.indexOf('expapi/authentication')!=-1)||(name.indexOf('expapi/expmapinclude')!=-1)||(name.indexOf('rosen/authentication')!=-1)){
			// Rosenzu ASP Map Service map, PATCH-122
			opera.defineMagicFunction('_ch',function(){return true;});
		}else if((name.indexOf('expapi/suggest')!=-1)||(name.indexOf('rosen/suggest')!=-1)){
			// Rosenzu ASP Map Service suggestions, PATCH-122
			opera.defineMagicFunction('checkBrowser',function(){return true;});
		}else if(name.indexOf('http://ebook.webcatalog.jp/engine/java/7net/common/sCommonLib.js')!=-1){ 
			// Netfly TrueEBook, PATCH-125
			opera.defineMagicFunction('funcGetBrowser',function(){return 2;}); 
		}
	},false);
			// PATCH-331, Disable HTMLElement.removeNode support, compat experiment
	delete HTMLElement.prototype.removeNode;
			// PATCH-373, TinyMCE double IFRAME init problem, some versions
	opera.addEventListener('bjsOnTinyMCEScript', function(e){
	  if( tinyMCEVersionInfo && tinyMCEVersionInfo.majorVersion==3 && tinyMCEVersionInfo.minorVersion>1.0 ){
	    Element.prototype.appendChild=function(el){ 
	      if(el.tagName=='IFRAME' && /^\s*javascript:/.test(el.src) && el.src.indexOf('document.domain')>-1){
	        el.src='about:blank'; 
	      }
	      return appendChild.call( this, el );
	    }
	  }
	}, false);
	


	if((hostname.indexOf('tokyo.jp')>-1)||(hostname.indexOf('lg.jp')>-1)){			// PATCH-186, tokyo.jp, lg.jp enable maps
		if (location.pathname.indexOf('citymap')>-1) {
			window.opera.defineMagicFunction('chkBrowser',function(){
				return true;
			},false);
		}
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (tokyo.jp, lg.jp enable maps). See browser.js for details');
	} else if(hostname.indexOf( 'fileplanet.com' ) >-1 && href.indexOf('/sp_downloadmanager.aspx')>-1){			// DSK-176321, Fileplanet.com sniffing blocks Opera
		opera.defineMagicVariable('agt',function(){return "win";},null);
		addPreprocessHandler( /(\b)window\s*.\s*opera(\b)/g,'$1undefined$2');
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Fileplanet.com sniffing blocks Opera). See browser.js for details');
	} else if(hostname.indexOf( 'nmviewogc.cr.usgs.gov' )!=-1){			// 233838, National Map Viewer on USGS relies on Netscape detection for functionality
		navigator.appName='Netscape';
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (National Map Viewer on USGS relies on Netscape detection for functionality). See browser.js for details');
	} else if(hostname.indexOf("cang.baidu.com") != -1 ){			// OTW-4761, cang.baidu.com for Baidu SouCang can't display saved items
		window.opera.defineMagicFunction(
			"top",
			function(originalFunction, oThis, oParam1, oParam2) {
				return originalFunction();
			}
		);
		
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (cang.baidu.com for Baidu SouCang can\'t display saved items). See browser.js for details');
	} else if(hostname.indexOf('.aaa.com')>-1){			// PATCH-38, Sniffing on aaa.com prevents zip code search
		opera.defineMagicVariable('NS6', function(){return true;}, null);
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Sniffing on aaa.com prevents zip code search). See browser.js for details');
	} else if(hostname.indexOf('.aol.') >-1){			// 0, AOL
		/* AOL */
	
	
		if(hostname.indexOf('.aol.jp')>-1){			// PATCH-45, AOL.jp sniffing prevents styling
			document.addEventListener('DOMContentLoaded', function(){document.documentElement.className='SAF';}, false);
				if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (AOL.jp sniffing prevents styling). See browser.js for details');
		}
		if(hostname.indexOf('aol.com') >-1){			// 188197, Making sure AOL pages are not overwritten by ad script
			avoidDocumentWriteAbuse();
					// PATCH-361, Avoid too tall content on AOL
			addCssToDocument('table.markets-table td{vertical-align:middle}');
				if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Making sure AOL pages are not overwritten by ad script\nAvoid too tall content on AOL). See browser.js for details');
		}
		if(hostname.indexOf('webmail.aol.com') >-1){			// CORE-18580, Converting RGB to Hex confuses "high contrast mode" detection
			if(CSSStyleDeclaration&&CSSStyleDeclaration.prototype&&CSSStyleDeclaration.prototype.__defineGetter__){	
				var CSSStyleDeclaration_color=getComputedStyle(document.documentElement, '').__lookupGetter__('color');
				CSSStyleDeclaration.prototype.__defineGetter__('color', function(){
					var color=CSSStyleDeclaration_color.apply(this,arguments);
					return (color=='#1f293b') ? 'rgb(31,41,59)'  : color;
				});
			}
				if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Converting RGB to Hex confuses "high contrast mode" detection). See browser.js for details');
		}
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (AOL). See browser.js for details');
	} else if(hostname.indexOf('.dell.')!=-1&&hostname.indexOf('support.')!=-1){			// 286618,  browser sniffing on support.dell.com
		opera.defineMagicVariable( 'ig_shared', null, function(o){ o.IsNetscape6=true; return o; } );
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' ( browser sniffing on support.dell.com). See browser.js for details');
	} else if(hostname.indexOf('.ebay.')>-1 || hostname.indexOf('.ebaydesc.')>-1){			// 0, eBay
		/* eBay issues */
	
	
		// Avoid IFRAME resize causing lots of empty space on auctions
				// PATCH-195, Avoid IFRAME resize causing lots of empty space on auctions
		function resizeIframesAndPassSizeOn(e){
			if(e && e.type==='message' && e.origin.indexOf('ebaydesc')>-1){
				for(var iframes=document.getElementsByTagName('iframe'),iframe,i=0;iframe=iframes[i];i++){
					if(iframe.src.indexOf(e.origin)>-1){
						iframe.style.height=(20+parseInt(e.data))+'px';
					}
				}
			}
			if(top!=self)parent.postMessage(document.documentElement.scrollHeight, '*');
		}
		window.addEventListener('message', resizeIframesAndPassSizeOn, false);
		
	
	
		if(hostname.indexOf('.ebay.')>-1){			// PATCH-268, eBay mixes security origins, basic photo upload fails
			 window.addEventListener('load',function(e){
				if( top==self && typeof top.opener ==='object' && window.ebay && ebay.oDocument && ebay.oDocument.oPage && typeof ebay.oDocument.oPage.onMSAResponse === 'function' ){
					var _originalFunc=ebay.oDocument.oPage.onMSAResponse;
					ebay.oDocument.oPage.onMSAResponse=function(){
						try{
							var retval=_originalFunc.apply(this, arguments);
						}catch(e){
							var json='["'+Array.prototype.join.call(arguments, '", "')+'"]';
							top.opener.postMessage('browser.js message: '+json, location.protocol+'//'+document.domain);
							window.close();
						}
						return retval;
					}
				}
			},false);
			
			window.addEventListener('message', function(e){
				var secTest=new RegExp( document.domain+'$', '' );
				if( e.origin.match(secTest) ){
					if(/^browser\.js message: /.test(e.data)){
						ebay.oDocument.oPage.updatePhoto.apply(ebay.oDocument.oPage, JSON.parse(e.data.substring(20)));
					}
				}
			}, false);
			
				if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (eBay mixes security origins, basic photo upload fails). See browser.js for details');
		}
		if(hostname.indexOf('.ebaydesc.')>-1){			// PATCH-195, Avoid IFRAME resize causing lots of empty space on auctions (the IFRAME part)
			window.addEventListener('load', function(){ 
				setTimeout(function(){
					if(top!=self)parent.postMessage(document.documentElement.scrollHeight, '*');
				}, 100); 
			}, false);
			setTimeout(function(){
				if(top!=self)parent.postMessage(document.documentElement.scrollHeight, '*');
			}, 600);
			
				if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Avoid IFRAME resize causing lots of empty space on auctions (the IFRAME part)). See browser.js for details');
		}
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (eBay). See browser.js for details');
	} else if(hostname.indexOf('.geoaccess.com')>-1){			// PATCH-314, PacifiCare doctor finder blocks Opera
		navigator.appName='Netscape';
		opera.defineMagicVariable('is_nav6up', function(){return true},null);
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (PacifiCare doctor finder blocks Opera). See browser.js for details');
	} else if(hostname.indexOf('.google.')>-1){			// 0, Google
		/* Google */
	
	
		if(hostname.indexOf('code.google.')>-1 && (pathname.indexOf('diff')>-1 || pathname.indexOf('detail')>-1 )){			// PATCH-321, Work around pre inheritance into tables on Google Code
			addCssToDocument('div.diff>pre>table{white-space: normal;}div.diff>pre>table th, div.diff>pre>table td{white-space: pre-wrap;}');
				if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Work around pre inheritance into tables on Google Code). See browser.js for details');
		}
		if(hostname.indexOf('docs.google.')>-1){			// PATCH-278, We should not send keypress events for navigation- and function keys
			document.addEventListener('load', function(e){
				if(e.target.tagName && e.target.contentWindow){
					e.target.contentWindow.addEventListener('keypress', function(e){
						if(e.which===0){
							e.__defineGetter__('keyCode', function(){return 0});
						}
					}, true);
				}
			}, true);
			
				if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (We should not send keypress events for navigation- and function keys). See browser.js for details');
		}
		if(hostname.indexOf('spreadsheets')>-1){			// PATCH-382, Google Spreadsheets cell size and column label size mismatch
			addCssToDocument('.row-header-wrapper {display:inline}');
				if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Google Spreadsheets cell size and column label size mismatch). See browser.js for details');
		}
		if(pathname.indexOf('/reader/view')==0){			// PATCH-32, Google Reader wraps long feed titles
			addCssToDocument(".scroll-tree .name { display: block;}");
				if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Google Reader wraps long feed titles). See browser.js for details');
		}
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Google). See browser.js for details');
	} else if(hostname.indexOf('.hotels.com')>-1){			// PATCH-276, Avoid crash when searching on hotels.com
		document.addEventListener('DOMContentLoaded',
			function(){
				ifr = document.getElementById('popupPlate');
				if(ifr && ifr.src.indexOf('blank.html')>-1){
					ifr.src = "about:blank";
				}
			}
		,false)
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Avoid crash when searching on hotels.com). See browser.js for details');
	} else if(hostname.indexOf('.in.gr')>-1){			// PATCH-367, Correct placement of marquee on in.gr
		document.addEventListener('DOMContentLoaded', function(){
		 elm = document.getElementById('ticker-area');
		 if(elm){
		  elm.innerHTML=elm.innerHTML.replace(/&nbsp;/,'');
		 }
		},false);
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Correct placement of marquee on in.gr). See browser.js for details');
	} else if(hostname.indexOf('.ing.nl')>-1){			// PATCH-76, Work around sniffing in old BackBase library on ing.nl
		opera.defineMagicFunction('$Es', function(){});
		window.controllers={}; // detecting some-whatever-Gecko-proprietary-object?
		navigator.productSub=20031002; // anything larger than 20031001
		
				// PATCH-76, Ensure submit button is visible
		addCssToDocument('.bfs-submit{ display: block !important }');
		
				// PATCH-76, Make sure getAttribute() does not confuse an old BackBase lib's code where it uses namespace-like syntax
		Element.prototype.getAttribute =(function (getAttribute){
			return function(name){
				for(var attr,i=0;attr=this.attributes[i];i++){
					if(attr.name==name)return attr.value;
				}
				return null;
			}
		})(Element.prototype.getAttribute);
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Work around sniffing in old BackBase library on ing.nl\nEnsure submit button is visible\nMake sure g...). See browser.js for details');
	} else if(hostname.indexOf('.jcrew.com')>-1){			// PATCH-338, If XHR doesn't support EventTarget interface, setting onload should throw
		XMLHttpRequest.prototype.__defineSetter__('onload', function(){ throw 'unsupported'; });
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (If XHR doesn\'t support EventTarget interface, setting onload should throw). See browser.js for details');
	} else if(hostname.indexOf('.nhl.com')>-1){			// PATCH-215, Broken expanding sections on nhl.com
		addCssToDocument('.sssAccordionItem{overflow: hidden!important}');
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Broken expanding sections on nhl.com). See browser.js for details');
	} else if(hostname.indexOf('.t-online.de')>-1){			// 225374,  video problems on T-online.de
		if(hostname.indexOf('unterhaltung')>-1){
					//Fix browser detection
					opera.defineMagicFunction( 'allResultsOK', function(){return true;} );
					// Fix plugin detection
					opera.defineMagicVariable( 'fHasWMP64', function(){ return navigator.mimeTypes['application/x-mplayer2'].enabledPlugin?true:false }, null )
					opera.defineMagicVariable( 'fHasWMP7', function(){ return navigator.mimeTypes['application/x-mplayer2'].enabledPlugin?true:false }, null )
					opera.defineMagicVariable( 'WMPVer', function(){ try{return fHasWMP64?'6.4':'unknown'}catch(e){return '6.4'} }, null )
			opera.addEventListener( 'BeforeScript',function(e){
				replace.call=call;
				e.element.text=replace.call(e.element.text,  'playerframe.Player.url=url;', 'playerframe.Player.url=url;nplayerframe.Player.Open(url);' );
			},false );
					// use TYPE as well as CLASSID on OBJECT tags in markup
					var objId='Player';
					var objref=null;
					document.addEventListener('DOMContentLoaded', function(e){ 
						if( ! (objref=document.getElementById(objId) ) ) return;
						if(objref.getAttribute('classid')=="CLSID:6BF52A52-394A-11d3-B153-00C04F79FAA6")objref.type='application/x-mplayer2';
					}, false);
					// Remove UI that depends on ActiveX scripting. Built-in WMP UI will do..
					document.addEventListener('DOMContentLoaded', function(e){ 
						var pb=document.getElementById('playBtn');
						var wmp=document.getElementById('playerframe');
						if( pb&&wmp ){
							pb.parentNode.style.visibility='hidden';	wmp.style.visibility='visible';
							try{ document.images.tonaus.height=0;document.images.tonaus.width=0;}catch(e){}
						}
					}, false);
		}
				// 231082,  video problems on T-online.de, WMP license installation
		if(href.indexOf('__license=delivered')>-1){
			location.replace( location.href.replace( /__license=delivered/, '?license=delivered' ) );
		}
		
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' ( video problems on T-online.de\n video problems on T-online.de, WMP license installation). See browser.js for details');
	} else if(hostname.indexOf('.ulead.') >-1){			// DSK-130832, Ulead.com old Milonic menu
		 fixMilonicMenu('mmenu.js');
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Ulead.com old Milonic menu). See browser.js for details');
	} else if(hostname.indexOf('.videoload.de')>-1){			// 231082,  video problems on T-online.de, VOD section
				if( hostname.indexOf('vod')>-1 ){ // 231082
					navigator.userAgent+=' Firefox';
				}
		
				// 226414,  video problems on T-online.de, no window.external detection
		window.external=window.external||{};
		
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' ( video problems on T-online.de, VOD section\n video problems on T-online.de, no window.external dete...). See browser.js for details');
	} else if(hostname.indexOf('.yahoo.')>-1){			// 0, Yahoo!
		/* Yahoo! */
	
	
		if(hostname.indexOf('.mail.yahoo.')>-1&&(href.indexOf( '/dc/system_requirements?browser=blocked' )>-1||href.indexOf( '/dc/system_requirements?browser=unsupported' )>-1)){			// 194334, Y!Mail work around browser blocking
			location.href='/dc/launch?sysreq=ignore';
			
				if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Y!Mail work around browser blocking). See browser.js for details');
		}
		if(hostname.indexOf('.mail.yahoo.')>-1&&(href.indexOf( '/neo/launch' )>-1&&location.search=='')){			// PATCH-325, Y!Mail work around browser blocking
			location.href='/neo/launch?reason=ignore';
			
				if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Y!Mail work around browser blocking). See browser.js for details');
		}
		if(hostname.indexOf('.mail.yahoo.')>=0 && pathname.indexOf('/dc/')==0){			// CORE-17539, Y!Mail spell check fix
			document.__defineGetter__('designMode', function() {
				return this.documentElement.contentEditable=='true' ? 'on' : 'off';
			});
			
			document.__defineSetter__('designMode', function(v) {
				this.documentElement.contentEditable = (v == 'on');
			});
					// CORE-17538, Y!Mail avoid text selection on drag-and-drop
			window.addEventListener('mousedown', function(evt) {
				var target = evt.target;
				var cursor = getComputedStyle(target, null).cursor;
				if (/move/i.test(cursor) || /size/i.test(cursor)) {
					evt.preventDefault();
				} else if (!('value' in target) /* don't preventDefault for <input>, etc */) {
					for (var node = target; node; node = node.parentNode) {
						if (node.hasAttribute && node.hasAttribute('tabindex')) {
							evt.preventDefault();
							break;
						}
					}
				}
			}, true);
					// 321384, createElement in XML document should put un-prefixed nodes in null namespace
			var docCreateElement = Document.prototype.createElement;
			if( window.XMLDocument ){
				XMLDocument.prototype.createElement = function(n){ return n.indexOf(':')==-1 ? this.createElementNS(null, n) : docCreateElement.call(this,n); }
			}else{
				Document.prototype.createElement = function(n){ return n.indexOf(':')==-1 ? this.createElementNS(null, n) : docCreateElement.call(this,n); }
			}
					// 194334, Make sure dragging does not cause visible selections
			addCssToDocument('[unselectable]::selection, [unselectable] ::selection { background-color: transparent; color: inherit }');
					// 327060, Shadow on dialogs is messed up, so fix it
			addCssToDocument('.dialogFooterCenter { font-size: 0; line-height: 0 } ');
					// PATCH-225, Can not scroll to see all messages in inbox if list is taller than 32767px
			document.addEventListener('DOMContentLoaded', function(e, img, addHeight){
				if(img=document.getElementById('sbInner_24')){
					addHeight=parseInt(img.style.height)-32767;
					while(addHeight>0){
						if(addHeight>32767){
							var thisHeight=32767;
						}else{
							thisHeight=addHeight;
						}
						var tmp=img.cloneNode(true);
						img.parentNode.appendChild(document.createElement('br'));
						img.parentNode.appendChild(tmp).style.height=thisHeight+'px';
						addHeight-=thisHeight;
					}
				}
			}, false);
			
					// 353880, Y!Mail reversed mouse wheel scrolling
			opera.addEventListener('BeforeEvent.mousewheel', function(e) {
				var d = e.event.wheelDelta * -1;
				e.event.__defineGetter__('wheelDelta', function() { return d });
			}, false);
					// 194334, Y!Mail remove selectSingleNode and selectNodes
			/* because Yahoo mail is better at emulating proprietary IE functions than we are.. */
			Node.prototype.selectSingleNode=undefined;
			Node.prototype.selectNodes=undefined;
				if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Y!Mail spell check fix\nY!Mail avoid text selection on drag-and-drop\ncreateElement in XML document ...). See browser.js for details');
		}
		if(hostname.indexOf('.mail.yahoo.')>=0 && pathname.indexOf('/mc/')==0){			// PATCH-359, Avoid overwriting Y!Mail classic inbox
			avoidDocumentWriteAbuse();
				if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Avoid overwriting Y!Mail classic inbox). See browser.js for details');
		}
		if(hostname.indexOf('finance.yahoo.')>-1){			// PATCH-297, Fool browser sniffing that prevents stock ticker on Yahoo Finance
			navigator.userAgent = 'Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.9.2.6) Gecko/20100625 Firefox/3.6.6'; 
				if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Fool browser sniffing that prevents stock ticker on Yahoo Finance). See browser.js for details');
		}
		if(hostname.indexOf('mail')==-1){			// 101146, Yahoo ISP portal blocks Opera users
			addPreprocessHandler( /d\.location\.href = ".*?\/browser_upgrade\.html";/g, '');
				if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Yahoo ISP portal blocks Opera users). See browser.js for details');
		}
		if(hostname.indexOf('mail.yahoo')>-1){			// DSK-263826, Keyboard navigation of autocomplete menu fails
			opera.addEventListener('BeforeEvent.keypress', function(e){
				if( e.event.keyCode>36 && e.event.keyCode<41 ){
					e.event.charCode=0;
				}
			}, false);
				if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Keyboard navigation of autocomplete menu fails). See browser.js for details');
		}
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Yahoo!). See browser.js for details');
	} else if(hostname.indexOf('ameba.jp')!=-1){			// 331093, Enable blog post editor on ameba.jp
		navigator.product='Gecko';
		navigator.userAgent=navigator.userAgent.replace('Opera', '0pera (spoofing as Firefox)');
				// 331093, Work around Opera bug where second BR tag overwrites newly inserted IMG
		addPreprocessHandler(/editor\.insertNodeAtSelection\(link\);\s*editor\.insertNodeAtSelection\(document\.createElement\('br'\)\);/, 'editor.insertNodeAtSelection(link);');
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Enable blog post editor on ameba.jp\nWork around Opera bug where second BR tag overwrites newly inse...). See browser.js for details');
	} else if(hostname.indexOf('athome.co.jp') > -1){			// PATCH-147, athome.co.jp Hide warning messages because of Browser UA
		opera.defineMagicFunction('checkTargetBrowser',function(){});
		opera.defineMagicFunction('checkTargetCookie',function(){});
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (athome.co.jp Hide warning messages because of Browser UA). See browser.js for details');
	} else if(hostname.indexOf('att.com')!=-1){			// PATCH-36, ATT / Bellsouth browser sniffing
		opera.defineMagicVariable( 'isDHTML', function(){return true;}, null );
		opera.defineMagicFunction('checkBrowser', function(){});
		navigator.appName='Microsoft Internet Explorer';
		navigator.appVersion='MSIE'+navigator.appVersion;
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (ATT / Bellsouth browser sniffing). See browser.js for details');
	} else if(hostname.indexOf('au.kddi.com')>-1){			// PATCH-376, Make sure main content isn't hidden on KDDI page
		addCssToDocument('.smartphoneBlock{overflow:visible !important}');
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Make sure main content isn\'t hidden on KDDI page). See browser.js for details');
	} else if(hostname.indexOf('auto.meta.ua')>-1){			// PATCH-380, Avoid blinking search field on meta.ua
		addCssToDocument('#a_more{display:block !important}');
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Avoid blinking search field on meta.ua). See browser.js for details');
	} else if(hostname.indexOf('barnesandnoble.com')>-1){			// OTW-1909, Barnes&Noble uses "required" attributes on elements that aren't required
		window.addEventListener('load', function(){var nodes=document.evaluate('//input[@required]', document.body,null,XPathResult.UNORDERED_NODE_SNAPSHOT_TYPE,null),node=null,i=0; while(node=nodes.snapshotItem(i)){ node.removeAttribute('required'); i++; }},false);
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Barnes&Noble uses "required" attributes on elements that aren\'t required). See browser.js for details');
	} else if(hostname.indexOf('bcbssc.com')>-1){			// PATCH-93, Blue Cross SC looks up named elements with getElementById()
		(function(gEBI) { 
		  document.getElementById = function(idOrName) { 
		    return gEBI.call(document, arguments) || document.getElementsByName(idOrName)[0] || null; 
		  }; 
		})(document.getElementById);
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Blue Cross SC looks up named elements with getElementById()). See browser.js for details');
	} else if(hostname.indexOf('bild.de')>-1){			// PATCH-205, Fix image gallery navigation
		addCssToDocument('.bdeFotoGalNavForw a:hover, .bdeFotoGalNavBack a:hover{background:inherit !important;}');
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Fix image gallery navigation). See browser.js for details');
	} else if(hostname.indexOf('blogger.com')>-1){			// DSK-152851, Blogger: browser detection prevents WYSIWYG editing
		navigator.product = 'Gecko';
		navigator.userAgent = navigator.userAgent.replace(/Opera/, 'Firefox')+' ( rv:1.9.0.3)';
		
		opera.defineMagicVariable(
			'Detect',
			function( obj ){return obj;},
			function( obj ){
				obj.OPERA = function(){return false;}
				obj.MOZILLA = function(){return true;}
				obj.IE=function(){return false;}
				obj.IE_5_5_newer=function(){return false;}
				return obj;
			}
		);
		
				// PATCH-206, Don't override native click() method and expect to submit forms by calling click() on a button..
		HTMLInputElement.prototype.click=HTMLButtonElement.prototype.click=HTMLElement.prototype.click;
				// PATCH-207, Spoofing as Mozilla to get rich text editor makes Blogger assume we support enableObjectResizing
		(function(iframeInterface){
			var nativeGetter=(document.createElement('iframe')).__lookupGetter__('contentDocument');
			iframeInterface.__defineGetter__('contentDocument', function(){
				var result=nativeGetter.call(this);
				var nativeExecCommand=result.execCommand;
				result.execCommand=function(){
					try{
						nativeExecCommand.apply(this, arguments);
					}catch(e){
						if(! (arguments[0] in {'enableObjectResizing':1,'enableInlineTableEditing':1})){
							throw e;
						}
					}
				};
				return result;
			});
		})(HTMLIFrameElement.prototype);
		
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Blogger: browser detection prevents WYSIWYG editing\nDon\'t override native click() method and expect...). See browser.js for details');
	} else if(hostname.indexOf('bookryanair.com')>-1){			// 319803, Make Opera's built-in WF2 validation ignore required attributes on bookryanair.com
		ignoreRequiredAttributes();
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Make Opera\'s built-in WF2 validation ignore required attributes on bookryanair.com). See browser.js for details');
	} else if(hostname.indexOf('britannica.com')>-1){			// 332948, Prevent overwriting document with stats graphic on britannica.com
		avoidDocumentWriteAbuse();
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Prevent overwriting document with stats graphic on britannica.com). See browser.js for details');
	} else if(hostname.indexOf('britishairways.')!=-1){			// 206810, Prevent britishairways.com from reloading the page on resize
		opera.defineMagicFunction('resizeHandler', function(){});
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Prevent britishairways.com from reloading the page on resize). See browser.js for details');
	} else if(hostname.indexOf('cajamadrid.es')!=-1){			// PATCH-208, Caja Madrid hides login form by CSS mistake
		document.addEventListener( 'DOMContentLoaded', function(){
			for(var collection=document.getElementsByClassName('clearfix'), el; el=collection[0];){
				el.className = el.className.replace(/clearfix/, '');
			}
		}, false );
		
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Caja Madrid hides login form by CSS mistake). See browser.js for details');
	} else if(hostname.indexOf('cambrian.mb.ca')>-1){			// PATCH-285, Enable log-in button on Cambrian bank
		Element.prototype.__defineGetter__('all', function(){});
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Enable log-in button on Cambrian bank). See browser.js for details');
	} else if(hostname.indexOf('capitalone.com')>-1&&location.protocol=='https:'){			// 86032, CapitalOne login fails - cross-domain access on https disallows setting location
		document.domain='capitalone.com';
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (CapitalOne login fails - cross-domain access on https disallows setting location). See browser.js for details');
	} else if(hostname.indexOf('cdec-sic.cl')!=-1){			// 365516, Old HierMenus on cdec-sic.cl
		fixHierMenus();
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Old HierMenus on cdec-sic.cl). See browser.js for details');
	} else if(hostname.indexOf('chaseonline.chase.com')!=-1){			// 243036, chase.com field refocus from onkeypress-problem
		opera.defineMagicFunction('handleTabs', function(oT, oF, name){
			var el=document.getElementById(name);
			if(el && el.value.length+1>=el.maxLength && !(event.keyCode==8||event.keyCode==46)){
				setTimeout( function(){ jumpToNext(el); }, 100);
			}
			function jumpToNext(el){
				var i=0;
				if(el.form){while(el!=el.form[i])i++;}else{ return;}
				if(el.form[i+1])el.form[i+1].focus();
			}
		});
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (chase.com field refocus from onkeypress-problem). See browser.js for details');
	} else if(hostname.indexOf('computerra.ru')>-1){			// PATCH-267, Make BBCode editor buttons work by disabling Opera sniffing
		document.addEventListener('DOMContentLoaded', function(){
			if(window.jsUtils&&window.jsUtils.bOpera)jsUtils.bOpera=false;
		}, false);
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Make BBCode editor buttons work by disabling Opera sniffing). See browser.js for details');
	} else if(hostname.indexOf('danawa.com')!=-1 && href.indexOf('danawa.com/product/item.html')!=-1){			// PATCH-14, Iframe content height is too small and not expanded on danawa.com
		HTMLBodyElement.prototype.__defineGetter__('offsetHeight', function(){
			return  (this.scrollHeight);
		});
		
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Iframe content height is too small and not expanded on danawa.com). See browser.js for details');
	} else if(hostname.indexOf('di.jal.co.jp')>-1){			// PATCH-237, Delay script execution on JAL map
		var dw=document.write;
		var MapViewer_dw;
		document.write=function( s ){
			if( String(s).indexOf('MapViewer') > -1 ){
				dw.apply(document, ["<div id='MapViewer_holder'></div>"]);
				MapViewer_dw = String(s);
				if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Delay script execution). See browser.js for details');
			}else{
				dw.apply(document, arguments);
			}
		};
		
		window.addEventListener('load',function(e){
			document.getElementById('MapViewer_holder').outerHTML = MapViewer_dw;
		},false)
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Delay script execution on JAL map). See browser.js for details');
	} else if(hostname.indexOf('easycruit.com')>-1){			// PATCH-219, Fujitsu recruitment page on EasyCruit hides content due to browser sniffing
		fixIFrameSSIscriptII('resizeIframe');
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Fujitsu recruitment page on EasyCruit hides content due to browser sniffing). See browser.js for details');
	} else if(hostname.indexOf('enter.nifmail.jp') > -1){			// OTW-4878, Nifmail web mail bypass browser blocking
		opera.defineMagicFunction('checkBrowser',function(){
			return 1;
		},false);
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Nifmail web mail bypass browser blocking). See browser.js for details');
	} else if(hostname.indexOf('espn.go.com')>-1){			// PATCH-375, Make sure the ESPN polls work
		navigator.appName="netscape";
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Make sure the ESPN polls work). See browser.js for details');
	} else if(hostname.indexOf('etour.co.jp') > -1){			// PATCH-152, etour.co.jp fix non-disappearing overlapping image
		navigator.appName='Netscape';
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (etour.co.jp fix non-disappearing overlapping image). See browser.js for details');
	} else if(hostname.indexOf('facebook.com')!=-1){			// PATCH-264, Enable @mentions
		var mentionsPatcher=addPreprocessHandler(/this\.suppressMentions=\(ua\.opera\(\)\|\|/, 'this.suppressMentions=(false||', true, function(el){return indexOf.call(el.text, 'this.suppressMentions=(ua.opera()')>-1; } );
		opera.addEventListener('BeforeEvent.DOMContentLoaded', function(){
			if(document.getElementsByName('status').length==0)opera.removeEventListener('BeforeScript', mentionsPatcher, false);
		}, false);
		
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Enable @mentions). See browser.js for details');
	} else if(hostname.indexOf('fantasy.nfl.com')>-1){			// PATCH-303, Reporting different clientHeight and scrollHeight for TEXTAREA breaks commenting on nfl.com
		HTMLTextAreaElement.prototype.__defineGetter__('clientHeight', function(){
			if(this.scrollHeight>this.rows*parseInt(document.defaultView.getComputedStyle(this,null).getPropertyValue('font-size')) ){
				return this.scrollHeight-1;
			}
			return this.scrollHeight;
		});
		
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Reporting different clientHeight and scrollHeight for TEXTAREA breaks commenting on nfl.com). See browser.js for details');
	} else if(hostname.indexOf('fedex.com')!=-1){			// 363564, FedEx.com mangles tables by turning TDs into block elements
		document.addEventListener('DOMContentLoaded', function(){ for(var els=document.getElementsByTagName('td'),el,i=0;el=els[i];i++)if(el.style.display=='block')el.style.display='';}, false);
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (FedEx.com mangles tables by turning TDs into block elements). See browser.js for details');
	} else if(hostname.indexOf('footballteam.pl')>-1){			// PATCH-358, Enable the password box on footballteam.pl
		HTMLInputElement.prototype.__defineSetter__('type',function(){
			if (this.getAttribute('type')!=arguments[0]) {
				var doFocus=false, result;
				if (this == document.activeElement) doFocus = true;
				result = this.setAttribute('type',arguments[0]);
				if (doFocus) this.focus();
				return result;
			}
		});
		
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Enable the password box on footballteam.pl). See browser.js for details');
	} else if(hostname.indexOf('fujifilm.ch')>-1){			// PATCH-220, Working around a bug that hides menu entries
		addCssToDocument('#navigation ul#primary li ul.secondary_drop_down li {display: inline !important }');
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Working around a bug that hides menu entries). See browser.js for details');
	} else if(hostname.indexOf('geoaccess.com')!=-1){			// 318050,  BlueCross browser sniffing prevents insurance search
		opera.defineMagicVariable('is_nav', function(){return true;}, null);
		
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' ( BlueCross browser sniffing prevents insurance search). See browser.js for details');
	} else if(hostname.indexOf('hangame.co.jp')>-1){			// PATCH-286, Avoid throwing JS errors on Hangame.co.jp from CSS hacks
		var cssInsertRule = CSSStyleSheet.prototype.insertRule;
		CSSStyleSheet.prototype.insertRule = function (rule,index){
			try { cssInsertRule.call(this,rule,index); } catch(e){}
		}
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Avoid throwing JS errors on Hangame.co.jp from CSS hacks). See browser.js for details');
	} else if(hostname.indexOf('hk.centamap.com')>-1){			// PATCH-318, Fix missing menu and misplaced highlights on hk.centamap.com
		document.addEventListener('DOMContentLoaded',function(evt){	// CORE-7324
			parent.document.body.__defineGetter__('offsetHeight',function(){ return parent.window.innerHeight; });
			parent.document.body.__defineGetter__('offsetWidth',function(){ return parent.window.innerWidth; });
		},false);
		if (pathname.indexOf('/i.aspx')>-1) {
			document.addEventListener('DOMContentLoaded',function(evt){	// CORE-25431
				var els=document.getElementsByTagName('a');
				for (var i=0,len=els.length;i<len;i++) {
					if (!els[i].childNodes.length) { els[i].setAttribute('style','display:block;'); }
				}
			},false);
		}
		
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Fix missing menu and misplaced highlights on hk.centamap.com). See browser.js for details');
	} else if(hostname.indexOf('iltasanomat.fi')>-1){			// PATCH-351, Avoid jumping on generated content
		addCssToDocument('ul:after,ol:after{height:1px}')
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Avoid jumping on generated content). See browser.js for details');
	} else if(hostname.indexOf('ingdirect.com.au')>-1){			// 352969, Make Opera's built-in WF2 validation ignore required attributes on ingdirect.com.au
		ignoreRequiredAttributes();
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Make Opera\'s built-in WF2 validation ignore required attributes on ingdirect.com.au). See browser.js for details');
	} else if(hostname.indexOf('investordaily.com.au')>-1){			// PATCH-238, Override minmax IE helper script
		opera.defineMagicFunction('minmax_scan', function(){});
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Override minmax IE helper script). See browser.js for details');
	} else if(hostname.indexOf('isbank.com.tr')>-1){			// 265077,  fixing navigation menu on isbank.com.tr
		opera.addEventListener('BeforeScript', function(e){ replace.call=call; e.element.text=replace.call(e.element.text, 'SaklaGoster(sFrameAdi, 0, i.sMenuAd);};else if', 'SaklaGoster(sFrameAdi, 0, i.sMenuAd);}else if') },false);
		
				// 265077, fixing keypress handler on isbank.com.tr
		var ignoreKeypressCodes = {8:'',9:'',16:'',17:'',35:'',36:'',37:'',38:'',39:'', 40:'',45:'',46:''};
		opera.addEventListener('BeforeEventListener.keypress', function( e ){ preventDefault.call=call; if( e.event.keyCode in ignoreKeypressCodes) preventDefault.call(e); }, false)
		
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' ( fixing navigation menu on isbank.com.tr\nfixing keypress handler on isbank.com.tr). See browser.js for details');
	} else if(hostname.indexOf('kort.arealinfo.dk')>-1){			// PATCH-348, Disable Opera detection that causes hidden content
		opera.defineMagicVariable('op', function(){return false}, null);
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Disable Opera detection that causes hidden content). See browser.js for details');
	} else if(hostname.indexOf('listen.grooveshark.com')>-1){			// PATCH-381, Prevent scroll position reset on grooveshark search results
		HTMLBodyElement.prototype.__defineSetter__('unselectable', function(){});
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Prevent scroll position reset on grooveshark search results). See browser.js for details');
	} else if(hostname.indexOf('login.live.com')!=-1){			// PATCH-242, Prevent readystatechange events on SCRIPT, causes double banners
		opera.addEventListener('BeforeEvent.readystatechange', function(e){
			preventDefault.call=call;
			if(e.event.target instanceof HTMLScriptElement)preventDefault.call(e);
		}, false);
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Prevent readystatechange events on SCRIPT, causes double banners). See browser.js for details');
	} else if(hostname.indexOf('mail.live.com')!=-1){			// CORE-17444, Fix drag and drop in Hotmail
		function fixButton(e) {
			if (e.button == 1) {
				e.__defineGetter__('button', function() { return 0 });
			}
		};
		window.addEventListener('mousedown', fixButton, true);
		window.addEventListener('mousemove', fixButton, true);
		window.addEventListener('mouseup', fixButton, true);
		
				// CORE-17447, Mispositioned sprites due to missing CSS
		addCssToDocument('.c_is { display: inline-block }');
				// CORE-17497, Opera doesn't support col-resize/row-resize cursors.
		addCssToDocument('html .SplitterBarH { cursor: s-resize } html .SplitterBarV { cursor: e-resize } #masterSplitter { cursor: e-resize }');
				// 178723, Emulating IE's cssText property on style sheets
		var getCssText = function() {
			if (!this.href)	{
				return this.ownerNode.textContent;
			} else {
				try {
					var xhr = new XMLHttpRequest();
					xhr.open('GET', this.href, false);
					xhr.send();
					return xhr.responseText;
				} catch(e) {
					return '';
				}
			}
		};
		if (window.__defineGetter__) {
			CSSStyleSheet.prototype.__defineGetter__('cssText', getCssText);
			CSSStyleSheet.prototype.__defineSetter__('cssText', function(v) {
				if (!this.href) {
					this.ownerNode.innerHTML = '';
					return this.ownerNode.appendChild(document.createTextNode(v));
				}
			});
		} else {
			window.addEventListener('load', function(){
				for( var i=0;i<document.styleSheets.length;i++ ){
					if(document.styleSheets[i])
						document.styleSheets[i].cssText = { _styleRef: document.styleSheets[i], toString:function(){
					return this._styleRef.ownerNode.textContent}
					};
				}
			},false);
		}
		
				// PATCH-311, Hidden 'next page' links due to markup errors
		document.addEventListener('DOMContentLoaded', function(){
			var el=document.getElementById('firstPageLink');
			if(el && el.parentNode.tagName=='LI'){
				el=el.parentNode; /* this LI contains some children it shouldn't contain due to </div</li> markup */
				for(var children=el.parentNode.getElementsByTagName('li'),child; child=children[children.length-1];){
					el.parentNode.parentNode.appendChild(child);
				}
				var tmp=document.createElement('div');
				var internalSetter=tmp.__lookupSetter__('innerHTML');
				Element.prototype.__defineSetter__('innerHTML', function(html){
					html=html.replace(/<\/div<\/li>/ig, '</div></li>');
					return internalSetter.call(this, html);
				});
				var internalGetter=tmp.__lookupGetter__('innerHTML');
				Element.prototype.__defineGetter__('innerHTML', function(){
					return internalGetter.call(this);
				});
			}
		}, false);
		
				// DSK-235885, Hotmail uses lookupGetter on prototypes, not instances
		var styleSetterLookupMethod = document.createElement('span').style.__lookupSetter__;
		 CSSStyleDeclaration.prototype.__lookupSetter__ = function(prop){
			return styleSetterLookupMethod.call(document.createElement('span').style, prop);
		 };
				// PATCH-135, Fixes removing contacts from To field by clicking small X icon
		addCssToDocument('.ContactPicker_AutoComplete img{position:static!important;}');
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Fix drag and drop in Hotmail\nMispositioned sprites due to missing CSS\nOpera doesn\'t support col-re...). See browser.js for details');
	} else if(hostname.indexOf('meebo.com')>-1){			// OTW-6247, Meebo tries to use detachEvent to remove listeners added with addEventListener due to inversed feature detection in their ui.detachEvent method
		delete window.detachEvent;
		delete Node.prototype.detachEvent;
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Meebo tries to use detachEvent to remove listeners added with addEventListener due to inversed featu...). See browser.js for details');
	} else if(hostname.indexOf('moneta.co.kr')!=-1){			// 219041,  moneta.co.kr relies on IE quirks for CSS positioning
		addCssToDocument('#stocking{position:relative}#stocking>div{position:absolute}');
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' ( moneta.co.kr relies on IE quirks for CSS positioning). See browser.js for details');
	} else if(hostname.indexOf('myspace.com')>-1){			// PATCH-266, Opera disallows using reserved word top as variable name
		(function(){
			var the_top;
			opera.defineMagicVariable('top', function(){return the_top;}, function(o){the_top=o;});
		})();
		
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Opera disallows using reserved word top as variable name). See browser.js for details');
	} else if(hostname.indexOf('nbc.com')>-1){			// PATCH-236, Make NBC videos work
		navigator.userAgent += " Chrome/5.0.375.9 Safari/533.4"
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Make NBC videos work). See browser.js for details');
	} else if(hostname.indexOf('news.naver.com')>-1){			// PATCH-241, Make menus visible on news.naver.com
		addCssToDocument('div.snb li div {overflow: visible !important;}');
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Make menus visible on news.naver.com). See browser.js for details');
	} else if(hostname.indexOf('news.qq.com')>-1){			// PATCH-112, Requires add() method on SELECT elements
		HTMLSelectElement.prototype.add=function(){this.appendChild.apply(this,arguments);};
				// PATCH-112, weather.news.qq.com expects getElementById() to find named elements
		var gEBI=document.getElementById;
		document.getElementById=function(){
			var result=gEBI.apply(this, arguments);
			if(!result)result=document.getElementsByName.apply(this,arguments)[0];
			return result;
		}
				// PATCH-112, weather.news.qq.com uses document.all for browser detection
		opera.defineMagicVariable('ie4',function(){return true;}, null);
				// OTW-4861, qq.com uses IE-style CSS filters
		fakeCSSFilters();
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Requires add() method on SELECT elements\nweather.news.qq.com expects getElementById() to find named...). See browser.js for details');
	} else if(hostname.indexOf('nrg.co.il')>-1){			// 244416,  NRG.co.il saving articles does not work
		addPreprocessHandler('document.getElementById("launcher").innerHTML="";', '');
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' ( NRG.co.il saving articles does not work). See browser.js for details');
	} else if(hostname.indexOf('nyteknik.se')>-1){			// PATCH-265, nyteknik.se uses parent as variable name
		enableRedefiningParent();
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (nyteknik.se uses parent as variable name). See browser.js for details');
	} else if(hostname.indexOf('opera.com')>-1&& pathname.indexOf('/docs/browserjs/')==0){			// 0, Browser.js status and version reported on browser.js documentation page
		document.addEventListener((parseFloat(opera.version())>9?'DOMContentLoaded':'load'),function(){
			if(document.getElementById('browserjs_active')){
				document.getElementById('browserjs_active').style.display='';
				document.getElementById('browserjs_active').getElementsByTagName('span')[0].appendChild(document.createTextNode(bjsversion));
				document.getElementById('browserjs_status_message').style.display='none';
			}else if(document.getElementById('browserjs_status_message')){
				document.getElementById('browserjs_status_message').firstChild.data='Browser.js is enabled! '+bjsversion;
			}
		}, false);
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Browser.js status and version reported on browser.js documentation page). See browser.js for details');
	} else if(hostname.indexOf('orbitdownloader.com')>-1){			// PATCH-322, Force height to avoid overlapping on orbitdownloader
		addCssToDocument('div.flag{height:1.1em;}');
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Force height to avoid overlapping on orbitdownloader). See browser.js for details');
	} else if(hostname.indexOf('orkut.com')>-1){			// PATCH-21, can't change orkut avatar picture
		var tmp=document.createElement('img');
		var w_getter=tmp.__lookupGetter__('width');
		var h_getter=tmp.__lookupGetter__('height');
		HTMLImageElement.prototype.__defineGetter__('height', function(){
			var h=h_getter.call(this), img;
			if(h==0){
				(img=new Image()).src=this.src;
				return h_getter.call(img);
			}
			return h;
		});
		HTMLImageElement.prototype.__defineGetter__('width', function(){
			var w=w_getter.call(this), img;
			if(w==0){
				(img=new Image()).src=this.src;
				return w_getter.call(img);
			}
			return w;
		});
		HTMLImageElement.prototype.__defineSetter__('width', tmp.__lookupSetter__('width'));
		HTMLImageElement.prototype.__defineSetter__('height', tmp.__lookupSetter__('height'));
				// CORE-19206, orkut avatar image crop does not happen because of timing issue
		(function(sTo){
			window.setTimeout=function(f,t){
				if( t==0 && !document.body )t=100;
				sTo.call( window, f, t );
			}
		})(window.setTimeout);
				// PATCH-229, Hidden form causes non-clickable button, prevents profile image selection
		addCssToDocument('form{opacity:1!important}');
				// PATCH-374, Panning an Orkut profile scrolls down to an unwanted loading message, hide it
		addCssToDocument('#orkutLoading {display: none;visibility: hidden}');
				// PATCH-377, Make it possible to log in to Orkut with 11.01
		window.__defineGetter__('orkutFrame', function(){
		  if(typeof arguments.callee.patchedWindowObjects=='undefined')arguments.callee.patchedWindowObjects=[];
		  var win, iframe=document.getElementById('orkutFrame');
		  if(iframe){
		    win=iframe.contentWindow;
		    if( arguments.callee.patchedWindowObjects.indexOf(win)==-1 ){
		      var realReplace=win.location.replace;
		      win.location.replace=function(str){
		        if(str==='about:blank')str='javascript:';
		        return realReplace.call(this, str);
		      }
		    }
		  }
		  return win;
		});
		
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (can\'t change orkut avatar picture\norkut avatar image crop does not happen because of timing issue\n...). See browser.js for details');
	} else if(hostname.indexOf('paypal.com') >-1){			// PATCH-366, Fix unclickable credit card selection box on PayPal
		addCssToDocument('div#fieldrowCCType div#selectBox{position:absolute;}');
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Fix unclickable credit card selection box on PayPal). See browser.js for details');
	} else if(hostname.indexOf('pb.yamada-denki.jp')>-1){			// OTW-5165, Show digital pamphlet from Yamada Denki
		Element.prototype.attachEvent = null;
		window.opera = null;
		document.addEventListener('DOMContentLoaded',function(e){
			document.addEventListener('mousewheel',onMouseWheel,true);
		},false);
		
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Show digital pamphlet from Yamada Denki). See browser.js for details');
	} else if(hostname.indexOf('pluginfree.com') > -1){			// PATCH-105, DNP Pluginfree Viewer fallback to Netscape version for Opera
		opera.defineMagicFunction('sort',function(rf,rt){
			var res;
			return (res=rf.apply(rt,slice.call(arguments, 2)))?res:"nn";
		},false);
		
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (DNP Pluginfree Viewer fallback to Netscape version for Opera). See browser.js for details');
	} else if(hostname.indexOf('rabobank.nl')!=-1){			// 277063,  Rabobank cancels t keypress
		opera.addEventListener('AfterEvent.keypress', function(e){
			preventDefault.call=call;
			if(e.event.keyCode==116 && e.eventCancelled)preventDefault.call(e);
		},false);
		
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' ( Rabobank cancels t keypress). See browser.js for details');
	} else if(hostname.indexOf('rediff.com')>-1){			// PATCH-269, Reposition invisible file input - Opera requires click on choose button, not text part of input
		addCssToDocument('.fileclass{ position:absolute!important;right:0px !important }');
				// PATCH-269, window.focus() does not focus a body with contentEditable set, cursor often disappears while writing mail
		window.addEventListener('load', function(e,el){
			if(el=document.getElementById('wysiwygmsgbody'))el.contentWindow.focus=function(){this.document.body.focus();}
		}, false);
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Reposition invisible file input - Opera requires click on choose button, not text part of input\nwin...). See browser.js for details');
	} else if(hostname.indexOf('salesforce.com')>-1){			// PATCH-176, Allow upload of workspace resources
		HTMLIFrameElement.prototype.__defineSetter__('onreadystatechange', function(){});
		
		opera.addEventListener('BeforeEventListener.load', 
			function(e){
				preventDefault.call=call;
				if(e.event.target.contentDocument && e.event.target.contentDocument.body.innerHTML == ""){
					preventDefault.call(e);
				}
			},
			false
		);
				// PATCH-87, Downloading documents on salesforce.com runs into too strict anti-drive-by-install security
		(function() {
			var x = document.createElement('iframe');
			var getSRC = x.__lookupGetter__('src');
			var setSRC = x.__lookupSetter__('src');
			x = null;
			var p = HTMLIFrameElement.prototype;
			p.__defineGetter__('src', function() {
				return getSRC.apply(this, arguments);
			});
			p.__defineSetter__('src', function(v) {
				if (v.indexOf('/download/') > -1) {
					this.contentWindow.location.href = v;
				} else {
					setSRC.apply(this, arguments);
				}
			});
		})();
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Allow upload of workspace resources\nDownloading documents on salesforce.com runs into too strict an...). See browser.js for details');
	} else if(hostname.indexOf('seb-bank.de')>-1){			// PATCH-84, SEB bank prevents typing certain keys
		ignoreCancellationOfCertainKeyEvents('keypress', {114:'', 116:'', 117:'', 122:''});
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (SEB bank prevents typing certain keys). See browser.js for details');
	} else if(hostname.indexOf('shimano.com')>-1){			// PATCH-329, Disable element.document support, breaks shimano.com menu
		Node.prototype.__defineGetter__('document', function(){});
		
		
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Disable element.document support, breaks shimano.com menu). See browser.js for details');
	} else if(hostname.indexOf('shoptime.com.br')>-1){			// PATCH-81, Fix for not possible to type since Opera does not support charCode
		defineMagicFunction.call(opera, 'soNums',
					function(real, e, args){
						evt = event.keyCode;
						if (evt <20 || (evt >47 && evt<58) ){return true;}
		            return false;
					},
				null);
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Fix for not possible to type since Opera does not support charCode). See browser.js for details');
	} else if(hostname.indexOf('show.co.kr')!=-1){			// 348818, Pre-filled text as INPUT background not cleared on focus
		document.addEventListener('focus', function(e){if(e.target.tagName=='INPUT'){e.target.style.backgroundImage='none'; e.target.onfocus=null;}},true);
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Pre-filled text as INPUT background not cleared on focus). See browser.js for details');
	} else if(hostname.indexOf('siren24.com')!=-1){			// SEOUL-609, ActiveX installation page redirect on siren24.com due to sniffing limitation on redirect script
		navigator.appName = 'Netscape';
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (ActiveX installation page redirect on siren24.com due to sniffing limitation on redirect script). See browser.js for details');
	} else if(hostname.indexOf('smithbarney.com')>-1){			// PATCH-360, Enable the password box on smithbarney.com
		HTMLInputElement.prototype.__defineSetter__('type',function(){
			if (this.getAttribute('type')!=arguments[0]) {
				var doFocus=false, result;
				if (this == document.activeElement) doFocus = true;
				result = this.setAttribute('type',arguments[0]);
				if (doFocus) this.focus();
				return result;
			}
		});
		
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Enable the password box on smithbarney.com). See browser.js for details');
	} else if(hostname.indexOf('sogou.com')>-1){			// PATCH-72, Sogou.com uses window.MouseEvent
		window.MouseEvent=Event;
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Sogou.com uses window.MouseEvent). See browser.js for details');
	} else if(hostname.indexOf('spaces.live.com')!=-1){			// 311225, Make Range.prototype.insertNode automatically import nodes from other documents
		var rangeInsertNode = Range.prototype.insertNode;
		Range.prototype.insertNode = function(n){
			if(this.startContainer && this.startContainer.ownerDocument && n.ownerDocument != this.startContainer.ownerDocument )n=this.startContainer.ownerDocument.importNode(n, true);
			return rangeInsertNode.call(this,n);
		}
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Make Range.prototype.insertNode automatically import nodes from other documents). See browser.js for details');
	} else if(hostname.indexOf('support.asus.com')>-1){			// PATCH-362, Prevent Asus browser sniffing from breaking support site software download
		navigator.appName='Netscape';
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Prevent Asus browser sniffing from breaking support site software download). See browser.js for details');
	} else if(hostname.indexOf('sytadin.fr')!=-1){			// 365351, Sytadin.fr IFRAME resize script detects Opera
		fixIFrameSSIscriptII('resizeIframeOnContent');
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Sytadin.fr IFRAME resize script detects Opera). See browser.js for details');
	} else if(hostname.indexOf('tdwaterhouse.ca')>-1&&location.protocol=='https:'){			// 147840, tdwaterhouse.ca login fails - cross-domain access on https disallows setting location
		document.domain='tdwaterhouse.ca';
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (tdwaterhouse.ca login fails - cross-domain access on https disallows setting location). See browser.js for details');
	} else if(hostname.indexOf('tickets.com')!=-1){			// MGTRN-2289, Scripts are not allowed to use reserved identifier "top"
		addPreprocessHandler( /top\(\)/g, '_top()' );
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Scripts are not allowed to use reserved identifier "top"). See browser.js for details');
	} else if(hostname.indexOf('tieba.baidu.com')>-1){			// DSK-275537, insert Vcode elements in advance to avoid insert element during typing
		if(pathname=="/f"){
		document.addEventListener("DOMContentLoaded", function(){
			antiAnswer.antiProcess();
		    if (PageData.is_need_verify) {
		        if (VCodePanel.isEmpty()) {
		            VCodePanel.show()
		        }
		    }
		}, false);
		}
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (insert Vcode elements in advance to avoid insert element during typing). See browser.js for details');
	} else if(hostname.indexOf('tistory.com')!=-1){			// 347990, two login buttons on tistory.com
		addCssToDocument('#memberbox .btn-login {text-indent:-100px;}');
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (two login buttons on tistory.com). See browser.js for details');
	} else if(hostname.indexOf('tuenti.com')!=-1){			// DSK-243723, Problems submitting messages and comments on tuenti.com
		opera.addEventListener('BeforeEventListener.load', function(e){preventDefault.call=call;
			if( e.event.target.contentWindow && e.event.target.contentWindow.location.href =='about:blank' )preventDefault.call(e);
		}, false);
				// PATCH-134, Videos not shown
		navigator.userAgent += ' [NOT firefox/3]';
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Problems submitting messages and comments on tuenti.com\nVideos not shown). See browser.js for details');
	} else if(hostname.indexOf('tvguide.com')>-1){			// PATCH-274, TVGuide doesn't show program descriptions, due to browser sniffing
		opera.defineMagicVariable('isSafari', function(){return true;}, null);
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (TVGuide doesn\'t show program descriptions, due to browser sniffing). See browser.js for details');
	} else if(hostname.indexOf('usairways.com')>-1){			// 0,  USAirways is not compatible with WF2 spec required attribute
		opera.addEventListener('BeforeEvent.invalid', function(e){
			/* they specify required="True" attributes on hidden form elements. This tries to check if they are hidden
			and make sure they are temporarily "un-required" if they are */
			getAttribute.call = getComputedStyle.call = removeAttribute.call = setTimeout.call = preventDefault.call = call;
			var el=e.event.target;
			if( getAttribute.call(el, 'required')=='True' && getComputedStyle.call(window, el).visibility=='hidden' ){
				removeAttribute.call(el,'required');
				setTimeout.call(window, function(){setAttribute.call=call; setAttribute.call(el,'required', 'True');},0 )
				preventDefault.call(e.event);
			}
		}, false);
		
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' ( USAirways is not compatible with WF2 spec required attribute). See browser.js for details');
	} else if(hostname.indexOf('usatoday.com')!=-1){			// OTW-4689, Work around browser sniffing to make videos appear
		navigator.product='Gecko';
		window.find=function(){};
		
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Work around browser sniffing to make videos appear). See browser.js for details');
	} else if(hostname.indexOf('vgtv.no')>-1 || hostname.indexOf('movenetworkshd.com')>-1){			// PATCH-110, Work around browser sniffing for Move media player
		opera.defineMagicVariable('QI', function(o){ o.browserIsGood=true; return o; }, null);
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Work around browser sniffing for Move media player). See browser.js for details');
	} else if(hostname.indexOf('viddler.com')>-1){			// PATCH-80, Prevent re-execution of scripts on viddler.com
		if(HTMLScriptElement.prototype.__defineGetter__)HTMLScriptElement.prototype.__defineGetter__('childNodes', function(){return []});
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Prevent re-execution of scripts on viddler.com). See browser.js for details');
	} else if(hostname.indexOf('voddler.com')>-1){			// PATCH-337, Remove browser warning message and allow movie playback
		addPreprocessHandler( 'if (browserMessage)', 'if (browserMessage && !(isWindows || (isOSX && isValidOSX)))');
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Remove browser warning message and allow movie playback). See browser.js for details');
	} else if(hostname.indexOf('westjet.com')>-1 ){			// PATCH-260,  Westjet browser sniffing warns against Opera
		opera.defineMagicVariable('browser', function(o){ o.isSupported=true; return o; }, null);
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' ( Westjet browser sniffing warns against Opera). See browser.js for details');
	} else if(hostname.indexOf('www.kpn.com')>-1){			// PATCH-153, kpn.com hides body by mistake
		addCssToDocument('body{display:block!important}');
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (kpn.com hides body by mistake). See browser.js for details');
	} else if(hostname.indexOf('www.weather.com')>-1){			// PATCH-294, Hide extra button text on weather.com
		document.addEventListener('DOMContentLoaded',
		 function(){
		  elm = document.getElementsByClassName('twc-weather-search-submit')[0];
		  if(elm && elm.type=='submit'){
		   elm.value='';
		  }
		 },
		 false
		);
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Hide extra button text on weather.com). See browser.js for details');
	} else if(hostname.indexOf('www.yoka.com')>-1){			// PATCH-238, Override minmax IE helper script
		opera.defineMagicFunction('minmax_scan', function(){});
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Override minmax IE helper script). See browser.js for details');
	} else if(hostname=='my.tnt.com'){			// PATCH-48, force all images to load before printing TNT delivery sheet
		opera.defineMagicFunction('printPageDirect',function (func,realThis) {
			var total = document.images.length, loaded = 0, imgs = [];
			for( var i = 0; i < total; i++ ) {
				imgs[i] = new Image();
				imgs[i].onload = imgs[i].onerror = function () {
					loaded++;
					if( total == loaded ) {
						func.apply(realThis, slice.call(arguments, 2));
					}
				};
				imgs[i].src = document.images[i].src;
			}
			setTimeout(function () {
				if( total > loaded ) {
					loaded = total;
					func.apply(realThis, slice.call(arguments, 2));
				}
			},10000);
		});
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (force all images to load before printing TNT delivery sheet). See browser.js for details');
	} else if(href.indexOf('/sample_lr.html')>-1){			// PATCH-128, Sun Webmail fails to set document.domain due to browser sniffing
		navigator.userAgent+=' Gecko';
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Sun Webmail fails to set document.domain due to browser sniffing). See browser.js for details');
	} else if(href==='https://bugs.opera.com/wizard/'){			// PATCH-221, Include browser.js timestamp in bug reports
		document.addEventListener('DOMContentLoaded', function(){
			var frm;
			if(document.getElementById('bug') instanceof HTMLFormElement){
				frm=document.getElementById('bug');
				if(frm.auto)frm.auto.value+='\n\nBrowser JavaScript: \n'+bjsversion;
			}
		}, false);
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Include browser.js timestamp in bug reports). See browser.js for details');
	} else if(pathname.indexOf("Maconomy/MaconomyPortal") > -1){			// PATCH-6, Fix unload form submit behavior on Maconomy portals
		opera.addEventListener("BeforeEvent.unload", function(e){
				if(!(typeof doSubmitEmptyData==='function'))return;
				var original_function = doSubmitEmptyData;
				doSubmitEmptyData = function( command, parameter_1, parameter_2, parameter_3, formSetup ){
					var form = viewDocument.forms["emptyForm"], node;
					setupForm(form, formSetup);
					form.windowSerialId.value = windowSerialId;
					form.command.value        = command;
					form.parameter_1.value    = parameter_1;
					form.parameter_2.value    = parameter_2;
					form.parameter_3.value    = parameter_3;
					form.dataChanged.value    = (formSetup.dataChanged == null ? 0 : (formSetup.dataChanged ? 1 : 0));
					form.componentName.value  = "";
		
					var getstr = "";
					for (i=0; node = form.elements[i]; i++) {
						switch(node.type){
							case "hidden":
							case "text":
							case "select-one":
								getstr += escape(node.name) + "=" + escape(node.value) + "&";
								break;
							case "checkbox":
								if (node.checked) {
									getstr += escape(node.name) + "=" + escape(node.value) + "&";
								} else {
									getstr += escape(node.name) + "=&";
								}
								break;
							case "radio":
								if (node.checked) {
									getstr += escape(node.name) + "=" + escape(node.value) + "&";
								}
								break;
						}
		
					}
					getstr = getstr.replace(/&$/,""); //remove trailing &
					var xhr = new XMLHttpRequest();
					xhr.open("POST",form.action,true);
					xhr.setRequestHeader("Content-Type","application/x-www-form-urlencoded");
					xhr.send(getstr);
					resetForm(form);
					doSubmitEmptyData = original_function;
			}
		},false);
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Fix unload form submit behavior on Maconomy portals). See browser.js for details');
	} else if(pathname.indexOf('/zimbra/')>-1){			// PATCH-255, Work around browser sniffing that prevents Zimbra's rich text editor from loading
		opera.defineMagicVariable('AjxEnv', null, function(obj){
			obj.__defineGetter__('isGeckoBased', function(){return true;});
			obj.__defineSetter__('isGeckoBased', function(){});
			return obj;
		});
		
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Work around browser sniffing that prevents Zimbra\'s rich text editor from loading). See browser.js for details');
	}

})(opera);
