/* $Id: alloc_func.cpp 16273 2009-05-10 21:33:55Z rubidium $ */

/** @file alloc_func.cpp Functions to 'handle' memory allocation errors */

#include "../stdafx.h"
#include "alloc_func.hpp"

/**
 * Function to exit with an error message after malloc() or calloc() have failed
 * @param size number of bytes we tried to allocate
 */
void NORETURN MallocError(size_t size)
{
	error("Out of memory. Cannot allocate " PRINTF_SIZE " bytes", size);
}

/**
 * Function to exit with an error message after realloc() have failed
 * @param size number of bytes we tried to allocate
 */
void NORETURN ReallocError(size_t size)
{
	error("Out of memory. Cannot reallocate " PRINTF_SIZE " bytes", size);
}
