#define COMMA_NUM_32 "\x7B"
#define COMMA_NUM_16 "\x7C"
#define COMMA_NUM_8  "\x7D"

#define NUM_U16 "\x7E"
#define CURRENCY "\x7F"
#define STRING "\x80"

#define STRING_INL(x) "\x81"
#define DATE_LONG "\x82"
#define DATE_SHORT "\x83"

#define SPEED "\x84"
#define SKIP_16 "\x85"

#define VOLUME "\x86"

static const char * const _default_strings[] = {
"\x94" "Cannot remove obstacles on land",
"\x94" "Off edge of map",
"\x94" "Too close to edge of map",
"\x94" "Not enough cash - requires " "\x7F",
"\x94" "\x7F",
"\x8B" "\x7F",
"",
"\x94" "Flat land required",
"\x98" "Waiting: " "\x94" "\x80",
"\x94" "\x80",
"\x94" "\x80" "\x90" "  (en-route from",
"\x90" "\x80" ")",
"\x98" "Accepts: " "\x94",
"\x98" "Accepts: " "\x8A",
"",
"Passengers",
"Coal",
"Mail",
"Oil",
"Livestock",
"Goods",
"Grain",
"Wood",
"Iron Ore",
"Steel",
"Valuables",
"Copper Ore",
"Maize",
"Fruit",
"Diamonds",
"Food",
"Paper",
"Gold",
"Water",
"Wheat",
"Rubber",
"Sugar",
"Toys",
"Candy",
"Cola",
"Cotton Candy",
"Bubbles",
"Toffee",
"Batteries",
"Plastic",
"Fizzy Drinks",
"",
"Passenger",
"Coal",
"Mail",
"Oil",
"Livestock",
"Goods",
"Grain",
"Wood",
"Iron Ore",
"Steel",
"Valuables",
"Copper Ore",
"Maize",
"Fruit",
"Diamond",
"Food",
"Paper",
"Gold",
"Water",
"Wheat",
"Rubber",
"Sugar",
"Toy ",
"Candy",
"Cola",
"Cotton Candy",
"Bubble",
"Toffee",
"Battery",
"Plastic",
"Fizzy Drink",
"",
"\x7C" " passenger",
"\x7C" " ton of coal",
"\x7C" " bag of mail",
"\x87" " of oil",
"\x7C" " item of livestock",
"\x7C" " crate of goods",
"\x7C" " ton of grain",
"\x7C" " ton of wood",
"\x7C" " ton of iron ore",
"\x7C" " ton of steel",
"\x7C" " bag of valuables",
"\x7C" " ton of copper ore",
"\x7C" " ton of maize",
"\x7C" " ton of fruit",
"\x7C" " bag of diamonds",
"\x7C" " ton of food",
"\x7C" " ton of paper",
"\x7C" " bag of gold",
"\x87" " of water",
"\x7C" " ton of wheat",
"\x87" " of rubber",
"\x7C" " ton of sugar",
"\x7C" " toy",
"\x7C" " bag of candy",
"\x87" " of cola",
"\x7C" " ton of cotton candy",
"\x7C" " bubble",
"\x7C" " ton of toffee",
"\x7C" " battery",
"\x87" " of plastic",
"\x7C" " fizzy drink",
"",
"\x7C" " passengers",
"\x7C" " tons of coal",
"\x7C" " bags of mail",
"\x87" " of oil",
"\x7C" " items of livestock",
"\x7C" " crates of goods",
"\x7C" " tons of grain",
"\x7C" " tons of wood",
"\x7C" " tons of iron ore",
"\x7C" " tons of steel",
"\x7C" " bags of valuables",
"\x7C" " tons of copper ore",
"\x7C" " tons of maize",
"\x7C" " tons of fruit",
"\x7C" " bags of diamonds",
"\x7C" " tons of food",
"\x7C" " tons of paper",
"\x7C" " bags of gold",
"\x87" " of water",
"\x7C" " tons of wheat",
"\x87" " of rubber",
"\x7C" " tons of sugar",
"\x7C" " toys",
"\x7C" " bags of candy",
"\x87" " of cola",
"\x7C" " tons of cotton candy",
"\x7C" " bubbles",
"\x7C" " tons of toffee",
"\x7C" " batteries",
"\x87" " of plastic",
"\x7C" " fizzy drinks",
"",
"\x0E" "PS",
"\x0E" "CL",
"\x0E" "ML",
"\x0E" "OL",
"\x0E" "LV",
"\x0E" "GD",
"\x0E" "GR",
"\x0E" "WD",
"\x0E" "OR",
"\x0E" "ST",
"\x0E" "VL",
"\x0E" "CO",
"\x0E" "MZ",
"\x0E" "FT",
"\x0E" "DM",
"\x0E" "FD",
"\x0E" "PR",
"\x0E" "GD",
"\x0E" "WR",
"\x0E" "WH",
"\x0E" "RB",
"\x0E" "SG",
"\x0E" "TY",
"\x0E" "SW",
"\x0E" "CL",
"\x0E" "CF",
"\x0E" "BU",
"\x0E" "TF",
"\x0E" "BA",
"\x0E" "PL",
"\x0E" "FZ",
"\x94" "\x83",
"\x94" "\x82",
"\x94" "Map - " "\x80",
"\x94" "Game Options",
"\x90" "Message",
"\x90" "Message from " "\x80",
"\x94" "Can't do this....",
"\x94" "Can't clear this area....",
"\x98" "Copyright " "\xA9" " 1995 Chris Sawyer, All rights reserved",
"\x98" "Version 3.02.011  11th October 1996 17:23:14",
"\x98" "Designed & Programmed by Chris Sawyer",
"\x98" "Graphics by Simon Foster",
"\x98" "Windows'95 conversion by FISH (UK) Ltd.\rProgrammed by Joe Booth\rAdditional code by Nick Tuckett\rWin'95 specific code " "\xA9" " 1996 FISH Technology Group\r\rMusic by John Broomhall\rSound Programming by Andrew Parton\r\rQuality Assurance:\rAndrew Luckett, Don Witcombe, Craig Lear, Daniel Luton, Justin Manning,\rJason Sampson, Darren Kirby, Phil McDonnell, Patrice Stauder\r\rProduced by Grant Dean and James Hawkins\rProducer for ITOCHU: Yasuo Kojima\rExecutive Producer: Mike Rudderham\r\rThanks to: Jacqui Lyons at Marjacq Micro\r",
"\x98" "Memory: " "\x7B" "K (" "\x7B" "K unused)",
"\x98" "Memory Manager:" "\x80" "\x80" "\x80" "\x80" "\x80",
"\x98" "Processor: 80" "\x7D" "86",
"\x98" "Graphics: VESA (",
"VESA (",
"ATI",
"Trident",
"Oak Technologies",
"Tseng Labs",
"Paradise",
"\x98" "\xAD",
"\x89" "\xAD",
"\x94" "Quit",
"\x98" "Yes",
"\x98" "No",
"\x90" "Are you sure you want to abandon this game and return to Windows ?",
"\x98" "1",
"\x98" "2",
"\x98" "3",
"\x98" "4",
"\x98" "5",
"Nothing",
"Dark Blue",
"Pale Green",
"Pink",
"Yellow",
"Red",
"Light Blue",
"Green",
"Dark Green",
"Blue",
"Cream",
"Mauve",
"Purple",
"Orange",
"Brown",
"Grey",
"White",
"\x94" "Too many vehicles in game",
"\x98" "\x7C",
"\x8B" "\x7C",
"\x98" "Location",
"Contours",
"Vehicles",
"Industries",
"Routes",
"Vegetation",
"Owners",
"\x98" "\x0E" "Roads",
"\x98" "\x0E" "Railroads",
"\x98" "\x0E" "Stations/Airports/Docks",
"\x98" "\x0E" "Buildings/Industries",
"\x98" "\x0E" "Vehicles",
"\x98" "\x0E" "100m",
"\x98" "\x0E" "200m",
"\x98" "\x0E" "300m",
"\x98" "\x0E" "400m",
"\x98" "\x0E" "500m",
"\x98" "\x0E" "Trains",
"\x98" "\x0E" "Road Vehicles",
"\x98" "\x0E" "Ships",
"\x98" "\x0E" "Aircraft",
"\x98" "\x0E" "Transport Routes",
"\x98" "\x0E" "Coal Mine",
"\x98" "\x0E" "Power Station",
"\x98" "\x0E" "Forest",
"\x98" "\x0E" "Sawmill",
"\x98" "\x0E" "Oil Refinery",
"\x98" "\x0E" "Farm",
"\x98" "\x0E" "Factory",
"\x98" "\x0E" "Printing Works",
"\x98" "\x0E" "Oil Wells",
"\x98" "\x0E" "Iron Ore Mine",
"\x98" "\x0E" "Steel Mill",
"\x98" "\x0E" "Bank",
"\x98" "\x0E" "Paper Mill",
"\x98" "\x0E" "Gold Mine",
"\x98" "\x0E" "Food Processing Plant",
"\x98" "\x0E" "Diamond Mine",
"\x98" "\x0E" "Copper Ore Mine",
"\x98" "\x0E" "Fruit Plantation",
"\x98" "\x0E" "Rubber Plantation",
"\x98" "\x0E" "Water Supply",
"\x98" "\x0E" "Water Tower",
"\x98" "\x0E" "Lumber Mill",
"\x98" "\x0E" "Cotton Candy Forest",
"\x98" "\x0E" "Candy Factory",
"\x98" "\x0E" "Battery Farm",
"\x98" "\x0E" "Cola Wells",
"\x98" "\x0E" "Toy Shop",
"\x98" "\x0E" "Toy Factory",
"\x98" "\x0E" "Plastic Fountains",
"\x98" "\x0E" "Fizzy Drink Factory",
"\x98" "\x0E" "Bubble Generator",
"\x98" "\x0E" "Toffee Quarry",
"\x98" "\x0E" "Sugar Mine",
"\x98" "\x0E" "Railroad Station",
"\x98" "\x0E" "Truck Loading Bay",
"\x98" "\x0E" "Bus Station",
"\x98" "\x0E" "Airport/Heliport",
"\x98" "\x0E" "Dock",
"\x98" "\x0E" "Rough Land",
"\x98" "\x0E" "Grass Land",
"\x98" "\x0E" "Bare Land",
"\x98" "\x0E" "Fields",
"\x98" "\x0E" "Trees",
"\x98" "\x0E" "Rocks",
"\x98" "\x0E" "Water",
"\x98" "\x0E" "No Owner",
"\x98" "\x0E" "Towns",
"\x98" "\x0E" "Industries",
"\x98" "\x0E" "Desert",
"\x98" "\x0E" "Snow",
"\x94" "Message",
"\x94" "\x80",
"\x98" "Cancel",
"\x98" "OK",
"\x98" "Rename",
"\x94" "Too many names defined",
"\x94" "Chosen name in use already",
"Pounds (" "\xA3" ")",
"Dollars ($)",
"Franc (FF)",
"Deutschmark (DM)",
"Yen (" "\xA5" ")",
"Peseta (Pt)",
"Imperial (miles)",
"Metric (kilometers)",
"\x94" "...owned by " "\x80",
"\x98" "Cargo",
"\x98" "Information",
"\x98" "Capacities",
"\x98" "Capacity: " "\x95" "\x80",
"\x98" "New Game",
"\x98" "Load Game",
"\x98" "Tutorial / Demonstration",
"\x98" "1 Player",
"\x98" "2 Players",
"\x94" "2 Player Link Setup",
"\x98" "Attempt Connection",
"\x94" "Unable to make connection to remote computer",
"\x98" "Game Options",
"",
"",
" XMS",
" VCPI",
" DPMI",
" Windows",
" OS/2",
"someone" "\x85" "\x85",
"Map of world",
"Town directory",
"Subsidies",
"Operating profit graph",
"Income graph",
"Delivered cargo graph",
"Performance history graph",
"Company value graph",
"Cargo payment rates",
"Company league table",
"\x94" "Transport Tycoon (Deluxe)",
"Save game",
"Quit game",
"",
"Quit",
"\x90" "Are you sure you want to quit this game ?",
"\x94" "Quit Game",
"Jan",
"Feb",
"Mar",
"Apr",
"May",
"Jun",
"Jul",
"Aug",
"Sep",
"Oct",
"Nov",
"Dec",
"\x0E" "\x80" "\r   " "\x80",
"\x0E" "\x80" "\r   " "\x80" "\r" "\x7E",
"\x0E" "\x80" "-",
"\x98" "Pause game",
"\x98" "Save game, abandon game, quit",
"\x98" "Display list of company's stations",
"\x98" "Display map",
"\x98" "Display map, town directory",
"\x98" "Display town directory",
"\x98" "Display company finances information",
"\x98" "Display company general information",
"\x98" "Display graphs",
"\x98" "Display company league table",
"\x98" "Display list of company's trains",
"\x98" "Display list of company's road vehicles",
"\x98" "Display list of company's ships",
"\x98" "Display list of company's aircraft",
"\x98" "Zoom the view in",
"\x98" "Zoom the view out",
"\x98" "Build railroad track",
"\x98" "Build roads",
"\x98" "Build ship docks",
"\x98" "Build airports",
"\x98" "Plant trees, place signs etc.",
"\x98" "Land block information",
"\x98" "Options",
"\x98" "\xBC",
"\x98" "\xBD",
"\x94" "Can't change servicing interval...",
"\x98" "Close window",
"\x98" "Window title - drag this to move window",
"\x98" "Demolish buildings etc. on a square of land",
"\x98" "Lower a corner of land",
"\x98" "Raise a corner of land",
"\x98" "Scroll bar - scrolls list up/down",
"\x98" "Show land contours on map",
"\x98" "Show vehicles on map",
"\x98" "Show industries on map",
"\x98" "Show transport routes on map",
"\x98" "Show vegetation on map",
"\x98" "Show land owners on map",
"\x98" "Toggle town names on/off on map",
"\x0E" "\x98" "Profit this year: " "\x7F" " (last year: " "\x7F" ")",
"\x7C" " year (" "\x7C" ")",
"\x7C" " years (" "\x7C" ")",
"\x8B" "\x7C" " years (" "\x7C" ")",
"Road vehicle",
"Aircraft",
"Ship",
"Train",
"\x94" "\x80" " " "\x7C" " is getting old",
"\x94" "\x80" " " "\x7C" " is getting very old",
"\x94" "\x80" " " "\x7C" " is getting very old and urgently needs replacing",
"\x94" "Land Area Information",
"\x98" "Cost to clear: " "\x95" "N/A",
"\x98" "Cost to clear: " "\x95" "\x7F",
"N/A",
"\x98" "Owner: " "\x95" "\x80",
"\x98" "Local authority: " "\x95" "\x80",
"None",
"\x98" "Name",
"\x98" "\x0E" "\x80",
"1st",
"2nd",
"3rd",
"4th",
"5th",
"6th",
"7th",
"8th",
"9th",
"10th",
"11th",
"12th",
"13th",
"14th",
"15th",
"16th",
"17th",
"18th",
"19th",
"20th",
"21st",
"22nd",
"23rd",
"24th",
"25th",
"26th",
"27th",
"28th",
"29th",
"30th",
"31st",
"\x0E" "\x7C",
"\x98" "Toggle large/small map size",
"\x94" "Select Tutorial/Demonstration",
"\x98" "Cargo accepted: " "\x95" "\x80",
"\x98" "Cargo accepted: " "\x95" "\x80" ", " "\x80",
"\x98" "Cargo accepted: " "\x95" "\x80" ", " "\x80" ", " "\x80",
"(" "\x7D" "/8 " "\x80" ")",
"\x94" "Jazz Jukebox",
"Sound/music",
"\x98" "Show sound/music window",
"\x0E" "All",
"\x0E" "Old Style",
"\x0E" "New Style",
"\x0E" "Ezy Street",
"\x0E" "Custom 1",
"\x0E" "Custom 2",
"\x98" "\x0E" "Music Volume",
"\x98" "\x0E" "Effects Volume",
"\x98" "\x0E" "MIN  '  '  '  '  '  '  MAX",
"\x98" "Skip to previous track in selection",
"\x98" "Skip to next track in selection",
"\x98" "Stop playing music",
"\x98" "Start playing music",
"\x98" "Drag sliders to set music and sound effect volumes",
"\x91" "\x0E" "--",
"\x91" "\x0E" "0" "\x7D",
"\x91" "\x0E" "\x7D",
"\x91" "\x0E" "------",
"\x91" "\x0E" "\"" "\x80" "\"",
"\x98" "\x0E" "Track" "\x01" "XTitle",
"\x0E" "Shuffle",
"\x0E" "\x98" "Program",
"\x94" "Music Program Selection",
"\x0E" "\x95" "0" "\x7C" "   \"" "\x80" "\"",
"\x0E" "\x95" "\x7C" "   \"" "\x80" "\"",
"\x0E" "\x98" "Track Index",
"\x0E" "\x98" "Program - '" "\x80" "'",
"\x0E" "\x98" "Clear",
"\x0E" "\x98" "Save",
"\x98" "Current program of music tracks",
"\x98" "Select 'all tracks' program",
"\x98" "Select 'old style music' program",
"\x98" "Select 'new style music' program",
"\x98" "Select 'Custom 1' (user-defined) program",
"\x98" "Select 'Custom 2' (user-defined) program",
"\x98" "Clear current program (Custom1 or Custom2 only)",
"\x98" "Save music settings to disk",
"\x98" "Click on music track to add to current program (Custom1 or Custom2 only)",
"\x98" "Toggle program shuffle on/off",
"\x98" "Show music track selection window",
"\x98" "Click on service to center view on industry/town",
"\x98" "Difficulty (" "\x80" ")",
"\x0E" "\x98" "\x82",
"Last message/news report",
"Message settings",
"Send message",
"\x98" "Show last message/news report, show message options",
"\x94" "Message Options",
"\x98" "Message types:-",
"\x90" "Arrival of first vehicle at player's station",
"\x90" "Arrival of first vehicle at competitor's station",
"\x90" "Accidents / disasters",
"\x90" "Company information",
"\x90" "Economy changes",
"\x90" "Advice / information on player's vehicles",
"\x90" "New vehicles",
"\x90" "Changes of cargo acceptance",
"\x90" "Subsidies",
"\x90" "General information",
"\x94" "...too far from previous destination",
"\x0F" "\x98" "Top companies who reached 2050\r(" "\x80" " Level)",
"\x0F" "\x7C" ".",
"Businessman",
"Entrepreneur",
"Industrialist",
"Capitalist",
"Magnate",
"Mogul",
"Tycoon of the Century",
"\x0F" "'" "\x80" "'   (" "\x7C" ")",
"\x0F" "\x80" "\x80" " achieves '" "\x80" "' status!",
"\x0F" "\x80" "\x80" " of " "\x80" " achieves '" "\x80" "' status!",
"\x98",
"\x94",
"\x88" "\x7C",
"\x98" "Create Scenario",
"\x90" "Transport Tycoon",
"\x90" "Scenario Editor",
"\x94" "Land Generation",
"\x98" "\xA0",
"\x98" "\xAA",
"\x98" "Random Land",
"\x98" "Reset Land",
"\x98" "Increase size of land area to lower/raise",
"\x98" "Decrease size of land area to lower/raise",
"\x98" "Generate random land",
"\x98" "Reset landscape",
"\x94" "Reset Landscape",
"\x98" "Are you sure you want to reset the landscape?",
"\x98" "Landscape generation",
"\x98" "Town generation",
"\x98" "Industry generation",
"\x98" "Road construction",
"\x98" "Vegetation and other objects",
"\x94" "Town Generation",
"\x98" "New Town",
"\x98" "Construct new town",
"\x94" "Can't build town here...",
"\x94" "...too close to edge of map",
"\x94" "...too close to another town",
"\x94" "...site unsuitable",
"\x94" "...too many towns",
"\x98" "Increase size of town",
"\x98" "Expand",
"\x98" "Random Town",
"\x98" "Build town in random location",
"\x94" "Industry Generation",
"\x98" "Coal Mine",
"\x98" "Power Station",
"\x98" "Sawmill",
"\x98" "Forest",
"\x98" "Oil Refinery",
"\x98" "Oil Rig",
"\x98" "Factory",
"\x98" "Steel Mill",
"\x98" "Farm",
"\x98" "Iron Ore Mine",
"\x98" "Oil Wells",
"\x98" "Bank",
"\x98" "Paper Mill",
"\x98" "Food Processing Plant",
"\x98" "Printing Works",
"\x98" "Gold Mine",
"\x98" "Lumber Mill",
"\x98" "Fruit Plantation",
"\x98" "Rubber Plantation",
"\x98" "Water Supply",
"\x98" "Water Tower",
"\x98" "Diamond Mine",
"\x98" "Copper Ore Mine",
"\x98" "Cotton Candy Forest",
"\x98" "Candy Factory",
"\x98" "Battery Farm",
"\x98" "Cola Wells",
"\x98" "Toy Shop",
"\x98" "Toy Factory",
"\x98" "Plastic Fountains",
"\x98" "Fizzy Drink Factory",
"\x98" "Bubble Generator",
"\x98" "Toffee Quarry",
"\x98" "Sugar Mine",
"\x98" "Construct Coal Mine",
"\x98" "Construct Power Station",
"\x98" "Construct Sawmill",
"\x98" "Plant Forest",
"\x98" "Construct Oil Refinery",
"\x98" "Construct Oil Rig (Can only be built near the edges of the map)",
"\x98" "Construct Factory",
"\x98" "Construct Steel Mill",
"\x98" "Construct Farm",
"\x98" "Construct Iron Ore Mine",
"\x98" "Construct Oil Wells",
"\x98" "Construct Bank (Can only be built in towns with a population greater than 1200)",
"\x98" "Construct Paper Mill",
"\x98" "Construct Food Processing Plant",
"\x98" "Construct Printing Works",
"\x98" "Construct Gold Mine",
"\x98" "Construct Bank (Can only be built in towns)",
"\x98" "Construct Lumber Mill (to clear rainforest and produce Wood)",
"\x98" "Plant Fruit Plantation",
"\x98" "Plant Rubber Plantation",
"\x98" "Construct Water Supply",
"\x98" "Construct Water Tower (Can only be built in towns)",
"\x98" "Construct Diamond Mine",
"\x98" "Construct Copper Ore Mine",
"\x98" "Plant Cotton Candy Forest",
"\x98" "Construct Candy Factory",
"\x98" "Construct Battery Farm",
"\x98" "Construct Cola Wells",
"\x98" "Construct Toy Shop",
"\x98" "Construct Toy Factory",
"\x98" "Construct Plastic Fountains",
"\x98" "Construct Fizzy Drink Factory",
"\x98" "Construct Bubble Generator",
"\x98" "Construct Toffee Quarry",
"\x98" "Construct Sugar Mine",
"\x94" "Can't build " "\x80" " here...",
"\x94" "...must build town first",
"\x94" "...only one allowed per town",
"\x98" "Plant trees",
"\x98" "Place sign",
"\x98" "Random Trees",
"\x98" "Plant trees randomly over landscape",
"\x98" "Place rocky areas on landscape",
"\x98" "Place lighthouse",
"\x98" "Place transmitter",
"\x98" "Define desert area",
"\x98" "Delete",
"\x98" "Delete this town completely",
"Save scenario",
"Load scenario",
"Quit editor",
"",
"Quit",
"\x98" "Save scenario, load scenario, abandon scenario editor, quit",
"\x94" "Load Scenario",
"\x94" "Save Scenario",
"\x98" "Play Scenario",
"\x90" "Are you sure you want to quit this scenario ?",
"\x94" "Quit Editor",
"\x94" "...can only be built in towns with a population of at least 1200",
"\x98" "Move the starting date backward 1 year",
"\x98" "Move the starting date forward 1 year",
"\x94" "...ends of bridge must both be on land",
"\x98" "Small",
"\x98" "Medium",
"\x98" "Large",
"\x98" "Select town size",
"\x90" "Town size:",
"\x94" "Message to Player 2",
"\x98" "Change Modem Initialisation String:",
"\x98" "Change Dial Number:",
"\x94" "Modem init. string:",
"\x94" "Dial number:",
"\x98" "Serial Port",
"COM1",
"COM2",
"COM3",
"COM4",
"\x98" "\x80",
"\x98" "Baud Rate",
"\x98" "\x85" "\x80" " baud",
"9600",
"14400",
"19200",
"\x80" "  -  " "\x80",
"\x98" "Show last message or news report",
"\x98" "Summary",
"\x98" "Full",
"\x89" "-  -  " "\x80" "  -  -",
"Town directory",
"\x98" "Vehicle design names",
"\x98" "\x80",
"Default",
"Custom",
"\x98" "Save custom names to disk",
"\x98" "Vehicle design names selection",
"\x98" "Save customized vehicle design names to disk",
"Game options",
"Game options",
"Difficulty settings",
"Difficulty settings",
"",
"",
"\xAC" "\x01" "\x0C" "Town names displayed",
"\x01" "\x0C" "Town names displayed",
"\xAC" "\x01" "\x0C" "Station names displayed",
"\x01" "\x0C" "Station names displayed",
"\xAC" "\x01" "\x0C" "Signs displayed",
"\x01" "\x0C" "Signs displayed",
"\xAC" "\x01" "\x0C" "Full animation",
"\x01" "\x0C" "Full animation",
"\xAC" "\x01" "\x0C" "Full detail",
"\x01" "\x0C" "Full detail",
"\xAC" "\x01" "\x0C" "Transparent buildings",
"\x01" "\x0C" "Transparent buildings",
"Land block info.",
"",
"ScreenShot (Ctrl-S)",
"Giant ScreenShot (Ctrl-G)",
"About 'Transport Tycoon'",
"\x98" "On",
"\x98" "Off",
"\x98" "Display subsidies",
"Subsidies",
"Map of world",
"Town directory",
"\x98" "Currency units",
"\x98" "\x85" "\x80",
"\x98" "Currency units selection",
"\x98" "Distance units",
"\x98" "\x85" "\x85" "\x80",
"\x98" "Distance units selection",
"\x98" "Road vehicles",
"\x98" "\x85" "\x85" "\x85" "\x80",
"\x98" "Select side of road for vehicles to drive on",
"Drive on left",
"Drive on right",
"\x98" "Town names",
"\x98" "\x85" "\x85" "\x85" "\x85" "\x80",
"\x98" "Select style of town names",
"English",
"French",
"German",
"American",
"Latin-American",
"Silly",
"\x98" "Autosave",
"\x98" "\x85" "\x85" "\x85" "\x85" "\x85" "\x80",
"\x98" "Select interval between automatic game saves",
"Off",
"Every 3 months",
"Every 6 months",
"Every 12 months",
"\x98" "Start a new game",
"\x98" "Load a saved game from disk",
"\x98" "View demonstrations/tutorials",
"\x98" "Create a customized game world/scenario",
"\x98" "Select single-player game",
"\x98" "Select two-player game",
"\x98" "Display game options",
"\x98" "Display difficulty options",
"\x98" "Start a new game, using a customized scenario",
"\x98" "Quit",
"\x98" "Leave 'Transport Tycoon', and quit",
"\x98" "View demonstration/tutorial",
"\x94" "Transport Tycoon (Deluxe)",
"\x98" "Select serial port to be used for direct or modem connection",
"\x98" "Select serial port speed for direct or modem connection",
"\x98" "Attempt to connect to second computer for 2 player game",
"\x98" "Change the modem initialisation string",
"\x98" "Set the number to be dialled by the modem",
"\x94" "...can only be built in towns",
"\x98" "Select 'temperate' landscape style",
"\x98" "Select 'sub-arctic' landscape style",
"\x98" "Select 'sub-tropical' landscape style",
"\x98" "Select 'toyland' landscape style",
"\x98" "Fund construction of new industry",
"Fund new industry",
"\x94" "Fund new industry",
"\x80",
"\x94" "...can only be built in towns",
"\x94" "...can only be built in rainforest areas",
"\x94" "...can only be built in desert areas",
"\x90" "*  *  PAUSED  *  *",
"SCR" "\x7C" ".PCX",
"\x94" "Screenshot successfully saved to disk as '" "\x80" "'",
"\x94" "Screenshot failed!",
"\x98" "Link method",
"\x98" "\x85" "\x85" "\x80",
"\x98" "Select communications link method for 2-player game",
"Serial cable (sender)",
"Serial cable (receiver)",
"Modem (send/dial)",
"Modem (receive)",
"Network - IPX protocol (sender)",
"Network - IPX protocol (receiver)",
"\x98" "Purchase land for future use",
"\x98" "Purchase land for future use",
"\x98" "Purchase land for future use",
"\x98" "Purchase land for future use",
"\x98" "1: Road vehicle service",
"\x98" "2: Railroad service",
"\x98" "3: Air service",
"\x98" "4: Ship service",
"\x98" "5: Railroad service (advanced)",
"\x8B" "AUTOSAVE",
"\x98" "Select 'Ezy Street style music' program",
"\x94" "...IPX driver not found",
"\x94" "...not enough free base memory for network buffers",
"\x94" "...unable to open an IPX socket",
"\x94" "Connection successful!\r\rGames now linked!",
};


static const char * const _landscape_string_table[] = {
"\x0E" "\x8B" "Cost: " "\x7F",
"\x8B" "Cost: " "\x7F",
"\x0E" "\x8F" "Income: " "\x7F",
"\x8F" "Income: " "\x7F",
"\x0E" "\x94" "Estimated Cost: " "\x7F",
"\x94" "Estimated Cost: " "\x7F",
"\x0E" "\x94" "Estimated Income: " "\x7F",
"\x94" "Estimated Income: " "\x7F",
"\x94" "Can't raise land here...",
"\x94" "Can't lower land here...",
"Rocks",
"Rough land",
"Bare land",
"Grass",
"Fields",
"Snow-covered land",
"Desert",
};


static const char * const _track_string_table[] = {
"\x94" "Land sloped in wrong direction",
"\x94" "Impossible track combination",
"\x94" "Excavation would damage tunnel",
"\x94" "Already at sea-level",
"\x94" "Too high",
"\x94" "No suitable railroad track",
"\x94" "Train inside depot",
"\x94" "...already built",
"\x94" "Must remove railroad track first",
"\x94" "Too many depots",
"\x94" "Railroad Construction",
"\x94" "Monorail Construction",
"\x94" "MagLev Construction",
"\x94" "Select Rail Bridge",
"\x94" "Can't build train depot here...",
"\x94" "Can't build railroad station here...",
"\x94" "Can't build signals here...",
"\x94" "Can't build railroad track here...",
"\x94" "Can't remove railroad track from here...",
"\x94" "Can't remove signals from here...",
"\x94" "Train Depot Orientation",
"Railroad construction",
"Monorail construction",
"MagLev construction",
"\x98" "Build railroad track",
"\x98" "Build train depot (for building and servicing trains)",
"\x98" "Build railroad station",
"\x98" "Build railroad signals",
"\x98" "Build railroad bridge",
"\x98" "Build railroad tunnel",
"\x98" "Toggle build/remove for railroad track and signals",
"\x98" "Bridge selection - click on selected bridge to build it",
"\x98" "Select railroad depot orientation",
"Railroad track",
"Railroad track with signals",
"Railroad train depot",
"\x94" "...area is owned by another company",
};


static const char * const _road_string_table[] = {
"\x94" "Land sloped in wrong direction for road",
"\x94" "Must remove road first",
"\x94" "Road Construction",
"\x94" "Select Road Bridge",
"\x94" "Can't build road here...",
"\x94" "Can't remove road from here...",
"\x94" "Road Depot Orientation",
"\x94" "Can't build road vehicle depot here...",
"\x94" "Can't build bus station...",
"\x94" "Can't build truck station...",
"Road construction",
"\x98" "Build road section",
"\x98" "Build road vehicle depot (for building and servicing vehicles)",
"\x98" "Build bus station",
"\x98" "Build truck loading bay",
"\x98" "Build road bridge",
"\x98" "Build road tunnel",
"\x98" "Toggle build/remove for road construction",
"\x98" "Bridge selection - click on selected bridge to build it",
"\x98" "Select road vehicle depot orientation",
"Road",
"Road with streetlights",
"Tree-lined road",
"Road vehicle depot",
"Road/rail level crossing",
};


static const char * const _city_string_table[] = {
"\x94" "Towns",
"\x94" "\x80",
"\x0E" "\x98" "\x80",
"\x0E" "\x94" "\x80",
"\x94" "Building must be demolished first",
"\x94" "\x80",
"\x98" "Population: " "\x8E" "\x7B",
"Rename Town",
"\x94" "Can't rename town...",
"\x94" "\x80" " local authority refuses to allow this",
"\x98" "Town names - click on name to center main view on town",
"\x98" "Center the main view on town location",
"\x98" "Change town name",
"\x98" "Passengers last month: " "\x8E" "\x7C" "\x98" "  max: " "\x8E" "\x7C",
"\x98" "Mail last month: " "\x8E" "\x7C" "\x98" "  max: " "\x8E" "\x7C",
"Tall office block",
"Office block",
"Small block of flats",
"Church",
"Large office block",
"Town houses",
"Hotel",
"Statue",
"Fountain",
"Park",
"Office block",
"Shops and offices",
"Modern office building",
"Warehouse",
"Office block",
"Stadium",
"Old houses",
"\x98" "Local authority",
"\x98" "Show information on local authority",
"\x94" "\x80" " local authority",
"\x98" "Transport company ratings:",
"\x90" "\x80" "\x80" ": " "\x8E" "\x80",
"\x94" "Subsidies",
"\x98" "Subsidies on offer for services taking:-",
"\x8E" "\x80" " from " "\x80" " to " "\x80",
"\x90" " (by " "\x83" ")",
"\x80" " " "\x80",
"\x8E" "None",
"\x98" "Services already subsidised:-",
"\x8E" "\x80" " from " "\x80" " to " "\x80" "\x90" " (" "\x80",
"\x90" ", until " "\x83" ")",
"\x98" "\x0F" "Offer of subsidy expired:\r\r" "\x80" " from " "\x80" " to " "\x80" " will now not attract a subsidy.",
"\x98" "\x0F" "Subsidy withdrawn:\r\r" "\x80" " service from " "\x80" " to " "\x80" " is no longer subsidised.",
"\x98" "\x0F" "Service subsidy offered:\r\rFirst " "\x80" " service from " "\x80" " to " "\x80" " will attract a year's subsidy from the local authority!",
"\x98" "\x0F" "Service subsidy awarded to " "\x80" "!\r\r" "\x80" " service from " "\x80" " to " "\x80" " will pay 50% extra for the next year!",
"\x98" "\x0F" "Service subsidy awarded to " "\x80" "!\r\r" "\x80" " service from " "\x80" " to " "\x80" " will pay double rates for the next year!",
"\x98" "\x0F" "Service subsidy awarded to " "\x80" "!\r\r" "\x80" " service from " "\x80" " to " "\x80" " will pay triple rates for the next year!",
"\x98" "\x0F" "Service subsidy awarded to " "\x80" "!\r\r" "\x80" " service from " "\x80" " to " "\x80" " will pay quadruple rates for the next year!",
"\x94" "\x80" " local authority refuses to allow another airport to be built in this town",
"Cottages",
"Houses",
"Flats",
"Tall office block",
"Shops and offices",
"Shops and offices",
"Theater",
"Stadium",
"Offices",
"Houses",
"Cinema",
"Shopping mall",
"\x98" "Do it",
"\x98" "List of things to do at this town - click on item for more details",
"\x98" "Carry out the highlighted action in the list above",
"\x98" "Actions available:",
"Small advertising campaign",
"Medium advertising campaign",
"Large advertising campaign",
"Fund local road reconstruction",
"Build statue of company owner",
"Fund new buildings",
"Buy exclusive transport rights",
"\x94" "\x80" "\r" "\x90" "  Initiate a small local advertising campaign, to attract more passengers and cargo to your transport services.\r  Cost: " "\x7F",
"\x94" "\x80" "\r" "\x90" "  Initiate a medium local advertising campaign, to attract more passengers and cargo to your transport services.\r  Cost: " "\x7F",
"\x94" "\x80" "\r" "\x90" "  Initiate a large local advertising campaign, to attract more passengers and cargo to your transport services.\r  Cost: " "\x7F",
"\x94" "\x80" "\r" "\x90" "  Fund the reconstruction of the urban road network. Causes considerable disruption to road traffic for up to 6 months.\r  Cost: " "\x7F",
"\x94" "\x80" "\r" "\x90" "  Build a statue in honor of your company.\r  Cost: " "\x7F",
"\x94" "\x80" "\r" "\x90" "  Fund the construction of new commercial buildings in the town.\r  Cost: " "\x7F",
"\x94" "\x80" "\r" "\x90" "  Buy 1 year's exclusive transport rights in town. Town authority will only allow passengers and cargo to use your company's stations.\r  Cost: " "\x7F",
"\x94" "Can't do this...",
"\x0F" "\x98" "Traffic chaos in " "\x80" "!\r\rRoad rebuilding programme funded by " "\x80" " brings 6 months of misery to motorists!",
"\x0E" "\x94" "\x80",
"\x8E" "\x80" "\x98" "  (" "\x7B" ")",
"\x80" " (under construction)",
"Igloo",
"Tepees",
"Teapot-House",
"Piggy-Bank",
};


static const char * const _tree_string_table[] = {
"Plant trees",
"Place sign",
"\x94" "Trees",
"\x94" "...tree already here",
"\x94" "...site unsuitable",
"\x94" "Can't plant tree here...",
"\x94" "\x80",
"\x0E" "\x94" "\x80",
"\x94" "...too many signs",
"\x94" "Can't place sign here...",
"Sign",
"\x94" "Edit sign text",
"\x94" "Can't change sign name...",
"\x98" "Select tree type to plant",
"Trees",
"Rainforest",
"Cactus Plants",
};


static const char * const _station_string_table[] = {
"\x94" "Rail Station Selection",
"\x94" "Airport Selection",
"\x98" "Orientation",
"\x98" "Number of tracks",
"\x98" "Platform length",
"\x94" "Too close to another railroad station",
"\x94" "Adjoins more than one existing station/loading area",
"\x94" "Too many stations/loading areas in this town",
"\x94" "Too many stations/loading areas",
"\x94" "Too close to another station/loading area",
"\x94" "\x80" " " "\x81" "\xD1" "0",
"\x94" "Must demolish railroad station first",
"",
"\x94" "Too close to another airport",
"\x94" "Must demolish airport first",
"\x80",
"\x80" " North",
"\x80" " South",
"\x80" " East",
"\x80" " West",
"\x80" " Central",
"\x80" " Transfer",
"\x80" " Halt",
"\x80" " Valley",
"\x80" " Heights",
"\x80" " Woods",
"\x80" " Lakeside",
"\x80" " Exchange",
"\x80" " Airport",
"\x80" " Oilfield",
"\x80" " Mines",
"\x80" " Docks",
"\x80" " Buoy 1",
"\x80" " Buoy 2",
"\x80" " Buoy 3",
"\x80" " Buoy 4",
"\x80" " Buoy 5",
"\x80" " Buoy 6",
"\x80" " Buoy 7",
"\x80" " Buoy 8",
"\x80" " Buoy 9",
"\x80" " Annexe",
"\x80" " Sidings",
"\x80" " Branch",
"Upper " "\x80",
"Lower " "\x80",
"\x80" " Heliport",
"\x80" " Forest",
"Rename station/loading area",
"\x94" "Can't rename station...",
"\x98" "Ratings",
"\x98" "Accepts",
"\x98" "Local rating of transport service:",
"Appalling",
"Very Poor",
"Poor",
"Mediocre",
"Good",
"Very Good",
"Excellent",
"Outstanding",
"\x94" "\x80" ": " "\x90" "\x80" " (" "\x7D" "%)",
"\x94" "\x80" " no longer accepts " "\x80",
"\x94" "\x80" " no longer accepts " "\x80" " or " "\x80",
"\x94" "\x80" " now accepts " "\x80",
"\x94" "\x80" " now accepts " "\x80" " and " "\x80",
"\x94" "Bus Station Orientation",
"\x94" "Truck Station Orient.",
"\x94" "Too close to another bus station",
"\x94" "Too close to another truck station",
"\x94" "Must demolish bus station first",
"\x94" "Must demolish truck station first",
"\x94" "\x80" " - Stations",
"\x90" "\x80" " " "\x81" "\xD1" "0",
"\x90" "- None -",
"\x94" "...site unsuitable",
"\x94" "Too close to another dock",
"\x94" "Must demolish dock first",
"\x98" "Select railroad station orientation",
"\x98" "Select number of platforms for railroad station",
"\x98" "Select length of railroad station",
"\x98" "Select bus station orientation",
"\x98" "Select truck loading bay orientation",
"\x98" "Center main view on station location",
"\x98" "Show station ratings",
"\x98" "Change name of station",
"\x98" "Show list of accepted cargo",
"\x98" "Station names - click on name to center main view on station",
"\x98" "Select size/type of airport",
"\x98" "Small",
"\x98" "Large",
"\x98" "Size",
"\x98" "\x80" " " "\x81" "\xD1" "0",
"\x0E" "\x98" "\x80" " " "\x81" "\xD1" "0",
"Railroad station",
"Aircraft hangar",
"Airport",
"Truck loading area",
"Bus station",
"Ship dock",
"\x98" "Highlight coverage area of proposed site",
"\x98" "Don't highlight coverage area of proposed site",
"\x98" "Coverage area highlight",
"\x94" "Monorail Station Select.",
"\x94" "Dock",
"Buoy",
"\x94" "...buoy in the way",
"\x98" "Heliport",
"\x94" "...station too spread out",
};


static const char * const _water_string_table[] = {
"\x94" "Ship Depot Orientation",
"\x94" "...must be built on water",
"\x94" "Can't build ship depot here...",
"\x98" "Select ship depot orientation",
"Water",
"Coast or riverbank",
"Ship depot",
"\x94" "...Can't build on water",
};


static const char * const _saveload_string_table[] = {
"\x94" "Save Game",
"\x94" "Load Game",
"\x98" "Save",
"\x98" "Delete",
"\x80" ", " "\x82",
"\x98" "\x7B" " bytes free",
"\x98" "Unable to read drive",
"\x94" "Game Save Failed",
"\x94" "Unable to delete file",
"\x94" "Game Load Failed",
"\x98" "List of drives, directories and saved-game files",
"\x98" "Currently selected name for saved-game",
"\x98" "Delete the currently selected saved-game",
"\x98" "Save the current game, using the selected name",
"\x94" "Select New Game Type",
"\x98" "Select scenario (green), pre-set game (blue), or random new game",
"Generate random new game",
};


static const char * const _industry_string_table[] = {
"\x94" "\x80" " in the way",
"\x94" "\x80" " " "\x80",
"Coal Mine",
"Power Station",
"Sawmill",
"Forest",
"Oil Refinery",
"Oil Rig",
"Factory",
"Printing Works",
"Steel Mill",
"Farm",
"Copper Ore Mine",
"Oil Wells",
"Bank",
"Food Processing Plant",
"Paper Mill",
"Gold Mine",
"Bank",
"Diamond Mine",
"Iron Ore Mine",
"Fruit Plantation",
"Rubber Plantation",
"Water Supply",
"Water Tower",
"Factory",
"Farm",
"Lumber Mill",
"Cotton Candy Forest",
"Candy Factory",
"Battery Farm",
"Cola Wells",
"Toy Shop",
"Toy Factory",
"Plastic Fountains",
"Fizzy Drink Factory",
"Bubble Generator",
"Toffee Quarry",
"Sugar Mine",
"\x98" "Requires: " "\x90" "\x80",
"\x98" "Requires: " "\x90" "\x80" ", " "\x80",
"\x98" "Requires: " "\x90" "\x80" ", " "\x80" ", " "\x80",
"\x98" "Production last month:",
"\x90" "\x80" "\x98" " (" "\x7C" "% transported)",
"\x98" "Center the main view on industry location",
"\x98" "\x0F" "New " "\x80" " under construction near " "\x80" "!",
"\x98" "\x0F" "New " "\x80" " being planted near " "\x80" "!",
"\x98" "Cost: " "\x90" "\x7F",
"\x94" "Can't construct this industry type here...",
"\x94" "...forest can only be planted above snow-line",
"\x98" "\x0F" "\x80" " " "\x80" " announces imminent closure!",
"\x98" "\x0F" "Supply problems cause " "\x80" " " "\x80" " to announce imminent closure!",
"\x98" "\x0F" "Lack of nearby trees causes " "\x80" " " "\x80" " to announce imminent closure!",
"\x98" "\x0F" "\x80" " " "\x80" " increases production!",
"\x98" "\x0F" "New coal seam found at " "\x80" " " "\x80" "!\rProduction is expected to double!",
"\x98" "\x0F" "New oil reserves found at " "\x80" " " "\x80" "!\rProduction is expected to double!",
"\x98" "\x0F" "Improved farming methods at " "\x80" " " "\x80" " are expected to double production!",
"\x98" "\x0F" "\x80" " " "\x80" " production down by 50%",
"\x98" "\x0F" "Insect infestation causes havoc at " "\x80" " " "\x80" "!\rProduction down by 50%",
"\x94" "...can only be positioned near edges of map",
};


static const char * const _tunnel_string_table[] = {
"\x94" "Train in tunnel",
"\x94" "Road vehicle in tunnel",
"",
"\x94" "Another tunnel in the way",
"",
"\x94" "Unable to excavate land for other end of tunnel",
"\x94" "Must demolish tunnel first",
"\x94" "Must demolish bridge first",
"\x94" "Cannot start and end on same position",
"\x94" "Level land or water required under bridge",
"\x94" "Start and end must be in line",
"\x94" "Site unsuitable for tunnel entrance",
"",
"\x8A" "\x80" ",\r " "\x84" "   " "\x94" "\x7F",
"Suspension, Steel",
"Girder, Steel",
"Cantilever, Steel",
"Suspension, Concrete",
"Wooden",
"Concrete",
"Tubular, Steel",
"\x94" "Can't build bridge here...",
"\x94" "Can't build tunnel here...",
"Railroad tunnel",
"Road tunnel",
"",
"",
"Steel suspension rail bridge",
"Steel girder rail bridge",
"Steel cantilever rail bridge",
"Reinforced concrete suspension rail bridge",
"Wooden rail bridge",
"Concrete rail bridge",
"Steel suspension road bridge",
"Steel girder road bridge",
"Steel cantilever road bridge",
"Reinforced concrete suspension road bridge",
"Wooden road bridge",
"Concrete road bridge",
"Tubular rail bridge",
"Tubular road bridge",
"Steel",
};


static const char * const _unmovable_string_table[] = {
"\x94" "Object in the way",
"Transmitter",
"Lighthouse",
"Company Headquarters",
"\x94" "...company headquarters in the way",
"Company-owned land",
"\x94" "Can't purchase this land area...",
"\x94" "...you already own it!",
};


static const char * const _debugger_string_table[] = {
"\x94" "Debugger",
"\x8B" "Animation blocks: " "\x7C" "/" "\x7C",
"\x98" "+Cash",
"\x98" "+Towns",
"\x98" "\x7B",
"\x98" "+",
"\x98" "-",
"\x8B" "Non-Effect Objects: " "\x7C" "/" "\x7C",
"\x8B" "Effect Objects: " "\x7C" "/" "\x7C",
"\x8B" "Text Effects: " "\x7C" "/" "\x7C",
"\x98" "Land Code: " "\x7C",
"\x8B" "Orders: " "\x7C" "/" "\x7C",
"\x8B" "Names: " "\x7C" "/" "\x7C",
"\x98" "AllVeh",
"\x98" "+Cmpny",
"\x98" "Interrupts: " "\x7C",
"\x98" "ID: " "\x7C",
"\x98" "Serial resends: " "\x7C",
"\x8E" "Rand.Seed: " "\x90" "\x7C",
"\x8B" "Gr.Cache Used: " "\x7B" "/" "\x7B",
"\x98" "Fingerprint: --------",
"\x8B" "Stations: " "\x7C" "/" "\x7C",
"\x98" "Random seed: " "\x8E" "\x7B",
"\x98" "NPC PZ",
"\x94" "GAMES OUT OF SYNC!",
};


static const char * const _newgame_string_table[] = {
"\x94" "Difficulty Level",
"\x98" "Easy",
"\x98" "Medium",
"\x98" "Hard",
"\x98" "Custom",
"\x95" "Maximum no. competitors: " "\x8E" "\x7C",
"\x95" "Competitor start time: " "\x8E" "\x80",
"\x95" "No. of towns: " "\x8E" "\x80",
"\x95" "No. of industries: " "\x8E" "\x80",
"\x95" "Maximum initial loan: " "\x8E" "\x7F" ",000",
"\x95" "Initial interest rate: " "\x8E" "\x7C" "%",
"\x95" "Vehicle running costs: " "\x8E" "\x80",
"\x95" "Construction speed of competitors: " "\x8E" "\x80",
"\x95" "Intelligence of competitors: " "\x8E" "\x80",
"\x95" "Vehicle breakdowns: " "\x8E" "\x80",
"\x95" "Subsidy multiplier: " "\x8E" "\x80",
"\x95" "Cost of construction: " "\x8E" "\x80",
"\x95" "Terrain type: " "\x8E" "\x80",
"\x95" "Quantity of sea/lakes: " "\x8E" "\x80",
"\x95" "Economy: " "\x8E" "\x80",
"\x95" "Train reversing: " "\x8E" "\x80",
"\x95" "Disasters: " "\x8E" "\x80",
"Low",
"Normal",
"High",
"\x98" "<",
"\x98" ">",
"Very Slow",
"Slow",
"Medium",
"Fast",
"Very Fast",
"Low",
"Medium",
"High",
"None",
"Reduced",
"Normal",
"x1.5",
"x2",
"x3",
"x4",
"Very Flat",
"Flat",
"Hilly",
"Mountainous",
"Steady",
"Fluctuating",
"Immediate",
"3 months after player",
"6 months after player",
"9 months after player",
"At end of line, and at stations",
"At end of line only",
"Off",
"On",
"\x98" "Show hi-score chart",
};


static const char * const _players_string_table[] = {
"Unnamed" "\x85" "\x85",
"\x94" "\x80" "\x98" "\x80",
" (Player 1)",
" (Player 2)",
"\x98" "New Face",
"\x98" "Color Scheme",
"\x8A" "Color Scheme:",
"\x94" "New Color Scheme",
"\x98" "Company Name",
"\x98" "President Name",
"Company Name",
"President's Name",
"\x94" "Can't change company name...",
"\x94" "Can't change president's name...",
"\x94" "\x80" " Finances" "\x98" "\x80",
"\x94" "Expenditure/Income",
"\x94" "\x7E",
"\x8A" "Construction",
"\x8A" "New Vehicles",
"\x8A" "Train Running Costs",
"\x8A" "Road Veh. Running Costs",
"\x8A" "Aircraft Running Costs",
"\x8A" "Ship Running Costs",
"\x8A" "Property Maintenance",
"\x8A" "Train Income",
"\x8A" "Road Vehicles Income",
"\x8A" "Aircraft Income",
"\x8A" "Ship Income",
"\x8A" "Loan Interest",
"\x8A" "Other",
"\x98" "-" "\x7F",
"\x98" "+" "\x7F",
"\x94" "Total:",
"\x80" "\x80",
"\x94" "Income Graph",
"\x7F",
"\x7B",
"\x94" "Operating Profit Graph",
"\x94" "Bank Balance",
"\x94" "Loan",
"\x98" "\x7F",
"\x98" "Borrow " "\x85" "\x85" "\x85" "\x85" "\x7F",
"\x98" "Repay " "\x85" "\x85" "\x85" "\x85" "\x7F",
"\x94" "...maximum permitted loan size is " "\x7F",
"\x94" "Can't borrow any more money...",
"\x94" "...loan already repayed",
"\x94" "..." "\x7F" " required",
"\x94" "Can't repay loan...",
"\x98" "Select new face for president",
"\x98" "Change the company vehicle livery",
"\x98" "Change the president's name",
"\x98" "Change the company name",
"\x98" "Click on selected new color scheme",
"\x98" "Increase size of loan",
"\x98" "Repay part of loan",
"\x94" "\x80" "\r" "\x8A" "(President)",
"\x8A" "Inaugurated: " "\x94" "\x7E",
"\x8A" "Vehicles: ",
"\x94" "\x7C" " train",
"\x94" "\x7C" " trains",
"\x94" "\x7C" " road vehicle",
"\x94" "\x7C" " road vehicles",
"\x94" "\x7C" " aircraft",
"\x94" "\x7C" " aircraft",
"\x94" "\x7C" " ship",
"\x94" "\x7C" " ships",
"\x94" "None",
"\x94" "Face Selection",
"\x98" "Male",
"\x98" "Female",
"\x98" "New Face",
"\x98" "Cancel new face selection",
"\x98" "Accept new face selection",
"\x98" "Select male faces",
"\x98" "Select female faces",
"\x98" "Generate random new face",
"\x98" "Key",
"\x98" "Show key to graphs",
"\x94" "Key to company graphs",
"\x98" "Click here to toggle company's entry on graph on/off",
"\x94" "Units of cargo delivered",
"\x94" "Company performance ratings (maximum rating=1000)",
"\x94" "Company values",
"\x94" "Company League Table",
"\x94" "\x80" "\x01" "-" "\x8E" "\x80" " " "\x98" "\x80" "   '" "\x80" "'",
"\x90" "\x80" "\x01" "-" "\x8E" "\x80" " " "\x98" "\x80" "   '" "\x80" "'",
"\x98" "\x0F" "Transport company in trouble!",
"\x98" "\x0F" "\x80" " will be sold off or declared bankrupt unless performance increases soon!",
"\x98" "\x80" "\r(President)",
"\x98" "\x0F" "Transport company merger!",
"\x98" "\x0F" "\x80" " has been sold to " "\x80" " for " "\x7F" "!",
"\x94" "We are looking for a transport company to take-over our company\r\rDo you want to purchase " "\x80" " for " "\x7F" "?",
"\x98" "\x0F" "Bankrupt!",
"\x98" "\x0F" "\x80" " has been closed down by creditors and all assets sold off!",
"\x98" "\x0F" "New transport company launched!",
"\x98" "\x0F" "\x80" " starts construction near " "\x80" "!",
"\x94" "Can't buy company...",
"\x94" "Cargo Payment Rates",
"\x98" "\x0E" "Days in transit",
"\x98" "\x0E" "Payment for delivering 10 units (or 1,000 litres) of cargo a distance of 20 squares",
"\x98" "Toggle graph for cargo type on/off",
"\x98" "\x0E" "\x80",
"Engineer",
"Traffic Manager",
"Transport Coordinator",
"Route Supervisor",
"Director",
"Chief Executive",
"Chairman",
"President",
"Tycoon",
"\x98" "Build HQ",
"\x98" "Build company headquarters / view company headquarters",
"\x94" "Can't build company headquarters...",
"\x98" "View HQ",
"\x0F" "\x98" "World Recession!\r\rFinancial experts fear worst as economy slumps!",
"\x0F" "\x98" "Recession Over!\r\rUpturn in trade gives confidence to industries as economy strengthens!",
"\x98" "Toggle large/small window size",
"\x8A" "Company value: " "\x94" "\x7F",
"\x98" "Buy 25% share in company",
"\x98" "Sell 25% share in company",
"\x98" "Buy 25% share in this company",
"\x98" "Sell 25% share in this company",
"\x94" "Can't buy 25% share in this company...",
"\x94" "Can't sell 25% share in this company...",
"\x94" "(" "\x7C" "% owned by " "\x80" ")",
"\x94" "(" "\x7C" "% owned by " "\x80" "\r   " "\x7C" "% owned by " "\x80" ")",
"\x98" "\x0F" "\x80" " has been taken over by " "\x80" "!",
};


static const char * const _engines_string_table[] = {
"Kirby Paul Tank (Steam)",
"MJS 250 (Diesel)",
"Ploddyphut Choo-Choo",
"Powernaut Choo-Choo",
"Mightymover Choo-Choo",
"Ploddyphut Diesel",
"Powernaut Diesel",
"Wills 2-8-0 (Steam)",
"Chaney 'Jubilee' (Steam)",
"Ginzu 'A4' (Steam)",
"SH '8P' (Steam)",
"Manley-Morel DMU (Diesel)",
"'Dash' (Diesel)",
"SH/Hendry '25' (Diesel)",
"UU '37' (Diesel)",
"Floss '47' (Diesel)",
"CS 4000 (Diesel)",
"CS 2400 (Diesel)",
"Centennial (Diesel)",
"Kelling 3100 (Diesel)",
"Turner Turbo (Diesel)",
"MJS 1000 (Diesel)",
"SH '125' (Diesel)",
"SH '30' (Electric)",
"SH '40' (Electric)",
"'T.I.M.' (Electric)",
"'AsiaStar' (Electric)",
"Passenger Car",
"Mail Van",
"Coal Car",
"Oil Tanker",
"Livestock Van",
"Goods Van",
"Grain Hopper",
"Wood Truck",
"Iron Ore Hopper",
"Steel Truck",
"Armored Van",
"Food Van",
"Paper Truck",
"Copper Ore Hopper",
"Water Tanker",
"Fruit Truck",
"Rubber Truck",
"Sugar Truck",
"Cotton Candy Hopper",
"Toffee Hopper",
"Bubble Van",
"Cola Tanker",
"Candy Van",
"Toy Van",
"Battery Truck",
"Fizzy Drink Truck",
"Plastic Truck",
"'X2001' (Electric)",
"'Millennium Z1' (Electric)",
"Wizzowow Z99",
"Passenger Car",
"Mail Van",
"Coal Car",
"Oil Tanker",
"Livestock Van",
"Goods Van",
"Grain Hopper",
"Wood Truck",
"Iron Ore Hopper",
"Steel Truck",
"Armored Van",
"Food Van",
"Paper Truck",
"Copper Ore Hopper",
"Water Tanker",
"Fruit Truck",
"Rubber Truck",
"Sugar Truck",
"Cotton Candy Hopper",
"Toffee Hopper",
"Bubble Van",
"Cola Tanker",
"Candy Van",
"Toy Van",
"Battery Truck",
"Fizzy Drink Truck",
"Plastic Truck",
"Lev1 'Leviathan' (Electric)",
"Lev2 'Cyclops' (Electric)",
"Lev3 'Pegasus' (Electric)",
"Lev4 'Chimaera' (Electric)",
"Wizzowow Rocketeer",
"Passenger Car",
"Mail Van",
"Coal Car",
"Oil Tanker",
"Livestock Van",
"Goods Van",
"Grain Hopper",
"Wood Truck",
"Iron Ore Hopper",
"Steel Truck",
"Armored Van",
"Food Van",
"Paper Truck",
"Copper Ore Hopper",
"Water Tanker",
"Fruit Truck",
"Rubber Truck",
"Sugar Truck",
"Cotton Candy Hopper",
"Toffee Hopper",
"Bubble Van",
"Cola Tanker",
"Candy Van",
"Toy Van",
"Battery Truck",
"Fizzy Drink Truck",
"Plastic Truck",
"MPS Regal Bus",
"Hereford Leopard Bus",
"Foster Bus",
"Foster MkII Superbus",
"Ploddyphut MkI Bus",
"Ploddyphut MkII Bus",
"Ploddyphut MkIII Bus",
"Balogh Coal Truck",
"Uhl Coal Truck",
"DW Coal Truck",
"MPS Mail Truck",
"Reynard Mail Truck",
"Perry Mail Truck",
"MightyMover Mail Truck",
"Powernaught Mail Truck",
"Wizzowow Mail Truck",
"Witcombe Oil Tanker",
"Foster Oil Tanker",
"Perry Oil Tanker",
"Talbott Livestock Van",
"Uhl Livestock Van",
"Foster Livestock Van",
"Balogh Goods Truck",
"Craighead Goods Truck",
"Goss Goods Truck",
"Hereford Grain Truck",
"Thomas Grain Truck",
"Goss Grain Truck",
"Witcombe Wood Truck",
"Foster Wood Truck",
"Moreland Wood Truck",
"MPS Iron Ore Truck",
"Uhl Iron Ore Truck",
"Chippy Iron Ore Truck",
"Balogh Steel Truck",
"Uhl Steel Truck",
"Kelling Steel Truck",
"Balogh Armored Truck",
"Uhl Armored Truck",
"Foster Armored Truck",
"Foster Food Van",
"Perry Food Van",
"Chippy Food Van",
"Uhl Paper Truck",
"Balogh Paper Truck",
"MPS Paper Truck",
"MPS Copper Ore Truck",
"Uhl Copper Ore Truck",
"Goss Copper Ore Truck",
"Uhl Water Tanker",
"Balogh Water Tanker",
"MPS Water Tanker",
"Balogh Fruit Truck",
"Uhl Fruit Truck",
"Kelling Fruit Truck",
"Balogh Rubber Truck",
"Uhl Rubber Truck",
"RMT Rubber Truck",
"MightyMover Sugar Truck",
"Powernaught Sugar Truck",
"Wizzowow Sugar Truck",
"MightyMover Cola Truck",
"Powernaught Cola Truck",
"Wizzowow Cola Truck",
"MightyMover Cotton Candy Truck",
"Powernaught Cotton Candy Truck",
"Wizzowow Cotton Candy Truck",
"MightyMover Toffee Truck",
"Powernaught Toffee Truck",
"Wizzowow Toffee Truck",
"MightyMover Toy Van",
"Powernaught Toy Van",
"Wizzowow Toy Van",
"MightyMover Candy Truck",
"Powernaught Candy Truck",
"Wizzowow Candy Truck",
"MightyMover Battery Truck",
"Powernaught Battery Truck",
"Wizzowow Battery Truck",
"MightyMover Fizzy Drink Truck",
"Powernaught Fizzy Drink Truck",
"Wizzowow Fizzy Drink Truck",
"MightyMover Plastic Truck",
"Powernaught Plastic Truck",
"Wizzowow Plastic Truck",
"MightyMover Bubble Truck",
"Powernaught Bubble Truck",
"Wizzowow Bubble Truck",
"MPS Oil Tanker",
"CS-Inc. Oil Tanker",
"MPS Passenger Ferry",
"FFP Passenger Ferry",
"Bakewell 300 Hovercraft",
"Chugger-Chug Passenger Ferry",
"Shivershake Passenger Ferry",
"Yate Cargo ship",
"Bakewell Cargo ship",
"Mightymover Cargo ship",
"Powernaut Cargo ship",
"Sampson U52",
"Coleman Count",
"FFP Dart",
"Yate Haugan",
"Bakewell Cotswald LB-3",
"Bakewell Luckett LB-8",
"Bakewell Luckett LB-9",
"Bakewell Luckett LB80",
"Bakewell Luckett LB-10",
"Bakewell Luckett LB-11",
"Yate Aerospace YAC 1-11",
"Darwin 100",
"Darwin 200",
"Darwin 300",
"Darwin 400",
"Darwin 500",
"Darwin 600",
"Guru Galaxy",
"Airtaxi A21",
"Airtaxi A31",
"Airtaxi A32",
"Airtaxi A33",
"Yate Aerospace YAe46",
"Dinger 100",
"AirTaxi A34-1000",
"Yate Z-Shuttle",
"Kelling K1",
"Kelling K6",
"Kelling K7",
"Darwin 700",
"FFP Hyperdart 2",
"Dinger 200",
"Dinger 1000",
"Ploddyphut 100",
"Ploddyphut 500",
"Flashbang X1",
"Juggerplane M1",
"Flashbang Wizzer",
"Tricario Helicopter",
"Guru X2 Helicopter",
"Powernaut Helicopter",
"\x94" "Message from vehicle manufacturer",
"\x8A" "We have just designed a new " "\x80" " - would you be interested in a year's exclusive use of this vehicle, so we can see how it performs before making it universally available ?",
"railroad locomotive",
"road vehicle",
"aircraft",
"ship",
"monorail locomotive",
"maglev locomotive",
};


static const char * const _trainview_string_table[] = {
"\x94" "\x80" " Train Depot",
"\x98" "\x0F" "Citizens celebrate . . .\rFirst train arrives at " "\x80" "!",
"\x94" "\x80" " (Details)",
"\x94" "Train in the way",
"\x01" "\x0A" "\x7D" ": " "\x80",
"\xAF" "\x01" "\x0A" "\x7D" ": " "\x80",
"Go to " "\x80",
"Go to " "\x80" " (Unload)",
"Go to " "\x80" " (Load)",
"",
"Go non-stop to " "\x80",
"Go non-stop to " "\x80" " (Unload)",
"Go non-stop to " "\x80" " (Load)",
"",
"Go to " "\x80" " Train Depot",
"Go non-stop to " "\x80" " Train Depot",
"\x95" "Heading for " "\x80",
"\x95" "Heading for " "\x80" " Train Depot",
"\x95" "Empty",
"\x95" "\x80" " from " "\x80",
"\x94" "Train " "\x7C" " is waiting in depot",
"\x98" "New Vehicles",
"\x98" "-",
"\x98" "Cost: " "\x8A" "\x7F" "\x98" "   Weight: " "\x8A" "\x7C" "t\r" "\x98" "Speed: " "\x8A" "\x84" "\x98" "   Power: " "\x8A" "\x7C" "hp\r" "\x98" "Running Cost: " "\x8A" "\x7F" "/yr\r" "\x98" "Capacity: " "\x8A" "\x80" "\r" "\x98" "Designed: " "\x8A" "\x7E" "\x98" "   Life: " "\x8A" "\x7C" " years\r" "\x98" "Max. Reliability: " "\x8A" "\x7D" "%",
"\x98" "Information",
"\x94" "Train too long",
"\x94" "Trains can only be altered when stopped inside a depot",
"\x94" "\x80" " - Trains",
"\x94" "New Rail Vehicles",
"\x94" "New Monorail Vehicles",
"\x94" "New Maglev Vehicles",
"\x98" "Build Vehicle",
"\x98" "Rename",
"\x98" "Cost: " "\x8A" "\x7F" "\r" "\x98" "Weight: " "\x8A" "\x7C" "t  (" "\x7C" "t)\r" "\x98" "Capacity: " "\x8A" "\x80",
"\x95" "No orders",
"\x98" "Skip",
"\x98" "Delete",
"\x98" "Non-Stop",
"\x98" "Go To",
"\x98" "Full Load",
"\x98" "Unload",
"\x94" "\x80" " (Orders)",
"\x01" "\x0A" "- - End of Orders - -",
"\x94" "Can't build railroad vehicle...",
"\x95" "\x80" "\x98" "   Built: " "\x95" "\x7E" "\x98" "   Value: " "\x95" "\x7F",
"\x95" "\x80" "\x98" "   Value: " "\x95" "\x7F",
"\x94" "\x80",
"\x95" "Loading / Unloading",
"\x94" "Can't send train to depot...",
"\x94" "No more space for orders",
"\x94" "Too many orders",
"\x94" "Can't insert new order...",
"\x94" "Can't delete this order...",
"\x94" "Can't modify this order...",
"\x94" "Must build train depot first",
"\x94" "Can't move vehicle...",
"N/A" "\x85",
"\x94" "Can't sell railroad vehicle...",
"\x94" "Unable to find route to local depot",
"\x94" "Can't stop/start train...",
"\x98" "Servicing interval: " "\x95" "\x7C" "days" "\x98" "   Last service: " "\x95" "\x82",
"\x98" "Trains - click on train for information",
"\x98" "Build new trains (requires train depot)",
"\x98" "Trains - click on train for info., drag vehicle to add/remove from train",
"\x98" "Build new train vehicle",
"\x98" "Drag train vehicle to here to sell it",
"\x98" "Center main view on train depot location",
"\x98" "Train vehicle selection list - click on vehicle for information",
"\x98" "Build the highlighted train vehicle",
"\x98" "Rename train vehicle type",
"\x98" "Current train action - click here to stop/start train",
"\x98" "Show train's orders",
"\x98" "Center main view on train's location",
"\x98" "Send train to depot",
"\x98" "Force train to proceed without waiting for signal to clear",
"\x98" "Reverse direction of train",
"\x98" "Show train details",
"\x98" "Increase servicing interval",
"\x98" "Decrease servicing interval",
"\x98" "Show details of cargo carried",
"\x98" "Show details of train vehicles",
"\x98" "Show capacities of each vehicle",
"\x98" "Orders list - click on order to highlight it",
"\x98" "Skip the current order, and start the next",
"\x98" "Delete the highlighted order",
"\x98" "Make the highlighted order non-stop",
"\x98" "Insert a new order before the highlighted order, or add to end of list",
"\x98" "Make the highlighted order force the vehicle to wait for a full load",
"\x98" "Make the highlighted order force the vehicle to unload",
"\x98" "\x0F" "New " "\x80" " now available!",
"\x98" "\x0F" "\x80",
"\x98" "Cost: " "\x7F" "    Weight: " "\x7C" "t\rSpeed: " "\x84" "    Power: " "\x7C" "hp\rRunning Cost: " "\x7F" "/yr\rCapacity: " "\x80",
"\x8B" "Broken down",
"\x98" "Age: " "\x95" "\x80" "\x98" "   Running Cost: " "\x95" "\x7F" "/yr",
"\x98" "Weight: " "\x95" "\x7C" "t   " "\x98" "Power: " "\x95" "\x7C" "hp" "\x98" "   Max. speed: " "\x95" "\x84",
"\x98" "Profit this year: " "\x95" "\x7F" "  (last year: " "\x7F" ")",
"\x98" "Reliability: " "\x95" "\x7D" "%   " "\x98" "Breakdowns since last service: " "\x95" "\x7C",
"\x8B" "Stopped",
"\x94" "Can't make train pass signal at danger...",
"\x8B" "Crashed!",
"Train " "\x7C",
"\x94" "Name train",
"\x94" "Can't name train...",
"\x98" "Name train",
"\x98" "\x0F" "Train Crash!\r" "\x7C" " die in fireball after collision",
"\x94" "Can't reverse direction of train...",
"\x94" "Rename train vehicle type",
"\x94" "Can't rename train vehicle type...",
};


static const char * const _roadview_string_table[] = {
"\x94" "Road vehicle in the way",
"\x94" "\x80" " - Road Vehicles",
"\x94" "\x80",
"\x94" "\x80" " Road Vehicle Depot",
"\x98" "New Vehicles",
"\x98" "Information",
"\x94" "New Road Vehicles",
"\x98" "Build Vehicle",
"\x98" "Cost: " "\x8A" "\x7F" "\x98" "   Speed: " "\x8A" "\x84" "\r" "\x98" "Running Cost: " "\x8A" "\x7F" "/yr\r" "\x98" "Capacity: " "\x8A" "\x80" "\r" "\x98" "Designed: " "\x8A" "\x7E" "\x98" "   Life: " "\x8A" "\x7C" " years\r" "\x98" "Max. Reliability: " "\x8A" "\x7D" "%",
"\x94" "Can't build road vehicle...",
"\x94" "Must build road vehicle depot first",
"\x94" "\x80" " (Orders)",
"\x94" "\x80" " (Details)",
"\x98" "Age: " "\x95" "\x80" "\x98" "   Running Cost: " "\x95" "\x7F" "/yr",
"\x98" "Max. speed: " "\x95" "\x84",
"\x98" "Profit this year: " "\x95" "\x7F" "  (last year: " "\x7F" ")",
"\x98" "Reliability: " "\x95" "\x7D" "%   " "\x98" "Breakdowns since last service: " "\x95" "\x7C",
"\x95" "\x80" "\x98" "   Built: " "\x95" "\x7E" "\x98" "   Value: " "\x95" "\x7F",
"\x98" "Capacity: " "\x95" "\x80",
"\x94" "...must be stopped inside a road vehicle depot",
"\x94" "Can't sell road vehicle...",
"\x94" "Can't stop/start road vehicle...",
"\x94" "Road Vehicle " "\x7C" " is waiting in depot",
"\x95" "Heading for " "\x80" " Road Depot",
"\x94" "Can't send vehicle to depot...",
"\x94" "Unable to find local depot",
"\x98" "Road vehicles - click on vehicle for information",
"\x98" "Build new road vehicles (requires road vehicle depot)",
"\x98" "Current vehicle action - click here to stop/start vehicle",
"\x98" "Show vehicle's orders",
"\x98" "Center main view on vehicle's location",
"\x98" "Send vehicle to depot",
"\x98" "Force vehicle to turn around",
"\x98" "Show road vehicle details",
"\x98" "Vehicles - click on vehicle for information",
"\x98" "Build new road vehicle",
"\x98" "Drag road vehicle to here to sell it",
"\x98" "Center main view on road vehicle depot location",
"\x98" "Road vehicle selection list - click on vehicle for information",
"\x98" "Build the highlighted road vehicle",
"\x98" "\x0F" "New road vehicle now available!",
"\x98" "\x0F" "\x80",
"\x98" "Cost: " "\x7F" "\rSpeed: " "\x84" "\rRunning Cost: " "\x7F" "/yr\rCapacity: " "\x80",
"Road Vehicle " "\x7C",
"\x94" "Name road vehicle",
"\x94" "Can't name road vehicle...",
"\x98" "Name road vehicle",
"\x98" "\x0F" "Citizens celebrate . . .\rFirst bus arrives at " "\x80" "!",
"\x98" "\x0F" "Citizens celebrate . . .\rFirst truck arrives at " "\x80" "!",
"\x98" "\x0F" "Road Vehicle Crash!\rDriver dies in fireball after collision with train",
"\x98" "\x0F" "Road Vehicle Crash!\r" "\x7C" " die in fireball after collision with train",
"\x94" "Can't make vehicle turn around...",
"\x98" "Rename",
"\x98" "Rename road vehicle type",
"\x94" "Rename road vehicle type",
"\x94" "Can't rename road vehicle type...",
};


static const char * const _docks_string_table[] = {
"Dock construction",
"\x94" "Dock construction",
"\x94" "Can't build dock here...",
"\x94" "\x80" " Ship Depot",
"\x98" "New Ships",
"\x94" "\x80" " - Ships",
"\x94" "Can't build ships...",
"\x94" "Must build ship depot first",
"\x94" "New Ships",
"\x98" "Build Ship",
"\x98" "Cost: " "\x8A" "\x7F" "\x98" "   Speed: " "\x8A" "\x84" "\r" "\x98" "Capacity: " "\x8A" "\x80" " " "\x80" "\r" "\x98" "Running Cost: " "\x8A" "\x7F" "/yr\r" "\x98" "Designed: " "\x8A" "\x7E" "\x98" "   Life: " "\x8A" "\x7C" " years\r" "\x98" "Max. Reliability: " "\x8A" "\x7D" "%",
"\x94" "Ship must be stopped in depot",
"\x94" "Can't sell ship...",
"\x94" "Can't build ship...",
"\x94" "Ship in the way",
"\x94" "\x80",
"\x94" "\x80" " (Orders)",
"\x94" "\x80" " (Details)",
"\x98" "Age: " "\x95" "\x80" "\x98" "   Running Cost: " "\x95" "\x7F" "/yr",
"\x98" "Max. speed: " "\x95" "\x84",
"\x98" "Profit this year: " "\x95" "\x7F" "  (last year: " "\x7F" ")",
"\x98" "Reliability: " "\x95" "\x7D" "%   " "\x98" "Breakdowns since last service: " "\x95" "\x7C",
"\x95" "\x80" "\x98" "   Built: " "\x95" "\x7E" "\x98" "   Value: " "\x95" "\x7F",
"\x98" "Capacity: " "\x95" "\x80",
"\x94" "Can't stop/start ship...",
"\x94" "Can't send ship to depot...",
"\x94" "Unable to find local depot",
"\x95" "Heading for " "\x80" " Ship Depot",
"\x94" "Ship " "\x7C" " is waiting in depot",
"\x98" "Build ship dock",
"\x98" "Build ship depot (for building and servicing ships)",
"\x98" "Ships - click on ship for information",
"\x98" "Build new ship",
"\x98" "Drag ship to here to sell it",
"\x98" "Center main view on ship depot location",
"\x98" "Ships - click on ship for information",
"\x98" "Build new ships (requires ship depot)",
"\x98" "Ship selection list - click on ship for information",
"\x98" "Build the highlighted ship",
"\x98" "Current ship action - click here to stop/start ship",
"\x98" "Show ship's orders",
"\x98" "Center main view on ship's location",
"\x98" "Send ship to depot",
"\x98" "Show ship details",
"\x98" "\x0F" "New ship now available!",
"\x98" "\x0F" "\x80",
"\x98" "Cost: " "\x7F" "    Max. Speed: " "\x84" "\rCapacity: " "\x80" "\rRunning Cost: " "\x7F" "/yr",
"\x98" "Name ship",
"Ship " "\x7C",
"\x94" "Name ship",
"\x94" "Can't name ship...",
"\x98" "\x0F" "Citizens celebrate . . .\rFirst ship arrives at " "\x80" "!",
"\x98" "Position buoy, which can be used for additional way points",
"\x94" "Can't position buoy here...",
"\x98" "Rename",
"\x98" "Rename ship type",
"\x94" "Rename ship type",
"\x94" "Can't rename ship type...",
"\x98" "Refit cargo ship to carry a different cargo type",
"\x94" "\x80" " (Refit)",
"\x98" "Refit ship",
"\x98" "Select type of cargo for ship to carry",
"\x98" "Refit ship to carry highlighted cargo type",
"\x8A" "Select cargo type to carry:-",
"\x98" "New capacity: " "\x8A" "\x80" "\r" "\x98" "Cost of refit: " "\x8A" "\x7F",
"\x94" "Can't refit ship...",
"(refittable)",
};


static const char * const _airport_string_table[] = {
"\x94" "Airport Construct.",
"\x94" "Can't build airport here...",
"\x94" "\x80" " Aircraft Hangar",
"\x98" "New Aircraft",
"\x98" "Information",
"\x94" "New Aircraft",
"\x98" "Build Aircraft",
"\x98" "Cost: " "\x8A" "\x7F" "\x98" "   Speed: " "\x8A" "\x84" "\r" "\x98" "Capacity: " "\x8A" "\x7C" " passengers, " "\x7C" " bags of mail\r" "\x98" "Running Cost: " "\x8A" "\x7F" "/yr\r" "\x98" "Designed: " "\x8A" "\x7E" "\x98" "   Life: " "\x8A" "\x7C" " years\r" "\x98" "Max. Reliability: " "\x8A" "\x7D" "%",
"\x94" "Can't build aircraft...",
"\x94" "\x80" " - Aircraft",
"\x94" "\x80",
"\x94" "\x80" " (Orders)",
"\x94" "\x80" " (Details)",
"\x98" "Age: " "\x95" "\x80" "\x98" "   Running Cost: " "\x95" "\x7F" "/yr",
"\x98" "Max. speed: " "\x95" "\x84",
"\x98" "Profit this year: " "\x95" "\x7F" "  (last year: " "\x7F" ")",
"\x98" "Reliability: " "\x95" "\x7D" "%   " "\x98" "Breakdowns since last service: " "\x95" "\x7C",
"\x95" "\x80" "\x98" "   Built: " "\x95" "\x7E" "\x98" "   Value: " "\x95" "\x7F",
"\x94" "Can't send aircraft to hangar...",
"\x95" "Heading for " "\x80" " Hangar",
"\x94" "Aircraft " "\x7C" " is waiting in the aircraft hangar",
"\x94" "Aircraft in the way",
"\x94" "Can't stop/start aircraft...",
"\x94" "Aircraft is in flight",
"\x94" "Must build airport first",
"\x98" "Capacity: " "\x95" "\x80" ", " "\x80",
"\x98" "Capacity: " "\x95" "\x80",
"\x94" "Aircraft must be stopped in hangar",
"\x94" "Can't sell aircraft...",
"Airport construction",
"\x98" "Build airport",
"\x98" "Aircraft - click on aircraft for information",
"\x98" "Build new aircraft (requires airport with hangar)",
"\x98" "Aircraft - click on aircraft for information",
"\x98" "Build new aircraft",
"\x98" "Drag aircraft to here to sell it",
"\x98" "Center main view on hangar location",
"\x98" "Aircraft selection list - click on aircraft for information",
"\x98" "Build the highlighted aircraft",
"\x98" "Current aircraft action - click here to stop/start aircraft",
"\x98" "Show aircraft's orders",
"\x98" "Center main view on aircraft's location",
"\x98" "Send aircraft to hangar",
"\x98" "Show aircraft details",
"\x98" "\x0F" "New aircraft now available!",
"\x98" "\x0F" "\x80",
"\x98" "Cost: " "\x7F" "    Max. Speed: " "\x84" "\rCapacity: " "\x7C" " passengers, " "\x7C" " bags of mail\rRunning Cost: " "\x7F" "/yr",
"Aircraft " "\x7C",
"\x94" "Name aircraft",
"\x94" "Can't name aircraft...",
"\x98" "Name aircraft",
"\x98" "\x0F" "Citizens celebrate . . .\rFirst aircraft arrives at " "\x80" "!",
"\x98" "\x0F" "Plane Crash!\r" "\x7C" " die in fireball at " "\x80",
"\x0E" "\x98" "Destinations: ",
"\x0E" "\x98" "\x80",
"\x98" "Rename",
"\x98" "Rename aircraft type",
"\x94" "Rename aircraft type",
"\x94" "Can't rename aircraft type...",
"\x98" "Refit aircraft to carry a different cargo type",
"\x94" "\x80" " (Refit)",
"\x98" "Refit aircraft",
"\x98" "Select type of cargo for aircraft to carry",
"\x98" "Refit aircraft to carry highlighted cargo type",
"\x8A" "Select cargo type to carry:-",
"\x98" "New capacity: " "\x8A" "\x80" "\r" "\x98" "Cost of refit: " "\x8A" "\x7F",
"\x94" "Can't refit aircraft...",
"(refittable)",
};


static const char * const _disaster_string_table[] = {
"\x98" "\x0F" "Zeppelin disaster at " "\x80" "!",
"\x98" "\x0F" "Road vehicle destroyed in 'UFO' collision!",
"\x98" "\x0F" "Oil refinery explosion near " "\x80" "!",
"\x98" "\x0F" "Factory destroyed in suspicious circumstances near " "\x80" "!",
"\x98" "\x0F" "'UFO' lands near " "\x80" "!",
"\x98" "\x0F" "Coal mine subsidence leaves trail of destruction near " "\x80" "!",
};

static const char * const _month_names_long[] = {
"January",
"February",
"March",
"April",
"May",
"June",
"July",
"August",
"September",
"October",
"November",
"December",
};
