#include "stdafx.h"
#include "ttd.h"

#include "window.h"
#include "gui.h"
#include "viewport.h"
#include "gfx.h"
#include "command.h"

static void ShowBusStationPicker();
static void ShowTruckStationPicker();
static void ShowRoadDepotPicker();

static bool _remove_button_clicked;
static bool _build_road_flag;

static byte _place_road_flag;

static byte _road_depot_orientation;
static byte _road_station_picker_orientation;

static void GenericRemoveRoad(uint tile, byte type)
{
	int32 ret;

	ret = DoCommandByTile(tile, type, 0, DC_EXEC | DC_MSG(STR_1805_CAN_T_REMOVE_ROAD_FROM), CMD_REMOVE_ROAD);
	if (ret != CMD_ERROR)
		SndPlayTileFx(0x1D, tile);
}

void PlaceRoad_NE(uint tile)
{
	if (_remove_button_clicked) {
		GenericRemoveRoad(tile, _tile_fract_coords.y < 8 ? 1 : 4);
		return;
	}

	_place_road_flag = (_tile_fract_coords.y >= 8) + 4;
	VpStartPlaceSizing(tile, 1);
}

void PlaceRoad_NW(uint tile)
{
	if (_remove_button_clicked) {
		GenericRemoveRoad(tile, _tile_fract_coords.x < 8 ? 8 : 2);
		return;
	}

	_place_road_flag = (_tile_fract_coords.x >= 8) + 0;
	VpStartPlaceSizing(tile, 2);
}

void PlaceRoad_Bridge(uint tile)
{
	VpStartPlaceSizing(tile, 0);
}

void PlaceRoad_Tunnel(uint tile)
{
	int32 ret;
	uint endtile;

	ret = DoCommandByTile(tile, 0x200, 0, DC_MSG(STR_5016_CAN_T_BUILD_TUNNEL_HERE) | DC_EXEC | DC_AUTO, CMD_BUILD_TUNNEL);

	endtile = _build_tunnel_endtile;
	if (ret == CMD_ERROR) {
		if (endtile != 0) {
			TileIndex old;

			MarkTileDirtyByTile(endtile);

			old = _thd.redsq;
			_thd.redsq = endtile;

			if (old != 0) {
				MarkTileDirtyByTile(old);
			}
		}
		return;
	}

	SndPlayTileFx(0x1D, tile);
	ResetObjectToPlace();
}

static void BuildRoadOutsideStation(uint tile, int direction)
{
	static const byte _roadbits_by_dir[4] = {2,1,8,4};
	tile += _tileoffs_by_dir[direction];
	if (IS_TILETYPE(tile, MP_STREET)) {
		if (DoCommandByTile(tile, _roadbits_by_dir[direction], 0, DC_AUTO, CMD_BUILD_ROAD) != CMD_ERROR) {
			DoCommandByTile(tile, _roadbits_by_dir[direction], 0, DC_EXEC | DC_AUTO, CMD_BUILD_ROAD);
		}
	}
}

void PlaceRoad_Depot(uint tile)
{
	if (DoCommandByTile(tile, _road_depot_orientation, 0, 
		DC_EXEC | DC_AUTO | DC_NO_WATER | DC_MSG(STR_1807_CAN_T_BUILD_ROAD_VEHICLE), CMD_BUILD_ROAD_DEPOT) == CMD_ERROR)
			return;

	SndPlayTileFx(0x1D, tile);
	ResetObjectToPlace();

	BuildRoadOutsideStation(tile, _road_depot_orientation);
}

void PlaceRoad_BusStation(uint tile)
{

	if (DoCommandByTile(tile, _road_station_picker_orientation, 0,
		DC_EXEC | DC_AUTO | DC_NO_WATER | DC_MSG(STR_1808_CAN_T_BUILD_BUS_STATION), CMD_BUILD_BUS_STATION) == CMD_ERROR)
			return;

	SndPlayTileFx(0x1D, tile);
	ResetObjectToPlace();

	BuildRoadOutsideStation(tile, _road_station_picker_orientation);
}

void PlaceRoad_TruckStation(uint tile)
{
	if (DoCommandByTile(tile, _road_station_picker_orientation, 0, 
		DC_EXEC | DC_AUTO | DC_NO_WATER | DC_MSG(STR_1809_CAN_T_BUILD_TRUCK_STATION), CMD_BUILD_TRUCK_STATION) == CMD_ERROR)
				return;

	SndPlayTileFx(0x1D, tile);
	ResetObjectToPlace();

	BuildRoadOutsideStation(tile, _road_station_picker_orientation);
}

typedef void OnButtonClick(Window *w);

void BuildRoadClick_NE(Window *w)
{
	_build_road_flag = 0;
	SndPlayFx(0x13);
	SetWindowDirty(w);

	if (w->click_state & (1<<2)) {
		ResetObjectToPlace();
		return;
	}

	SetObjectToPlaceWnd(0x51F, 1, w);

	w->click_state |= (1<<2);
	_place_proc = PlaceRoad_NE;
}

void BuildRoadClick_NW(Window *w)
{
	_build_road_flag = 0;
	SndPlayFx(0x13);
	SetWindowDirty(w);

	if (w->click_state & (1<<3)) {
		ResetObjectToPlace();
		return;
	}

	SetObjectToPlaceWnd(0x520, 1, w);

	w->click_state |= (1<<3);
	_place_proc = PlaceRoad_NW;
}

void BuildRoadClick_Demolish(Window *w)
{
	extern const uint16 _demolish_animcursor[];

	SndPlayFx(0x13);
	SetWindowDirty(w);

	if (w->click_state & (1<<4)) {
		ResetObjectToPlace();
		return;
	}

	SetObjectToPlaceWnd((uint32)_demolish_animcursor, 1|SOTP_ANIM_CURSOR, w);

	w->click_state |= (1<<4);
	_place_proc = PlaceProc_Demolish;
}

void BuildRoadClick_Lower(Window *w)
{
	extern const uint16 _lower_land_animcursor[];
	
	SndPlayFx(0x13);
	SetWindowDirty(w);

	if (w->click_state & (1<<5)) {
		ResetObjectToPlace();
		return;
	}

	SetObjectToPlaceWnd((uint32)_lower_land_animcursor, 2|SOTP_ANIM_CURSOR, w);

	w->click_state |= (1<<5);
	_place_proc = PlaceProc_LowerLand;
}

void BuildRoadClick_Raise(Window *w)
{
	extern const uint16 _raise_land_animcursor[];
	
	SndPlayFx(0x13);
	SetWindowDirty(w);

	if (w->click_state & (1<<6)) {
		ResetObjectToPlace();
		return;
	}
	
	SetObjectToPlaceWnd((uint32)_raise_land_animcursor, 2|SOTP_ANIM_CURSOR, w);

	w->click_state |= (1<<6);
	_place_proc = PlaceProc_RaiseLand;
}

void BuildRoadClick_Depot(Window *w)
{
	SndPlayFx(0x13);
	SetWindowDirty(w);

	if (w->click_state & (1<<7)) {
		ResetObjectToPlace();
		return;
	}

	SetObjectToPlaceWnd(0x511, 1, w);

	w->click_state |= (1<<7);
	_place_proc = PlaceRoad_Depot;
	
	ShowRoadDepotPicker();
}

void BuildRoadClick_BusStation(Window *w)
{
	SndPlayFx(0x13);
	SetWindowDirty(w);

	if (w->click_state & (1<<8)) {
		ResetObjectToPlace();
		return;
	}

	SetObjectToPlaceWnd(0xAA5, 1, w);

	w->click_state |= (1<<8);
	_place_proc = PlaceRoad_BusStation;

	ShowBusStationPicker();
}

void BuildRoadClick_TruckStation(Window *w)
{
	SndPlayFx(0x13);
	SetWindowDirty(w);

	if (w->click_state & (1<<9)) {
		ResetObjectToPlace();
		return;
	}

	SetObjectToPlaceWnd(0xAA6, 1, w);

	w->click_state |= (1<<9);
	_place_proc = PlaceRoad_TruckStation;

	ShowTruckStationPicker();
}

void BuildRoadClick_Bridge(Window *w)
{
	_build_road_flag = 0;

	SndPlayFx(0x13);
	SetWindowDirty(w);

	if (w->click_state & (1<<10)) {
		ResetObjectToPlace();
		return;
	}

	SetObjectToPlaceWnd(0xA21, 1, w);

	w->click_state |= (1<<10);
	_place_proc = PlaceRoad_Bridge;
}

void BuildRoadClick_Tunnel(Window *w)
{
	_build_road_flag = 0;

	SndPlayFx(0x13);
	SetWindowDirty(w);

	if (w->click_state & (1<<11)) {
		ResetObjectToPlace();
		return;
	}

	SetObjectToPlaceWnd(0x981, 3, w);
		
	w->click_state |= (1<<11);
	_place_proc = PlaceRoad_Tunnel;

	VpStartPreSizing();
}

void BuildRoadClick_Remove(Window *w)
{
	if (w->disabled_state & (1<<12))
		return;
	SetWindowDirty(w);
	SndPlayFx(0x13);
	_thd.make_square_red = !!((w->click_state ^= (1 << 12)) & (1<<12));
}

void BuildRoadClick_Purchase(Window *w)
{
	SndPlayFx(0x13);
	SetWindowDirty(w);

	if (w->click_state & (1<<13)) {
		ResetObjectToPlace();
		return;
	}

	SetObjectToPlaceWnd(0x12B8, 1, w);

	w->click_state |= (1<<13);
	_place_proc = PlaceProc_BuyLand;
}

static OnButtonClick * const _build_road_button_proc[] = {
	BuildRoadClick_NE,
	BuildRoadClick_NW,
	BuildRoadClick_Demolish,
	BuildRoadClick_Lower,
	BuildRoadClick_Raise,
	BuildRoadClick_Depot,
	BuildRoadClick_BusStation,
	BuildRoadClick_TruckStation,
	BuildRoadClick_Bridge,
	BuildRoadClick_Tunnel,
	BuildRoadClick_Remove,
	BuildRoadClick_Purchase,
};

static void BuildRoadToolbWndProc(Window *w, WindowEvent *e) {
	switch(e->event) {
	case WE_PAINT:
		w->disabled_state &= ~(1 << 12);
		if (!(w->click_state & 12)) {
			w->disabled_state |= (1 << 12);
			w->click_state &= ~(1<<12);
		}
		DrawWindowWidgets(w);
		break;

	case WE_CLICK: {
		if (e->click.widget >= 2)
			_build_road_button_proc[e->click.widget - 2](w);
	}	break;

	case WE_KEYPRESS:
		switch(e->keypress.keycode) {
		case '1': BuildRoadClick_NE(w); break;
		case '2': BuildRoadClick_NW(w); break;
		default:
			return;
		}
		e->keypress.cont = false;
		break;

	case WE_PLACE_OBJ:
		_remove_button_clicked = (w->click_state & (1 << 12)) != 0;
		_place_proc(e->place.tile);
		break;

	case WE_ABORT_PLACE_OBJ:
		w->click_state = 0;
		SetWindowDirty(w);

		w = FindWindowById(WC_BUS_STATION, 0);
		if (w != NULL) WP(w,def_d).close=true;
		w = FindWindowById(WC_TRUCK_STATION, 0);
		if (w != NULL) WP(w,def_d).close=true;
		w = FindWindowById(WC_BUILD_DEPOT, 0);
		if (w != NULL) WP(w,def_d).close=true;
		break;

	case WE_PLACE_DRAG: {
		int sel_method;
		if (e->place.userdata == 1) {
			sel_method = VPM_FIX_X;
			_place_road_flag = (_place_road_flag&~2) | ((e->place.pt.y&8)>>2);
		} else if (e->place.userdata == 2) {
			sel_method = VPM_FIX_Y;
			_place_road_flag = (_place_road_flag&~2) | ((e->place.pt.x&8)>>2);
		} else {
			sel_method = VPM_X_OR_Y;
		}
		
		VpSelectTilesWithMethod(e->place.pt.x, e->place.pt.y, sel_method);
		return;
	}

	case WE_PLACE_MOUSEUP:
		if (e->place.pt.x != -1) {
			if (e->place.userdata == 0)
				ShowBuildBridgeWindow(e->place.pt.x, e->place.pt.y, 0x80);
			else {
				uint start_tile = TILE_FROM_XY(_thd.select_to.x, _thd.select_to.y);
				uint end_tile = TILE_FROM_XY(e->place.pt.x, e->place.pt.y);
				if (DoCommandByTile(end_tile, start_tile, _place_road_flag, 
						DC_AUTO | DC_NO_WATER | DC_EXEC | DC_MSG(STR_1804_CAN_T_BUILD_ROAD_HERE), CMD_BUILD_LONG_ROAD) != CMD_ERROR) {
					SndPlayTileFx(0x1D, end_tile);
				}
			}
		}
		if (e->place.userdata == 1) {
			BuildRoadClick_NE(w);
		} else if (e->place.userdata == 2) {
			BuildRoadClick_NW(w);
		}
		break;

	case WE_PLACE_PRESIZE: {
		uint tile = e->place.tile;
		DoCommandByTile(tile, 0x200, 0, DC_AUTO, CMD_BUILD_TUNNEL);
		VpSetPresizeRange(tile, _build_tunnel_endtile==0?tile:_build_tunnel_endtile);
		break;
	}
	}
}

static const Widget _build_road_widgets[] = {
{   WWT_CLOSEBOX,     7,     0,    10,     0,    13, STR_00C5, STR_018B_CLOSE_WINDOW},
{    WWT_CAPTION,     7,    11,   283,     0,    13, STR_1802_ROAD_CONSTRUCTION, STR_018C_WINDOW_TITLE_DRAG_THIS},
{      WWT_PANEL,     7,     0,    21,    14,    35, 0x51D, STR_180B_BUILD_ROAD_SECTION},
{      WWT_PANEL,     7,    22,    43,    14,    35, 0x51E, STR_180B_BUILD_ROAD_SECTION},
{      WWT_PANEL,     7,    44,    65,    14,    35, 0x2BF, STR_018D_DEMOLISH_BUILDINGS_ETC},
{      WWT_PANEL,     7,    66,    87,    14,    35, 0x2B7, STR_018E_LOWER_A_CORNER_OF_LAND},
{      WWT_PANEL,     7,    88,   109,    14,    35, 0x2B6, STR_018F_RAISE_A_CORNER_OF_LAND},
{      WWT_PANEL,     7,   110,   131,    14,    35, 0x50F, STR_180C_BUILD_ROAD_VEHICLE_DEPOT},
{      WWT_PANEL,     7,   132,   153,    14,    35, 0x2ED, STR_180D_BUILD_BUS_STATION},
{      WWT_PANEL,     7,   154,   175,    14,    35, 0x2EE, STR_180E_BUILD_TRUCK_LOADING_BAY},
{      WWT_PANEL,     7,   176,   217,    14,    35, 0xA22, STR_180F_BUILD_ROAD_BRIDGE},
{      WWT_PANEL,     7,   218,   239,    14,    35, 0x97D, STR_1810_BUILD_ROAD_TUNNEL},
{      WWT_PANEL,     7,   240,   261,    14,    35, 0x2CA, STR_1811_TOGGLE_BUILD_REMOVE_FOR},
{      WWT_PANEL,     7,   262,   283,    14,    35, 0x12B7, STR_0329_PURCHASE_LAND_FOR_FUTURE},
{      WWT_LAST},
};

static const WindowDesc _build_road_desc = {
	0x164, 0x16, 0x11c, 0x24,
	WC_BUILD_TOOLBAR,0,
	WDF_STD_TOOLTIPS | WDF_STD_BTN | WDF_DEF_WIDGET,
	_build_road_widgets,
	BuildRoadToolbWndProc
};

void ShowBuildRoadToolbar()
{
	DeleteWindowById(WC_BUILD_TOOLBAR, 0);
	AllocateWindowDesc(&_build_road_desc);
}

static const Widget _build_road_scen_widgets[] = {
{    WWT_TEXTBTN,     7,     0,    10,     0,    13, STR_00C5, STR_018B_CLOSE_WINDOW},
{    WWT_CAPTION,     7,    11,   195,     0,    13, STR_1802_ROAD_CONSTRUCTION, STR_018C_WINDOW_TITLE_DRAG_THIS},
{     WWT_IMGBTN,     7,     0,    21,    14,    35, 0x51D, STR_180B_BUILD_ROAD_SECTION},
{     WWT_IMGBTN,     7,    22,    43,    14,    35, 0x51E, STR_180B_BUILD_ROAD_SECTION},
{     WWT_IMGBTN,     7,    44,    65,    14,    35, 0x2BF, STR_018D_DEMOLISH_BUILDINGS_ETC},
{     WWT_IMGBTN,     7,    66,    87,    14,    35, 0x2B7, STR_018E_LOWER_A_CORNER_OF_LAND},
{     WWT_IMGBTN,     7,    88,   109,    14,    35, 0x2B6, STR_018F_RAISE_A_CORNER_OF_LAND},
{      WWT_EMPTY,     0,     0,     0,     0,     0, 0x0},
{      WWT_EMPTY,     0,     0,     0,     0,     0, 0x0},
{      WWT_EMPTY,     0,     0,     0,     0,     0, 0x0},
{     WWT_IMGBTN,     7,   110,   151,    14,    35, 0xA22, STR_180F_BUILD_ROAD_BRIDGE},
{     WWT_IMGBTN,     7,   152,   173,    14,    35, 0x97D, STR_1810_BUILD_ROAD_TUNNEL},
{     WWT_IMGBTN,     7,   174,   195,    14,    35, 0x2CA, STR_1811_TOGGLE_BUILD_REMOVE_FOR},
{      WWT_LAST},
};

static const WindowDesc _build_road_scen_desc = {
	-1, -1, 0xC4, 0x24,
	WC_SCEN_BUILD_ROAD,0,
	WDF_STD_TOOLTIPS | WDF_STD_BTN | WDF_DEF_WIDGET,
	_build_road_scen_widgets,
	BuildRoadToolbWndProc
};

void ShowBuildRoadScenToolbar()
{
	AllocateWindowDescFront(&_build_road_scen_desc, 0);
}

static void BuildRoadDepotWndProc(Window *w, WindowEvent *e) {
	switch(e->event) {
	case WE_PAINT:
		w->click_state = (1<<3) << _road_depot_orientation;
		DrawWindowWidgets(w);

		DrawRoadDepotSprite(70, 17, 0);
		DrawRoadDepotSprite(70, 69, 1);
		DrawRoadDepotSprite(2, 69, 2);
		DrawRoadDepotSprite(2, 17, 3);
		break;

	case WE_CLICK: {
		switch(e->click.widget) {
		case 0:
			ResetObjectToPlace();
			break;
		case 3:
		case 4:
		case 5:
		case 6:
			_road_depot_orientation = e->click.widget - 3;
			SndPlayFx(0x13);
			SetWindowDirty(w);
			break;
		}	
	}	break;
	
	case WE_MOUSELOOP:
		if (WP(w,def_d).close)
			DeleteWindow(w);
		break;
	}
}

static const Widget _build_road_depot_widgets[] = {
{   WWT_CLOSEBOX,     7,     0,    10,     0,    13, STR_00C5, STR_018B_CLOSE_WINDOW},
{    WWT_CAPTION,     7,    11,   139,     0,    13, STR_1806_ROAD_DEPOT_ORIENTATION, STR_018C_WINDOW_TITLE_DRAG_THIS},
{      WWT_PANEL,     7,     0,   139,    14,   121, 0x0, 0},
{      WWT_PANEL,    14,    71,   136,    17,    66, 0x0, STR_1813_SELECT_ROAD_VEHICLE_DEPOT},
{      WWT_PANEL,    14,    71,   136,    69,   118, 0x0, STR_1813_SELECT_ROAD_VEHICLE_DEPOT},
{      WWT_PANEL,    14,     3,    68,    69,   118, 0x0, STR_1813_SELECT_ROAD_VEHICLE_DEPOT},
{      WWT_PANEL,    14,     3,    68,    17,    66, 0x0, STR_1813_SELECT_ROAD_VEHICLE_DEPOT},
{      WWT_LAST},
};

static const WindowDesc _build_road_depot_desc = {
	-1,-1, 0x8C, 0x7A,
	WC_BUILD_DEPOT,WC_BUILD_TOOLBAR,
	WDF_STD_TOOLTIPS | WDF_STD_BTN | WDF_DEF_WIDGET,
	_build_road_depot_widgets,
	BuildRoadDepotWndProc
};

static void ShowRoadDepotPicker()
{
	AllocateWindowDesc(&_build_road_depot_desc);
}


static void RoadStationPickerWndProc(Window *w, WindowEvent *e) {
	switch(e->event) {
	case WE_PAINT: {
		int image;

		w->click_state = ((1<<3) << _road_station_picker_orientation)	|
										 ((1<<7) << _station_show_coverage);
		DrawWindowWidgets(w);

		SetTileSelectSize(1, 1);
		if (_station_show_coverage)
			SetTileSelectBigSize(-4, -4, 8, 8);

		image = (w->window_class == WC_BUS_STATION) ? 0x47 : 0x43;

		StationPickerDrawSprite(103, 35, 0, image);
		StationPickerDrawSprite(103, 85, 0, image+1);
		StationPickerDrawSprite(35, 85, 0, image+2);
		StationPickerDrawSprite(35, 35, 0, image+3);

		DrawStringCentered(70, 120, STR_3066_COVERAGE_AREA_HIGHLIGHT, 0);
		DrawStationCoverageAreaText(2, 146,
			((w->window_class == WC_BUS_STATION) ? (1<<CT_PASSENGERS) : ~(1<<CT_PASSENGERS))
		);

	} break;

	case WE_CLICK: {
		switch(e->click.widget) {
		case 0:
			ResetObjectToPlace();
			break;
		case 3:
		case 4:
		case 5:
		case 6:
			_road_station_picker_orientation = e->click.widget - 3;
			SndPlayFx(0x13);
			SetWindowDirty(w);
			break;
		case 7:
		case 8:
			_station_show_coverage = e->click.widget - 7;
			SndPlayFx(0x13);
			SetWindowDirty(w);
			break;
		}
	} break;
	
	case WE_MOUSELOOP: {
		if (WP(w,def_d).close) {
			DeleteWindow(w);
			return;
		}

		CheckRedrawStationCoverage(w);
	} break;
	}		
}

static const Widget _bus_station_picker_widgets[] = {
{   WWT_CLOSEBOX,     7,     0,    10,     0,    13, STR_00C5, STR_018B_CLOSE_WINDOW},
{    WWT_CAPTION,     7,    11,   139,     0,    13, STR_3042_BUS_STATION_ORIENTATION, STR_018C_WINDOW_TITLE_DRAG_THIS},
{      WWT_PANEL,     7,     0,   139,    14,   176, 0x0, 0},
{      WWT_PANEL,    14,    71,   136,    17,    66, 0x0, STR_3051_SELECT_BUS_STATION_ORIENTATION},
{      WWT_PANEL,    14,    71,   136,    69,   118, 0x0, STR_3051_SELECT_BUS_STATION_ORIENTATION},
{      WWT_PANEL,    14,     3,    68,    69,   118, 0x0, STR_3051_SELECT_BUS_STATION_ORIENTATION},
{      WWT_PANEL,    14,     3,    68,    17,    66, 0x0, STR_3051_SELECT_BUS_STATION_ORIENTATION},
{   WWT_CLOSEBOX,    14,    10,    69,   133,   144, STR_02DB_OFF, STR_3065_DON_T_HIGHLIGHT_COVERAGE},
{   WWT_CLOSEBOX,    14,    70,   129,   133,   144, STR_02DA_ON, STR_3064_HIGHLIGHT_COVERAGE_AREA},
{      WWT_LAST},
};

static const WindowDesc _bus_station_picker_desc = {
	-1,-1, 0x8C, 0xB1,
	WC_BUS_STATION,WC_BUILD_TOOLBAR,
	WDF_STD_TOOLTIPS | WDF_STD_BTN | WDF_DEF_WIDGET,
	_bus_station_picker_widgets,
	RoadStationPickerWndProc
};

static void ShowBusStationPicker()
{
	AllocateWindowDesc(&_bus_station_picker_desc);
}

static const Widget _truck_station_picker_widgets[] = {
{   WWT_CLOSEBOX,     7,     0,    10,     0,    13, STR_00C5, STR_018B_CLOSE_WINDOW},
{    WWT_CAPTION,     7,    11,   139,     0,    13, STR_3043_TRUCK_STATION_ORIENT, STR_018C_WINDOW_TITLE_DRAG_THIS},
{      WWT_PANEL,     7,     0,   139,    14,   176, 0x0, 0},
{      WWT_PANEL,    14,    71,   136,    17,    66, 0x0, STR_3052_SELECT_TRUCK_LOADING_BAY},
{      WWT_PANEL,    14,    71,   136,    69,   118, 0x0, STR_3052_SELECT_TRUCK_LOADING_BAY},
{      WWT_PANEL,    14,     3,    68,    69,   118, 0x0, STR_3052_SELECT_TRUCK_LOADING_BAY},
{      WWT_PANEL,    14,     3,    68,    17,    66, 0x0, STR_3052_SELECT_TRUCK_LOADING_BAY},
{   WWT_CLOSEBOX,    14,    10,    69,   133,   144, STR_02DB_OFF, STR_3065_DON_T_HIGHLIGHT_COVERAGE},
{   WWT_CLOSEBOX,    14,    70,   129,   133,   144, STR_02DA_ON, STR_3064_HIGHLIGHT_COVERAGE_AREA},
{      WWT_LAST},
};

static const WindowDesc _truck_station_picker_desc = {
	-1,-1, 0x8C, 0xB1,
	WC_TRUCK_STATION,WC_BUILD_TOOLBAR,
	WDF_STD_TOOLTIPS | WDF_STD_BTN | WDF_DEF_WIDGET,
	_truck_station_picker_widgets,
	RoadStationPickerWndProc
};

static void ShowTruckStationPicker()
{
	AllocateWindowDesc(&_truck_station_picker_desc);
}

void InitializeRoadGui()
{
	_road_depot_orientation = 3;
	_road_station_picker_orientation = 3;
}
