/* $Id: crc32.cpp 10161 2007-06-14 20:16:06Z truelight $ */

#include "crc32.hpp"

/* static */ crc_t CRC32::Table[256] = {1};	// will be 0 when generated

#define CRC_BYTE(c,b) (Table[((b) ^ (c)) & 255] ^ ((c) >> 8))

/* static */ void CRC32::MakeTable()
{
	for (int bp = 255; bp >= 0; bp--) {
		crc_t x = bp;
		for (int cx = 0; cx < 8; cx++) {
			int carry_dx = (x) & 1;
			x >>= 1;
			if (carry_dx) x ^= 0xEDB88320;
		}
		Table[bp] = x;
	}
}

/* static */ crc_t CRC32::DoBlock(const void *bl, unsigned int l)
{
	if (Table[0] != 0) MakeTable();

	crc_t cur = 0xFFFFFFFF;
	const unsigned char *u = reinterpret_cast<const unsigned char*>(bl);
	for (unsigned int t = 0; t < l; t++) cur = CRC_BYTE(cur, u[t]);
	return cur ^ 0xFFFFFFFF;
}

/* static */ crc_t CRC32::DoString(const char *s)
{
	if (Table[0] != 0) MakeTable();

	crc_t cur = 0xFFFFFFFF;
	if (s != '\0') {
		do {
			cur = CRC_BYTE(cur, *s);
		} while (*s++);
	}
	return cur ^ 0xFFFFFFFF;
}

