/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.appframework.swingx;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.RootPaneContainer;
import org.jdesktop.appframework.swingx.XProperties;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.SessionStorage;
import org.jdesktop.application.SingleFrameApplication;
import org.jdesktop.application.session.PropertySupport;
import org.jdesktop.swingx.JXFrame;
import org.jdesktop.swingx.JXTable;

public abstract class SingleXFrameApplication
extends SingleFrameApplication {
    private static final Logger logger = Logger.getLogger(SingleXFrameApplication.class.getName());
    private boolean started = false;

    protected void initialize(String[] stringArray) {
        this.injectSessionProperties();
        this.setMainFrame((JFrame)this.createXMainFrame());
    }

    public void prepareDialog(JDialog jDialog, boolean bl) {
        if (jDialog == null) {
            throw new IllegalArgumentException("null JDialog");
        }
        if (!this.hadBeenPrepared(jDialog)) {
            this.prepareWindow(jDialog);
        }
        if (bl) {
            jDialog.setVisible(true);
        }
    }

    private boolean hadBeenPrepared(RootPaneContainer rootPaneContainer) {
        String string;
        JRootPane jRootPane = rootPaneContainer.getRootPane();
        boolean bl = Boolean.TRUE.equals(jRootPane.getClientProperty(string = "SingleFrameApplication.initRootPaneContainer"));
        if (!bl) {
            jRootPane.putClientProperty(string, Boolean.TRUE);
        }
        return bl;
    }

    protected void startup() {
        this.started = true;
    }

    protected void prepareWindow(Window window) {
        boolean bl;
        Dimension dimension;
        Object object;
        this.configureWindow(window);
        if (window.getWidth() < 150 || window.getHeight() < 20) {
            window.pack();
            if (!window.isLocationByPlatform()) {
                object = window != this.getMainFrame() ? this.getMainFrame() : null;
                window.setLocationRelativeTo((Component)object);
            }
        }
        if ((object = this.sessionFilename(window)) != null) {
            try {
                dimension = this.getContext();
                dimension.getSessionStorage().restore((Component)window, (String)object);
            }
            catch (Exception exception) {
                logger.log(Level.WARNING, "couldn't restore sesssion", exception);
            }
        }
        dimension = window.getPreferredSize();
        boolean bl2 = window.getWidth() < dimension.width;
        boolean bl3 = bl = window.getHeight() < dimension.height;
        if (bl2 || bl) {
            if (bl2 && bl) {
                window.pack();
            } else {
                window.setSize(bl2 ? dimension.width : window.getWidth(), bl ? dimension.height : window.getHeight());
            }
            if (!window.isLocationByPlatform()) {
                JFrame jFrame = window != this.getMainFrame() ? this.getMainFrame() : null;
                window.setLocationRelativeTo(jFrame);
            }
        }
        window.addWindowListener(this.getDialogListener());
    }

    private WindowListener getDialogListener() {
        return new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                SingleXFrameApplication.this.saveSession(windowEvent.getWindow());
            }

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                SingleXFrameApplication.this.saveSession(windowEvent.getWindow());
            }
        };
    }

    protected void shutdown() {
        if (!this.started) {
            return;
        }
        ArrayList<Window> arrayList = new ArrayList<Window>();
        JFrame jFrame = this.getMainFrame();
        if (jFrame instanceof JXFrame) {
            arrayList.add(jFrame);
            for (int i = 0; i < this.getMainFrame().getOwnedWindows().length; ++i) {
                arrayList.add(this.getMainFrame().getOwnedWindows()[i]);
            }
        }
        for (Window window : arrayList) {
            JFrame jFrame2;
            Object object;
            if (window.isShowing() || window.isValid()) {
                this.saveSession(window);
                continue;
            }
            if (!(window instanceof JFrame) || !Boolean.TRUE.equals(object = (jFrame2 = (JFrame)window).getRootPane().getClientProperty("initialized"))) continue;
            this.saveSession(window);
        }
    }

    private String sessionFilename(Window window) {
        if (window == null) {
            return null;
        }
        String string = window.getName();
        return string == null ? null : string + ".session.xml";
    }

    private void saveSession(Window window) {
        String string = this.sessionFilename(window);
        if (string != null) {
            ApplicationContext applicationContext = this.getContext();
            try {
                applicationContext.getSessionStorage().save((Component)window, string);
            }
            catch (IOException iOException) {
                logger.log(Level.WARNING, "couldn't save session", iOException);
            }
            catch (SecurityException securityException) {
                logger.log(Level.WARNING, "couldn't save session", securityException);
            }
        }
    }

    public void show(JFrame jFrame) {
        super.show(jFrame);
        Point point = jFrame.getLocationOnScreen();
        int n = Math.max(0, point.x);
        int n2 = Math.max(0, point.y);
        if (jFrame.getWidth() < 150 || jFrame.getHeight() < 20) {
            jFrame.pack();
        }
        if (!(point.x == n && point.y == n2 || jFrame.isLocationByPlatform())) {
            JFrame jFrame2 = jFrame != this.getMainFrame() ? this.getMainFrame() : null;
            jFrame.setLocationRelativeTo(jFrame2);
        }
        jFrame.getRootPane().putClientProperty("initialized", Boolean.TRUE);
    }

    protected void deleteSessionState() {
        ApplicationContext applicationContext = this.getContext();
        try {
            applicationContext.getLocalStorage().deleteFile("mainFrame.session.xml");
        }
        catch (IOException iOException) {
            logger.log(Level.WARNING, "couldn't delete sesssion", iOException);
        }
        catch (SecurityException securityException) {
            logger.log(Level.WARNING, "couldn't delete sesssion", securityException);
        }
    }

    protected JXFrame createXMainFrame() {
        JXFrame jXFrame = new JXFrame();
        ApplicationContext applicationContext = this.getContext();
        String string = applicationContext.getResourceMap().getString("Application.title", new Object[0]);
        jXFrame.setStartPosition(JXFrame.StartPosition.Manual);
        jXFrame.setTitle(string);
        jXFrame.setName("mainFrame");
        return jXFrame;
    }

    protected void injectSessionProperties() {
        SessionStorage sessionStorage = this.getContext().getSessionStorage();
        sessionStorage.registerPropertySupport(JXTable.class, (PropertySupport)new XProperties.XTableProperty());
        new XProperties().registerPersistenceDelegates();
    }
}

