/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.swing;

import com.jgoodies.forms.layout.ColumnSpec;
import cz.vity.freerapid.swing.components.EditorPaneLinkDetector;
import cz.vity.freerapid.swing.components.PopdownButton;
import cz.vity.freerapid.swing.models.NaiiveComboModel;
import cz.vity.freerapid.swing.renderers.ComboBoxRenderer;
import java.awt.Dimension;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.DateFormat;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPasswordField;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SpinnerDateModel;
import javax.swing.text.DateFormatter;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.JTextComponent;

public class ComponentFactory {
    private FocusListener focusListener = new SelectAllOnFocusListener();
    private static ComponentFactory instance;
    public static final ColumnSpec DATEPICKER_COLUMN_SPEC;
    public static final ColumnSpec BUTTON_COLSPEC;

    private static synchronized ComponentFactory getInstance() {
        if (instance == null) {
            instance = new ComponentFactory();
        }
        return instance;
    }

    private ComponentFactory() {
    }

    private FocusListener getFocusListener() {
        return this.focusListener;
    }

    public static JSpinner getTimeSpinner() {
        JSpinner jSpinner = new JSpinner(new SpinnerDateModel());
        ((JSpinner.DateEditor)jSpinner.getEditor()).getTextField().setFormatterFactory(new DefaultFormatterFactory(new DateFormatter(DateFormat.getTimeInstance(3))));
        return jSpinner;
    }

    public static JComboBox getComboBox() {
        JComboBox jComboBox = new JComboBox(new NaiiveComboModel());
        jComboBox.setRenderer(new ComboBoxRenderer());
        return jComboBox;
    }

    public static JTextArea getTextArea() {
        JTextArea jTextArea = new JTextArea();
        jTextArea.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        return jTextArea;
    }

    public static JTextField getTextField() {
        JTextField jTextField = new JTextField();
        jTextField.addFocusListener(ComponentFactory.getInstance().getFocusListener());
        return jTextField;
    }

    public static JButton getToolbarButton() {
        JButton jButton = new JButton();
        jButton.setFocusable(false);
        jButton.setPreferredSize(new Dimension(26, 23));
        jButton.setMinimumSize(jButton.getPreferredSize());
        return jButton;
    }

    public static JToggleButton getToolbarToggleButton() {
        JToggleButton jToggleButton = new JToggleButton();
        jToggleButton.setFocusable(false);
        jToggleButton.setPreferredSize(new Dimension(26, 23));
        jToggleButton.setMinimumSize(jToggleButton.getPreferredSize());
        return jToggleButton;
    }

    public static JPasswordField getPasswordField() {
        JPasswordField jPasswordField = new JPasswordField();
        jPasswordField.addFocusListener(ComponentFactory.getInstance().getFocusListener());
        return jPasswordField;
    }

    public static EditorPaneLinkDetector getURLsEditorPane() {
        return new EditorPaneLinkDetector();
    }

    public static PopdownButton getPopdownButton() {
        return new PopdownButton();
    }

    static {
        DATEPICKER_COLUMN_SPEC = new ColumnSpec("max(pref;65dlu)");
        BUTTON_COLSPEC = new ColumnSpec("max(pref;42dlu)");
    }

    public static final class SelectAllOnFocusListener
    implements FocusListener {
        @Override
        public final void focusGained(FocusEvent focusEvent) {
            if (!focusEvent.isTemporary()) {
                ((JTextComponent)focusEvent.getComponent()).selectAll();
            }
        }

        @Override
        public final void focusLost(FocusEvent focusEvent) {
        }
    }
}

