/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.managers;

import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.gui.dialogs.WrappedPluginData;
import cz.vity.freerapid.gui.managers.ManagerDirector;
import cz.vity.freerapid.gui.managers.PluginMetaDataManager;
import cz.vity.freerapid.gui.managers.exceptions.NotSupportedDownloadServiceException;
import cz.vity.freerapid.gui.managers.exceptions.PluginIsNotEnabledException;
import cz.vity.freerapid.model.DownloadFile;
import cz.vity.freerapid.model.PluginMetaData;
import cz.vity.freerapid.plugimpl.StandardDialogSupportImpl;
import cz.vity.freerapid.plugimpl.StandardPluginContextImpl;
import cz.vity.freerapid.plugimpl.StandardStorageSupportImpl;
import cz.vity.freerapid.plugins.webclient.DownloadState;
import cz.vity.freerapid.plugins.webclient.interfaces.PluginContext;
import cz.vity.freerapid.plugins.webclient.interfaces.ShareDownloadService;
import cz.vity.freerapid.swing.Swinger;
import cz.vity.freerapid.utilities.LogUtils;
import cz.vity.freerapid.utilities.Utils;
import java.io.File;
import java.io.FilenameFilter;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.java.plugin.JpfException;
import org.java.plugin.ObjectFactory;
import org.java.plugin.PathResolver;
import org.java.plugin.Plugin;
import org.java.plugin.PluginManager;
import org.java.plugin.registry.PluginDescriptor;
import org.java.plugin.registry.PluginRegistry;
import org.java.plugin.standard.ShadingPathResolver;
import org.java.plugin.standard.StandardPluginLocation;
import org.java.plugin.util.ExtendedProperties;
import org.java.plugin.util.IoUtil;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationContext;

public class PluginsManager {
    private static final Logger logger = Logger.getLogger(PluginsManager.class.getName());
    private static final String ID_DIRECT = "direct";
    private final Map<String, PluginMetaData> supportedPlugins = new HashMap<String, PluginMetaData>();
    private final Object lock = new Object();
    private final ApplicationContext context;
    private final ManagerDirector director;
    private PluginManager pluginManager;
    private PluginMetaDataManager pluginMetaDataManager;
    private static final int MAX_ENTRIES = 10;
    private final Map<String, PluginMetaData> pluginsCache = Collections.synchronizedMap(new LinkedHashMap<String, PluginMetaData>(10, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry entry) {
            return this.size() > 10;
        }
    });

    public PluginsManager(ApplicationContext applicationContext, ManagerDirector managerDirector) {
        this.context = applicationContext;
        this.director = managerDirector;
        this.pluginMetaDataManager = new PluginMetaDataManager(applicationContext);
        this.context.getApplication().addExitListener(new Application.ExitListener(){

            public boolean canExit(EventObject eventObject) {
                return true;
            }

            public void willExit(EventObject eventObject) {
                if (PluginsManager.this.pluginManager != null) {
                    try {
                        PluginsManager.this.pluginManager.shutdown();
                        File file = new File(System.getProperty("java.io.tmpdir"), ".jpf-shadow");
                        IoUtil.emptyFolder((File)file);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        this.findAndInitNewPlugins();
    }

    private void findAndInitNewPlugins() {
        logger.info("Init Plugins Manager");
        ObjectFactory objectFactory = ObjectFactory.newInstance();
        ShadingPathResolver shadingPathResolver = new ShadingPathResolver();
        try {
            shadingPathResolver.configure(new ExtendedProperties());
        }
        catch (Exception exception) {
            LogUtils.processException(logger, exception);
        }
        this.pluginManager = objectFactory.createManager(objectFactory.createRegistry(), (PathResolver)shadingPathResolver);
        this.initNewPlugins(this.searchExistingPlugins());
    }

    public boolean isPluginInUseForUpdates(String string) {
        PluginRegistry pluginRegistry;
        if (this.hasPlugin(string) && (pluginRegistry = this.pluginManager.getRegistry()).isPluginDescriptorAvailable(string)) {
            PluginDescriptor pluginDescriptor = pluginRegistry.getPluginDescriptor(string);
            return this.pluginManager.isBadPlugin(pluginDescriptor) || !this.pluginManager.isPluginEnabled(pluginDescriptor);
        }
        return false;
    }

    public boolean isPluginDisabled(String string) {
        PluginRegistry pluginRegistry;
        if (this.hasPlugin(string) && (pluginRegistry = this.pluginManager.getRegistry()).isPluginDescriptorAvailable(string)) {
            PluginDescriptor pluginDescriptor = pluginRegistry.getPluginDescriptor(string);
            return this.pluginManager.isBadPlugin(pluginDescriptor) || !this.pluginManager.isPluginEnabled(pluginDescriptor);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateNewPlugins(Collection<WrappedPluginData> collection) throws JpfException {
        if (collection.isEmpty()) {
            return;
        }
        PluginRegistry pluginRegistry = this.pluginManager.getRegistry();
        HashSet<String> hashSet = new HashSet<String>();
        ArrayList<Object> arrayList = new ArrayList<Object>(collection.size());
        Object object = this.lock;
        synchronized (object) {
            Object object2;
            Object malformedURLException;
            String string;
            for (WrappedPluginData object4 : collection) {
                string = object4.getID();
                if (pluginRegistry.isPluginDescriptorAvailable(string)) {
                    malformedURLException = pluginRegistry.getPluginDescriptor(string);
                    if (object4.isToBeDeleted()) {
                        try {
                            object2 = PluginsManager.urlToFile(malformedURLException.getLocation());
                            if (!((File)object2).delete()) {
                                logger.severe("Failed to delete plugin file " + ((File)object2).getAbsolutePath());
                            }
                            logger.info(string + " " + object4.getVersion() + " should be deleted");
                            hashSet.add(string);
                            this.supportedPlugins.remove(string);
                        }
                        catch (Exception exception) {
                            LogUtils.processException(logger, exception);
                            object4.getHttpFile().setState(DownloadState.ERROR);
                        }
                        continue;
                    }
                    hashSet.add(string);
                    object2 = pluginRegistry.getDependingPlugins((PluginDescriptor)malformedURLException);
                    Iterator iterator = object2.iterator();
                    while (iterator.hasNext()) {
                        PluginDescriptor pluginDescriptor = (PluginDescriptor)iterator.next();
                        logger.info("Found dependency update for plugin " + string + " - dependency plugin " + pluginDescriptor.getId());
                        hashSet.add(pluginDescriptor.getId());
                    }
                    continue;
                }
                arrayList.add(object4.getHttpFile().getOutputFile());
            }
            for (String string2 : hashSet) {
                if (!pluginRegistry.isPluginDescriptorAvailable(string2)) continue;
                string = pluginRegistry.getPluginDescriptor(string2);
                try {
                    malformedURLException = string.getLocation();
                    logger.info("Location " + ((URL)malformedURLException).toExternalForm());
                    object2 = PluginsManager.urlToFile((URL)malformedURLException);
                    if (!((File)object2).exists()) continue;
                    arrayList.add(object2);
                }
                catch (URISyntaxException uRISyntaxException) {
                    logger.severe("Descriptor location " + string.getLocation() + " cannot be converted to URI!");
                    LogUtils.processException(logger, uRISyntaxException);
                }
                catch (MalformedURLException malformedURLException2) {
                    LogUtils.processException(logger, malformedURLException2);
                }
            }
            Iterator<WrappedPluginData> iterator = hashSet.toArray(new String[hashSet.size()]);
            logger.info("Unregistering plugins " + Arrays.toString(iterator));
            pluginRegistry.unregister(iterator);
            logger.info("Clearing plugin cache");
            this.pluginsCache.clear();
            this.initNewPlugins(arrayList.toArray(new File[arrayList.size()]));
        }
    }

    private void initNewPlugins(File[] fileArray) {
        block6: {
            if (fileArray.length == 0) {
                return;
            }
            try {
                this.pluginManager.publishPlugins(this.getPluginLocations(fileArray));
                Set<PluginMetaData> set = this.pluginMetaDataManager.getItems();
                HashMap<String, PluginMetaData> hashMap = new HashMap<String, PluginMetaData>(set.size());
                for (PluginMetaData object2 : set) {
                    hashMap.put(object2.getId(), object2);
                }
                Collection collection = this.pluginManager.getRegistry().getPluginDescriptors();
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    PluginDescriptor pluginDescriptor = (PluginDescriptor)iterator.next();
                    String string = pluginDescriptor.getId();
                    if (hashMap.containsKey(string)) {
                        PluginMetaData pluginMetaData = (PluginMetaData)hashMap.get(string);
                        pluginMetaData.setPluginDescriptor(pluginDescriptor);
                        this.supportedPlugins.put(string, pluginMetaData);
                        continue;
                    }
                    this.supportedPlugins.put(string, new PluginMetaData(pluginDescriptor));
                }
                this.disablePluginsInConflict();
            }
            catch (Exception exception) {
                LogUtils.processException(logger, exception);
                if (this.supportedPlugins != null && !this.supportedPlugins.isEmpty()) break block6;
                this.context.getApplication().exit();
            }
        }
    }

    private PluginManager.PluginLocation[] getPluginLocations(File[] fileArray) {
        if (fileArray == null) {
            throw new IllegalStateException("Plugin directory does not exist");
        }
        int n = fileArray.length;
        PluginManager.PluginLocation[] pluginLocationArray = new PluginManager.PluginLocation[n];
        for (int i = 0; i < n; ++i) {
            try {
                String string = PluginsManager.fileToUrl(fileArray[i]).toExternalForm();
                logger.info("Plugins path:" + string);
                URL uRL = new URL("jar:" + string + "!/");
                URL uRL2 = new URL("jar:" + string + "!/plugin.xml");
                pluginLocationArray[i] = new StandardPluginLocation(uRL, uRL2);
                continue;
            }
            catch (MalformedURLException malformedURLException) {
                LogUtils.processException(logger, malformedURLException);
            }
        }
        return pluginLocationArray;
    }

    private File[] searchExistingPlugins() {
        File file = this.getPluginsDir();
        logger.info("Plugins dir: " + file.getAbsolutePath());
        return file.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return string.toLowerCase(Locale.ENGLISH).endsWith(".frp");
            }
        });
    }

    public File getPluginsDir() {
        File file = new File(Utils.getAppPath(), "plugins");
        String string = System.getProperty("plug-dir", file.getAbsolutePath());
        File file2 = new File(string);
        if (!file2.exists() && !file2.mkdirs()) {
            logger.warning("Failed to create plugin directory");
        }
        return file2;
    }

    private void disablePluginsInConflict() {
        HashMap hashMap = new HashMap();
        for (PluginMetaData object3 : this.supportedPlugins.values()) {
            Object object;
            if (!object3.isEnabled()) continue;
            String string = object3.getServices();
            if (hashMap.containsKey(string)) {
                object = (List)hashMap.get(string);
                object.add(object3);
                continue;
            }
            object = new LinkedList();
            object.add(object3);
            hashMap.put(string, object);
        }
        for (List list : hashMap.values()) {
            if (list.size() <= 1) continue;
            for (Object object : list) {
                if (!((PluginMetaData)object).isPremium()) continue;
                ((PluginMetaData)object).setEnabled(false);
            }
        }
    }

    public boolean isSupported(URL uRL) {
        return this.isSupported(uRL, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSupported(URL uRL, boolean bl) {
        String string = uRL.toExternalForm();
        Object object = this.lock;
        synchronized (object) {
            PluginMetaData[] pluginMetaDataArray = this.getCachedPlugins();
            for (int i = pluginMetaDataArray.length - 1; i >= 0; --i) {
                PluginMetaData pluginMetaData = pluginMetaDataArray[i];
                if (!pluginMetaData.isSupported(string)) continue;
                this.addToCache(pluginMetaData);
                logger.info("Cache hit");
                if (!pluginMetaData.isEnabled()) continue;
                return !bl || pluginMetaData.isClipboardMonitored();
            }
            for (PluginMetaData pluginMetaData : this.supportedPlugins.values()) {
                if (!pluginMetaData.isSupported(string)) continue;
                this.addToCache(pluginMetaData);
                if (!pluginMetaData.isEnabled()) continue;
                return !bl || pluginMetaData.isClipboardMonitored();
            }
            return (!bl || AppPrefs.getProperty("enableClipboardMonitoringForDirectDownloads", false)) && this.isDirectDownloadEnabled();
        }
    }

    private void addToCache(PluginMetaData pluginMetaData) {
        this.pluginsCache.put(pluginMetaData.getId(), pluginMetaData);
    }

    private PluginMetaData[] getCachedPlugins() {
        Collection<PluginMetaData> collection = this.pluginsCache.values();
        int n = collection.size();
        PluginMetaData[] pluginMetaDataArray = new PluginMetaData[n];
        collection.toArray(pluginMetaDataArray);
        return pluginMetaDataArray;
    }

    public String getServiceIDForURL(URL uRL) throws NotSupportedDownloadServiceException {
        String string = uRL.toExternalForm();
        PluginMetaData pluginMetaData = null;
        PluginMetaData[] pluginMetaDataArray = this.getCachedPlugins();
        for (int i = pluginMetaDataArray.length - 1; i >= 0; --i) {
            PluginMetaData pluginMetaData2 = pluginMetaDataArray[i];
            if (!pluginMetaData2.isSupported(string)) continue;
            this.addToCache(pluginMetaData2);
            logger.info("Cache hit");
            if (!pluginMetaData2.isEnabled()) continue;
            return pluginMetaData2.getId();
        }
        for (PluginMetaData pluginMetaData2 : this.supportedPlugins.values()) {
            if (!pluginMetaData2.isSupported(string)) continue;
            this.addToCache(pluginMetaData2);
            if (!pluginMetaData2.isEnabled()) {
                pluginMetaData = pluginMetaData2;
                continue;
            }
            return pluginMetaData2.getId();
        }
        if (pluginMetaData != null) {
            throw new PluginIsNotEnabledException(pluginMetaData);
        }
        if (this.isDirectDownloadEnabled()) {
            return ID_DIRECT;
        }
        throw new NotSupportedDownloadServiceException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShareDownloadService getPluginInstance(String string) throws NotSupportedDownloadServiceException {
        Object object = this.lock;
        synchronized (object) {
            Plugin plugin;
            if (!this.hasPlugin(string)) {
                throw new NotSupportedDownloadServiceException(string);
            }
            try {
                logger.info("Loading plugin with ID=" + string);
                plugin = this.pluginManager.getPlugin(string);
            }
            catch (Exception exception) {
                LogUtils.processException(logger, exception);
                throw new NotSupportedDownloadServiceException(string);
            }
            if (!(plugin instanceof ShareDownloadService)) {
                throw new NotSupportedDownloadServiceException(string);
            }
            ShareDownloadService shareDownloadService = (ShareDownloadService)plugin;
            if (shareDownloadService.getPluginContext() == null) {
                shareDownloadService.setPluginContext(this.createPluginContext());
            }
            logger.info("Plugin with ID=" + string + " was loaded");
            return shareDownloadService;
        }
    }

    public PluginManager getPluginManager() {
        return this.pluginManager;
    }

    private PluginContext createPluginContext() {
        return StandardPluginContextImpl.create(new StandardDialogSupportImpl(this.context), new StandardStorageSupportImpl(this.context), this.director.getDataManager());
    }

    public List<PluginMetaData> getSupportedPlugins() {
        Collection<PluginMetaData> collection = this.supportedPlugins.values();
        ArrayList<PluginMetaData> arrayList = new ArrayList<PluginMetaData>(collection.size());
        for (PluginMetaData pluginMetaData : collection) {
            if (pluginMetaData.isLibraryPlugin() || pluginMetaData.getMaxParallelDownloads() < 1) continue;
            arrayList.add(pluginMetaData);
        }
        return arrayList;
    }

    public void updatePluginSettings() {
        this.pluginMetaDataManager.saveToFile(new HashSet<PluginMetaData>(this.supportedPlugins.values()));
    }

    public PluginMetaData getPluginMetadata(String string) throws NotSupportedDownloadServiceException {
        if (!this.supportedPlugins.containsKey(string)) {
            throw new NotSupportedDownloadServiceException(string);
        }
        return this.supportedPlugins.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShareDownloadService getService(DownloadFile downloadFile) {
        Object object = this.lock;
        synchronized (object) {
            return this.getActiveService(downloadFile);
        }
    }

    private ShareDownloadService getActiveService(DownloadFile downloadFile) {
        String string = downloadFile.getPluginID();
        try {
            PluginMetaData pluginMetaData = this.getPluginMetadata(string);
            if (!pluginMetaData.isEnabled()) {
                try {
                    String string2 = this.getServiceIDForURL(downloadFile.getFileUrl());
                    downloadFile.setPluginID(string2);
                    return this.getPluginInstance(string2);
                }
                catch (NotSupportedDownloadServiceException notSupportedDownloadServiceException) {
                    downloadFile.setPluginID(string);
                    downloadFile.setState(DownloadState.DISABLED);
                    downloadFile.setErrorMessage(Swinger.getMessageFromException(Swinger.getResourceMap(), notSupportedDownloadServiceException));
                    return null;
                }
            }
            return this.getPluginInstance(string);
        }
        catch (NotSupportedDownloadServiceException notSupportedDownloadServiceException) {
            try {
                String string3 = this.getServiceIDForURL(downloadFile.getFileUrl());
                downloadFile.setPluginID(string3);
                return this.getPluginInstance(string3);
            }
            catch (PluginIsNotEnabledException pluginIsNotEnabledException) {
                downloadFile.setState(DownloadState.DISABLED);
                downloadFile.setErrorMessage(Swinger.getResourceMap().getString("PluginIsNotEnabled", new Object[]{downloadFile.getPluginID()}));
            }
            catch (NotSupportedDownloadServiceException notSupportedDownloadServiceException2) {
                downloadFile.setState(DownloadState.ERROR);
                downloadFile.setErrorMessage(Swinger.getMessageFromException(Swinger.getResourceMap(), notSupportedDownloadServiceException));
            }
            return null;
        }
    }

    public boolean hasPlugin(String string) {
        return this.supportedPlugins.containsKey(string);
    }

    private static URL fileToUrl(File file) throws MalformedURLException {
        return file.toURI().toURL();
    }

    private static File urlToFile(URL uRL) throws MalformedURLException, URISyntaxException {
        String string = uRL.getFile();
        int n = string.lastIndexOf("!/");
        if (n != -1) {
            return new File(new URL(string.substring(0, n)).toURI());
        }
        return new File(uRL.toURI());
    }

    private boolean isDirectDownloadEnabled() {
        return AppPrefs.getProperty("enableDirectDownloads", false) && !this.isPluginDisabled(ID_DIRECT);
    }
}

