/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.dialogs;

import com.jgoodies.binding.adapter.Bindings;
import com.jgoodies.binding.value.Trigger;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.layout.Sizes;
import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.gui.dialogs.AppDialog;
import cz.vity.freerapid.swing.ComponentFactory;
import cz.vity.freerapid.swing.LimitedPlainDocument;
import cz.vity.freerapid.swing.Swinger;
import cz.vity.freerapid.swing.binding.MyPresentationModel;
import cz.vity.freerapid.swing.components.CompTitledPane;
import cz.vity.freerapid.utilities.LogUtils;
import cz.vity.freerapid.utilities.Utils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.jdesktop.application.Action;
import org.jdesktop.swinghelper.buttonpanel.JXButtonPanel;

public class ConnectDialog
extends AppDialog {
    private static final Logger logger = Logger.getLogger(ConnectDialog.class.getName());
    private MyPresentationModel model = null;
    private JTextField fieldHostName;
    private JTextField fieldPort;
    private JCheckBox checkAuthentification;
    private JTextField fieldUserName;
    private JPasswordField fieldPassword;
    private JCheckBox checkStorePassword;
    private JButton btnOk;
    private JButton btnCancel;
    private JPanel contentPanel;
    private JLabel labelLoginName;
    private JLabel labelPassword;
    private JLabel labelWarning;
    private JCheckBox checkUseProxy;
    private JCheckBox checkSocksProxy;

    public ConnectDialog(JDialog jDialog) {
        super((Dialog)jDialog, true);
        this.setName("ConnectDialog");
        try {
            this.initComponents();
            this.build();
        }
        catch (Exception exception) {
            LogUtils.processException(logger, exception);
            this.doClose();
        }
    }

    @Action
    public void cancelBtnAction() {
        this.model.triggerFlush();
        this.doClose();
    }

    @Action
    public void okBtnAction() {
        this.setResult(0);
        this.model.triggerCommit();
        AppPrefs.storeProperty("proxy.password", Utils.generateXorString(String.valueOf(this.fieldPassword.getPassword())));
        this.doClose();
    }

    @Override
    public void doClose() {
        if (this.model != null) {
            this.model.release();
        }
        super.doClose();
    }

    private void build() {
        this.inject();
        this.buildGUI();
        this.buildModels();
        this.setAction(this.btnOk, "okBtnAction");
        this.setAction(this.btnCancel, "cancelBtnAction");
        this.pack();
        this.setResizable(true);
        ConnectDialog.locateOnOpticalScreenCenter(this);
    }

    @Override
    protected AbstractButton getBtnCancel() {
        return this.btnCancel;
    }

    @Override
    protected AbstractButton getBtnOK() {
        return this.btnOk;
    }

    private void buildModels() {
        this.model = new MyPresentationModel(null, (ValueModel)new Trigger());
        this.bind(this.fieldHostName, "proxy.url", (Object)"");
        this.bind(this.fieldUserName, "proxy.username", (Object)"");
        this.bind(this.fieldPort, "proxy.port", (Object)"");
        this.bind(this.checkStorePassword, "proxy.savepassword", (Object)false);
        this.bind(this.checkAuthentification, "proxy.login", (Object)false);
        this.bind(this.checkUseProxy, "proxy", (Object)false);
        this.bind(this.checkSocksProxy, "defaultConnectionSocks", (Object)false);
        this.fieldPassword.setText(Utils.generateXorString(AppPrefs.getProperty("proxy.password", "")));
    }

    private void buildGUI() {
        this.checkAuthentification.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = ConnectDialog.this.checkAuthentification.isSelected();
                ConnectDialog.this.updateEnabledUseLogin(bl);
                if (bl) {
                    Swinger.inputFocus(ConnectDialog.this.fieldUserName);
                }
            }
        });
        this.checkUseProxy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConnectDialog.this.updateEnabledUseProxy(ConnectDialog.this.checkUseProxy.isSelected());
            }
        });
        boolean bl = AppPrefs.getProperty("proxy", false);
        this.updateEnabledUseProxy(bl);
        this.updateEnabledUseLogin(AppPrefs.getProperty("proxy.login", false) && bl);
    }

    private void updateEnabledUseProxy(boolean bl) {
        Component[] componentArray;
        for (Component component : componentArray = this.contentPanel.getComponents()) {
            if (component.equals(this.checkUseProxy)) continue;
            component.setEnabled(bl);
        }
        this.checkSocksProxy.setEnabled(bl);
        if (this.checkAuthentification.isSelected() && bl) {
            this.updateEnabledUseLogin(true);
        } else {
            this.updateEnabledUseLogin(false);
        }
        if (bl) {
            Swinger.inputFocus(this.fieldHostName);
        }
    }

    private void updateEnabledUseLogin(boolean bl) {
        this.fieldUserName.setEnabled(bl);
        this.fieldPassword.setEnabled(bl);
        this.checkStorePassword.setEnabled(bl);
        this.labelLoginName.setEnabled(bl);
        this.labelPassword.setEnabled(bl);
        this.labelWarning.setEnabled(bl);
    }

    private void bind(JCheckBox jCheckBox, String string, Object object) {
        Bindings.bind((JCheckBox)jCheckBox, (ValueModel)this.model.getBufferedPreferences(string, object));
    }

    private void bind(JTextField jTextField, String string, Object object) {
        Bindings.bind((JTextField)jTextField, (ValueModel)this.model.getBufferedPreferences(string, object), (boolean)false);
    }

    private void initComponents() {
        JPanel jPanel = new JPanel();
        this.checkUseProxy = new JCheckBox();
        this.checkSocksProxy = new JCheckBox();
        this.checkUseProxy.setName("checkUseHttpProxy");
        this.checkSocksProxy.setName("checkSocksProxy");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 2));
        jPanel2.add(this.checkUseProxy);
        jPanel2.add(Box.createHorizontalGlue());
        jPanel2.add(this.checkSocksProxy);
        CompTitledPane compTitledPane = new CompTitledPane(jPanel2);
        this.contentPanel = compTitledPane.getContentPane();
        this.contentPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        JLabel jLabel = new JLabel();
        this.fieldHostName = ComponentFactory.getTextField();
        JLabel jLabel2 = new JLabel();
        this.fieldPort = ComponentFactory.getTextField();
        this.checkAuthentification = new JCheckBox();
        this.labelLoginName = new JLabel();
        this.fieldUserName = ComponentFactory.getTextField();
        this.labelPassword = new JLabel();
        this.fieldPassword = new JPasswordField();
        this.checkStorePassword = new JCheckBox();
        this.labelWarning = new JLabel();
        JXButtonPanel jXButtonPanel = new JXButtonPanel();
        jXButtonPanel.setCyclic(true);
        this.btnOk = new JButton();
        this.btnCancel = new JButton();
        CellConstraints cellConstraints = new CellConstraints();
        this.fieldPort.setDocument(new LimitedPlainDocument("[0-9]{0,6}"));
        this.setName("ConnectDialog");
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        jPanel.setBorder(Borders.DIALOG_BORDER);
        jPanel.setName("dialogPane");
        jPanel.setLayout(new BorderLayout());
        this.contentPanel.setName("contentPanel");
        jLabel.setLabelFor(this.fieldHostName);
        jLabel.setName("labelHostName");
        this.fieldHostName.setColumns(10);
        this.fieldHostName.setName("fieldHostName");
        jLabel2.setLabelFor(this.fieldPort);
        jLabel2.setName("labelPortNumber");
        this.fieldPort.setColumns(5);
        this.fieldPort.setName("fieldPort");
        this.checkAuthentification.setName("checkUserProxy");
        this.labelLoginName.setLabelFor(this.fieldUserName);
        this.labelLoginName.setName("labelLoginName");
        this.fieldUserName.setName("fieldLogin");
        this.labelPassword.setLabelFor(this.fieldPassword);
        this.labelPassword.setName("labelPassword");
        this.fieldPassword.setName("fieldPassword");
        this.checkStorePassword.setName("checkStorePassword");
        this.labelWarning.setName("labelWarning");
        PanelBuilder panelBuilder = new PanelBuilder(new FormLayout(new ColumnSpec[]{FormFactory.PREF_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.PREFERRED, 1.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}), this.contentPanel);
        panelBuilder.add((Component)jLabel, cellConstraints.xy(1, 1));
        panelBuilder.add((Component)this.fieldHostName, cellConstraints.xy(3, 1));
        panelBuilder.add((Component)jLabel2, cellConstraints.xy(5, 1));
        panelBuilder.add((Component)this.fieldPort, cellConstraints.xy(7, 1));
        panelBuilder.add((Component)this.checkAuthentification, new CellConstraints(1, 3, 3, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 7, 0, 0)));
        panelBuilder.add((Component)this.labelLoginName, cellConstraints.xy(1, 5));
        panelBuilder.add((Component)this.fieldUserName, cellConstraints.xy(3, 5));
        panelBuilder.add((Component)this.labelPassword, cellConstraints.xy(1, 7));
        panelBuilder.add((Component)this.fieldPassword, cellConstraints.xy(3, 7));
        panelBuilder.add((Component)this.checkStorePassword, cellConstraints.xywh(5, 7, 3, 1));
        panelBuilder.add((Component)this.labelWarning, cellConstraints.xywh(1, 9, 7, 1));
        jPanel.add((Component)compTitledPane, "Center");
        jXButtonPanel.setBorder(Borders.BUTTON_BAR_GAP_BORDER);
        jXButtonPanel.setName("buttonBar");
        this.btnOk.setName("btnOk");
        this.btnCancel.setName("btnCancel");
        panelBuilder = new PanelBuilder(new FormLayout(new ColumnSpec[]{FormFactory.GLUE_COLSPEC, FormFactory.BUTTON_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ComponentFactory.BUTTON_COLSPEC}, RowSpec.decodeSpecs((String)"pref")), (JPanel)jXButtonPanel);
        ((FormLayout)jXButtonPanel.getLayout()).setColumnGroups((int[][])new int[][]{{2, 4}});
        panelBuilder.add((Component)this.btnOk, cellConstraints.xy(2, 1));
        panelBuilder.add((Component)this.btnCancel, cellConstraints.xy(4, 1));
        jPanel.add((Component)jXButtonPanel, "South");
        container.add((Component)jPanel, "Center");
    }
}

