/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.content;

import cz.vity.freerapid.model.DownloadFile;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.ResourceMap;

final class CheckedCellRenderer
extends DefaultTableCellRenderer {
    private final Icon notFound;
    private final Icon checked;
    private final Icon unknown;
    private final ApplicationContext context;

    CheckedCellRenderer(ApplicationContext applicationContext) {
        this.context = applicationContext;
        ResourceMap resourceMap = applicationContext.getResourceMap();
        this.notFound = resourceMap.getIcon("notFoundIcon");
        this.checked = resourceMap.getIcon("checkedIcon");
        this.unknown = resourceMap.getIcon("unknownIcon");
    }

    @Override
    public final Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        if (object == null) {
            object = jTable.getValueAt(n, n2);
        }
        DownloadFile downloadFile = (DownloadFile)object;
        assert (downloadFile != null);
        this.setIconTextGap(2);
        this.setHorizontalAlignment(0);
        Component component = super.getTableCellRendererComponent(jTable, null, bl, bl2, n, n2);
        switch (downloadFile.getFileState()) {
            case FILE_NOT_FOUND: {
                this.setIcon(this.notFound);
                this.setToolTipText(this.context.getResourceMap().getString("checked_fileNotFound", new Object[0]));
                break;
            }
            case CHECKED_AND_EXISTING: {
                this.setIcon(this.checked);
                this.setToolTipText(this.context.getResourceMap().getString("checked_success", new Object[0]));
                break;
            }
            default: {
                this.setToolTipText(this.context.getResourceMap().getString("checked_unknown", new Object[0]));
                this.setIcon(this.unknown);
            }
        }
        this.getAccessibleContext().setAccessibleName(jTable.getColumnName(n2) + "   " + this.getToolTipText());
        return component;
    }
}

