/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.core;

import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.core.LanguageBinding;
import cz.vity.freerapid.core.SupportedLanguage;
import cz.vity.freerapid.utilities.LogUtils;
import cz.vity.freerapid.utilities.Utils;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.logging.Logger;
import jlibs.xml.sax.binding.BindingHandler;
import org.xml.sax.InputSource;

public final class Lng {
    private static final Logger logger = Logger.getLogger(Lng.class.getName());
    private static List<SupportedLanguage> supportedLanguages = null;
    private static final String LANG_LIST_FILE = "languages.xml";
    public static final String localeLanguageCode = Locale.getDefault().getLanguage();
    private static String selLanguageCode;
    private static String selCountryCode;
    private static final String localeCountry;

    private Lng() {
    }

    public static synchronized List<SupportedLanguage> getSupportedLanguages() {
        if (supportedLanguages == null) {
            BindingHandler bindingHandler = new BindingHandler(LanguageBinding.class);
            try {
                supportedLanguages = (List)bindingHandler.parse(new InputSource(Utils.class.getClassLoader().getResourceAsStream(LANG_LIST_FILE)));
            }
            catch (Exception exception) {
                LogUtils.processException(logger, exception);
                supportedLanguages = Collections.emptyList();
            }
        }
        return supportedLanguages;
    }

    private static SupportedLanguage findSupportedLanguage(SupportedLanguage supportedLanguage) {
        if ("".equals(supportedLanguage.getCountry())) {
            for (SupportedLanguage supportedLanguage2 : Lng.getSupportedLanguages()) {
                if (!supportedLanguage2.getLanguageCode().equalsIgnoreCase(supportedLanguage.getLanguageCode())) continue;
                return supportedLanguage2;
            }
        } else {
            for (SupportedLanguage supportedLanguage3 : Lng.getSupportedLanguages()) {
                if (!supportedLanguage3.equals(supportedLanguage)) continue;
                return supportedLanguage3;
            }
        }
        return null;
    }

    public static void loadLangProperties() {
        SupportedLanguage supportedLanguage;
        selLanguageCode = AppPrefs.getProperty("selLanguage", null);
        if (selLanguageCode == null) {
            supportedLanguage = Lng.findSupportedLanguage(new SupportedLanguage(localeLanguageCode, localeCountry));
            if (supportedLanguage == null && (supportedLanguage = Lng.findSupportedLanguage(new SupportedLanguage(localeLanguageCode, ""))) == null) {
                supportedLanguage = new SupportedLanguage("EN", "");
            }
        } else {
            selCountryCode = AppPrefs.getProperty("country", "");
            supportedLanguage = Lng.findSupportedLanguage(new SupportedLanguage(selLanguageCode, selCountryCode));
            if (supportedLanguage == null && (supportedLanguage = Lng.findSupportedLanguage(new SupportedLanguage(selLanguageCode, ""))) == null) {
                supportedLanguage = new SupportedLanguage("EN", "");
            }
        }
        selLanguageCode = supportedLanguage.getLanguageCode();
        selCountryCode = supportedLanguage.getCountry();
        Locale locale = new Locale(selLanguageCode.toLowerCase(Locale.ENGLISH), ("".equals(selCountryCode) ? localeCountry : selCountryCode).toUpperCase(Locale.ENGLISH));
        logger.config("Setting locale " + locale);
        Locale.setDefault(locale);
    }

    public static SupportedLanguage getSelectedLanguage() {
        SupportedLanguage supportedLanguage = Lng.findSupportedLanguage(new SupportedLanguage(selLanguageCode, selCountryCode));
        if (supportedLanguage == null && (supportedLanguage = Lng.findSupportedLanguage(new SupportedLanguage(selLanguageCode, ""))) == null) {
            supportedLanguage = new SupportedLanguage("EN", "");
        }
        return supportedLanguage;
    }

    static {
        localeCountry = Locale.getDefault().getCountry();
    }
}

