/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.binding.util;

import com.jgoodies.binding.beans.BeanUtils;
import com.jgoodies.binding.beans.Model;
import com.jgoodies.binding.value.ValueModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public final class ChangeTracker
extends Model {
    public static final String PROPERTYNAME_CHANGED = "changed";
    private final PropertyChangeListener updateHandler = new UpdateHandler();
    private boolean changed = false;

    public boolean isChanged() {
        return this.changed;
    }

    public void reset() {
        this.setChanged(false);
    }

    private void setChanged(boolean newValue) {
        boolean oldValue = this.isChanged();
        this.changed = newValue;
        this.firePropertyChange(PROPERTYNAME_CHANGED, oldValue, newValue);
    }

    public void observe(Object bean, String propertyName) {
        if (bean == null) {
            throw new NullPointerException("The bean must not be null.");
        }
        if (propertyName == null) {
            throw new NullPointerException("The property name must not be null.");
        }
        BeanUtils.addPropertyChangeListener(bean, propertyName, this.updateHandler);
    }

    public void observe(ValueModel valueModel) {
        if (valueModel == null) {
            throw new NullPointerException("The ValueModel must not be null.");
        }
        valueModel.addValueChangeListener(this.updateHandler);
    }

    public void retractInterestFor(Object bean, String propertyName) {
        if (bean == null) {
            throw new NullPointerException("The bean must not be null.");
        }
        if (propertyName == null) {
            throw new NullPointerException("The property name must not be null.");
        }
        BeanUtils.removePropertyChangeListener(bean, propertyName, this.updateHandler);
    }

    public void retractInterestFor(ValueModel valueModel) {
        if (valueModel == null) {
            throw new NullPointerException("The ValueModel must not be null.");
        }
        valueModel.removeValueChangeListener(this.updateHandler);
    }

    private final class UpdateHandler
    implements PropertyChangeListener {
        private UpdateHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propertyName = evt.getPropertyName();
            if (!ChangeTracker.PROPERTYNAME_CHANGED.equals(propertyName) || ((Boolean)evt.getNewValue()).booleanValue()) {
                ChangeTracker.this.setChanged(true);
            }
        }
    }
}

