/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.codecimpl;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGQTable;
import com.sun.media.jai.codec.ImageEncodeParam;
import com.sun.media.jai.codec.ImageEncoderImpl;
import com.sun.media.jai.codec.JPEGEncodeParam;
import com.sun.media.jai.codecimpl.CodecUtils;
import com.sun.media.jai.codecimpl.ImagingListenerProxy;
import com.sun.media.jai.codecimpl.JaiI18N;
import com.sun.media.jai.codecimpl.util.ImagingException;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.PackedColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.OutputStream;

public class JPEGImageEncoder
extends ImageEncoderImpl {
    private JPEGEncodeParam jaiEP = null;

    public JPEGImageEncoder(OutputStream outputStream, ImageEncodeParam imageEncodeParam) {
        super(outputStream, imageEncodeParam);
        if (imageEncodeParam != null) {
            this.jaiEP = (JPEGEncodeParam)imageEncodeParam;
        }
    }

    static void modifyEncodeParam(JPEGEncodeParam jPEGEncodeParam, com.sun.image.codec.jpeg.JPEGEncodeParam jPEGEncodeParam2, int n) {
        int n2;
        for (int i = 0; i < n; ++i) {
            n2 = jPEGEncodeParam.getHorizontalSubsampling(i);
            jPEGEncodeParam2.setHorizontalSubsampling(i, n2);
            n2 = jPEGEncodeParam.getVerticalSubsampling(i);
            jPEGEncodeParam2.setVerticalSubsampling(i, n2);
            if (!jPEGEncodeParam.isQTableSet(i)) continue;
            int[] nArray = jPEGEncodeParam.getQTable(i);
            n2 = jPEGEncodeParam.getQTableSlot(i);
            jPEGEncodeParam2.setQTableComponentMapping(i, n2);
            jPEGEncodeParam2.setQTable(n2, new JPEGQTable(nArray));
        }
        if (jPEGEncodeParam.isQualitySet()) {
            float f = jPEGEncodeParam.getQuality();
            jPEGEncodeParam2.setQuality(f, true);
        }
        n2 = jPEGEncodeParam.getRestartInterval();
        jPEGEncodeParam2.setRestartInterval(n2);
        if (jPEGEncodeParam.getWriteTablesOnly()) {
            jPEGEncodeParam2.setImageInfoValid(false);
            jPEGEncodeParam2.setTableInfoValid(true);
        }
        if (jPEGEncodeParam.getWriteImageOnly()) {
            jPEGEncodeParam2.setTableInfoValid(false);
            jPEGEncodeParam2.setImageInfoValid(true);
        }
        if (!jPEGEncodeParam.getWriteJFIFHeader()) {
            jPEGEncodeParam2.setMarkerData(224, (byte[][])null);
        }
    }

    public void encode(RenderedImage renderedImage) throws IOException {
        Object object;
        Object object2;
        Object object3;
        BufferedImage bufferedImage;
        SampleModel sampleModel = renderedImage.getSampleModel();
        ColorModel colorModel = renderedImage.getColorModel();
        int n = colorModel.getNumColorComponents();
        int n2 = sampleModel.getTransferType();
        if (n2 != 0 && !CodecUtils.isPackedByteImage(renderedImage) || n != 1 && n != 3) {
            throw new RuntimeException(JaiI18N.getString("JPEGImageEncoder0"));
        }
        int n3 = colorModel.getColorSpace().getType();
        if (n3 != 6 && n3 != 5) {
            throw new RuntimeException(JaiI18N.getString("JPEGImageEncoder1"));
        }
        if (renderedImage instanceof BufferedImage) {
            bufferedImage = (BufferedImage)renderedImage;
        } else {
            if (renderedImage.getNumXTiles() == 1 && renderedImage.getNumYTiles() == 1) {
                object3 = renderedImage.getTile(renderedImage.getMinTileX(), renderedImage.getMinTileY());
            } else {
                object2 = sampleModel.getSampleSize(0) == 8 ? Raster.createInterleavedRaster(0, renderedImage.getWidth(), renderedImage.getHeight(), sampleModel.getNumBands(), new Point(renderedImage.getMinX(), renderedImage.getMinY())) : null;
                object3 = renderedImage.copyData((WritableRaster)object2);
            }
            object2 = object3 instanceof WritableRaster ? (WritableRaster)object3 : Raster.createWritableRaster(((Raster)object3).getSampleModel(), ((Raster)object3).getDataBuffer(), new Point(((Raster)object3).getSampleModelTranslateX(), ((Raster)object3).getSampleModelTranslateY()));
            if (((Raster)object2).getMinX() != 0 || ((Raster)object2).getMinY() != 0 || ((Raster)object2).getWidth() != renderedImage.getWidth() || ((Raster)object2).getHeight() != renderedImage.getHeight()) {
                object2 = ((WritableRaster)object2).createWritableChild(((Raster)object2).getMinX(), ((Raster)object2).getMinY(), renderedImage.getWidth(), renderedImage.getHeight(), 0, 0, null);
            }
            bufferedImage = new BufferedImage(colorModel, (WritableRaster)object2, false, null);
        }
        if (colorModel instanceof IndexColorModel && (bufferedImage = ((IndexColorModel)(object3 = (IndexColorModel)colorModel)).convertToIntDiscrete(bufferedImage.getRaster(), false)).getSampleModel().getNumBands() == 4) {
            object2 = bufferedImage.getRaster();
            WritableRaster writableRaster = ((WritableRaster)object2).createWritableChild(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), 0, 0, new int[]{0, 1, 2});
            object = (PackedColorModel)bufferedImage.getColorModel();
            int n4 = ((ColorModel)object).getComponentSize(0) + ((ColorModel)object).getComponentSize(1) + ((ColorModel)object).getComponentSize(2);
            DirectColorModel directColorModel = new DirectColorModel(n4, ((PackedColorModel)object).getMask(0), ((PackedColorModel)object).getMask(1), ((PackedColorModel)object).getMask(2));
            bufferedImage = new BufferedImage(directColorModel, writableRaster, false, null);
        }
        object3 = JPEGCodec.getDefaultJPEGEncodeParam((BufferedImage)bufferedImage);
        if (this.jaiEP != null) {
            JPEGImageEncoder.modifyEncodeParam(this.jaiEP, (com.sun.image.codec.jpeg.JPEGEncodeParam)object3, n);
        }
        object2 = JPEGCodec.createJPEGEncoder((OutputStream)this.output, (com.sun.image.codec.jpeg.JPEGEncodeParam)object3);
        try {
            object2.encode(bufferedImage);
        }
        catch (IOException iOException) {
            object = JaiI18N.getString("JPEGImageEncoder2");
            ImagingListenerProxy.errorOccurred((String)object, new ImagingException((String)object, iOException), this, false);
        }
    }
}

