/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.forms.builder;

import com.jgoodies.forms.builder.AbstractButtonPanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.ConstantSize;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.util.LayoutStyle;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class ButtonBarBuilder2
extends AbstractButtonPanelBuilder {
    private static final ColumnSpec[] COL_SPECS = new ColumnSpec[0];
    private static final RowSpec[] ROW_SPECS = new RowSpec[]{RowSpec.decode("center:pref")};
    private static final String NARROW_KEY = "jgoodies.isNarrow";
    private boolean leftToRight = LayoutStyle.getCurrent().isLeftToRightButtonOrder();

    public ButtonBarBuilder2() {
        this(new JPanel(null));
    }

    public ButtonBarBuilder2(JPanel jPanel) {
        super(new FormLayout(COL_SPECS, ROW_SPECS), jPanel);
        this.setOpaque(false);
    }

    public static ButtonBarBuilder2 createLeftToRightBuilder() {
        ButtonBarBuilder2 buttonBarBuilder2 = new ButtonBarBuilder2();
        buttonBarBuilder2.setLeftToRightButtonOrder(true);
        return buttonBarBuilder2;
    }

    public boolean isLeftToRightButtonOrder() {
        return this.leftToRight;
    }

    public void setLeftToRightButtonOrder(boolean bl) {
        this.leftToRight = bl;
    }

    public void setDefaultButtonBarGapBorder() {
        this.setBorder(Borders.BUTTON_BAR_GAP_BORDER);
    }

    public void addGlue() {
        this.appendGlueColumn();
        this.nextColumn();
    }

    public void addRelatedGap() {
        this.appendRelatedComponentsGapColumn();
        this.nextColumn();
    }

    public void addUnrelatedGap() {
        this.appendUnrelatedComponentsGapColumn();
        this.nextColumn();
    }

    public void addStrut(ConstantSize constantSize) {
        this.getLayout().appendColumn(ColumnSpec.createGap(constantSize));
        this.nextColumn();
    }

    public void addButton(JComponent jComponent) {
        jComponent.putClientProperty(NARROW_KEY, Boolean.TRUE);
        this.getLayout().appendColumn(FormFactory.BUTTON_COLSPEC);
        this.add(jComponent);
        this.nextColumn();
    }

    public void addButton(JComponent jComponent, JComponent jComponent2) {
        this.addButton(new JComponent[]{jComponent, jComponent2});
    }

    public void addButton(JComponent jComponent, JComponent jComponent2, JComponent jComponent3) {
        this.addButton(new JComponent[]{jComponent, jComponent2, jComponent3});
    }

    public void addButton(JComponent jComponent, JComponent jComponent2, JComponent jComponent3, JComponent jComponent4) {
        this.addButton(new JComponent[]{jComponent, jComponent2, jComponent3, jComponent4});
    }

    public void addButton(JComponent jComponent, JComponent jComponent2, JComponent jComponent3, JComponent jComponent4, JComponent jComponent5) {
        this.addButton(new JComponent[]{jComponent, jComponent2, jComponent3, jComponent4, jComponent5});
    }

    public void addButton(JComponent[] jComponentArray) {
        if (jComponentArray == null) {
            throw new NullPointerException("The button array must not be null.");
        }
        int n = jComponentArray.length;
        if (n == 0) {
            throw new IllegalArgumentException("The button array must not be empty.");
        }
        for (int i = 0; i < n; ++i) {
            int n2 = this.leftToRight ? i : n - 1 - i;
            this.addButton(jComponentArray[n2]);
            if (i >= jComponentArray.length - 1) continue;
            this.addRelatedGap();
        }
    }

    public void addButton(Action action) {
        if (action == null) {
            throw new NullPointerException("The button Action must not be null.");
        }
        this.addButton(new JButton(action));
    }

    public void addButton(Action action, Action action2) {
        this.addButton(new Action[]{action, action2});
    }

    public void addButton(Action action, Action action2, Action action3) {
        this.addButton(new Action[]{action, action2, action3});
    }

    public void addButton(Action action, Action action2, Action action3, Action action4) {
        this.addButton(new Action[]{action, action2, action3, action4});
    }

    public void addButton(Action action, Action action2, Action action3, Action action4, Action action5) {
        this.addButton(new Action[]{action, action2, action3, action4, action5});
    }

    public void addButton(Action[] actionArray) {
        if (actionArray == null) {
            throw new NullPointerException("The Action array must not be null.");
        }
        int n = actionArray.length;
        if (n == 0) {
            throw new IllegalArgumentException("The Action array must not be empty.");
        }
        JComponent[] jComponentArray = new JButton[n];
        for (int i = 0; i < n; ++i) {
            jComponentArray[i] = new JButton(actionArray[i]);
        }
        this.addButton(jComponentArray);
    }

    public void addGrowing(JComponent jComponent) {
        this.getLayout().appendColumn(FormFactory.GROWING_BUTTON_COLSPEC);
        jComponent.putClientProperty(NARROW_KEY, Boolean.TRUE);
        this.add(jComponent);
        this.nextColumn();
    }

    public void addGrowing(JComponent[] jComponentArray) {
        int n = jComponentArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = this.leftToRight ? i : n - 1 - i;
            this.addGrowing(jComponentArray[n2]);
            if (i >= jComponentArray.length - 1) continue;
            this.addRelatedGap();
        }
    }

    public void addFixed(JComponent jComponent) {
        jComponent.putClientProperty(NARROW_KEY, Boolean.TRUE);
        this.getLayout().appendColumn(FormFactory.PREF_COLSPEC);
        this.add(jComponent);
        this.nextColumn();
    }
}

