/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua;

import ch.randelshofer.quaqua.QuaquaUtilities;
import ch.randelshofer.quaqua.VisuallyLayoutable;
import ch.randelshofer.quaqua.border.BackgroundBorder;
import ch.randelshofer.quaqua.color.InactivatableColorUIResource;
import ch.randelshofer.quaqua.color.PaintableColor;
import ch.randelshofer.quaqua.util.Debug;
import ch.randelshofer.quaqua.util.Fonts;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicLabelUI;

public class QuaquaLabelUI
extends BasicLabelUI
implements VisuallyLayoutable {
    protected static QuaquaLabelUI labelUI = new QuaquaLabelUI();
    private static Rectangle iconR = new Rectangle();
    private static Rectangle textR = new Rectangle();
    private static Rectangle viewR = new Rectangle();
    private static Insets viewInsets = new Insets(0, 0, 0, 0);

    public static ComponentUI createUI(JComponent c) {
        return labelUI;
    }

    protected void installDefaults(JLabel b) {
        super.installDefaults(b);
        LookAndFeel.installBorder(b, "Label.border");
        if (b.getClass().getName().endsWith("LabelUIResource")) {
            b.setFont(UIManager.getFont("Slider.labelFont"));
        }
    }

    public void paint(Graphics gr, JComponent c) {
        Border b;
        Graphics2D g = (Graphics2D)gr;
        Object oldHints = QuaquaUtilities.beginGraphics(g);
        if (c.isOpaque()) {
            g.setPaint(PaintableColor.getPaint(c.getBackground(), c));
            g.fillRect(0, 0, c.getWidth(), c.getHeight());
        }
        if ((b = c.getBorder()) != null && b instanceof BackgroundBorder) {
            ((BackgroundBorder)b).getBackgroundBorder().paintBorder(c, g, 0, 0, c.getWidth(), c.getHeight());
        }
        super.paint(g, c);
        QuaquaUtilities.endGraphics(g, oldHints);
        Debug.paint(g, c, this);
    }

    protected void paintDisabledText(JLabel l, Graphics g, String s, int textX, int textY) {
        Font font = l.getFont();
        Color foreground = UIManager.getColor("Label.disabledForeground");
        int accChar = -1;
        String style = (String)l.getClientProperty("Quaqua.Label.style");
        if (style != null) {
            boolean selected = style.endsWith("Selected");
            if (style.startsWith("category")) {
                s = s.toUpperCase();
                font = UIManager.getFont("Tree.sideBarCategory.font");
                style = selected ? "shadow" : "emboss";
                foreground = UIManager.getColor(selected ? "Tree.sideBarCategory.selectionForeground" : "Tree.sideBarCategory.foreground");
            } else if (style.startsWith("row")) {
                font = selected ? UIManager.getFont("Tree.sideBar.selectionFont") : UIManager.getFont("Tree.sideBar.font");
                font = selected ? font.deriveFont(l.getFont().getStyle() | font.getStyle()) : font.deriveFont(l.getFont().getStyle());
                String string = style = selected ? "shadow" : null;
            }
            if (style != null && style.equals("emboss")) {
                g.setFont(font);
                g.setColor(UIManager.getColor("Label.embossForeground"));
                QuaquaUtilities.drawString(g, s, accChar, textX, textY + 1);
            } else if (style != null && style.equals("shadow")) {
                g.setFont(font);
                g.setColor(UIManager.getColor("Label.shadowForeground"));
                QuaquaUtilities.drawString(g, s, accChar, textX, textY + 1);
            }
        }
        g.setFont(font);
        g.setColor(foreground);
        QuaquaUtilities.drawString(g, s, accChar, textX, textY);
    }

    protected void paintEnabledText(JLabel l, Graphics g, String s, int textX, int textY) {
        int mnemIndex = l.getDisplayedMnemonicIndex();
        Font font = l.getFont();
        Color foreground = l.getForeground();
        String style = (String)l.getClientProperty("Quaqua.Label.style");
        if (style != null) {
            boolean active;
            boolean selected = style.endsWith("Selected");
            boolean bl = active = style.indexOf("Inactive") == -1;
            if (style.startsWith("category")) {
                s = s.toUpperCase();
                font = UIManager.getFont(selected ? "Tree.sideBarCategory.selectionFont" : "Tree.sideBarCategory.font");
                foreground = UIManager.getColor(selected ? "Tree.sideBarCategory.selectionForeground" : "Tree.sideBarCategory.foreground");
                if (foreground instanceof InactivatableColorUIResource) {
                    ((InactivatableColorUIResource)foreground).setActive(active);
                }
                style = selected ? "shadow" : "emboss";
            } else if (style.startsWith("row")) {
                Font font2 = font = selected ? UIManager.getFont("Tree.sideBar.selectionFont") : UIManager.getFont("Tree.sideBar.font");
                if (font == null) {
                    font = l.getFont();
                }
                font = selected ? font.deriveFont(l.getFont().getStyle() | font.getStyle()) : font.deriveFont(l.getFont().getStyle());
                foreground = UIManager.getColor(selected ? "Tree.sideBar.selectionForeground" : "Tree.sideBar.foreground");
                if (foreground instanceof InactivatableColorUIResource) {
                    ((InactivatableColorUIResource)foreground).setActive(active);
                }
                String string = style = selected ? "shadow" : null;
            }
            if (style != null && style.equals("emboss")) {
                g.setFont(font);
                g.setColor(UIManager.getColor("Label.embossForeground"));
                QuaquaUtilities.drawString(g, s, mnemIndex, textX, textY + 1);
            } else if (style != null && style.equals("shadow")) {
                g.setFont(font);
                g.setColor(UIManager.getColor("Label.shadowForeground"));
                QuaquaUtilities.drawString(g, s, mnemIndex, textX, textY + 1);
            }
        }
        g.setFont(font);
        g.setColor(foreground);
        QuaquaUtilities.drawString(g, s, mnemIndex, textX, textY);
    }

    protected String layoutCL(JLabel label, FontMetrics fontMetrics, String text, Icon icon, Rectangle viewR, Rectangle iconR, Rectangle textR) {
        return SwingUtilities.layoutCompoundLabel(label, fontMetrics, text, icon, label.getVerticalAlignment(), label.getHorizontalAlignment(), label.getVerticalTextPosition(), label.getHorizontalTextPosition(), viewR, iconR, textR, label.getIconTextGap());
    }

    public int getBaseline(JComponent c, int width, int height) {
        Rectangle vb = this.getVisualBounds(c, 2, width, height);
        return vb == null ? -1 : vb.y + vb.height;
    }

    public Rectangle getVisualBounds(JComponent c, int type, int width, int height) {
        boolean isEmpty;
        Rectangle rect = new Rectangle(0, 0, width, height);
        if (type == 0) {
            return rect;
        }
        JLabel b = (JLabel)c;
        String text = b.getText();
        boolean bl = isEmpty = text == null || text.length() == 0;
        if (isEmpty) {
            text = " ";
        }
        Icon icon = b.isEnabled() ? b.getIcon() : b.getDisabledIcon();
        Font f = c.getFont();
        FontMetrics fm = c.getFontMetrics(f);
        Insets insets = c.getInsets(viewInsets);
        QuaquaLabelUI.viewR.x = insets.left;
        QuaquaLabelUI.viewR.y = insets.top;
        QuaquaLabelUI.viewR.width = width - (insets.left + insets.right);
        QuaquaLabelUI.viewR.height = height - (insets.top + insets.bottom);
        QuaquaLabelUI.iconR.height = 0;
        QuaquaLabelUI.iconR.width = 0;
        QuaquaLabelUI.iconR.y = 0;
        QuaquaLabelUI.iconR.x = 0;
        QuaquaLabelUI.textR.height = 0;
        QuaquaLabelUI.textR.width = 0;
        QuaquaLabelUI.textR.y = 0;
        QuaquaLabelUI.textR.x = 0;
        String clippedText = this.layoutCL(b, fm, text, icon, viewR, iconR, textR);
        Rectangle textBounds = Fonts.getPerceivedBounds(text, f, c);
        if (isEmpty) {
            textBounds.width = 0;
        }
        int ascent = fm.getAscent();
        QuaquaLabelUI.textR.x += textBounds.x;
        QuaquaLabelUI.textR.width = textBounds.width;
        QuaquaLabelUI.textR.y += ascent + textBounds.y;
        QuaquaLabelUI.textR.height -= fm.getHeight() - textBounds.height;
        switch (type) {
            case 1: {
                if (icon != null) {
                    rect = textR.union(iconR);
                    break;
                }
                rect.setBounds(textR);
                break;
            }
            case 2: {
                if (text == null) {
                    return rect;
                }
                rect.setBounds(textR);
            }
        }
        return rect;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if (name.equals("JComponent.sizeVariant")) {
            QuaquaUtilities.applySizeVariant((JLabel)evt.getSource());
        } else {
            super.propertyChange(evt);
        }
    }
}

