/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.aero;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseInternalFrameTitlePane;
import com.jtattoo.plaf.BaseTitleButton;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import com.jtattoo.plaf.aero.AeroLookAndFeel;
import java.awt.Color;
import java.awt.Graphics;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JInternalFrame;
import javax.swing.plaf.ColorUIResource;

public class AeroInternalFrameTitlePane
extends BaseInternalFrameTitlePane {
    public AeroInternalFrameTitlePane(JInternalFrame jInternalFrame) {
        super(jInternalFrame);
    }

    protected int getHorSpacing() {
        return 0;
    }

    protected int getVerSpacing() {
        return 0;
    }

    protected void createButtons() {
        this.iconButton = new TitleButton(this.iconifyAction, "Iconify", this.iconIcon);
        this.maxButton = new TitleButton(this.maximizeAction, "Maximize", this.maxIcon);
        this.closeButton = new TitleButton(this.closeAction, "Close", this.closeIcon);
        this.setButtonIcons();
    }

    public void paintBorder(Graphics graphics) {
        if (this.isActive()) {
            graphics.setColor(ColorHelper.brighter(AeroLookAndFeel.getWindowTitleColorDark(), 50.0));
        } else {
            graphics.setColor(ColorHelper.darker(AeroLookAndFeel.getWindowInactiveTitleColorDark(), 10.0));
        }
        graphics.drawLine(0, this.getHeight() - 1, this.getWidth(), this.getHeight() - 1);
    }

    public void paintText(Graphics graphics, int n, int n2, String string) {
        if (this.isActive()) {
            ColorUIResource colorUIResource = AbstractLookAndFeel.getWindowTitleForegroundColor();
            if (ColorHelper.getGrayValue(colorUIResource) > 164) {
                graphics.setColor(Color.black);
            } else {
                graphics.setColor(Color.white);
            }
            JTattooUtilities.drawString(this.frame, graphics, string, n + 1, n2 + 1);
            graphics.setColor(AbstractLookAndFeel.getWindowTitleForegroundColor());
            JTattooUtilities.drawString(this.frame, graphics, string, n, n2);
        } else {
            graphics.setColor(AbstractLookAndFeel.getWindowInactiveTitleForegroundColor());
            JTattooUtilities.drawString(this.frame, graphics, string, n, n2);
        }
    }

    private class TitleButton
    extends BaseTitleButton {
        public TitleButton(Action action, String string, Icon icon) {
            super(action, string, icon, 1.0f);
        }

        public void paint(Graphics graphics) {
            boolean bl = this.getModel().isPressed();
            boolean bl2 = this.getModel().isArmed();
            boolean bl3 = this.getModel().isRollover();
            int n = this.getWidth();
            int n2 = this.getHeight();
            Color[] colorArray = AeroLookAndFeel.getTheme().getButtonColors();
            if (bl3) {
                colorArray = AeroLookAndFeel.getTheme().getRolloverColors();
            }
            if (bl && bl2) {
                colorArray = AeroLookAndFeel.getTheme().getPressedColors();
            }
            JTattooUtilities.fillHorGradient(graphics, colorArray, 0, 0, n, n2);
            graphics.setColor(Color.lightGray);
            graphics.drawLine(0, 0, 0, n2);
            graphics.drawLine(0, n2 - 1, n, n2 - 1);
            graphics.setColor(Color.white);
            graphics.drawLine(1, 0, 1, n2);
            this.getIcon().paintIcon(this, graphics, 1, 0);
        }
    }
}

