/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.acryl;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseTabbedPaneUI;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import com.jtattoo.plaf.acryl.AcrylLookAndFeel;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.text.View;

public class AcrylTabbedPaneUI
extends BaseTabbedPaneUI {
    public static ComponentUI createUI(JComponent jComponent) {
        return new AcrylTabbedPaneUI();
    }

    public void installDefaults() {
        super.installDefaults();
        this.tabAreaInsets.bottom = 5;
    }

    protected Color[] getTabColors(int n, boolean bl) {
        if (n >= 0 && n < this.tabPane.getTabCount()) {
            boolean bl2 = this.tabPane.isEnabledAt(n);
            Color color = this.tabPane.getBackgroundAt(n);
            Color[] colorArray = AbstractLookAndFeel.getTheme().getTabColors();
            colorArray = color instanceof UIResource ? (bl ? AbstractLookAndFeel.getTheme().getDefaultColors() : (n == this.rolloverIndex && bl2 ? AbstractLookAndFeel.getTheme().getRolloverColors() : AbstractLookAndFeel.getTheme().getTabColors())) : (bl ? AbstractLookAndFeel.getTheme().getDefaultColors() : (n == this.rolloverIndex && bl2 ? AbstractLookAndFeel.getTheme().getRolloverColors() : ColorHelper.createColorArr(ColorHelper.brighter(color, 40.0), ColorHelper.darker(color, 10.0), 20)));
            return colorArray;
        }
        return AbstractLookAndFeel.getTheme().getTabColors();
    }

    protected Color[] getContentBorderColors(int n) {
        Color[] colorArray = new Color[]{ColorHelper.brighter(AcrylLookAndFeel.getControlColorLight(), 20.0), AcrylLookAndFeel.getControlColorLight(), ColorHelper.brighter(AcrylLookAndFeel.getControlColorDark(), 20.0), AcrylLookAndFeel.getControlColorDark(), ColorHelper.darker(AcrylLookAndFeel.getControlColorDark(), 20.0)};
        return colorArray;
    }

    protected Color getContentBorderColor(int n) {
        return ColorHelper.brighter(AbstractLookAndFeel.getTheme().getFrameColor(), 50.0);
    }

    protected Color getSelectedBorderColor(int n) {
        return ColorHelper.darker(AbstractLookAndFeel.getControlDarkShadow(), 50.0);
    }

    protected Color getLoBorderColor(int n) {
        return ColorHelper.darker(AbstractLookAndFeel.getControlDarkShadow(), 20.0);
    }

    protected Color getHiBorderColor(int n) {
        if (n == this.tabPane.getSelectedIndex()) {
            return ColorHelper.darker(super.getHiBorderColor(n), 30.0);
        }
        return super.getHiBorderColor(n);
    }

    protected Color getGapColor(int n) {
        if (n == this.tabPane.getSelectedIndex()) {
            Color[] colorArray = AbstractLookAndFeel.getTheme().getDefaultColors();
            return colorArray[colorArray.length - 1];
        }
        return super.getGapColor(n);
    }

    protected Font getTabFont(boolean bl) {
        if (bl) {
            return super.getTabFont(bl).deriveFont(1);
        }
        return super.getTabFont(bl);
    }

    protected void paintContentBorder(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        graphics.setColor(AbstractLookAndFeel.getTabAreaBackgroundColor());
        int n7 = this.calculateTabAreaHeight(n, this.runCount, this.maxTabHeight);
        int n8 = this.calculateTabAreaWidth(n, this.runCount, this.maxTabWidth);
        if (n == 1 || n == 2) {
            graphics.fillRect(n3, n4, n8, n7);
        } else if (n == 3) {
            graphics.fillRect(n3, n6 - n7 + 1, n5, n7);
        } else {
            graphics.fillRect(n5 - n8 + 1, n4, n8, n6);
        }
        super.paintContentBorder(graphics, n, n2, n3, n4, n5, n6);
    }

    protected void paintText(Graphics graphics, int n, Font font, FontMetrics fontMetrics, int n2, String string, Rectangle rectangle, boolean bl) {
        graphics.setFont(font);
        View view = this.getTextViewForTab(n2);
        if (view != null) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Object object = null;
            if (AbstractLookAndFeel.getTheme().isTextAntiAliasingOn()) {
                object = graphics2D.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
                graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, AbstractLookAndFeel.getTheme().getTextAntiAliasingHint());
            }
            view.paint(graphics, rectangle);
            if (AbstractLookAndFeel.getTheme().isTextAntiAliasingOn()) {
                graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, object);
            }
        } else {
            int n3 = -1;
            if (JTattooUtilities.getJavaVersion() >= 1.4) {
                n3 = this.tabPane.getDisplayedMnemonicIndexAt(n2);
            }
            if (this.tabPane.isEnabled() && this.tabPane.isEnabledAt(n2)) {
                if (bl) {
                    Color color = ColorHelper.darker(AcrylLookAndFeel.getWindowTitleColorDark(), 30.0);
                    graphics.setColor(color);
                    JTattooUtilities.drawStringUnderlineCharAt(this.tabPane, graphics, string, n3, rectangle.x - 1, rectangle.y - 1 + fontMetrics.getAscent());
                    JTattooUtilities.drawStringUnderlineCharAt(this.tabPane, graphics, string, n3, rectangle.x - 1, rectangle.y + 1 + fontMetrics.getAscent());
                    JTattooUtilities.drawStringUnderlineCharAt(this.tabPane, graphics, string, n3, rectangle.x + 1, rectangle.y - 1 + fontMetrics.getAscent());
                    JTattooUtilities.drawStringUnderlineCharAt(this.tabPane, graphics, string, n3, rectangle.x + 1, rectangle.y + 1 + fontMetrics.getAscent());
                    graphics.setColor(AbstractLookAndFeel.getTheme().getWindowTitleForegroundColor());
                } else {
                    graphics.setColor(this.tabPane.getForegroundAt(n2));
                }
                JTattooUtilities.drawStringUnderlineCharAt(this.tabPane, graphics, string, n3, rectangle.x, rectangle.y + fontMetrics.getAscent());
            } else {
                graphics.setColor(this.tabPane.getBackgroundAt(n2).brighter());
                JTattooUtilities.drawStringUnderlineCharAt(this.tabPane, graphics, string, n3, rectangle.x, rectangle.y + fontMetrics.getAscent());
                graphics.setColor(this.tabPane.getBackgroundAt(n2).darker());
                JTattooUtilities.drawStringUnderlineCharAt(this.tabPane, graphics, string, n3, rectangle.x - 1, rectangle.y + fontMetrics.getAscent() - 1);
            }
        }
    }
}

