/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.core.filterchain;

import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.filterchain.IoFilterAdapter;
import org.apache.mina.core.filterchain.IoFilterChain;
import org.apache.mina.core.filterchain.IoFilterLifeCycleException;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.session.AbstractIoSession;
import org.apache.mina.core.session.AttributeKey;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.write.WriteRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultIoFilterChain
implements IoFilterChain {
    public static final AttributeKey SESSION_CREATED_FUTURE = new AttributeKey(DefaultIoFilterChain.class, "connectFuture");
    private final AbstractIoSession session;
    private final Map<String, IoFilterChain.Entry> name2entry = new ConcurrentHashMap<String, IoFilterChain.Entry>();
    private final EntryImpl head;
    private final EntryImpl tail;
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultIoFilterChain.class);

    public DefaultIoFilterChain(AbstractIoSession abstractIoSession) {
        if (abstractIoSession == null) {
            throw new IllegalArgumentException("session");
        }
        this.session = abstractIoSession;
        this.head = new EntryImpl(null, null, "head", new HeadFilter());
        this.tail = new EntryImpl(this.head, null, "tail", new TailFilter());
        this.head.nextEntry = this.tail;
    }

    @Override
    public IoSession getSession() {
        return this.session;
    }

    public IoFilterChain.Entry getEntry(IoFilter ioFilter) {
        EntryImpl entryImpl = this.head.nextEntry;
        while (entryImpl != this.tail) {
            if (entryImpl.getFilter() == ioFilter) {
                return entryImpl;
            }
            entryImpl = entryImpl.nextEntry;
        }
        return null;
    }

    public IoFilterChain.Entry getEntry(Class<? extends IoFilter> clazz) {
        EntryImpl entryImpl = this.head.nextEntry;
        while (entryImpl != this.tail) {
            if (clazz.isAssignableFrom(entryImpl.getFilter().getClass())) {
                return entryImpl;
            }
            entryImpl = entryImpl.nextEntry;
        }
        return null;
    }

    @Override
    public synchronized void addLast(String string, IoFilter ioFilter) {
        this.checkAddable(string);
        this.register(this.tail.prevEntry, string, ioFilter);
    }

    @Override
    public synchronized void clear() throws Exception {
        ArrayList<IoFilterChain.Entry> arrayList = new ArrayList<IoFilterChain.Entry>(this.name2entry.values());
        for (IoFilterChain.Entry entry : arrayList) {
            try {
                this.deregister((EntryImpl)entry);
            }
            catch (Exception exception) {
                throw new IoFilterLifeCycleException("clear(): " + entry.getName() + " in " + this.getSession(), exception);
            }
        }
    }

    private void register(EntryImpl entryImpl, String string, IoFilter ioFilter) {
        EntryImpl entryImpl2 = new EntryImpl(entryImpl, entryImpl.nextEntry, string, ioFilter);
        try {
            ioFilter.onPreAdd(this, string, entryImpl2.getNextFilter());
        }
        catch (Exception exception) {
            throw new IoFilterLifeCycleException("onPreAdd(): " + string + ':' + ioFilter + " in " + this.getSession(), exception);
        }
        entryImpl.nextEntry.prevEntry = entryImpl2;
        entryImpl.nextEntry = entryImpl2;
        this.name2entry.put(string, entryImpl2);
        try {
            ioFilter.onPostAdd(this, string, entryImpl2.getNextFilter());
        }
        catch (Exception exception) {
            this.deregister0(entryImpl2);
            throw new IoFilterLifeCycleException("onPostAdd(): " + string + ':' + ioFilter + " in " + this.getSession(), exception);
        }
    }

    private void deregister(EntryImpl entryImpl) {
        IoFilter ioFilter = entryImpl.getFilter();
        try {
            ioFilter.onPreRemove(this, entryImpl.getName(), entryImpl.getNextFilter());
        }
        catch (Exception exception) {
            throw new IoFilterLifeCycleException("onPreRemove(): " + entryImpl.getName() + ':' + ioFilter + " in " + this.getSession(), exception);
        }
        this.deregister0(entryImpl);
        try {
            ioFilter.onPostRemove(this, entryImpl.getName(), entryImpl.getNextFilter());
        }
        catch (Exception exception) {
            throw new IoFilterLifeCycleException("onPostRemove(): " + entryImpl.getName() + ':' + ioFilter + " in " + this.getSession(), exception);
        }
    }

    private void deregister0(EntryImpl entryImpl) {
        EntryImpl entryImpl2 = entryImpl.prevEntry;
        EntryImpl entryImpl3 = entryImpl.nextEntry;
        entryImpl2.nextEntry = entryImpl3;
        entryImpl3.prevEntry = entryImpl2;
        this.name2entry.remove(entryImpl.name);
    }

    private void checkAddable(String string) {
        if (this.name2entry.containsKey(string)) {
            throw new IllegalArgumentException("Other filter is using the same name '" + string + "'");
        }
    }

    @Override
    public void fireSessionCreated() {
        EntryImpl entryImpl = this.head;
        this.callNextSessionCreated(entryImpl, this.session);
    }

    private void callNextSessionCreated(IoFilterChain.Entry entry, IoSession ioSession) {
        try {
            IoFilter ioFilter = entry.getFilter();
            IoFilter.NextFilter nextFilter = entry.getNextFilter();
            ioFilter.sessionCreated(nextFilter, ioSession);
        }
        catch (Throwable throwable) {
            this.fireExceptionCaught(throwable);
        }
    }

    @Override
    public void fireSessionOpened() {
        EntryImpl entryImpl = this.head;
        this.callNextSessionOpened(entryImpl, this.session);
    }

    private void callNextSessionOpened(IoFilterChain.Entry entry, IoSession ioSession) {
        try {
            IoFilter ioFilter = entry.getFilter();
            IoFilter.NextFilter nextFilter = entry.getNextFilter();
            ioFilter.sessionOpened(nextFilter, ioSession);
        }
        catch (Throwable throwable) {
            this.fireExceptionCaught(throwable);
        }
    }

    @Override
    public void fireSessionClosed() {
        try {
            this.session.getCloseFuture().setClosed();
        }
        catch (Throwable throwable) {
            this.fireExceptionCaught(throwable);
        }
        EntryImpl entryImpl = this.head;
        this.callNextSessionClosed(entryImpl, this.session);
    }

    private void callNextSessionClosed(IoFilterChain.Entry entry, IoSession ioSession) {
        try {
            IoFilter ioFilter = entry.getFilter();
            IoFilter.NextFilter nextFilter = entry.getNextFilter();
            ioFilter.sessionClosed(nextFilter, ioSession);
        }
        catch (Throwable throwable) {
            this.fireExceptionCaught(throwable);
        }
    }

    @Override
    public void fireSessionIdle(IdleStatus idleStatus) {
        this.session.increaseIdleCount(idleStatus, System.currentTimeMillis());
        EntryImpl entryImpl = this.head;
        this.callNextSessionIdle(entryImpl, this.session, idleStatus);
    }

    private void callNextSessionIdle(IoFilterChain.Entry entry, IoSession ioSession, IdleStatus idleStatus) {
        try {
            IoFilter ioFilter = entry.getFilter();
            IoFilter.NextFilter nextFilter = entry.getNextFilter();
            ioFilter.sessionIdle(nextFilter, ioSession, idleStatus);
        }
        catch (Throwable throwable) {
            this.fireExceptionCaught(throwable);
        }
    }

    @Override
    public void fireMessageReceived(Object object) {
        if (object instanceof IoBuffer) {
            this.session.increaseReadBytes(((IoBuffer)object).remaining(), System.currentTimeMillis());
        }
        EntryImpl entryImpl = this.head;
        this.callNextMessageReceived(entryImpl, this.session, object);
    }

    private void callNextMessageReceived(IoFilterChain.Entry entry, IoSession ioSession, Object object) {
        try {
            IoFilter ioFilter = entry.getFilter();
            IoFilter.NextFilter nextFilter = entry.getNextFilter();
            ioFilter.messageReceived(nextFilter, ioSession, object);
        }
        catch (Throwable throwable) {
            this.fireExceptionCaught(throwable);
        }
    }

    @Override
    public void fireMessageSent(WriteRequest writeRequest) {
        this.session.increaseWrittenMessages(writeRequest, System.currentTimeMillis());
        try {
            writeRequest.getFuture().setWritten();
        }
        catch (Throwable throwable) {
            this.fireExceptionCaught(throwable);
        }
        EntryImpl entryImpl = this.head;
        if (!writeRequest.isEncoded()) {
            this.callNextMessageSent(entryImpl, this.session, writeRequest);
        }
    }

    private void callNextMessageSent(IoFilterChain.Entry entry, IoSession ioSession, WriteRequest writeRequest) {
        try {
            IoFilter ioFilter = entry.getFilter();
            IoFilter.NextFilter nextFilter = entry.getNextFilter();
            ioFilter.messageSent(nextFilter, ioSession, writeRequest);
        }
        catch (Throwable throwable) {
            this.fireExceptionCaught(throwable);
        }
    }

    @Override
    public void fireExceptionCaught(Throwable throwable) {
        EntryImpl entryImpl = this.head;
        this.callNextExceptionCaught(entryImpl, this.session, throwable);
    }

    private void callNextExceptionCaught(IoFilterChain.Entry entry, IoSession ioSession, Throwable throwable) {
        ConnectFuture connectFuture = (ConnectFuture)ioSession.removeAttribute(SESSION_CREATED_FUTURE);
        if (connectFuture == null) {
            try {
                IoFilter ioFilter = entry.getFilter();
                IoFilter.NextFilter nextFilter = entry.getNextFilter();
                ioFilter.exceptionCaught(nextFilter, ioSession, throwable);
            }
            catch (Throwable throwable2) {
                LOGGER.warn("Unexpected exception from exceptionCaught handler.", throwable2);
            }
        } else {
            ioSession.close(true);
            connectFuture.setException(throwable);
        }
    }

    @Override
    public void fireFilterWrite(WriteRequest writeRequest) {
        EntryImpl entryImpl = this.tail;
        this.callPreviousFilterWrite(entryImpl, this.session, writeRequest);
    }

    private void callPreviousFilterWrite(IoFilterChain.Entry entry, IoSession ioSession, WriteRequest writeRequest) {
        try {
            IoFilter ioFilter = entry.getFilter();
            IoFilter.NextFilter nextFilter = entry.getNextFilter();
            ioFilter.filterWrite(nextFilter, ioSession, writeRequest);
        }
        catch (Throwable throwable) {
            writeRequest.getFuture().setException(throwable);
            this.fireExceptionCaught(throwable);
        }
    }

    @Override
    public void fireFilterClose() {
        EntryImpl entryImpl = this.tail;
        this.callPreviousFilterClose(entryImpl, this.session);
    }

    private void callPreviousFilterClose(IoFilterChain.Entry entry, IoSession ioSession) {
        try {
            IoFilter ioFilter = entry.getFilter();
            IoFilter.NextFilter nextFilter = entry.getNextFilter();
            ioFilter.filterClose(nextFilter, ioSession);
        }
        catch (Throwable throwable) {
            this.fireExceptionCaught(throwable);
        }
    }

    @Override
    public boolean contains(IoFilter ioFilter) {
        return this.getEntry(ioFilter) != null;
    }

    @Override
    public boolean contains(Class<? extends IoFilter> clazz) {
        return this.getEntry(clazz) != null;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{ ");
        boolean bl = true;
        EntryImpl entryImpl = this.head.nextEntry;
        while (entryImpl != this.tail) {
            if (!bl) {
                stringBuilder.append(", ");
            } else {
                bl = false;
            }
            stringBuilder.append('(');
            stringBuilder.append(entryImpl.getName());
            stringBuilder.append(':');
            stringBuilder.append(entryImpl.getFilter());
            stringBuilder.append(')');
            entryImpl = entryImpl.nextEntry;
        }
        if (bl) {
            stringBuilder.append("empty");
        }
        stringBuilder.append(" }");
        return stringBuilder.toString();
    }

    private class EntryImpl
    implements IoFilterChain.Entry {
        private EntryImpl prevEntry;
        private EntryImpl nextEntry;
        private final String name;
        private IoFilter filter;
        private final IoFilter.NextFilter nextFilter;

        private EntryImpl(EntryImpl entryImpl, EntryImpl entryImpl2, String string, IoFilter ioFilter) {
            if (ioFilter == null) {
                throw new IllegalArgumentException("filter");
            }
            if (string == null) {
                throw new IllegalArgumentException("name");
            }
            this.prevEntry = entryImpl;
            this.nextEntry = entryImpl2;
            this.name = string;
            this.filter = ioFilter;
            this.nextFilter = new IoFilter.NextFilter(){

                public void sessionCreated(IoSession ioSession) {
                    EntryImpl entryImpl = EntryImpl.this.nextEntry;
                    DefaultIoFilterChain.this.callNextSessionCreated(entryImpl, ioSession);
                }

                public void sessionOpened(IoSession ioSession) {
                    EntryImpl entryImpl = EntryImpl.this.nextEntry;
                    DefaultIoFilterChain.this.callNextSessionOpened(entryImpl, ioSession);
                }

                public void sessionClosed(IoSession ioSession) {
                    EntryImpl entryImpl = EntryImpl.this.nextEntry;
                    DefaultIoFilterChain.this.callNextSessionClosed(entryImpl, ioSession);
                }

                public void sessionIdle(IoSession ioSession, IdleStatus idleStatus) {
                    EntryImpl entryImpl = EntryImpl.this.nextEntry;
                    DefaultIoFilterChain.this.callNextSessionIdle(entryImpl, ioSession, idleStatus);
                }

                public void exceptionCaught(IoSession ioSession, Throwable throwable) {
                    EntryImpl entryImpl = EntryImpl.this.nextEntry;
                    DefaultIoFilterChain.this.callNextExceptionCaught(entryImpl, ioSession, throwable);
                }

                public void messageReceived(IoSession ioSession, Object object) {
                    EntryImpl entryImpl = EntryImpl.this.nextEntry;
                    DefaultIoFilterChain.this.callNextMessageReceived(entryImpl, ioSession, object);
                }

                public void messageSent(IoSession ioSession, WriteRequest writeRequest) {
                    EntryImpl entryImpl = EntryImpl.this.nextEntry;
                    DefaultIoFilterChain.this.callNextMessageSent(entryImpl, ioSession, writeRequest);
                }

                public void filterWrite(IoSession ioSession, WriteRequest writeRequest) {
                    EntryImpl entryImpl = EntryImpl.this.prevEntry;
                    DefaultIoFilterChain.this.callPreviousFilterWrite(entryImpl, ioSession, writeRequest);
                }

                public void filterClose(IoSession ioSession) {
                    EntryImpl entryImpl = EntryImpl.this.prevEntry;
                    DefaultIoFilterChain.this.callPreviousFilterClose(entryImpl, ioSession);
                }

                public String toString() {
                    return EntryImpl.this.nextEntry.name;
                }
            };
        }

        public String getName() {
            return this.name;
        }

        public IoFilter getFilter() {
            return this.filter;
        }

        public IoFilter.NextFilter getNextFilter() {
            return this.nextFilter;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("('").append(this.getName()).append('\'');
            stringBuilder.append(", prev: '");
            if (this.prevEntry != null) {
                stringBuilder.append(this.prevEntry.name);
                stringBuilder.append(':');
                stringBuilder.append(this.prevEntry.getFilter().getClass().getSimpleName());
            } else {
                stringBuilder.append("null");
            }
            stringBuilder.append("', next: '");
            if (this.nextEntry != null) {
                stringBuilder.append(this.nextEntry.name);
                stringBuilder.append(':');
                stringBuilder.append(this.nextEntry.getFilter().getClass().getSimpleName());
            } else {
                stringBuilder.append("null");
            }
            stringBuilder.append("')");
            return stringBuilder.toString();
        }
    }

    private static class TailFilter
    extends IoFilterAdapter {
        private TailFilter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sessionCreated(IoFilter.NextFilter nextFilter, IoSession ioSession) throws Exception {
            try {
                ioSession.getHandler().sessionCreated(ioSession);
            }
            finally {
                ConnectFuture connectFuture = (ConnectFuture)ioSession.removeAttribute(SESSION_CREATED_FUTURE);
                if (connectFuture != null) {
                    connectFuture.setSession(ioSession);
                }
            }
        }

        public void sessionOpened(IoFilter.NextFilter nextFilter, IoSession ioSession) throws Exception {
            ioSession.getHandler().sessionOpened(ioSession);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sessionClosed(IoFilter.NextFilter nextFilter, IoSession ioSession) throws Exception {
            AbstractIoSession abstractIoSession = (AbstractIoSession)ioSession;
            try {
                abstractIoSession.getHandler().sessionClosed(ioSession);
            }
            finally {
                try {
                    abstractIoSession.getWriteRequestQueue().dispose(ioSession);
                }
                finally {
                    try {
                        abstractIoSession.getAttributeMap().dispose(ioSession);
                    }
                    finally {
                        try {
                            ioSession.getFilterChain().clear();
                        }
                        finally {
                            if (abstractIoSession.getConfig().isUseReadOperation()) {
                                abstractIoSession.offerClosedReadFuture();
                            }
                        }
                    }
                }
            }
        }

        public void sessionIdle(IoFilter.NextFilter nextFilter, IoSession ioSession, IdleStatus idleStatus) throws Exception {
            ioSession.getHandler().sessionIdle(ioSession, idleStatus);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void exceptionCaught(IoFilter.NextFilter nextFilter, IoSession ioSession, Throwable throwable) throws Exception {
            AbstractIoSession abstractIoSession = (AbstractIoSession)ioSession;
            try {
                abstractIoSession.getHandler().exceptionCaught(abstractIoSession, throwable);
            }
            finally {
                if (abstractIoSession.getConfig().isUseReadOperation()) {
                    abstractIoSession.offerFailedReadFuture(throwable);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void messageReceived(IoFilter.NextFilter nextFilter, IoSession ioSession, Object object) throws Exception {
            AbstractIoSession abstractIoSession = (AbstractIoSession)ioSession;
            if (!(object instanceof IoBuffer)) {
                abstractIoSession.increaseReadMessages(System.currentTimeMillis());
            } else if (!((IoBuffer)object).hasRemaining()) {
                abstractIoSession.increaseReadMessages(System.currentTimeMillis());
            }
            try {
                ioSession.getHandler().messageReceived(abstractIoSession, object);
            }
            finally {
                if (abstractIoSession.getConfig().isUseReadOperation()) {
                    abstractIoSession.offerReadFuture(object);
                }
            }
        }

        public void messageSent(IoFilter.NextFilter nextFilter, IoSession ioSession, WriteRequest writeRequest) throws Exception {
            ioSession.getHandler().messageSent(ioSession, writeRequest.getMessage());
        }

        public void filterWrite(IoFilter.NextFilter nextFilter, IoSession ioSession, WriteRequest writeRequest) throws Exception {
            nextFilter.filterWrite(ioSession, writeRequest);
        }

        public void filterClose(IoFilter.NextFilter nextFilter, IoSession ioSession) throws Exception {
            nextFilter.filterClose(ioSession);
        }
    }

    private class HeadFilter
    extends IoFilterAdapter {
        private HeadFilter() {
        }

        public void filterWrite(IoFilter.NextFilter nextFilter, IoSession ioSession, WriteRequest writeRequest) throws Exception {
            AbstractIoSession abstractIoSession = (AbstractIoSession)ioSession;
            if (writeRequest.getMessage() instanceof IoBuffer) {
                IoBuffer ioBuffer = (IoBuffer)writeRequest.getMessage();
                ioBuffer.mark();
                int n = ioBuffer.remaining();
                if (n == 0) {
                    abstractIoSession.increaseScheduledWriteMessages();
                } else {
                    abstractIoSession.increaseScheduledWriteBytes(n);
                }
            } else {
                abstractIoSession.increaseScheduledWriteMessages();
            }
            abstractIoSession.getWriteRequestQueue().offer(abstractIoSession, writeRequest);
            if (!abstractIoSession.isWriteSuspended()) {
                abstractIoSession.getProcessor().flush(abstractIoSession);
            }
        }

        public void filterClose(IoFilter.NextFilter nextFilter, IoSession ioSession) throws Exception {
            ((AbstractIoSession)ioSession).getProcessor().remove((AbstractIoSession)ioSession);
        }
    }
}

