/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.utils.icon;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.pushingpixels.substance.internal.animation.IconGlowTracker;
import org.pushingpixels.substance.internal.utils.SubstanceColorUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;

public class GlowingIcon
implements Icon {
    protected Icon delegate;
    protected IconGlowTracker iconGlowTracker;
    protected Map<Float, Icon> iconMap;

    public GlowingIcon(Icon icon, IconGlowTracker iconGlowTracker) {
        this.delegate = icon;
        this.iconGlowTracker = iconGlowTracker;
        this.iconMap = new HashMap<Float, Icon>();
    }

    public Icon getDelegate() {
        return this.delegate;
    }

    @Override
    public int getIconHeight() {
        if (this.delegate == null) {
            return 0;
        }
        return this.delegate.getIconHeight();
    }

    @Override
    public int getIconWidth() {
        if (this.delegate == null) {
            return 0;
        }
        return this.delegate.getIconWidth();
    }

    @Override
    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        if (this.delegate == null) {
            return;
        }
        float f = this.iconGlowTracker.getIconGlowPosition();
        Icon icon = this.iconMap.get(Float.valueOf(f));
        if (icon == null) {
            int n3 = this.getIconWidth();
            int n4 = this.getIconHeight();
            BufferedImage bufferedImage = SubstanceCoreUtilities.getBlankImage(n3, n4);
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            this.delegate.paintIcon(component, graphics2D, 0, 0);
            for (int i = 0; i < n3; ++i) {
                for (int j = 0; j < n4; ++j) {
                    int n5 = bufferedImage.getRGB(i, j);
                    int n6 = n5 >>> 24 & 0xFF;
                    double d = Math.sin(Math.PI * 2 * (double)f / 2.0) / 3.0;
                    Color color = d >= 0.0 ? SubstanceColorUtilities.getLighterColor(new Color(n5), d) : SubstanceColorUtilities.getDarkerColor(new Color(n5), -d);
                    bufferedImage.setRGB(i, j, n6 << 24 | color.getRed() << 16 | color.getGreen() << 8 | color.getBlue());
                }
            }
            icon = new ImageIcon(bufferedImage);
            this.iconMap.put(Float.valueOf(f), icon);
        }
        icon.paintIcon(component, graphics, n, n2);
    }
}

