/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.utils;

import java.awt.Component;
import java.awt.Insets;
import java.awt.Toolkit;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.api.fonts.FontPolicy;
import org.pushingpixels.substance.api.fonts.FontSet;
import org.pushingpixels.substance.internal.fonts.DefaultGnomeFontPolicy;

public class SubstanceSizeUtils {
    private static int controlFontSize = -1;
    private static double pointsToPixelsRatio = 1.0;

    public static int getControlFontSize() {
        if (controlFontSize > 0) {
            return controlFontSize;
        }
        FontPolicy fontPolicy = SubstanceLookAndFeel.getFontPolicy();
        FontSet fontSet = fontPolicy.getFontSet("Substance", null);
        controlFontSize = fontSet.getControlFont().getSize();
        return controlFontSize;
    }

    public static void setControlFontSize(int n) {
        controlFontSize = n;
    }

    public static int getComponentFontSize(Component component) {
        return component == null || component.getFont() == null ? SubstanceSizeUtils.getControlFontSize() : component.getFont().getSize();
    }

    public static float getAdjustedSize(int n, float f, int n2, float f2) {
        int n3 = n - 11;
        if (n3 <= 0) {
            return f;
        }
        float f3 = f + (float)n3 * f2 / (float)n2;
        return f3;
    }

    public static int getAdjustedSize(int n, int n2, int n3, int n4, boolean bl) {
        int n5 = n - 11;
        if (n5 <= 0) {
            return n2;
        }
        int n6 = n2 + n5 * n4 / n3;
        if (bl && n6 % 2 != 0) {
            --n6;
        }
        return n6;
    }

    public static float getArrowIconHeight(int n) {
        if (n < 12) {
            return 2.5f + (float)n * 0.5f;
        }
        return 3.0f + (float)n * 0.6f;
    }

    public static float getArrowIconWidth(int n) {
        int n2 = 2 * n / 3;
        if (n2 % 2 == 0) {
            ++n2;
        }
        return n2 + 4;
    }

    public static float getArrowStrokeWidth(int n) {
        return (float)n / 6.0f;
    }

    public static float getBorderStrokeWidth(int n) {
        return (float)n / 10.0f;
    }

    public static Insets getButtonInsets(int n) {
        Insets insets = SubstanceSizeUtils.getTextBorderInsets(n);
        int n2 = (int)SubstanceSizeUtils.getBorderStrokeWidth(n);
        int n3 = insets.top - n2;
        int n4 = insets.bottom - n2;
        int n5 = SubstanceSizeUtils.getAdjustedSize(n, 4, 4, 1, false);
        return new Insets(n3, n5, n4, n5);
    }

    public static Border getCheckBoxBorder(int n, boolean bl) {
        int n2 = SubstanceSizeUtils.getAdjustedSize(n, 2, 3, 1, false);
        int n3 = SubstanceSizeUtils.getAdjustedSize(n, 3, 3, 1, false);
        if (n == 11) {
            n2 = 2;
            n3 = 2;
        }
        int n4 = SubstanceSizeUtils.getAdjustedSize(n, 3, 3, 1, false);
        int n5 = SubstanceSizeUtils.getAdjustedSize(n, 5, 3, 1, false);
        return new BorderUIResource.EmptyBorderUIResource(n2, bl ? n4 : n5, n3, bl ? n5 : n4);
    }

    public static int getCheckBoxMarkSize(int n) {
        return 5 + n;
    }

    public static float getClassicButtonCornerRadius(int n) {
        return SubstanceSizeUtils.getAdjustedSize(n, 2, 6, 1, false);
    }

    public static Insets getComboBorderInsets(int n) {
        int n2 = SubstanceSizeUtils.getAdjustedSize(n, 1, 3, 1, false);
        int n3 = SubstanceSizeUtils.getAdjustedSize(n, 2, 3, 1, false);
        return new Insets(n2, n3, n2, n3);
    }

    public static Insets getComboLayoutInsets(int n) {
        int n2 = SubstanceSizeUtils.getAdjustedSize(n, 2, 4, 1, false);
        int n3 = SubstanceSizeUtils.getAdjustedSize(n, 2, 4, 1, false);
        return new Insets(n2, n3, n2, n3);
    }

    public static Insets getComboTextBorderInsets(int n) {
        Insets insets = SubstanceSizeUtils.getTextBorderInsets(n);
        Insets insets2 = SubstanceSizeUtils.getComboBorderInsets(n);
        int n2 = insets.top - insets2.top;
        int n3 = insets.bottom - insets2.bottom;
        int n4 = SubstanceSizeUtils.getAdjustedSize(n, 3, 4, 1, false);
        return new Insets(n2, n4, n3, n4);
    }

    public static Insets getDefaultBorderInsets(int n) {
        int n2 = SubstanceSizeUtils.getAdjustedSize(n, 2, 3, 1, false);
        return new Insets(n2, n2, n2, n2);
    }

    public static float getDoubleArrowStrokeWidth(int n) {
        return (float)n / 8.0f;
    }

    public static int getDragBumpDiameter(int n) {
        return SubstanceSizeUtils.getAdjustedSize(n, 2, 4, 1, false);
    }

    public static int getBigDragBumpDiameter(int n) {
        int n2 = SubstanceSizeUtils.getAdjustedSize(n, 3, 3, 1, false);
        if (n2 % 2 != 0) {
            ++n2;
        }
        return n2;
    }

    public static int getExtraPadding(int n) {
        if (n < 14) {
            return 0;
        }
        return (int)SubstanceSizeUtils.getAdjustedSize(n, 0.0f, 3, 1.2f);
    }

    public static int getFocusRingPadding(int n) {
        if (n < 14) {
            return 2;
        }
        return 3 + (int)SubstanceSizeUtils.getAdjustedSize(n, 0.0f, 3, 0.8f);
    }

    public static float getFocusStrokeWidth(int n) {
        return Math.max(1.0f, (float)n / 10.0f);
    }

    public static Insets getListCellRendererInsets(int n) {
        Insets insets = SubstanceSizeUtils.getTextBorderInsets(n);
        Insets insets2 = SubstanceSizeUtils.getComboBorderInsets(n);
        int n2 = (int)SubstanceSizeUtils.getBorderStrokeWidth(n);
        int n3 = insets.top - insets2.top - n2;
        int n4 = insets.bottom - insets2.bottom - n2;
        int n5 = SubstanceSizeUtils.getAdjustedSize(n, 4, 4, 1, false);
        return new Insets(n3, n5, n4, n5);
    }

    public static int getMenuCheckMarkSize(int n) {
        int n2 = n - 2;
        if (n2 % 2 == 0) {
            --n2;
        }
        return n2;
    }

    public static int getMenuItemMargin(int n) {
        return SubstanceSizeUtils.getAdjustedSize(n, 2, 4, 1, false);
    }

    public static int getTextIconGap(int n) {
        return SubstanceSizeUtils.getAdjustedSize(n, 4, 3, 1, false);
    }

    public static int getMinButtonWidth(int n) {
        return 5 * n + 12;
    }

    public static int getPasswordDotDiameter(int n) {
        return SubstanceSizeUtils.getAdjustedSize(n, 7, 2, 1, false);
    }

    public static int getPasswordDotGap(int n) {
        return (n - 6) / 3;
    }

    public static Border getRadioButtonBorder(int n, boolean bl) {
        Border border = SubstanceSizeUtils.getCheckBoxBorder(n, bl);
        Insets insets = border.getBorderInsets(null);
        return new BorderUIResource.EmptyBorderUIResource(insets.top, insets.left - (bl ? 0 : 2), insets.bottom, insets.right - (bl ? 2 : 0));
    }

    public static int getRadioButtonMarkSize(int n) {
        int n2 = n;
        if (n2 % 2 == 0) {
            --n2;
        }
        return n2;
    }

    public static int getScrollBarWidth(int n) {
        int n2 = (int)(SubstanceSizeUtils.getArrowIconWidth(n) * 3.0f / 2.0f);
        if (n2 % 2 == 0) {
            ++n2;
        }
        return n2;
    }

    public static int getSliderIconSize(int n) {
        int n2 = n + 5;
        if (n2 % 2 != 0) {
            --n2;
        }
        return n2;
    }

    public static int getSliderTickSize(int n) {
        return Math.max(7, n - 3);
    }

    public static int getSliderTrackSize(int n) {
        return SubstanceSizeUtils.getAdjustedSize(n, 5, 4, 1, false);
    }

    public static float getSmallArrowIconHeight(int n) {
        return SubstanceSizeUtils.getArrowIconHeight(n) - 1.0f;
    }

    public static float getSmallArrowIconWidth(int n) {
        return SubstanceSizeUtils.getArrowIconWidth(n) - 2.0f;
    }

    public static float getSpinnerArrowIconHeight(int n) {
        float f = SubstanceSizeUtils.getArrowIconHeight(n) + SubstanceSizeUtils.getAdjustedSize(n + 1, 0.0f, 1, -0.25f);
        return f;
    }

    public static float getSpinnerArrowIconWidth(int n) {
        int n2 = (int)(SubstanceSizeUtils.getArrowIconWidth(n) + SubstanceSizeUtils.getAdjustedSize(n, 1.0f, 1, -0.15f));
        if (n2 % 2 == 0) {
            --n2;
        }
        return n2;
    }

    public static Insets getSpinnerBorderInsets(int n) {
        Insets insets = SubstanceSizeUtils.getComboBorderInsets(n);
        return new Insets(insets.top + 1, insets.left, insets.bottom + 1, insets.right);
    }

    public static Insets getSpinnerArrowButtonInsets(int n) {
        int n2 = (int)Math.floor(SubstanceSizeUtils.getBorderStrokeWidth(n));
        return new Insets(n2, n2, n2, n2);
    }

    public static Insets getSpinnerTextBorderInsets(int n) {
        Insets insets = SubstanceSizeUtils.getComboTextBorderInsets(n);
        return new Insets(insets.top - 1, insets.left, insets.bottom - 1, insets.right);
    }

    public static float getSplitPaneArrowIconHeight(int n) {
        float f = SubstanceSizeUtils.getArrowIconHeight(n) + SubstanceSizeUtils.getAdjustedSize(n, -1.0f, 1, -0.3f);
        return f;
    }

    public static float getSplitPaneArrowIconWidth(int n) {
        float f = SubstanceSizeUtils.getArrowIconWidth(n) + SubstanceSizeUtils.getAdjustedSize(n, -2.0f, 1, -0.25f);
        return f;
    }

    public static int getSplitPaneButtonOffset(int n) {
        return SubstanceSizeUtils.getAdjustedSize(n, 2, 3, 1, false);
    }

    public static Insets getTabbedPaneContentInsets(int n) {
        float f = SubstanceSizeUtils.getBorderStrokeWidth(n);
        int n2 = (int)Math.ceil(2.5 * (double)f);
        int n3 = (int)Math.ceil(3.0 * (double)f);
        return new Insets(n2, n3, n2, n3);
    }

    public static float getTabCloseButtonStrokeWidth(int n) {
        return (float)n / 10.0f;
    }

    public static int getTabCloseIconSize(int n) {
        return n - 2;
    }

    public static Insets getTableCellRendererInsets(int n) {
        Insets insets = SubstanceSizeUtils.getTextBorderInsets(n);
        Insets insets2 = SubstanceSizeUtils.getComboBorderInsets(n);
        int n2 = insets.top - insets2.top - 1;
        int n3 = insets.bottom - insets2.bottom - 2;
        if (n == 11) {
            ++n3;
        }
        int n4 = SubstanceSizeUtils.getAdjustedSize(n, 2, 4, 1, false);
        return new Insets(n2, n4, n3, n4);
    }

    public static Insets getTextBorderInsets(int n) {
        int n2 = SubstanceSizeUtils.getAdjustedSize(n, 3, 3, 1, false);
        int n3 = SubstanceSizeUtils.getAdjustedSize(n, 4, 3, 1, false);
        if (n == 11) {
            n2 = 3;
            n3 = 3;
        }
        int n4 = SubstanceSizeUtils.getAdjustedSize(n, 5, 3, 1, false);
        return new Insets(n2, n4, n3, n4);
    }

    public static int getTextButtonLRPadding(int n) {
        return SubstanceSizeUtils.getAdjustedSize(n, 3, 2, 1, false);
    }

    public static int getTitlePaneIconSize() {
        return 5 + SubstanceSizeUtils.getControlFontSize();
    }

    public static int getToolBarDragInset(int n) {
        return n + 5;
    }

    public static Insets getToolBarInsets(int n) {
        int n2 = SubstanceSizeUtils.getAdjustedSize(n, 2, 3, 1, false);
        int n3 = SubstanceSizeUtils.getAdjustedSize(n, 1, 3, 1, false);
        return new Insets(n3, n2, n2, n2);
    }

    public static Insets getToolTipBorderInsets(int n) {
        int n2 = SubstanceSizeUtils.getAdjustedSize(n, 1, 3, 1, false);
        return new Insets(n2, n2, n2, n2);
    }

    public static Insets getTreeCellRendererInsets(int n) {
        Insets insets = SubstanceSizeUtils.getListCellRendererInsets(n);
        return new Insets(insets.top - 1, insets.left - 2, insets.bottom - 1, insets.right - 2);
    }

    public static int getTreeIconSize(int n) {
        int n2 = SubstanceSizeUtils.getExtraPadding(n);
        int n3 = 2 * n2;
        return 10 + n3;
    }

    public static double getPointsToPixelsRatio() {
        return pointsToPixelsRatio;
    }

    public static void resetPointsToPixelsRatio(FontPolicy fontPolicy) {
        pointsToPixelsRatio = fontPolicy instanceof DefaultGnomeFontPolicy ? DefaultGnomeFontPolicy.getPointsToPixelsRatio() : (double)Toolkit.getDefaultToolkit().getScreenResolution() / 72.0;
    }
}

