/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.ui;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicLabelUI;
import javax.swing.text.View;
import org.pushingpixels.lafwidget.LafWidget;
import org.pushingpixels.lafwidget.LafWidgetRepository;
import org.pushingpixels.lafwidget.utils.RenderingUtils;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.internal.painter.BackgroundPaintingUtils;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceTextUtilities;

public class SubstanceLabelUI
extends BasicLabelUI {
    protected Set lafWidgets;
    protected PropertyChangeListener substancePropertyChangeListener;
    private Rectangle paintIconR = new Rectangle();
    private Rectangle paintTextR = new Rectangle();
    private Rectangle paintViewR = new Rectangle();
    private Insets paintViewInsets = new Insets(0, 0, 0, 0);

    protected void __org__pushingpixels__substance__internal__ui__SubstanceLabelUI__installComponents(JLabel jLabel) {
        super.installComponents(jLabel);
    }

    @Override
    protected void installComponents(JLabel jLabel) {
        this.__org__pushingpixels__substance__internal__ui__SubstanceLabelUI__installComponents(jLabel);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installComponents();
        }
    }

    public void __org__pushingpixels__substance__internal__ui__SubstanceLabelUI__installUI(JComponent jComponent) {
        super.installUI(jComponent);
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.lafWidgets = LafWidgetRepository.getRepository().getMatchingWidgets(jComponent);
        this.__org__pushingpixels__substance__internal__ui__SubstanceLabelUI__installUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installUI();
        }
    }

    public void __org__pushingpixels__substance__internal__ui__SubstanceLabelUI__uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.__org__pushingpixels__substance__internal__ui__SubstanceLabelUI__uninstallUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallUI();
        }
    }

    @Override
    protected void installListeners(JLabel jLabel) {
        this.__org__pushingpixels__substance__internal__ui__SubstanceLabelUI__installListeners(jLabel);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installListeners();
        }
    }

    protected void __org__pushingpixels__substance__internal__ui__SubstanceLabelUI__installDefaults(JLabel jLabel) {
        super.installDefaults(jLabel);
    }

    @Override
    protected void installDefaults(JLabel jLabel) {
        this.__org__pushingpixels__substance__internal__ui__SubstanceLabelUI__installDefaults(jLabel);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installDefaults();
        }
    }

    protected void __org__pushingpixels__substance__internal__ui__SubstanceLabelUI__uninstallComponents(JLabel jLabel) {
        super.uninstallComponents(jLabel);
    }

    @Override
    protected void uninstallComponents(JLabel jLabel) {
        this.__org__pushingpixels__substance__internal__ui__SubstanceLabelUI__uninstallComponents(jLabel);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallComponents();
        }
    }

    @Override
    protected void uninstallListeners(JLabel jLabel) {
        this.__org__pushingpixels__substance__internal__ui__SubstanceLabelUI__uninstallListeners(jLabel);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallListeners();
        }
    }

    protected void __org__pushingpixels__substance__internal__ui__SubstanceLabelUI__uninstallDefaults(JLabel jLabel) {
        super.uninstallDefaults(jLabel);
    }

    @Override
    protected void uninstallDefaults(JLabel jLabel) {
        this.__org__pushingpixels__substance__internal__ui__SubstanceLabelUI__uninstallDefaults(jLabel);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallDefaults();
        }
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        RenderingUtils.installDesktopHints(graphics2D, jComponent);
        this.__org__pushingpixels__substance__internal__ui__SubstanceLabelUI__update(graphics2D, jComponent);
        graphics2D.dispose();
    }

    public static ComponentUI createUI(JComponent jComponent) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation(jComponent);
        return new SubstanceLabelUI();
    }

    protected void __org__pushingpixels__substance__internal__ui__SubstanceLabelUI__installListeners(final JLabel jLabel) {
        super.installListeners(jLabel);
        this.substancePropertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("opaque".equals(propertyChangeEvent.getPropertyName()) && !Boolean.TRUE.equals(jLabel.getClientProperty("substancelaf.lockopacity"))) {
                    jLabel.putClientProperty("substancelaf.buttonopacityoriginal", propertyChangeEvent.getNewValue());
                }
            }
        };
        jLabel.addPropertyChangeListener(this.substancePropertyChangeListener);
    }

    protected void __org__pushingpixels__substance__internal__ui__SubstanceLabelUI__uninstallListeners(JLabel jLabel) {
        jLabel.removePropertyChangeListener(this.substancePropertyChangeListener);
        this.substancePropertyChangeListener = null;
        super.uninstallListeners(jLabel);
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        JLabel jLabel = (JLabel)jComponent;
        String string = jLabel.getText();
        Icon icon = null;
        if (jLabel.isEnabled()) {
            icon = jLabel.getIcon();
            if (icon != null && SubstanceCoreUtilities.useThemedDefaultIcon(jLabel)) {
                icon = SubstanceCoreUtilities.getThemedIcon(jLabel, icon);
            }
        } else {
            icon = jLabel.getDisabledIcon();
        }
        if (icon == null && string == null) {
            return;
        }
        Insets insets = jLabel.getInsets(this.paintViewInsets);
        this.paintViewR.x = insets.left;
        this.paintViewR.y = insets.top;
        this.paintViewR.width = jComponent.getWidth() - (insets.left + insets.right);
        this.paintViewR.height = jComponent.getHeight() - (insets.top + insets.bottom);
        this.paintIconR.height = 0;
        this.paintIconR.width = 0;
        this.paintIconR.y = 0;
        this.paintIconR.x = 0;
        this.paintTextR.height = 0;
        this.paintTextR.width = 0;
        this.paintTextR.y = 0;
        this.paintTextR.x = 0;
        String string2 = SwingUtilities.layoutCompoundLabel(jLabel, graphics.getFontMetrics(), string, icon, jLabel.getVerticalAlignment(), jLabel.getHorizontalAlignment(), jLabel.getVerticalTextPosition(), jLabel.getHorizontalTextPosition(), this.paintViewR, this.paintIconR, this.paintTextR, jLabel.getIconTextGap());
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        BackgroundPaintingUtils.updateIfOpaque(graphics2D, jComponent);
        if (icon != null) {
            icon.paintIcon(jComponent, graphics2D, this.paintIconR.x, this.paintIconR.y);
        }
        ComponentState componentState = jLabel.isEnabled() ? ComponentState.ENABLED : ComponentState.DISABLED_UNSELECTED;
        float f = SubstanceColorSchemeUtilities.getAlpha(jLabel, componentState);
        if (string != null) {
            View view = (View)jComponent.getClientProperty("html");
            if (view != null) {
                view.paint(graphics2D, this.paintTextR);
            } else {
                SubstanceTextUtilities.paintText(graphics, (JComponent)jLabel, this.paintTextR, string2, jLabel.getDisplayedMnemonicIndex(), componentState, f);
            }
        }
        graphics2D.dispose();
    }

    public void __org__pushingpixels__substance__internal__ui__SubstanceLabelUI__update(Graphics graphics, JComponent jComponent) {
        if (!SubstanceLookAndFeel.isCurrentLookAndFeel()) {
            return;
        }
        this.paint(graphics, jComponent);
    }
}

