/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.inputmaps;

import javax.swing.TransferHandler;
import org.pushingpixels.substance.api.inputmaps.InputMapSet;
import org.pushingpixels.substance.api.inputmaps.SubstanceInputMap;

public class BaseInputMapSet
implements InputMapSet {
    public static final String PRESSED = "pressed";
    public static final String RELEASED = "released";
    public static final String COPY = (String)TransferHandler.getCopyAction().getValue("Name");
    public static final String PASTE = (String)TransferHandler.getPasteAction().getValue("Name");
    public static final String CUT = (String)TransferHandler.getCutAction().getValue("Name");

    protected SubstanceInputMap getActionControlFocusInputMap() {
        SubstanceInputMap substanceInputMap = new SubstanceInputMap();
        substanceInputMap.put("SPACE", PRESSED);
        substanceInputMap.put("released SPACE", RELEASED);
        return substanceInputMap;
    }

    @Override
    public SubstanceInputMap getButtonFocusInputMap() {
        return this.getActionControlFocusInputMap();
    }

    @Override
    public SubstanceInputMap getCheckBoxFocusInputMap() {
        return this.getActionControlFocusInputMap();
    }

    @Override
    public SubstanceInputMap getComboBoxAncestorInputMap() {
        SubstanceInputMap substanceInputMap = new SubstanceInputMap();
        substanceInputMap.put("ESCAPE", "hidePopup");
        substanceInputMap.put("PAGE_UP", "pageUpPassThrough");
        substanceInputMap.put("PAGE_DOWN", "pageDownPassThrough");
        substanceInputMap.put("HOME", "homePassThrough");
        substanceInputMap.put("END", "endPassThrough");
        substanceInputMap.put("DOWN", "selectNext");
        substanceInputMap.put("KP_DOWN", "selectNext");
        substanceInputMap.put("alt DOWN", "togglePopup");
        substanceInputMap.put("alt KP_DOWN", "togglePopup");
        substanceInputMap.put("alt UP", "togglePopup");
        substanceInputMap.put("alt KP_UP", "togglePopup");
        substanceInputMap.put("SPACE", "spacePopup");
        substanceInputMap.put("ENTER", "enterPressed");
        substanceInputMap.put("UP", "selectPrevious");
        substanceInputMap.put("KP_UP", "selectPrevious");
        return substanceInputMap;
    }

    @Override
    public SubstanceInputMap getDesktopAncestorInputMap() {
        SubstanceInputMap substanceInputMap = new SubstanceInputMap();
        substanceInputMap.put("ctrl F5", DesktopPaneActions.RESTORE);
        substanceInputMap.put("ctrl F4", DesktopPaneActions.CLOSE);
        substanceInputMap.put("ctrl F7", DesktopPaneActions.MOVE);
        substanceInputMap.put("ctrl F8", DesktopPaneActions.RESIZE);
        substanceInputMap.put("RIGHT", DesktopPaneActions.RIGHT);
        substanceInputMap.put("KP_RIGHT", DesktopPaneActions.RIGHT);
        substanceInputMap.put("shift RIGHT", DesktopPaneActions.SHRINK_RIGHT);
        substanceInputMap.put("shift KP_RIGHT", DesktopPaneActions.SHRINK_RIGHT);
        substanceInputMap.put("LEFT", DesktopPaneActions.LEFT);
        substanceInputMap.put("KP_LEFT", DesktopPaneActions.LEFT);
        substanceInputMap.put("shift LEFT", DesktopPaneActions.SHRINK_LEFT);
        substanceInputMap.put("shift KP_LEFT", DesktopPaneActions.SHRINK_LEFT);
        substanceInputMap.put("UP", DesktopPaneActions.UP);
        substanceInputMap.put("KP_UP", DesktopPaneActions.UP);
        substanceInputMap.put("shift UP", DesktopPaneActions.SHRINK_UP);
        substanceInputMap.put("shift KP_UP", DesktopPaneActions.SHRINK_UP);
        substanceInputMap.put("DOWN", DesktopPaneActions.DOWN);
        substanceInputMap.put("KP_DOWN", DesktopPaneActions.DOWN);
        substanceInputMap.put("shift DOWN", DesktopPaneActions.SHRINK_DOWN);
        substanceInputMap.put("shift KP_DOWN", DesktopPaneActions.SHRINK_DOWN);
        substanceInputMap.put("ESCAPE", DesktopPaneActions.ESCAPE);
        substanceInputMap.put("ctrl F9", DesktopPaneActions.MINIMIZE);
        substanceInputMap.put("ctrl F10", DesktopPaneActions.MAXIMIZE);
        substanceInputMap.put("ctrl F6", DesktopPaneActions.NEXT_FRAME);
        substanceInputMap.put("ctrl TAB", DesktopPaneActions.NEXT_FRAME);
        substanceInputMap.put("ctrl alt F6", DesktopPaneActions.NEXT_FRAME);
        substanceInputMap.put("shift ctrl alt F6", DesktopPaneActions.PREVIOUS_FRAME);
        substanceInputMap.put("ctrl F12", DesktopPaneActions.NAVIGATE_NEXT);
        substanceInputMap.put("shift ctrl F12", DesktopPaneActions.NAVIGATE_PREVIOUS);
        return substanceInputMap;
    }

    protected SubstanceInputMap getMultilineTextComponentFocusInputMap() {
        SubstanceInputMap substanceInputMap = new SubstanceInputMap();
        substanceInputMap.put("ctrl C", "copy-to-clipboard");
        substanceInputMap.put("ctrl V", "paste-from-clipboard");
        substanceInputMap.put("ctrl X", "cut-to-clipboard");
        substanceInputMap.put("COPY", "copy-to-clipboard");
        substanceInputMap.put("PASTE", "paste-from-clipboard");
        substanceInputMap.put("CUT", "cut-to-clipboard");
        substanceInputMap.put("control INSERT", "copy-to-clipboard");
        substanceInputMap.put("shift INSERT", "paste-from-clipboard");
        substanceInputMap.put("shift DELETE", "cut-to-clipboard");
        substanceInputMap.put("shift LEFT", "selection-backward");
        substanceInputMap.put("shift KP_LEFT", "selection-backward");
        substanceInputMap.put("shift RIGHT", "selection-forward");
        substanceInputMap.put("shift KP_RIGHT", "selection-forward");
        substanceInputMap.put("ctrl LEFT", "caret-previous-word");
        substanceInputMap.put("ctrl KP_LEFT", "caret-previous-word");
        substanceInputMap.put("ctrl RIGHT", "caret-next-word");
        substanceInputMap.put("ctrl KP_RIGHT", "caret-next-word");
        substanceInputMap.put("ctrl shift LEFT", "selection-previous-word");
        substanceInputMap.put("ctrl shift KP_LEFT", "selection-previous-word");
        substanceInputMap.put("ctrl shift RIGHT", "selection-next-word");
        substanceInputMap.put("ctrl shift KP_RIGHT", "selection-next-word");
        substanceInputMap.put("ctrl A", "select-all");
        substanceInputMap.put("HOME", "caret-begin-line");
        substanceInputMap.put("END", "caret-end-line");
        substanceInputMap.put("shift HOME", "selection-begin-line");
        substanceInputMap.put("shift END", "selection-end-line");
        substanceInputMap.put("UP", "caret-up");
        substanceInputMap.put("KP_UP", "caret-up");
        substanceInputMap.put("DOWN", "caret-down");
        substanceInputMap.put("KP_DOWN", "caret-down");
        substanceInputMap.put("PAGE_UP", "page-up");
        substanceInputMap.put("PAGE_DOWN", "page-down");
        substanceInputMap.put("shift PAGE_UP", "selection-page-up");
        substanceInputMap.put("shift PAGE_DOWN", "selection-page-down");
        substanceInputMap.put("ctrl shift PAGE_UP", "selection-page-left");
        substanceInputMap.put("ctrl shift PAGE_DOWN", "selection-page-right");
        substanceInputMap.put("shift UP", "selection-up");
        substanceInputMap.put("shift KP_UP", "selection-up");
        substanceInputMap.put("shift DOWN", "selection-down");
        substanceInputMap.put("shift KP_DOWN", "selection-down");
        substanceInputMap.put("ctrl shift HOME", "selection-begin");
        substanceInputMap.put("ctrl shift END", "selection-end");
        substanceInputMap.put("ENTER", "insert-break");
        substanceInputMap.put("BACK_SPACE", "delete-previous");
        substanceInputMap.put("shift BACK_SPACE", "delete-previous");
        substanceInputMap.put("ctrl H", "delete-previous");
        substanceInputMap.put("DELETE", "delete-next");
        substanceInputMap.put("ctrl DELETE", "delete-next-word");
        substanceInputMap.put("ctrl BACK_SPACE", "delete-previous-word");
        substanceInputMap.put("RIGHT", "caret-forward");
        substanceInputMap.put("KP_RIGHT", "caret-forward");
        substanceInputMap.put("LEFT", "caret-backward");
        substanceInputMap.put("KP_LEFT", "caret-backward");
        substanceInputMap.put("TAB", "insert-tab");
        substanceInputMap.put("ctrl BACK_SLASH", "unselect");
        substanceInputMap.put("ctrl HOME", "caret-begin");
        substanceInputMap.put("ctrl END", "caret-end");
        substanceInputMap.put("ctrl T", "next-link-action");
        substanceInputMap.put("ctrl shift T", "previous-link-action");
        substanceInputMap.put("ctrl SPACE", "activate-link-action");
        substanceInputMap.put("control shift O", "toggle-componentOrientation");
        return substanceInputMap;
    }

    @Override
    public SubstanceInputMap getEditorPaneFocusInputMap() {
        return this.getMultilineTextComponentFocusInputMap();
    }

    @Override
    public SubstanceInputMap getFileChooserAncestorInputMap() {
        SubstanceInputMap substanceInputMap = new SubstanceInputMap();
        substanceInputMap.put("ESCAPE", "cancelSelection");
        substanceInputMap.put("F2", "editFileName");
        substanceInputMap.put("F5", "refresh");
        substanceInputMap.put("BACK_SPACE", "Go Up");
        substanceInputMap.put("ENTER", "approveSelection");
        substanceInputMap.put("ctrl ENTER", "approveSelection");
        return substanceInputMap;
    }

    @Override
    public SubstanceInputMap getFormattedTextFieldFocusInputMap() {
        SubstanceInputMap substanceInputMap = new SubstanceInputMap();
        substanceInputMap.put("ctrl C", "copy-to-clipboard");
        substanceInputMap.put("ctrl V", "paste-from-clipboard");
        substanceInputMap.put("ctrl X", "cut-to-clipboard");
        substanceInputMap.put("COPY", "copy-to-clipboard");
        substanceInputMap.put("PASTE", "paste-from-clipboard");
        substanceInputMap.put("CUT", "cut-to-clipboard");
        substanceInputMap.put("control INSERT", "copy-to-clipboard");
        substanceInputMap.put("shift INSERT", "paste-from-clipboard");
        substanceInputMap.put("shift DELETE", "cut-to-clipboard");
        substanceInputMap.put("shift LEFT", "selection-backward");
        substanceInputMap.put("shift KP_LEFT", "selection-backward");
        substanceInputMap.put("shift RIGHT", "selection-forward");
        substanceInputMap.put("shift KP_RIGHT", "selection-forward");
        substanceInputMap.put("ctrl LEFT", "caret-previous-word");
        substanceInputMap.put("ctrl KP_LEFT", "caret-previous-word");
        substanceInputMap.put("ctrl RIGHT", "caret-next-word");
        substanceInputMap.put("ctrl KP_RIGHT", "caret-next-word");
        substanceInputMap.put("ctrl shift LEFT", "selection-previous-word");
        substanceInputMap.put("ctrl shift KP_LEFT", "selection-previous-word");
        substanceInputMap.put("ctrl shift RIGHT", "selection-next-word");
        substanceInputMap.put("ctrl shift KP_RIGHT", "selection-next-word");
        substanceInputMap.put("ctrl A", "select-all");
        substanceInputMap.put("HOME", "caret-begin-line");
        substanceInputMap.put("END", "caret-end-line");
        substanceInputMap.put("shift HOME", "selection-begin-line");
        substanceInputMap.put("shift END", "selection-end-line");
        substanceInputMap.put("BACK_SPACE", "delete-previous");
        substanceInputMap.put("shift BACK_SPACE", "delete-previous");
        substanceInputMap.put("ctrl H", "delete-previous");
        substanceInputMap.put("DELETE", "delete-next");
        substanceInputMap.put("ctrl DELETE", "delete-next-word");
        substanceInputMap.put("ctrl BACK_SPACE", "delete-previous-word");
        substanceInputMap.put("RIGHT", "caret-forward");
        substanceInputMap.put("LEFT", "caret-backward");
        substanceInputMap.put("KP_RIGHT", "caret-forward");
        substanceInputMap.put("KP_LEFT", "caret-backward");
        substanceInputMap.put("ENTER", "notify-field-accept");
        substanceInputMap.put("ctrl BACK_SLASH", "unselect");
        substanceInputMap.put("control shift O", "toggle-componentOrientation");
        substanceInputMap.put("ESCAPE", "reset-field-edit");
        substanceInputMap.put("UP", "increment");
        substanceInputMap.put("KP_UP", "increment");
        substanceInputMap.put("DOWN", "decrement");
        substanceInputMap.put("KP_DOWN", "decrement");
        return substanceInputMap;
    }

    @Override
    public SubstanceInputMap getListFocusInputMap() {
        SubstanceInputMap substanceInputMap = new SubstanceInputMap();
        substanceInputMap.put("ctrl C", COPY);
        substanceInputMap.put("ctrl V", PASTE);
        substanceInputMap.put("ctrl X", CUT);
        substanceInputMap.put("COPY", COPY);
        substanceInputMap.put("PASTE", PASTE);
        substanceInputMap.put("CUT", CUT);
        substanceInputMap.put("control INSERT", COPY);
        substanceInputMap.put("shift INSERT", PASTE);
        substanceInputMap.put("shift DELETE", CUT);
        substanceInputMap.put("UP", "selectPreviousRow");
        substanceInputMap.put("KP_UP", "selectPreviousRow");
        substanceInputMap.put("shift UP", "selectPreviousRowExtendSelection");
        substanceInputMap.put("shift KP_UP", "selectPreviousRowExtendSelection");
        substanceInputMap.put("ctrl shift UP", "selectPreviousRowExtendSelection");
        substanceInputMap.put("ctrl shift KP_UP", "selectPreviousRowExtendSelection");
        substanceInputMap.put("ctrl UP", "selectPreviousRowChangeLead");
        substanceInputMap.put("ctrl KP_UP", "selectPreviousRowChangeLead");
        substanceInputMap.put("DOWN", "selectNextRow");
        substanceInputMap.put("KP_DOWN", "selectNextRow");
        substanceInputMap.put("shift DOWN", "selectNextRowExtendSelection");
        substanceInputMap.put("shift KP_DOWN", "selectNextRowExtendSelection");
        substanceInputMap.put("ctrl shift DOWN", "selectNextRowExtendSelection");
        substanceInputMap.put("ctrl shift KP_DOWN", "selectNextRowExtendSelection");
        substanceInputMap.put("ctrl DOWN", "selectNextRowChangeLead");
        substanceInputMap.put("ctrl KP_DOWN", "selectNextRowChangeLead");
        substanceInputMap.put("LEFT", "selectPreviousColumn");
        substanceInputMap.put("KP_LEFT", "selectPreviousColumn");
        substanceInputMap.put("shift LEFT", "selectPreviousColumnExtendSelection");
        substanceInputMap.put("shift KP_LEFT", "selectPreviousColumnExtendSelection");
        substanceInputMap.put("ctrl shift LEFT", "selectPreviousColumnExtendSelection");
        substanceInputMap.put("ctrl shift KP_LEFT", "selectPreviousColumnExtendSelection");
        substanceInputMap.put("ctrl LEFT", "selectPreviousColumnChangeLead");
        substanceInputMap.put("ctrl KP_LEFT", "selectPreviousColumnChangeLead");
        substanceInputMap.put("RIGHT", "selectNextColumn");
        substanceInputMap.put("KP_RIGHT", "selectNextColumn");
        substanceInputMap.put("shift RIGHT", "selectNextColumnExtendSelection");
        substanceInputMap.put("shift KP_RIGHT", "selectNextColumnExtendSelection");
        substanceInputMap.put("ctrl shift RIGHT", "selectNextColumnExtendSelection");
        substanceInputMap.put("ctrl shift KP_RIGHT", "selectNextColumnExtendSelection");
        substanceInputMap.put("ctrl RIGHT", "selectNextColumnChangeLead");
        substanceInputMap.put("ctrl KP_RIGHT", "selectNextColumnChangeLead");
        substanceInputMap.put("HOME", "selectFirstRow");
        substanceInputMap.put("shift HOME", "selectFirstRowExtendSelection");
        substanceInputMap.put("ctrl shift HOME", "selectFirstRowExtendSelection");
        substanceInputMap.put("ctrl HOME", "selectFirstRowChangeLead");
        substanceInputMap.put("END", "selectLastRow");
        substanceInputMap.put("shift END", "selectLastRowExtendSelection");
        substanceInputMap.put("ctrl shift END", "selectLastRowExtendSelection");
        substanceInputMap.put("ctrl END", "selectLastRowChangeLead");
        substanceInputMap.put("PAGE_UP", "scrollUp");
        substanceInputMap.put("shift PAGE_UP", "scrollUpExtendSelection");
        substanceInputMap.put("ctrl shift PAGE_UP", "scrollUpExtendSelection");
        substanceInputMap.put("ctrl PAGE_UP", "scrollUpChangeLead");
        substanceInputMap.put("PAGE_DOWN", "scrollDown");
        substanceInputMap.put("shift PAGE_DOWN", "scrollDownExtendSelection");
        substanceInputMap.put("ctrl shift PAGE_DOWN", "scrollDownExtendSelection");
        substanceInputMap.put("ctrl PAGE_DOWN", "scrollDownChangeLead");
        substanceInputMap.put("ctrl A", "selectAll");
        substanceInputMap.put("ctrl SLASH", "selectAll");
        substanceInputMap.put("ctrl BACK_SLASH", "clearSelection");
        substanceInputMap.put("SPACE", "addToSelection");
        substanceInputMap.put("ctrl SPACE", "toggleAndAnchor");
        substanceInputMap.put("shift SPACE", "extendTo");
        substanceInputMap.put("ctrl shift SPACE", "moveSelectionTo");
        return substanceInputMap;
    }

    @Override
    public SubstanceInputMap getPasswordFieldFocusInputMap() {
        SubstanceInputMap substanceInputMap = new SubstanceInputMap();
        substanceInputMap.put("ctrl C", "copy-to-clipboard");
        substanceInputMap.put("ctrl V", "paste-from-clipboard");
        substanceInputMap.put("ctrl X", "cut-to-clipboard");
        substanceInputMap.put("COPY", "copy-to-clipboard");
        substanceInputMap.put("PASTE", "paste-from-clipboard");
        substanceInputMap.put("CUT", "cut-to-clipboard");
        substanceInputMap.put("control INSERT", "copy-to-clipboard");
        substanceInputMap.put("shift INSERT", "paste-from-clipboard");
        substanceInputMap.put("shift DELETE", "cut-to-clipboard");
        substanceInputMap.put("shift LEFT", "selection-backward");
        substanceInputMap.put("shift KP_LEFT", "selection-backward");
        substanceInputMap.put("shift RIGHT", "selection-forward");
        substanceInputMap.put("shift KP_RIGHT", "selection-forward");
        substanceInputMap.put("ctrl LEFT", "caret-begin-line");
        substanceInputMap.put("ctrl KP_LEFT", "caret-begin-line");
        substanceInputMap.put("ctrl RIGHT", "caret-end-line");
        substanceInputMap.put("ctrl KP_RIGHT", "caret-end-line");
        substanceInputMap.put("ctrl shift LEFT", "selection-begin-line");
        substanceInputMap.put("ctrl shift KP_LEFT", "selection-begin-line");
        substanceInputMap.put("ctrl shift RIGHT", "selection-end-line");
        substanceInputMap.put("ctrl shift KP_RIGHT", "selection-end-line");
        substanceInputMap.put("ctrl A", "select-all");
        substanceInputMap.put("HOME", "caret-begin-line");
        substanceInputMap.put("END", "caret-end-line");
        substanceInputMap.put("shift HOME", "selection-begin-line");
        substanceInputMap.put("shift END", "selection-end-line");
        substanceInputMap.put("BACK_SPACE", "delete-previous");
        substanceInputMap.put("shift BACK_SPACE", "delete-previous");
        substanceInputMap.put("ctrl H", "delete-previous");
        substanceInputMap.put("DELETE", "delete-next");
        substanceInputMap.put("RIGHT", "caret-forward");
        substanceInputMap.put("LEFT", "caret-backward");
        substanceInputMap.put("KP_RIGHT", "caret-forward");
        substanceInputMap.put("KP_LEFT", "caret-backward");
        substanceInputMap.put("ENTER", "notify-field-accept");
        substanceInputMap.put("ctrl BACK_SLASH", "unselect");
        substanceInputMap.put("control shift O", "toggle-componentOrientation");
        return substanceInputMap;
    }

    @Override
    public SubstanceInputMap getRadioButtonFocusInputMap() {
        return this.getActionControlFocusInputMap();
    }

    @Override
    public SubstanceInputMap getRootPaneAncestorInputMap() {
        SubstanceInputMap substanceInputMap = new SubstanceInputMap();
        substanceInputMap.put("shift F10", "postPopup");
        substanceInputMap.put("CONTEXT_MENU", "postPopup");
        return substanceInputMap;
    }

    @Override
    public SubstanceInputMap getScrollBarAncestorInputMap() {
        SubstanceInputMap substanceInputMap = new SubstanceInputMap();
        substanceInputMap.put("RIGHT", "positiveUnitIncrement");
        substanceInputMap.put("KP_RIGHT", "positiveUnitIncrement");
        substanceInputMap.put("DOWN", "positiveUnitIncrement");
        substanceInputMap.put("KP_DOWN", "positiveUnitIncrement");
        substanceInputMap.put("PAGE_DOWN", "positiveBlockIncrement");
        substanceInputMap.put("LEFT", "negativeUnitIncrement");
        substanceInputMap.put("KP_LEFT", "negativeUnitIncrement");
        substanceInputMap.put("UP", "negativeUnitIncrement");
        substanceInputMap.put("KP_UP", "negativeUnitIncrement");
        substanceInputMap.put("PAGE_UP", "negativeBlockIncrement");
        substanceInputMap.put("HOME", "minScroll");
        substanceInputMap.put("END", "maxScroll");
        return substanceInputMap;
    }

    @Override
    public SubstanceInputMap getScrollPaneAncestorInputMap() {
        SubstanceInputMap substanceInputMap = new SubstanceInputMap();
        substanceInputMap.put("RIGHT", "unitScrollRight");
        substanceInputMap.put("KP_RIGHT", "unitScrollRight");
        substanceInputMap.put("DOWN", "unitScrollDown");
        substanceInputMap.put("KP_DOWN", "unitScrollDown");
        substanceInputMap.put("LEFT", "unitScrollLeft");
        substanceInputMap.put("KP_LEFT", "unitScrollLeft");
        substanceInputMap.put("UP", "unitScrollUp");
        substanceInputMap.put("KP_UP", "unitScrollUp");
        substanceInputMap.put("PAGE_UP", "scrollUp");
        substanceInputMap.put("PAGE_DOWN", "scrollDown");
        substanceInputMap.put("ctrl PAGE_UP", "scrollLeft");
        substanceInputMap.put("ctrl PAGE_DOWN", "scrollRight");
        substanceInputMap.put("ctrl HOME", "scrollHome");
        substanceInputMap.put("ctrl END", "scrollEnd");
        return substanceInputMap;
    }

    @Override
    public SubstanceInputMap getSliderFocusInputMap() {
        SubstanceInputMap substanceInputMap = new SubstanceInputMap();
        substanceInputMap.put("RIGHT", "positiveUnitIncrement");
        substanceInputMap.put("KP_RIGHT", "positiveUnitIncrement");
        substanceInputMap.put("DOWN", "negativeUnitIncrement");
        substanceInputMap.put("KP_DOWN", "negativeUnitIncrement");
        substanceInputMap.put("LEFT", "negativeUnitIncrement");
        substanceInputMap.put("KP_LEFT", "negativeUnitIncrement");
        substanceInputMap.put("UP", "positiveUnitIncrement");
        substanceInputMap.put("KP_UP", "positiveUnitIncrement");
        substanceInputMap.put("PAGE_DOWN", "negativeBlockIncrement");
        substanceInputMap.put("ctrl PAGE_DOWN", "negativeBlockIncrement");
        substanceInputMap.put("PAGE_UP", "positiveBlockIncrement");
        substanceInputMap.put("ctrl PAGE_UP", "positiveBlockIncrement");
        substanceInputMap.put("HOME", "minScroll");
        substanceInputMap.put("END", "maxScroll");
        return substanceInputMap;
    }

    @Override
    public SubstanceInputMap getSpinnerAncestorInputMap() {
        SubstanceInputMap substanceInputMap = new SubstanceInputMap();
        substanceInputMap.put("UP", "increment");
        substanceInputMap.put("KP_UP", "increment");
        substanceInputMap.put("DOWN", "decrement");
        substanceInputMap.put("KP_DOWN", "decrement");
        return substanceInputMap;
    }

    @Override
    public SubstanceInputMap getSplitPaneAncestorInputMap() {
        SubstanceInputMap substanceInputMap = new SubstanceInputMap();
        substanceInputMap.put("UP", "negativeIncrement");
        substanceInputMap.put("DOWN", "positiveIncrement");
        substanceInputMap.put("LEFT", "negativeIncrement");
        substanceInputMap.put("RIGHT", "positiveIncrement");
        substanceInputMap.put("KP_UP", "negativeIncrement");
        substanceInputMap.put("KP_DOWN", "positiveIncrement");
        substanceInputMap.put("KP_LEFT", "negativeIncrement");
        substanceInputMap.put("KP_RIGHT", "positiveIncrement");
        substanceInputMap.put("HOME", "selectMin");
        substanceInputMap.put("END", "selectMax");
        substanceInputMap.put("F8", "startResize");
        substanceInputMap.put("F6", "toggleFocus");
        substanceInputMap.put("ctrl TAB", "focusOutForward");
        substanceInputMap.put("ctrl shift TAB", "focusOutBackward");
        return substanceInputMap;
    }

    @Override
    public SubstanceInputMap getTabbedPaneAncestorInputMap() {
        SubstanceInputMap substanceInputMap = new SubstanceInputMap();
        substanceInputMap.put("ctrl PAGE_DOWN", "navigatePageDown");
        substanceInputMap.put("ctrl PAGE_UP", "navigatePageUp");
        substanceInputMap.put("ctrl UP", "requestFocus");
        substanceInputMap.put("ctrl KP_UP", "requestFocus");
        return substanceInputMap;
    }

    @Override
    public SubstanceInputMap getTabbedPaneFocusInputMap() {
        SubstanceInputMap substanceInputMap = new SubstanceInputMap();
        substanceInputMap.put("RIGHT", "navigateRight");
        substanceInputMap.put("KP_RIGHT", "navigateRight");
        substanceInputMap.put("LEFT", "navigateLeft");
        substanceInputMap.put("KP_LEFT", "navigateLeft");
        substanceInputMap.put("UP", "navigateUp");
        substanceInputMap.put("KP_UP", "navigateUp");
        substanceInputMap.put("DOWN", "navigateDown");
        substanceInputMap.put("KP_DOWN", "navigateDown");
        substanceInputMap.put("ctrl DOWN", "requestFocusForVisibleComponent");
        substanceInputMap.put("ctrl KP_DOWN", "requestFocusForVisibleComponent");
        return substanceInputMap;
    }

    @Override
    public SubstanceInputMap getTableAncestorInputMap() {
        SubstanceInputMap substanceInputMap = new SubstanceInputMap();
        substanceInputMap.put("ctrl C", COPY);
        substanceInputMap.put("ctrl V", PASTE);
        substanceInputMap.put("ctrl X", CUT);
        substanceInputMap.put("COPY", COPY);
        substanceInputMap.put("PASTE", PASTE);
        substanceInputMap.put("CUT", CUT);
        substanceInputMap.put("control INSERT", COPY);
        substanceInputMap.put("shift INSERT", PASTE);
        substanceInputMap.put("shift DELETE", CUT);
        substanceInputMap.put("RIGHT", "selectNextColumn");
        substanceInputMap.put("KP_RIGHT", "selectNextColumn");
        substanceInputMap.put("shift RIGHT", "selectNextColumnExtendSelection");
        substanceInputMap.put("shift KP_RIGHT", "selectNextColumnExtendSelection");
        substanceInputMap.put("ctrl shift RIGHT", "selectNextColumnExtendSelection");
        substanceInputMap.put("ctrl shift KP_RIGHT", "selectNextColumnExtendSelection");
        substanceInputMap.put("ctrl RIGHT", "selectNextColumnChangeLead");
        substanceInputMap.put("ctrl KP_RIGHT", "selectNextColumnChangeLead");
        substanceInputMap.put("LEFT", "selectPreviousColumn");
        substanceInputMap.put("KP_LEFT", "selectPreviousColumn");
        substanceInputMap.put("shift LEFT", "selectPreviousColumnExtendSelection");
        substanceInputMap.put("shift KP_LEFT", "selectPreviousColumnExtendSelection");
        substanceInputMap.put("ctrl shift LEFT", "selectPreviousColumnExtendSelection");
        substanceInputMap.put("ctrl shift KP_LEFT", "selectPreviousColumnExtendSelection");
        substanceInputMap.put("ctrl LEFT", "selectPreviousColumnChangeLead");
        substanceInputMap.put("ctrl KP_LEFT", "selectPreviousColumnChangeLead");
        substanceInputMap.put("DOWN", "selectNextRow");
        substanceInputMap.put("KP_DOWN", "selectNextRow");
        substanceInputMap.put("shift DOWN", "selectNextRowExtendSelection");
        substanceInputMap.put("shift KP_DOWN", "selectNextRowExtendSelection");
        substanceInputMap.put("ctrl shift DOWN", "selectNextRowExtendSelection");
        substanceInputMap.put("ctrl shift KP_DOWN", "selectNextRowExtendSelection");
        substanceInputMap.put("ctrl DOWN", "selectNextRowChangeLead");
        substanceInputMap.put("ctrl KP_DOWN", "selectNextRowChangeLead");
        substanceInputMap.put("UP", "selectPreviousRow");
        substanceInputMap.put("KP_UP", "selectPreviousRow");
        substanceInputMap.put("shift UP", "selectPreviousRowExtendSelection");
        substanceInputMap.put("shift KP_UP", "selectPreviousRowExtendSelection");
        substanceInputMap.put("ctrl shift UP", "selectPreviousRowExtendSelection");
        substanceInputMap.put("ctrl shift KP_UP", "selectPreviousRowExtendSelection");
        substanceInputMap.put("ctrl UP", "selectPreviousRowChangeLead");
        substanceInputMap.put("ctrl KP_UP", "selectPreviousRowChangeLead");
        substanceInputMap.put("HOME", "selectFirstColumn");
        substanceInputMap.put("shift HOME", "selectFirstColumnExtendSelection");
        substanceInputMap.put("ctrl shift HOME", "selectFirstRowExtendSelection");
        substanceInputMap.put("ctrl HOME", "selectFirstRow");
        substanceInputMap.put("END", "selectLastColumn");
        substanceInputMap.put("shift END", "selectLastColumnExtendSelection");
        substanceInputMap.put("ctrl shift END", "selectLastRowExtendSelection");
        substanceInputMap.put("ctrl END", "selectLastRow");
        substanceInputMap.put("PAGE_UP", "scrollUpChangeSelection");
        substanceInputMap.put("shift PAGE_UP", "scrollUpExtendSelection");
        substanceInputMap.put("ctrl shift PAGE_UP", "scrollLeftExtendSelection");
        substanceInputMap.put("ctrl PAGE_UP", "scrollLeftChangeSelection");
        substanceInputMap.put("PAGE_DOWN", "scrollDownChangeSelection");
        substanceInputMap.put("shift PAGE_DOWN", "scrollDownExtendSelection");
        substanceInputMap.put("ctrl shift PAGE_DOWN", "scrollRightExtendSelection");
        substanceInputMap.put("ctrl PAGE_DOWN", "scrollRightChangeSelection");
        substanceInputMap.put("TAB", "selectNextColumnCell");
        substanceInputMap.put("shift TAB", "selectPreviousColumnCell");
        substanceInputMap.put("ENTER", "selectNextRowCell");
        substanceInputMap.put("shift ENTER", "selectPreviousRowCell");
        substanceInputMap.put("ctrl A", "selectAll");
        substanceInputMap.put("ctrl SLASH", "selectAll");
        substanceInputMap.put("ctrl BACK_SLASH", "clearSelection");
        substanceInputMap.put("ESCAPE", "cancel");
        substanceInputMap.put("F2", "startEditing");
        substanceInputMap.put("SPACE", "addToSelection");
        substanceInputMap.put("ctrl SPACE", "toggleAndAnchor");
        substanceInputMap.put("shift SPACE", "extendTo");
        substanceInputMap.put("ctrl shift SPACE", "moveSelectionTo");
        substanceInputMap.put("F8", "focusHeader");
        return substanceInputMap;
    }

    @Override
    public SubstanceInputMap getTableHeaderAncestorInputMap() {
        SubstanceInputMap substanceInputMap = new SubstanceInputMap();
        substanceInputMap.put("SPACE", "toggleSortOrder");
        substanceInputMap.put("LEFT", "selectColumnToLeft");
        substanceInputMap.put("KP_LEFT", "selectColumnToLeft");
        substanceInputMap.put("RIGHT", "selectColumnToRight");
        substanceInputMap.put("KP_RIGHT", "selectColumnToRight");
        substanceInputMap.put("alt LEFT", "moveColumnLeft");
        substanceInputMap.put("alt KP_LEFT", "moveColumnLeft");
        substanceInputMap.put("alt RIGHT", "moveColumnRight");
        substanceInputMap.put("alt KP_RIGHT", "moveColumnRight");
        substanceInputMap.put("alt shift LEFT", "resizeLeft");
        substanceInputMap.put("alt shift KP_LEFT", "resizeLeft");
        substanceInputMap.put("alt shift RIGHT", "resizeRight");
        substanceInputMap.put("alt shift KP_RIGHT", "resizeRight");
        substanceInputMap.put("ESCAPE", "focusTable");
        return substanceInputMap;
    }

    @Override
    public SubstanceInputMap getTextAreaFocusInputMap() {
        return this.getMultilineTextComponentFocusInputMap();
    }

    @Override
    public SubstanceInputMap getTextFieldFocusInputMap() {
        SubstanceInputMap substanceInputMap = new SubstanceInputMap();
        substanceInputMap.put("ctrl C", "copy-to-clipboard");
        substanceInputMap.put("ctrl V", "paste-from-clipboard");
        substanceInputMap.put("ctrl X", "cut-to-clipboard");
        substanceInputMap.put("COPY", "copy-to-clipboard");
        substanceInputMap.put("PASTE", "paste-from-clipboard");
        substanceInputMap.put("CUT", "cut-to-clipboard");
        substanceInputMap.put("control INSERT", "copy-to-clipboard");
        substanceInputMap.put("shift INSERT", "paste-from-clipboard");
        substanceInputMap.put("shift DELETE", "cut-to-clipboard");
        substanceInputMap.put("shift LEFT", "selection-backward");
        substanceInputMap.put("shift KP_LEFT", "selection-backward");
        substanceInputMap.put("shift RIGHT", "selection-forward");
        substanceInputMap.put("shift KP_RIGHT", "selection-forward");
        substanceInputMap.put("ctrl LEFT", "caret-previous-word");
        substanceInputMap.put("ctrl KP_LEFT", "caret-previous-word");
        substanceInputMap.put("ctrl RIGHT", "caret-next-word");
        substanceInputMap.put("ctrl KP_RIGHT", "caret-next-word");
        substanceInputMap.put("ctrl shift LEFT", "selection-previous-word");
        substanceInputMap.put("ctrl shift KP_LEFT", "selection-previous-word");
        substanceInputMap.put("ctrl shift RIGHT", "selection-next-word");
        substanceInputMap.put("ctrl shift KP_RIGHT", "selection-next-word");
        substanceInputMap.put("ctrl A", "select-all");
        substanceInputMap.put("HOME", "caret-begin-line");
        substanceInputMap.put("END", "caret-end-line");
        substanceInputMap.put("shift HOME", "selection-begin-line");
        substanceInputMap.put("shift END", "selection-end-line");
        substanceInputMap.put("BACK_SPACE", "delete-previous");
        substanceInputMap.put("shift BACK_SPACE", "delete-previous");
        substanceInputMap.put("ctrl H", "delete-previous");
        substanceInputMap.put("DELETE", "delete-next");
        substanceInputMap.put("ctrl DELETE", "delete-next-word");
        substanceInputMap.put("ctrl BACK_SPACE", "delete-previous-word");
        substanceInputMap.put("RIGHT", "caret-forward");
        substanceInputMap.put("LEFT", "caret-backward");
        substanceInputMap.put("KP_RIGHT", "caret-forward");
        substanceInputMap.put("KP_LEFT", "caret-backward");
        substanceInputMap.put("ENTER", "notify-field-accept");
        substanceInputMap.put("ctrl BACK_SLASH", "unselect");
        substanceInputMap.put("control shift O", "toggle-componentOrientation");
        return substanceInputMap;
    }

    @Override
    public SubstanceInputMap getTextPaneFocusInputMap() {
        return this.getMultilineTextComponentFocusInputMap();
    }

    @Override
    public SubstanceInputMap getToggleButtonFocusInputMap() {
        return this.getActionControlFocusInputMap();
    }

    @Override
    public SubstanceInputMap getToolBarAncestorInputMap() {
        SubstanceInputMap substanceInputMap = new SubstanceInputMap();
        substanceInputMap.put("UP", "navigateUp");
        substanceInputMap.put("KP_UP", "navigateUp");
        substanceInputMap.put("DOWN", "navigateDown");
        substanceInputMap.put("KP_DOWN", "navigateDown");
        substanceInputMap.put("LEFT", "navigateLeft");
        substanceInputMap.put("KP_LEFT", "navigateLeft");
        substanceInputMap.put("RIGHT", "navigateRight");
        substanceInputMap.put("KP_RIGHT", "navigateRight");
        return substanceInputMap;
    }

    @Override
    public SubstanceInputMap getTreeAncestorInputMap() {
        SubstanceInputMap substanceInputMap = new SubstanceInputMap();
        substanceInputMap.put("ESCAPE", "cancel");
        return substanceInputMap;
    }

    @Override
    public SubstanceInputMap getTreeFocusInputMap() {
        SubstanceInputMap substanceInputMap = new SubstanceInputMap();
        substanceInputMap.put("ADD", "expand");
        substanceInputMap.put("SUBTRACT", "collapse");
        substanceInputMap.put("ctrl C", COPY);
        substanceInputMap.put("ctrl V", PASTE);
        substanceInputMap.put("ctrl X", CUT);
        substanceInputMap.put("COPY", COPY);
        substanceInputMap.put("PASTE", PASTE);
        substanceInputMap.put("CUT", CUT);
        substanceInputMap.put("control INSERT", COPY);
        substanceInputMap.put("shift INSERT", PASTE);
        substanceInputMap.put("shift DELETE", CUT);
        substanceInputMap.put("UP", "selectPrevious");
        substanceInputMap.put("KP_UP", "selectPrevious");
        substanceInputMap.put("shift UP", "selectPreviousExtendSelection");
        substanceInputMap.put("shift KP_UP", "selectPreviousExtendSelection");
        substanceInputMap.put("ctrl shift UP", "selectPreviousExtendSelection");
        substanceInputMap.put("ctrl shift KP_UP", "selectPreviousExtendSelection");
        substanceInputMap.put("ctrl UP", "selectPreviousChangeLead");
        substanceInputMap.put("ctrl KP_UP", "selectPreviousChangeLead");
        substanceInputMap.put("DOWN", "selectNext");
        substanceInputMap.put("KP_DOWN", "selectNext");
        substanceInputMap.put("shift DOWN", "selectNextExtendSelection");
        substanceInputMap.put("shift KP_DOWN", "selectNextExtendSelection");
        substanceInputMap.put("ctrl shift DOWN", "selectNextExtendSelection");
        substanceInputMap.put("ctrl shift KP_DOWN", "selectNextExtendSelection");
        substanceInputMap.put("ctrl DOWN", "selectNextChangeLead");
        substanceInputMap.put("ctrl KP_DOWN", "selectNextChangeLead");
        substanceInputMap.put("RIGHT", "selectChild");
        substanceInputMap.put("KP_RIGHT", "selectChild");
        substanceInputMap.put("LEFT", "selectParent");
        substanceInputMap.put("KP_LEFT", "selectParent");
        substanceInputMap.put("PAGE_UP", "scrollUpChangeSelection");
        substanceInputMap.put("shift PAGE_UP", "scrollUpExtendSelection");
        substanceInputMap.put("ctrl shift PAGE_UP", "scrollUpExtendSelection");
        substanceInputMap.put("ctrl PAGE_UP", "scrollUpChangeLead");
        substanceInputMap.put("PAGE_DOWN", "scrollDownChangeSelection");
        substanceInputMap.put("shift PAGE_DOWN", "scrollDownExtendSelection");
        substanceInputMap.put("ctrl shift PAGE_DOWN", "scrollDownExtendSelection");
        substanceInputMap.put("ctrl PAGE_DOWN", "scrollDownChangeLead");
        substanceInputMap.put("HOME", "selectFirst");
        substanceInputMap.put("shift HOME", "selectFirstExtendSelection");
        substanceInputMap.put("ctrl shift HOME", "selectFirstExtendSelection");
        substanceInputMap.put("ctrl HOME", "selectFirstChangeLead");
        substanceInputMap.put("END", "selectLast");
        substanceInputMap.put("shift END", "selectLastExtendSelection");
        substanceInputMap.put("ctrl shift END", "selectLastExtendSelection");
        substanceInputMap.put("ctrl END", "selectLastChangeLead");
        substanceInputMap.put("F2", "startEditing");
        substanceInputMap.put("ctrl A", "selectAll");
        substanceInputMap.put("ctrl SLASH", "selectAll");
        substanceInputMap.put("ctrl BACK_SLASH", "clearSelection");
        substanceInputMap.put("ctrl LEFT", "scrollLeft");
        substanceInputMap.put("ctrl KP_LEFT", "scrollLeft");
        substanceInputMap.put("ctrl RIGHT", "scrollRight");
        substanceInputMap.put("ctrl KP_RIGHT", "scrollRight");
        substanceInputMap.put("SPACE", "addToSelection");
        substanceInputMap.put("ctrl SPACE", "toggleAndAnchor");
        substanceInputMap.put("shift SPACE", "extendTo");
        substanceInputMap.put("ctrl shift SPACE", "moveSelectionTo");
        return substanceInputMap;
    }

    protected static class TreeActions {
        public static final String SELECT_PREVIOUS = "selectPrevious";
        public static final String SELECT_PREVIOUS_CHANGE_LEAD = "selectPreviousChangeLead";
        public static final String SELECT_PREVIOUS_EXTEND_SELECTION = "selectPreviousExtendSelection";
        public static final String SELECT_NEXT = "selectNext";
        public static final String SELECT_NEXT_CHANGE_LEAD = "selectNextChangeLead";
        public static final String SELECT_NEXT_EXTEND_SELECTION = "selectNextExtendSelection";
        public static final String SELECT_CHILD = "selectChild";
        public static final String SELECT_CHILD_CHANGE_LEAD = "selectChildChangeLead";
        public static final String SELECT_PARENT = "selectParent";
        public static final String SELECT_PARENT_CHANGE_LEAD = "selectParentChangeLead";
        public static final String SCROLL_UP_CHANGE_SELECTION = "scrollUpChangeSelection";
        public static final String SCROLL_UP_CHANGE_LEAD = "scrollUpChangeLead";
        public static final String SCROLL_UP_EXTEND_SELECTION = "scrollUpExtendSelection";
        public static final String SCROLL_DOWN_CHANGE_SELECTION = "scrollDownChangeSelection";
        public static final String SCROLL_DOWN_EXTEND_SELECTION = "scrollDownExtendSelection";
        public static final String SCROLL_DOWN_CHANGE_LEAD = "scrollDownChangeLead";
        public static final String SELECT_FIRST = "selectFirst";
        public static final String SELECT_FIRST_CHANGE_LEAD = "selectFirstChangeLead";
        public static final String SELECT_FIRST_EXTEND_SELECTION = "selectFirstExtendSelection";
        public static final String SELECT_LAST = "selectLast";
        public static final String SELECT_LAST_CHANGE_LEAD = "selectLastChangeLead";
        public static final String SELECT_LAST_EXTEND_SELECTION = "selectLastExtendSelection";
        public static final String TOGGLE = "toggle";
        public static final String CANCEL_EDITING = "cancel";
        public static final String START_EDITING = "startEditing";
        public static final String SELECT_ALL = "selectAll";
        public static final String CLEAR_SELECTION = "clearSelection";
        public static final String SCROLL_LEFT = "scrollLeft";
        public static final String SCROLL_RIGHT = "scrollRight";
        public static final String SCROLL_LEFT_EXTEND_SELECTION = "scrollLeftExtendSelection";
        public static final String SCROLL_RIGHT_EXTEND_SELECTION = "scrollRightExtendSelection";
        public static final String SCROLL_RIGHT_CHANGE_LEAD = "scrollRightChangeLead";
        public static final String SCROLL_LEFT_CHANGE_LEAD = "scrollLeftChangeLead";
        public static final String EXPAND = "expand";
        public static final String COLLAPSE = "collapse";
        public static final String MOVE_SELECTION_TO_PARENT = "moveSelectionToParent";
        public static final String ADD_TO_SELECTION = "addToSelection";
        public static final String TOGGLE_AND_ANCHOR = "toggleAndAnchor";
        public static final String EXTEND_TO = "extendTo";
        public static final String MOVE_SELECTION_TO = "moveSelectionTo";

        protected TreeActions() {
        }
    }

    protected static class ToolBarActions {
        public static final String NAVIGATE_RIGHT = "navigateRight";
        public static final String NAVIGATE_LEFT = "navigateLeft";
        public static final String NAVIGATE_UP = "navigateUp";
        public static final String NAVIGATE_DOWN = "navigateDown";

        protected ToolBarActions() {
        }
    }

    protected static class TableHeaderActions {
        public static final String TOGGLE_SORT_ORDER = "toggleSortOrder";
        public static final String SELECT_COLUMN_TO_LEFT = "selectColumnToLeft";
        public static final String SELECT_COLUMN_TO_RIGHT = "selectColumnToRight";
        public static final String MOVE_COLUMN_LEFT = "moveColumnLeft";
        public static final String MOVE_COLUMN_RIGHT = "moveColumnRight";
        public static final String RESIZE_LEFT = "resizeLeft";
        public static final String RESIZE_RIGHT = "resizeRight";
        public static final String FOCUS_TABLE = "focusTable";

        protected TableHeaderActions() {
        }
    }

    protected static class TableActions {
        public static final String CANCEL_EDITING = "cancel";
        public static final String SELECT_ALL = "selectAll";
        public static final String CLEAR_SELECTION = "clearSelection";
        public static final String START_EDITING = "startEditing";
        public static final String NEXT_ROW = "selectNextRow";
        public static final String NEXT_ROW_CELL = "selectNextRowCell";
        public static final String NEXT_ROW_EXTEND_SELECTION = "selectNextRowExtendSelection";
        public static final String NEXT_ROW_CHANGE_LEAD = "selectNextRowChangeLead";
        public static final String PREVIOUS_ROW = "selectPreviousRow";
        public static final String PREVIOUS_ROW_CELL = "selectPreviousRowCell";
        public static final String PREVIOUS_ROW_EXTEND_SELECTION = "selectPreviousRowExtendSelection";
        public static final String PREVIOUS_ROW_CHANGE_LEAD = "selectPreviousRowChangeLead";
        public static final String NEXT_COLUMN = "selectNextColumn";
        public static final String NEXT_COLUMN_CELL = "selectNextColumnCell";
        public static final String NEXT_COLUMN_EXTEND_SELECTION = "selectNextColumnExtendSelection";
        public static final String NEXT_COLUMN_CHANGE_LEAD = "selectNextColumnChangeLead";
        public static final String PREVIOUS_COLUMN = "selectPreviousColumn";
        public static final String PREVIOUS_COLUMN_CELL = "selectPreviousColumnCell";
        public static final String PREVIOUS_COLUMN_EXTEND_SELECTION = "selectPreviousColumnExtendSelection";
        public static final String PREVIOUS_COLUMN_CHANGE_LEAD = "selectPreviousColumnChangeLead";
        public static final String SCROLL_LEFT_CHANGE_SELECTION = "scrollLeftChangeSelection";
        public static final String SCROLL_LEFT_EXTEND_SELECTION = "scrollLeftExtendSelection";
        public static final String SCROLL_RIGHT_CHANGE_SELECTION = "scrollRightChangeSelection";
        public static final String SCROLL_RIGHT_EXTEND_SELECTION = "scrollRightExtendSelection";
        public static final String SCROLL_UP_CHANGE_SELECTION = "scrollUpChangeSelection";
        public static final String SCROLL_UP_EXTEND_SELECTION = "scrollUpExtendSelection";
        public static final String SCROLL_DOWN_CHANGE_SELECTION = "scrollDownChangeSelection";
        public static final String SCROLL_DOWN_EXTEND_SELECTION = "scrollDownExtendSelection";
        public static final String FIRST_COLUMN = "selectFirstColumn";
        public static final String FIRST_COLUMN_EXTEND_SELECTION = "selectFirstColumnExtendSelection";
        public static final String LAST_COLUMN = "selectLastColumn";
        public static final String LAST_COLUMN_EXTEND_SELECTION = "selectLastColumnExtendSelection";
        public static final String FIRST_ROW = "selectFirstRow";
        public static final String FIRST_ROW_EXTEND_SELECTION = "selectFirstRowExtendSelection";
        public static final String LAST_ROW = "selectLastRow";
        public static final String LAST_ROW_EXTEND_SELECTION = "selectLastRowExtendSelection";
        public static final String ADD_TO_SELECTION = "addToSelection";
        public static final String TOGGLE_AND_ANCHOR = "toggleAndAnchor";
        public static final String EXTEND_TO = "extendTo";
        public static final String MOVE_SELECTION_TO = "moveSelectionTo";
        public static final String FOCUS_HEADER = "focusHeader";

        protected TableActions() {
        }
    }

    protected static class TabbedPaneActions {
        public static final String NEXT = "navigateNext";
        public static final String PREVIOUS = "navigatePrevious";
        public static final String RIGHT = "navigateRight";
        public static final String LEFT = "navigateLeft";
        public static final String UP = "navigateUp";
        public static final String DOWN = "navigateDown";
        public static final String PAGE_UP = "navigatePageUp";
        public static final String PAGE_DOWN = "navigatePageDown";
        public static final String REQUEST_FOCUS = "requestFocus";
        public static final String REQUEST_FOCUS_FOR_VISIBLE = "requestFocusForVisibleComponent";
        public static final String SET_SELECTED = "setSelectedIndex";
        public static final String SELECT_FOCUSED = "selectTabWithFocus";
        public static final String SCROLL_FORWARD = "scrollTabsForwardAction";
        public static final String SCROLL_BACKWARD = "scrollTabsBackwardAction";

        protected TabbedPaneActions() {
        }
    }

    protected static class SplitPaneActions {
        public static final String NEGATIVE_INCREMENT = "negativeIncrement";
        public static final String POSITIVE_INCREMENT = "positiveIncrement";
        public static final String SELECT_MIN = "selectMin";
        public static final String SELECT_MAX = "selectMax";
        public static final String START_RESIZE = "startResize";
        public static final String TOGGLE_FOCUS = "toggleFocus";
        public static final String FOCUS_OUT_FORWARD = "focusOutForward";
        public static final String FOCUS_OUT_BACKWARD = "focusOutBackward";

        protected SplitPaneActions() {
        }
    }

    protected static class SliderActions {
        public static final String POSITIVE_UNIT_INCREMENT = "positiveUnitIncrement";
        public static final String POSITIVE_BLOCK_INCREMENT = "positiveBlockIncrement";
        public static final String NEGATIVE_UNIT_INCREMENT = "negativeUnitIncrement";
        public static final String NEGATIVE_BLOCK_INCREMENT = "negativeBlockIncrement";
        public static final String MIN_SCROLL_INCREMENT = "minScroll";
        public static final String MAX_SCROLL_INCREMENT = "maxScroll";

        protected SliderActions() {
        }
    }

    protected static class ScrollPaneActions {
        public static final String SCROLL_UP = "scrollUp";
        public static final String SCROLL_DOWN = "scrollDown";
        public static final String SCROLL_HOME = "scrollHome";
        public static final String SCROLL_END = "scrollEnd";
        public static final String UNIT_SCROLL_UP = "unitScrollUp";
        public static final String UNIT_SCROLL_DOWN = "unitScrollDown";
        public static final String SCROLL_LEFT = "scrollLeft";
        public static final String SCROLL_RIGHT = "scrollRight";
        public static final String UNIT_SCROLL_LEFT = "unitScrollLeft";
        public static final String UNIT_SCROLL_RIGHT = "unitScrollRight";

        protected ScrollPaneActions() {
        }
    }

    protected static class ScrollBarActions {
        public static final String POSITIVE_UNIT_INCREMENT = "positiveUnitIncrement";
        public static final String POSITIVE_BLOCK_INCREMENT = "positiveBlockIncrement";
        public static final String NEGATIVE_UNIT_INCREMENT = "negativeUnitIncrement";
        public static final String NEGATIVE_BLOCK_INCREMENT = "negativeBlockIncrement";
        public static final String MIN_SCROLL = "minScroll";
        public static final String MAX_SCROLL = "maxScroll";

        protected ScrollBarActions() {
        }
    }

    protected static class RootPaneActions {
        public static final String POST_POPUP = "postPopup";

        protected RootPaneActions() {
        }
    }

    protected static class ListActions {
        public static final String SELECT_PREVIOUS_COLUMN = "selectPreviousColumn";
        public static final String SELECT_PREVIOUS_COLUMN_EXTEND = "selectPreviousColumnExtendSelection";
        public static final String SELECT_PREVIOUS_COLUMN_CHANGE_LEAD = "selectPreviousColumnChangeLead";
        public static final String SELECT_NEXT_COLUMN = "selectNextColumn";
        public static final String SELECT_NEXT_COLUMN_EXTEND = "selectNextColumnExtendSelection";
        public static final String SELECT_NEXT_COLUMN_CHANGE_LEAD = "selectNextColumnChangeLead";
        public static final String SELECT_PREVIOUS_ROW = "selectPreviousRow";
        public static final String SELECT_PREVIOUS_ROW_EXTEND = "selectPreviousRowExtendSelection";
        public static final String SELECT_PREVIOUS_ROW_CHANGE_LEAD = "selectPreviousRowChangeLead";
        public static final String SELECT_NEXT_ROW = "selectNextRow";
        public static final String SELECT_NEXT_ROW_EXTEND = "selectNextRowExtendSelection";
        public static final String SELECT_NEXT_ROW_CHANGE_LEAD = "selectNextRowChangeLead";
        public static final String SELECT_FIRST_ROW = "selectFirstRow";
        public static final String SELECT_FIRST_ROW_EXTEND = "selectFirstRowExtendSelection";
        public static final String SELECT_FIRST_ROW_CHANGE_LEAD = "selectFirstRowChangeLead";
        public static final String SELECT_LAST_ROW = "selectLastRow";
        public static final String SELECT_LAST_ROW_EXTEND = "selectLastRowExtendSelection";
        public static final String SELECT_LAST_ROW_CHANGE_LEAD = "selectLastRowChangeLead";
        public static final String SCROLL_UP = "scrollUp";
        public static final String SCROLL_UP_EXTEND = "scrollUpExtendSelection";
        public static final String SCROLL_UP_CHANGE_LEAD = "scrollUpChangeLead";
        public static final String SCROLL_DOWN = "scrollDown";
        public static final String SCROLL_DOWN_EXTEND = "scrollDownExtendSelection";
        public static final String SCROLL_DOWN_CHANGE_LEAD = "scrollDownChangeLead";
        public static final String SELECT_ALL = "selectAll";
        public static final String CLEAR_SELECTION = "clearSelection";
        public static final String ADD_TO_SELECTION = "addToSelection";
        public static final String TOGGLE_AND_ANCHOR = "toggleAndAnchor";
        public static final String EXTEND_TO = "extendTo";
        public static final String MOVE_SELECTION_TO = "moveSelectionTo";

        protected ListActions() {
        }
    }

    protected static class FileChooserActions {
        public static final String APPROVE_SELECTION = "approveSelection";
        public static final String CANCEL_SELECTION = "cancelSelection";
        public static final String EDIT_FILE_NAME = "editFileName";
        public static final String REFRESH = "refresh";
        public static final String GO_UP = "Go Up";

        protected FileChooserActions() {
        }
    }

    protected static class TextComponentActions {
        public static final String SELECTION_PAGE_UP = "selection-page-up";
        public static final String SELECTION_PAGE_DOWN = "selection-page-down";
        public static final String SELECTION_PAGE_LEFT = "selection-page-left";
        public static final String SELECTION_PAGE_RIGHT = "selection-page-right";
        public static final String UNSELECT = "unselect";
        public static final String TOGGLE_COMPONENT_ORIENTATION = "toggle-componentOrientation";
        public static final String NEXT_LINK = "next-link-action";
        public static final String PREVIOUS_LINK = "previous-link-action";
        public static final String ACTIVATE_LINK = "activate-link-action";
        public static final String RESET_FIELD_EDIT = "reset-field-edit";
        public static final String INCREMENT = "increment";
        public static final String DECREMENT = "decrement";

        protected TextComponentActions() {
        }
    }

    protected static class DesktopPaneActions {
        public static String CLOSE = "close";
        public static String ESCAPE = "escape";
        public static String MAXIMIZE = "maximize";
        public static String MINIMIZE = "minimize";
        public static String MOVE = "move";
        public static String RESIZE = "resize";
        public static String RESTORE = "restore";
        public static String LEFT = "left";
        public static String RIGHT = "right";
        public static String UP = "up";
        public static String DOWN = "down";
        public static String SHRINK_LEFT = "shrinkLeft";
        public static String SHRINK_RIGHT = "shrinkRight";
        public static String SHRINK_UP = "shrinkUp";
        public static String SHRINK_DOWN = "shrinkDown";
        public static String NEXT_FRAME = "selectNextFrame";
        public static String PREVIOUS_FRAME = "selectPreviousFrame";
        public static String NAVIGATE_NEXT = "navigateNext";
        public static String NAVIGATE_PREVIOUS = "navigatePrevious";

        protected DesktopPaneActions() {
        }
    }

    protected static class ComboActions {
        public static final String HIDE = "hidePopup";
        public static final String DOWN = "selectNext";
        public static final String DOWN_2 = "selectNext2";
        public static final String TOGGLE = "togglePopup";
        public static final String TOGGLE_2 = "spacePopup";
        public static final String UP = "selectPrevious";
        public static final String UP_2 = "selectPrevious2";
        public static final String ENTER = "enterPressed";
        public static final String PAGE_DOWN = "pageDownPassThrough";
        public static final String PAGE_UP = "pageUpPassThrough";
        public static final String HOME = "homePassThrough";
        public static final String END = "endPassThrough";

        protected ComboActions() {
        }
    }
}

