/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.colorscheme;

import java.awt.Color;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.colorscheme.BaseColorScheme;
import org.pushingpixels.substance.internal.utils.SubstanceColorUtilities;

public class BlendBiColorScheme
extends BaseColorScheme {
    private Color mainUltraLightColor;
    private Color mainExtraLightColor;
    private Color mainLightColor;
    private Color mainMidColor;
    private Color mainDarkColor;
    private Color mainUltraDarkColor;
    private Color foregroundColor;
    private SubstanceColorScheme firstScheme;
    private SubstanceColorScheme secondScheme;
    private double firstSchemeLikeness;

    public BlendBiColorScheme(SubstanceColorScheme substanceColorScheme, SubstanceColorScheme substanceColorScheme2, double d) {
        super("Blended " + substanceColorScheme.getDisplayName() + " & " + substanceColorScheme2.getDisplayName() + " " + d, substanceColorScheme.isDark());
        this.firstScheme = substanceColorScheme;
        this.secondScheme = substanceColorScheme2;
        this.firstSchemeLikeness = d;
        this.foregroundColor = new Color(SubstanceColorUtilities.getInterpolatedRGB(substanceColorScheme.getForegroundColor(), substanceColorScheme2.getForegroundColor(), d));
        this.mainUltraDarkColor = new Color(SubstanceColorUtilities.getInterpolatedRGB(substanceColorScheme.getUltraDarkColor(), substanceColorScheme2.getUltraDarkColor(), d));
        this.mainDarkColor = new Color(SubstanceColorUtilities.getInterpolatedRGB(substanceColorScheme.getDarkColor(), substanceColorScheme2.getDarkColor(), d));
        this.mainMidColor = new Color(SubstanceColorUtilities.getInterpolatedRGB(substanceColorScheme.getMidColor(), substanceColorScheme2.getMidColor(), d));
        this.mainLightColor = new Color(SubstanceColorUtilities.getInterpolatedRGB(substanceColorScheme.getLightColor(), substanceColorScheme2.getLightColor(), d));
        this.mainExtraLightColor = new Color(SubstanceColorUtilities.getInterpolatedRGB(substanceColorScheme.getExtraLightColor(), substanceColorScheme2.getExtraLightColor(), d));
        this.mainUltraLightColor = new Color(SubstanceColorUtilities.getInterpolatedRGB(substanceColorScheme.getUltraLightColor(), substanceColorScheme2.getUltraLightColor(), d));
    }

    @Override
    public Color getForegroundColor() {
        return this.foregroundColor;
    }

    @Override
    public Color getUltraLightColor() {
        return this.mainUltraLightColor;
    }

    @Override
    public Color getExtraLightColor() {
        return this.mainExtraLightColor;
    }

    @Override
    public Color getLightColor() {
        return this.mainLightColor;
    }

    @Override
    public Color getMidColor() {
        return this.mainMidColor;
    }

    @Override
    public Color getDarkColor() {
        return this.mainDarkColor;
    }

    @Override
    public Color getUltraDarkColor() {
        return this.mainUltraDarkColor;
    }

    public double getFirstSchemeLikeness() {
        return this.firstSchemeLikeness;
    }

    public SubstanceColorScheme getFirstScheme() {
        return this.firstScheme;
    }

    public SubstanceColorScheme getSecondScheme() {
        return this.secondScheme;
    }
}

