/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.api.watermark;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.watermark.SubstanceWatermark;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;

public class SubstanceCrosshatchWatermark
implements SubstanceWatermark {
    private static Image watermarkImage = null;

    @Override
    public void drawWatermarkImage(Graphics graphics, Component component, int n, int n2, int n3, int n4) {
        if (!component.isShowing()) {
            return;
        }
        int n5 = component.getLocationOnScreen().x;
        int n6 = component.getLocationOnScreen().y;
        graphics.drawImage(watermarkImage, n, n2, n + n3, n2 + n4, n + n5, n2 + n6, n + n5 + n3, n2 + n6 + n4, null);
    }

    @Override
    public boolean updateWatermarkImage(SubstanceSkin substanceSkin) {
        GraphicsDevice[] graphicsDeviceArray;
        Rectangle rectangle = new Rectangle();
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (GraphicsDevice graphicsDevice : graphicsDeviceArray = graphicsEnvironment.getScreenDevices()) {
            GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
            rectangle = rectangle.union(graphicsConfiguration.getBounds());
        }
        int n = rectangle.width;
        int n2 = rectangle.height;
        watermarkImage = SubstanceCoreUtilities.getBlankImage(n, n2);
        Graphics2D graphics2D = (Graphics2D)watermarkImage.getGraphics().create();
        boolean bl = this.drawWatermarkImage(substanceSkin, graphics2D, 0, 0, n, n2, false);
        graphics2D.dispose();
        return bl;
    }

    @Override
    public void previewWatermark(Graphics graphics, SubstanceSkin substanceSkin, int n, int n2, int n3, int n4) {
        this.drawWatermarkImage(substanceSkin, (Graphics2D)graphics, n, n2, n3, n4, true);
    }

    private boolean drawWatermarkImage(SubstanceSkin substanceSkin, Graphics2D graphics2D, int n, int n2, int n3, int n4, boolean bl) {
        Color color = null;
        Color color2 = null;
        Color color3 = null;
        SubstanceColorScheme substanceColorScheme = substanceSkin.getWatermarkColorScheme();
        if (bl) {
            color = substanceColorScheme.isDark() ? Color.white : Color.black;
            color2 = Color.lightGray;
            color3 = substanceColorScheme.isDark() ? Color.black : Color.white;
        } else {
            color = substanceColorScheme.getWatermarkDarkColor();
            color2 = substanceColorScheme.getWatermarkStampColor();
            color3 = substanceColorScheme.getWatermarkLightColor();
        }
        graphics2D.setColor(color2);
        graphics2D.fillRect(0, 0, n3, n4);
        BufferedImage bufferedImage = SubstanceCoreUtilities.getBlankImage(4, 4);
        bufferedImage.setRGB(0, 0, color.getRGB());
        bufferedImage.setRGB(2, 2, color.getRGB());
        bufferedImage.setRGB(0, 1, color3.getRGB());
        bufferedImage.setRGB(2, 3, color3.getRGB());
        Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
        graphics2D2.setComposite(AlphaComposite.getInstance(3, 0.4f));
        for (int i = n2; i < n2 + n4; i += 4) {
            for (int j = n; j < n + n3; j += 4) {
                graphics2D2.drawImage((Image)bufferedImage, j, i, null);
            }
        }
        graphics2D2.dispose();
        return true;
    }

    @Override
    public String getDisplayName() {
        return SubstanceCrosshatchWatermark.getName();
    }

    public static String getName() {
        return "Crosshatch";
    }

    @Override
    public void dispose() {
        watermarkImage = null;
    }
}

