/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.api.skin;

import java.awt.Color;
import org.pushingpixels.substance.api.ColorSchemeAssociationKind;
import org.pushingpixels.substance.api.ColorSchemeSingleColorQuery;
import org.pushingpixels.substance.api.ColorSchemeTransform;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.DecorationAreaType;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.SubstanceColorSchemeBundle;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.painter.border.ClassicBorderPainter;
import org.pushingpixels.substance.api.painter.border.CompositeBorderPainter;
import org.pushingpixels.substance.api.painter.border.DelegateBorderPainter;
import org.pushingpixels.substance.api.painter.decoration.MatteDecorationPainter;
import org.pushingpixels.substance.api.painter.fill.StandardFillPainter;
import org.pushingpixels.substance.api.painter.highlight.ClassicHighlightPainter;
import org.pushingpixels.substance.api.painter.overlay.BottomLineOverlayPainter;
import org.pushingpixels.substance.api.painter.overlay.TopLineOverlayPainter;
import org.pushingpixels.substance.api.shaper.ClassicButtonShaper;

public class DustSkin
extends SubstanceSkin {
    public static final String NAME = "Dust";
    private BottomLineOverlayPainter menuOverlayPainter;
    private TopLineOverlayPainter toolbarOverlayPainter;

    public DustSkin() {
        SubstanceSkin.ColorSchemes colorSchemes = SubstanceSkin.getColorSchemes("org/pushingpixels/substance/api/skin/dust.colorschemes");
        SubstanceColorScheme substanceColorScheme = colorSchemes.get("Dust Active");
        SubstanceColorScheme substanceColorScheme2 = colorSchemes.get("Dust Enabled");
        SubstanceColorSchemeBundle substanceColorSchemeBundle = new SubstanceColorSchemeBundle(substanceColorScheme, substanceColorScheme2, substanceColorScheme2);
        substanceColorSchemeBundle.registerColorScheme(substanceColorScheme2, 0.5f, ComponentState.DISABLED_UNSELECTED);
        substanceColorSchemeBundle.registerColorScheme(substanceColorScheme, 0.5f, ComponentState.DISABLED_SELECTED);
        SubstanceColorScheme substanceColorScheme3 = colorSchemes.get("Dust Border Enabled");
        SubstanceColorScheme substanceColorScheme4 = colorSchemes.get("Dust Border Active");
        substanceColorSchemeBundle.registerColorScheme(substanceColorScheme3, ColorSchemeAssociationKind.BORDER, ComponentState.ENABLED, ComponentState.DISABLED_SELECTED, ComponentState.DISABLED_UNSELECTED);
        substanceColorSchemeBundle.registerColorScheme(substanceColorScheme4, ColorSchemeAssociationKind.BORDER, ComponentState.getActiveStates());
        substanceColorSchemeBundle.registerColorScheme(substanceColorScheme3, ColorSchemeAssociationKind.MARK, new ComponentState[0]);
        this.registerDecorationAreaSchemeBundle(substanceColorSchemeBundle, DecorationAreaType.NONE);
        SubstanceColorScheme substanceColorScheme5 = colorSchemes.get("Dust Header Active");
        SubstanceColorScheme substanceColorScheme6 = colorSchemes.get("Dust Header Enabled");
        SubstanceColorScheme substanceColorScheme7 = colorSchemes.get("Dust Header Watermark");
        SubstanceColorScheme substanceColorScheme8 = colorSchemes.get("Dust Header Separator");
        SubstanceColorScheme substanceColorScheme9 = colorSchemes.get("Dust Header Border");
        SubstanceColorSchemeBundle substanceColorSchemeBundle2 = new SubstanceColorSchemeBundle(substanceColorScheme5, substanceColorScheme6, substanceColorScheme6);
        substanceColorSchemeBundle2.registerColorScheme(substanceColorScheme6, 0.7f, ComponentState.DISABLED_UNSELECTED);
        substanceColorSchemeBundle2.registerColorScheme(substanceColorScheme5, 0.7f, ComponentState.DISABLED_SELECTED);
        substanceColorSchemeBundle2.registerColorScheme(substanceColorScheme9, ColorSchemeAssociationKind.BORDER, new ComponentState[0]);
        substanceColorSchemeBundle2.registerColorScheme(substanceColorScheme8, ColorSchemeAssociationKind.SEPARATOR, new ComponentState[0]);
        substanceColorSchemeBundle2.registerHighlightColorScheme(substanceColorScheme5, 1.0f, new ComponentState[0]);
        substanceColorSchemeBundle2.registerHighlightColorScheme(substanceColorScheme5, 0.0f, ComponentState.ENABLED);
        this.registerDecorationAreaSchemeBundle(substanceColorSchemeBundle2, DecorationAreaType.TOOLBAR);
        this.registerDecorationAreaSchemeBundle(substanceColorSchemeBundle2, substanceColorScheme7, DecorationAreaType.PRIMARY_TITLE_PANE, DecorationAreaType.SECONDARY_TITLE_PANE, DecorationAreaType.HEADER, DecorationAreaType.FOOTER);
        this.setSelectedTabFadeStart(0.1);
        this.setSelectedTabFadeEnd(0.3);
        this.menuOverlayPainter = new BottomLineOverlayPainter(new ColorSchemeSingleColorQuery(){

            @Override
            public Color query(SubstanceColorScheme substanceColorScheme) {
                return substanceColorScheme.getUltraDarkColor().darker();
            }
        });
        this.toolbarOverlayPainter = new TopLineOverlayPainter(new ColorSchemeSingleColorQuery(){

            @Override
            public Color query(SubstanceColorScheme substanceColorScheme) {
                Color color = substanceColorScheme.getForegroundColor();
                return new Color(color.getRed(), color.getGreen(), color.getBlue(), 32);
            }
        });
        this.addOverlayPainter(this.menuOverlayPainter, DecorationAreaType.HEADER);
        this.addOverlayPainter(this.toolbarOverlayPainter, DecorationAreaType.TOOLBAR);
        this.buttonShaper = new ClassicButtonShaper();
        this.watermark = null;
        this.fillPainter = new StandardFillPainter();
        this.decorationPainter = new MatteDecorationPainter();
        this.highlightPainter = new ClassicHighlightPainter();
        this.borderPainter = new CompositeBorderPainter(NAME, new ClassicBorderPainter(), new DelegateBorderPainter("Dust Inner", new ClassicBorderPainter(), 0x60FFFFFF, 0x30FFFFFF, 0x18FFFFFF, new ColorSchemeTransform(){

            @Override
            public SubstanceColorScheme transform(SubstanceColorScheme substanceColorScheme) {
                return substanceColorScheme.shiftBackground(substanceColorScheme.getUltraLightColor(), 0.8).tint(0.6).saturate(0.2);
            }
        }));
    }

    @Override
    public String getDisplayName() {
        return NAME;
    }
}

