/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.api.renderers;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.TableUI;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.pushingpixels.substance.api.ColorSchemeAssociationKind;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.api.renderers.SubstanceRenderer;
import org.pushingpixels.substance.internal.animation.StateTransitionTracker;
import org.pushingpixels.substance.internal.ui.SubstanceTableUI;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceStripingUtils;
import org.pushingpixels.substance.internal.utils.UpdateOptimizationInfo;
import org.pushingpixels.substance.internal.utils.border.SubstanceTableCellBorder;

@SubstanceRenderer
public class SubstanceDefaultTableCellRenderer
extends DefaultTableCellRenderer {
    public SubstanceDefaultTableCellRenderer() {
        this.putClientProperty("substancelaf.colorizationFactor", 1.0);
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        Object object2;
        Object object3;
        boolean bl3;
        if (!SubstanceLookAndFeel.isCurrentLookAndFeel()) {
            return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }
        TableUI tableUI = jTable.getUI();
        SubstanceTableUI substanceTableUI = (SubstanceTableUI)tableUI;
        bl2 = substanceTableUI.isFocusedCell(n, n2);
        SubstanceTableUI.TableCellId tableCellId = new SubstanceTableUI.TableCellId(n, n2);
        StateTransitionTracker.ModelStateInfo modelStateInfo = substanceTableUI.getModelStateInfo(tableCellId);
        ComponentState componentState = substanceTableUI.getCellState(tableCellId);
        JTable.DropLocation dropLocation = jTable.getDropLocation();
        boolean bl4 = bl3 = dropLocation != null && !dropLocation.isInsertRow() && !dropLocation.isInsertColumn() && dropLocation.getRow() == n && dropLocation.getColumn() == n2;
        if (!bl3 && modelStateInfo != null) {
            if (substanceTableUI.hasRolloverAnimations() || substanceTableUI.hasSelectionAnimations()) {
                object3 = modelStateInfo.getStateContributionMap();
                object2 = this.getColorSchemeForState(jTable, substanceTableUI, componentState);
                if (componentState.isDisabled() || object3 == null || object3.size() == 1) {
                    super.setForeground(new ColorUIResource(object2.getForegroundColor()));
                } else {
                    float f = 0.0f;
                    float f2 = 0.0f;
                    float f3 = 0.0f;
                    for (Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> entry : modelStateInfo.getStateContributionMap().entrySet()) {
                        ComponentState componentState2 = entry.getKey();
                        SubstanceColorScheme substanceColorScheme = this.getColorSchemeForState(jTable, substanceTableUI, componentState2);
                        Color color = substanceColorScheme.getForegroundColor();
                        float f4 = entry.getValue().getContribution();
                        f += (float)color.getRed() * f4;
                        f2 += (float)color.getGreen() * f4;
                        f3 += (float)color.getBlue() * f4;
                    }
                    super.setForeground(new ColorUIResource(new Color((int)f, (int)f2, (int)f3)));
                }
            } else {
                object3 = this.getColorSchemeForState(jTable, substanceTableUI, componentState);
                super.setForeground(new ColorUIResource(object3.getForegroundColor()));
            }
        } else {
            object3 = this.getColorSchemeForState(jTable, substanceTableUI, componentState);
            if (bl3) {
                object3 = SubstanceColorSchemeUtilities.getColorScheme(jTable, ColorSchemeAssociationKind.TEXT_HIGHLIGHT, componentState);
            }
            super.setForeground(new ColorUIResource(object3.getForegroundColor()));
        }
        SubstanceStripingUtils.applyStripedBackground(jTable, n, this);
        this.setFont(jTable.getFont());
        object3 = new SubstanceTableUI.TableCellId(n, n2);
        object2 = substanceTableUI.getStateTransitionTracker((SubstanceTableUI.TableCellId)object3);
        Insets insets = substanceTableUI.getCellRendererInsets();
        if (bl2 || object2 != null) {
            SubstanceTableCellBorder substanceTableCellBorder = new SubstanceTableCellBorder(insets, substanceTableUI, (SubstanceTableUI.TableCellId)object3);
            if (object2 != null) {
                substanceTableCellBorder.setAlpha(((StateTransitionTracker)object2).getFocusStrength(bl2));
            }
            if (!jTable.getShowHorizontalLines() && !jTable.getShowVerticalLines()) {
                this.setBorder(new CompoundBorder(new EmptyBorder(jTable.getRowMargin() / 2, 0, jTable.getRowMargin() / 2, 0), substanceTableCellBorder));
            } else {
                this.setBorder(substanceTableCellBorder);
            }
        } else {
            this.setBorder(new EmptyBorder(insets.top, insets.left, insets.bottom, insets.right));
        }
        this.setValue(object);
        this.setOpaque(false);
        this.setEnabled(jTable.isEnabled());
        return this;
    }

    private SubstanceColorScheme getColorSchemeForState(JTable jTable, SubstanceTableUI substanceTableUI, ComponentState componentState) {
        UpdateOptimizationInfo updateOptimizationInfo = substanceTableUI.getUpdateOptimizationInfo();
        if (componentState == ComponentState.ENABLED) {
            if (updateOptimizationInfo == null) {
                return SubstanceColorSchemeUtilities.getColorScheme(jTable, componentState);
            }
            return updateOptimizationInfo.getDefaultScheme();
        }
        if (updateOptimizationInfo == null) {
            return SubstanceColorSchemeUtilities.getColorScheme(jTable, ColorSchemeAssociationKind.HIGHLIGHT, componentState);
        }
        return updateOptimizationInfo.getHighlightColorScheme(componentState);
    }

    @Override
    public final void paint(Graphics graphics) {
        super.paint(graphics);
    }

    @Override
    protected final void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
    }

    @Override
    protected final void paintBorder(Graphics graphics) {
        super.paintBorder(graphics);
    }

    @Override
    public final void paintComponents(Graphics graphics) {
    }

    public static class DateRenderer
    extends SubstanceDefaultTableCellRenderer {
        DateFormat formatter;

        @Override
        public void setValue(Object object) {
            if (this.formatter == null) {
                this.formatter = DateFormat.getDateInstance();
            }
            this.setText(object == null ? "" : this.formatter.format(object));
        }
    }

    public static class DoubleRenderer
    extends NumberRenderer {
        NumberFormat formatter;

        @Override
        public void setValue(Object object) {
            if (this.formatter == null) {
                this.formatter = NumberFormat.getInstance();
            }
            this.setText(object == null ? "" : this.formatter.format(object));
        }
    }

    public static class NumberRenderer
    extends SubstanceDefaultTableCellRenderer {
        public NumberRenderer() {
            this.setHorizontalAlignment(4);
        }
    }

    public static class IconRenderer
    extends SubstanceDefaultTableCellRenderer {
        public IconRenderer() {
            this.setHorizontalAlignment(0);
        }

        @Override
        public void setValue(Object object) {
            this.setIcon(object instanceof Icon ? (Icon)object : null);
            this.setText(null);
        }
    }

    @SubstanceRenderer
    public static class BooleanRenderer
    extends JCheckBox
    implements TableCellRenderer {
        private static final Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);

        public BooleanRenderer() {
            this.setHorizontalAlignment(0);
            this.setBorderPainted(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (bl) {
                this.setForeground(jTable.getSelectionForeground());
            } else {
                this.setForeground(jTable.getForeground());
            }
            SubstanceStripingUtils.applyStripedBackground(jTable, n, this);
            this.setSelected(object != null && (Boolean)object != false);
            this.setEnabled(jTable.isEnabled());
            TableUI tableUI = jTable.getUI();
            if (tableUI instanceof SubstanceTableUI) {
                SubstanceTableUI substanceTableUI = (SubstanceTableUI)tableUI;
                bl2 = substanceTableUI.isFocusedCell(n, n2);
                SubstanceTableUI.TableCellId tableCellId = new SubstanceTableUI.TableCellId(n, n2);
                StateTransitionTracker stateTransitionTracker = substanceTableUI.getStateTransitionTracker(tableCellId);
                if (bl2 || stateTransitionTracker != null) {
                    SubstanceTableCellBorder substanceTableCellBorder = new SubstanceTableCellBorder(new Insets(0, 0, 0, 0), substanceTableUI, tableCellId);
                    if (stateTransitionTracker != null) {
                        substanceTableCellBorder.setAlpha(stateTransitionTracker.getFocusStrength(bl2));
                    }
                    this.setBorder(substanceTableCellBorder);
                } else {
                    this.setBorder(noFocusBorder);
                }
            } else if (bl2) {
                this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            } else {
                this.setBorder(noFocusBorder);
            }
            this.setOpaque(false);
            return this;
        }

        @Override
        public final void paint(Graphics graphics) {
            super.paint(graphics);
        }

        @Override
        protected final void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
        }

        @Override
        protected final void paintBorder(Graphics graphics) {
            super.paintBorder(graphics);
        }

        @Override
        public final void paintComponents(Graphics graphics) {
        }
    }
}

