/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.api.painter.decoration;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import org.pushingpixels.substance.api.DecorationAreaType;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.painter.decoration.SubstanceDecorationPainter;
import org.pushingpixels.substance.api.painter.fill.ClassicFillPainter;
import org.pushingpixels.substance.internal.utils.HashMapKey;
import org.pushingpixels.substance.internal.utils.LazyResettableHashMap;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;

public class ClassicDecorationPainter
implements SubstanceDecorationPainter {
    public static final String DISPLAY_NAME = "Classic";
    protected static final LazyResettableHashMap<BufferedImage> smallImageCache = new LazyResettableHashMap("ClassicDecorationPainter");
    protected ClassicFillPainter painter = new ClassicFillPainter();

    @Override
    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    @Override
    public void paintDecorationArea(Graphics2D graphics2D, Component component, DecorationAreaType decorationAreaType, int n, int n2, SubstanceSkin substanceSkin) {
        SubstanceColorScheme substanceColorScheme = substanceSkin.getBackgroundColorScheme(decorationAreaType);
        if (n * n2 < 100000) {
            HashMapKey hashMapKey = SubstanceCoreUtilities.getHashKey(n, n2, substanceColorScheme.getDisplayName());
            BufferedImage bufferedImage = smallImageCache.get(hashMapKey);
            if (bufferedImage == null) {
                bufferedImage = SubstanceCoreUtilities.getBlankImage(n, n2);
                this.internalPaint((Graphics2D)bufferedImage.getGraphics(), component, n, n2, substanceColorScheme);
                smallImageCache.put(hashMapKey, bufferedImage);
            }
            graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
            return;
        }
        this.internalPaint(graphics2D, component, n, n2, substanceColorScheme);
    }

    protected void internalPaint(Graphics2D graphics2D, Component component, int n, int n2, SubstanceColorScheme substanceColorScheme) {
        Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
        graphics2D2.translate(-3, -3);
        this.painter.paintContourBackground(graphics2D2, component, n + 6, n2 + 6, new Rectangle(n + 6, n2 + 6), false, substanceColorScheme, false);
        graphics2D2.dispose();
    }
}

