/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.application;

import java.awt.KeyboardFocusManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.WeakHashMap;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import org.jdesktop.application.AbstractBean;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationAction;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.TextActions;

public class ActionManager
extends AbstractBean {
    private static final Logger logger = Logger.getLogger(ActionManager.class.getName());
    private final ApplicationContext context;
    private final WeakHashMap<Object, WeakReference<ApplicationActionMap>> actionMaps;
    private ApplicationActionMap globalActionMap = null;

    protected ActionManager(ApplicationContext applicationContext) {
        if (applicationContext == null) {
            throw new IllegalArgumentException("null context");
        }
        this.context = applicationContext;
        this.actionMaps = new WeakHashMap();
    }

    protected final ApplicationContext getContext() {
        return this.context;
    }

    private ApplicationActionMap createActionMapChain(Class clazz, Class clazz2, Object object, ResourceMap resourceMap) {
        ArrayList arrayList = new ArrayList();
        Object object2 = clazz;
        while (true) {
            arrayList.add(object2);
            if (object2.equals(clazz2)) break;
            object2 = ((Class)object2).getSuperclass();
        }
        Collections.reverse(arrayList);
        object2 = this.getContext();
        ApplicationActionMap applicationActionMap = null;
        for (Class clazz3 : arrayList) {
            ApplicationActionMap applicationActionMap2 = new ApplicationActionMap((ApplicationContext)object2, clazz3, object, resourceMap);
            applicationActionMap2.setParent(applicationActionMap);
            applicationActionMap = applicationActionMap2;
        }
        return applicationActionMap;
    }

    public ApplicationActionMap getActionMap() {
        if (this.globalActionMap == null) {
            ApplicationContext applicationContext = this.getContext();
            Application application = applicationContext.getApplication();
            Class clazz = applicationContext.getApplicationClass();
            ResourceMap resourceMap = applicationContext.getResourceMap();
            this.globalActionMap = this.createActionMapChain(clazz, Application.class, application, resourceMap);
            this.initProxyActionSupport();
        }
        return this.globalActionMap;
    }

    private void initProxyActionSupport() {
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        keyboardFocusManager.addPropertyChangeListener(new KeyboardFocusPCL());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApplicationActionMap getActionMap(Class clazz, Object object) {
        if (clazz == null) {
            throw new IllegalArgumentException("null actionsClass");
        }
        if (object == null) {
            throw new IllegalArgumentException("null actionsObject");
        }
        if (!clazz.isAssignableFrom(object.getClass())) {
            throw new IllegalArgumentException("actionsObject not instanceof actionsClass");
        }
        WeakHashMap<Object, WeakReference<ApplicationActionMap>> weakHashMap = this.actionMaps;
        synchronized (weakHashMap) {
            ApplicationActionMap applicationActionMap;
            WeakReference<ApplicationActionMap> weakReference = this.actionMaps.get(object);
            ApplicationActionMap applicationActionMap2 = applicationActionMap = weakReference != null ? (ApplicationActionMap)weakReference.get() : null;
            if (applicationActionMap == null || applicationActionMap.getActionsClass() != clazz) {
                ApplicationContext applicationContext = this.getContext();
                Class<?> clazz2 = object.getClass();
                ResourceMap resourceMap = applicationContext.getResourceMap(clazz2, clazz);
                ActionMap actionMap = applicationActionMap = this.createActionMapChain(clazz2, clazz, object, resourceMap);
                while (actionMap.getParent() != null) {
                    actionMap = actionMap.getParent();
                }
                actionMap.setParent(this.getActionMap());
                this.actionMaps.put(object, new WeakReference<ApplicationActionMap>(applicationActionMap));
            }
            return applicationActionMap;
        }
    }

    private void updateAllProxyActions(JComponent jComponent, JComponent jComponent2) {
        ActionMap actionMap;
        if (jComponent2 != null && (actionMap = jComponent2.getActionMap()) != null) {
            this.updateProxyActions(this.getActionMap(), actionMap, jComponent2);
            for (WeakReference<ApplicationActionMap> weakReference : this.actionMaps.values()) {
                ApplicationActionMap applicationActionMap = (ApplicationActionMap)weakReference.get();
                if (applicationActionMap == null) continue;
                this.updateProxyActions(applicationActionMap, actionMap, jComponent2);
            }
        }
    }

    private void updateProxyActions(ApplicationActionMap applicationActionMap, ActionMap actionMap, JComponent jComponent) {
        for (ApplicationAction applicationAction : applicationActionMap.getProxyActions()) {
            String string = applicationAction.getName();
            Action action = actionMap.get(string);
            if (action != null) {
                applicationAction.setProxy(action);
                applicationAction.setProxySource(jComponent);
                continue;
            }
            applicationAction.setProxy(null);
            applicationAction.setProxySource(null);
        }
    }

    private final class KeyboardFocusPCL
    implements PropertyChangeListener {
        private final TextActions textActions;

        KeyboardFocusPCL() {
            this.textActions = new TextActions(ActionManager.this.getContext());
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("permanentFocusOwner".equals(propertyChangeEvent.getPropertyName())) {
                JComponent jComponent = ActionManager.this.getContext().getFocusOwner();
                Object object = propertyChangeEvent.getNewValue();
                JComponent jComponent2 = object instanceof JComponent ? (JComponent)object : null;
                this.textActions.updateFocusOwner(jComponent, jComponent2);
                ActionManager.this.getContext().setFocusOwner(jComponent2);
                ActionManager.this.updateAllProxyActions(jComponent, jComponent2);
            }
        }
    }
}

