/*
 * Decompiled with CFR 0.152.
 */
package jlibs.core.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import jlibs.core.util.CollectionUtil;

public class Range {
    public final int min;
    public final int max;

    public Range(int min, int max) {
        if (min > max) {
            throw new IllegalArgumentException("invalid range: [" + min + ", " + max + ']');
        }
        this.min = min;
        this.max = max;
    }

    public int hashCode() {
        return this.min + this.max;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Range) {
            Range that = (Range)obj;
            return this.min == that.min && this.max == that.max;
        }
        return false;
    }

    public String toString() {
        return "[" + this.min + ", " + this.max + ']';
    }

    public boolean before(int x) {
        return x > this.max;
    }

    public boolean after(int x) {
        return x < this.min;
    }

    public boolean contains(int x) {
        return !this.before(x) && !this.after(x);
    }

    public boolean[] position(Range that) {
        boolean before = that.after(this.min);
        boolean after = that.before(this.max);
        boolean inside = before && after ? true : (!before && !after ? true : (before ? that.contains(this.max) : that.contains(this.min)));
        return new boolean[]{before, inside, after};
    }

    public Range[] split(Range that) {
        boolean[] position = this.position(that);
        Range before = null;
        if (position[0]) {
            before = new Range(this.min, Math.min(this.max, that.min - 1));
        }
        Range after = null;
        if (position[2]) {
            after = new Range(Math.max(this.min, that.max + 1), this.max);
        }
        Range inside = null;
        if (position[1]) {
            inside = new Range(Math.max(this.min, that.min), Math.min(this.max, that.max));
        }
        return new Range[]{before, inside, after};
    }

    public Range intersection(Range that) {
        return this.split(that)[1];
    }

    public Range[] union(Range that) {
        if (this.min > that.min) {
            return that.union(this);
        }
        if (this.contains(that.min)) {
            return new Range[]{new Range(this.min, Math.max(this.max, that.max))};
        }
        return new Range[]{this, that};
    }

    public Range[] minus(Range that) {
        Range[] split = this.split(that);
        if (split[0] == null && split[2] == null) {
            return new Range[0];
        }
        if (split[0] != null && split[2] != null) {
            return new Range[]{split[0], split[2]};
        }
        return new Range[]{split[0] != null ? split[0] : split[2]};
    }

    public static List<Range> union(List<Range> ranges) {
        ranges = new ArrayList<Range>(ranges);
        Collections.sort(ranges, new Comparator<Range>(){

            @Override
            public int compare(Range r1, Range r2) {
                return r1.min - r2.min;
            }
        });
        ArrayList<Range> union = new ArrayList<Range>();
        for (Range r : ranges) {
            if (union.isEmpty()) {
                union.add(r);
                continue;
            }
            CollectionUtil.addAll(union, ((Range)union.remove(union.size() - 1)).union(r));
        }
        return union;
    }

    public static List<Range> intersection(List<Range> list1, List<Range> list2) {
        list1 = Range.union(list1);
        list2 = Range.union(list2);
        ArrayList<Range> intersection = new ArrayList<Range>();
        for (Range r1 : list1) {
            for (Range r2 : list2) {
                Range r = r1.intersection(r2);
                if (r == null) continue;
                intersection.add(r);
            }
        }
        return Range.union(intersection);
    }

    public static List<Range> minus(List<Range> list1, List<Range> list2) {
        list1 = Range.union(list1);
        list2 = Range.union(list2);
        for (Range r2 : list2) {
            ArrayList<Range> temp = new ArrayList<Range>();
            for (Range r1 : list1) {
                CollectionUtil.addAll(temp, r1.minus(r2));
            }
            list1 = temp;
        }
        return Range.union(list1);
    }

    public static boolean same(List<Range> list1, List<Range> list2) {
        list1 = Range.union(list1);
        list2 = Range.union(list2);
        return ((Object)list1).equals(list2);
    }
}

