/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.auth.identity.cli.controller;

import com.amazonaws.services.auth.identity.cli.common.Utils;
import com.amazonaws.services.auth.identity.cli.controller.IAMDriver;
import com.amazonaws.services.auth.identity.cli.model.CLIRequest;
import com.amazonaws.services.auth.identity.cli.model.UserListMFADevicesRequest;
import com.amazonaws.services.awsidentitymanagementv20100508.model.ListMFADevicesRequest;
import com.amazonaws.services.awsidentitymanagementv20100508.model.ListMFADevicesResult;
import com.amazonaws.services.awsidentitymanagementv20100508.model.MFADevice;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IAMUserListMFADevicesDriver
extends IAMDriver {
    private static final Log LOG = LogFactory.getLog(IAMUserListMFADevicesDriver.class);

    protected void invokeRequestImpl(CLIRequest request) {
        if (request instanceof UserListMFADevicesRequest) {
            UserListMFADevicesRequest req = (UserListMFADevicesRequest)request;
            ListMFADevicesRequest listMFADevicesRequest = new ListMFADevicesRequest();
            listMFADevicesRequest.setUserName(req.getUserName());
            listMFADevicesRequest.setMarker(req.getMarker());
            listMFADevicesRequest.setMaxItems(req.getMaxItems());
            LOG.debug((Object)("Calling listmfadevice with request " + request));
            ListMFADevicesResult res = this.getClient().listMFADevices(listMFADevicesRequest);
            for (MFADevice device : res.getMFADevices()) {
                LOG.info((Object)device.getSerialNumber());
            }
            LOG.info((Object)("IsTruncated: " + res.getIsTruncated()));
            if (res.getIsTruncated().booleanValue()) {
                LOG.info((Object)("Marker: " + res.getMarker()));
            }
        } else {
            Utils.exit(1, "request " + request + " is of an incorrect type.", null);
        }
    }
}

