/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.auth.identity.cli.controller;

import com.amazonaws.services.auth.identity.cli.common.Utils;
import com.amazonaws.services.auth.identity.cli.controller.IAMDriver;
import com.amazonaws.services.auth.identity.cli.model.CLIRequest;
import com.amazonaws.services.auth.identity.cli.model.UserListKeysRequest;
import com.amazonaws.services.awsidentitymanagementv20100508.model.AccessKeyMetadata;
import com.amazonaws.services.awsidentitymanagementv20100508.model.ListAccessKeysRequest;
import com.amazonaws.services.awsidentitymanagementv20100508.model.ListAccessKeysResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class IAMUserListKeysDriver
extends IAMDriver {
    private static final Log LOG = LogFactory.getLog(IAMUserListKeysDriver.class);

    protected void invokeRequestImpl(CLIRequest request) {
        if (request instanceof UserListKeysRequest) {
            UserListKeysRequest req = (UserListKeysRequest)request;
            LOG.debug((Object)("Listing keys " + req));
            ListAccessKeysRequest listAccessKeysRequest = new ListAccessKeysRequest();
            listAccessKeysRequest.setUserName(req.getUserName());
            listAccessKeysRequest.setMarker(req.getMarker());
            listAccessKeysRequest.setMaxItems(req.getMaxItems());
            ListAccessKeysResult result = this.getClient().listAccessKeys(listAccessKeysRequest);
            for (AccessKeyMetadata key : result.getAccessKeyMetadata()) {
                LOG.info((Object)key.getAccessKeyId());
                LOG.info((Object)key.getStatus());
            }
            LOG.info((Object)("IsTruncated: " + result.getIsTruncated()));
            if (result.getIsTruncated().booleanValue()) {
                LOG.info((Object)("Marker: " + result.getMarker()));
            }
        } else {
            Utils.exit(1, "request " + request + " is of an incorrect type.", null);
        }
    }
}

