/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.auth.identity.cli.controller;

import com.amazonaws.services.auth.identity.cli.common.Utils;
import com.amazonaws.services.auth.identity.cli.controller.IAMDriver;
import com.amazonaws.services.auth.identity.cli.model.CLIRequest;
import com.amazonaws.services.auth.identity.cli.model.GroupListPoliciesRequest;
import com.amazonaws.services.awsidentitymanagementv20100508.model.GetGroupPolicyRequest;
import com.amazonaws.services.awsidentitymanagementv20100508.model.GetGroupPolicyResult;
import com.amazonaws.services.awsidentitymanagementv20100508.model.ListGroupPoliciesRequest;
import com.amazonaws.services.awsidentitymanagementv20100508.model.ListGroupPoliciesResult;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IAMGroupListPoliciesDriver
extends IAMDriver {
    private static final Log LOG = LogFactory.getLog(IAMGroupListPoliciesDriver.class);

    protected void invokeRequestImpl(CLIRequest request) {
        if (request instanceof GroupListPoliciesRequest) {
            GroupListPoliciesRequest req = (GroupListPoliciesRequest)request;
            LOG.debug((Object)("list policies " + req));
            if (req.getPolicyName() == null) {
                LOG.debug((Object)"Listing all policies on an entity");
                ListGroupPoliciesRequest listPoliciesRequest = new ListGroupPoliciesRequest();
                GetGroupPolicyRequest getPolicyRequest = new GetGroupPolicyRequest();
                listPoliciesRequest.setGroupName(req.getGroupName());
                listPoliciesRequest.setMarker(req.getMarker());
                listPoliciesRequest.setMaxItems(req.getMaxItems());
                getPolicyRequest.setGroupName(req.getGroupName());
                LOG.debug((Object)"Listing policies");
                ListGroupPoliciesResult listPoliciesResult = this.getClient().listGroupPolicies(listPoliciesRequest);
                for (String policy : listPoliciesResult.getPolicyNames()) {
                    LOG.info((Object)policy);
                    if (!req.isVerbose()) continue;
                    getPolicyRequest.setPolicyName(policy);
                    LOG.debug((Object)"Getting single policy");
                    GetGroupPolicyResult getPolicyResult = this.getClient().getGroupPolicy(getPolicyRequest);
                    LOG.info((Object)this.urlDecodePolicy(getPolicyResult.getPolicyDocument()));
                }
                LOG.info((Object)("IsTruncated: " + listPoliciesResult.getIsTruncated()));
                if (listPoliciesResult.getIsTruncated().booleanValue()) {
                    LOG.info((Object)("Marker: " + listPoliciesResult.getMarker()));
                }
            } else {
                GetGroupPolicyRequest getPolicyRequest = new GetGroupPolicyRequest();
                getPolicyRequest.setPolicyName(req.getPolicyName());
                getPolicyRequest.setGroupName(req.getGroupName());
                LOG.debug((Object)"Getting single policy");
                GetGroupPolicyResult getPolicyResult = this.getClient().getGroupPolicy(getPolicyRequest);
                LOG.info((Object)this.urlDecodePolicy(getPolicyResult.getPolicyDocument()));
            }
        } else {
            Utils.exit(1, "request " + request + " is of an incorrect type.", null);
        }
    }

    private String urlDecodePolicy(String policy) {
        String decodedPolicy = null;
        try {
            decodedPolicy = URLDecoder.decode(policy, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            Utils.exit(1, e.getMessage(), e);
        }
        return decodedPolicy;
    }
}

