/*
 * Decompiled with CFR 0.152.
 */
package amazon.fws.clicommando.processors.service.aws;

import amazon.fws.clicommando.Command;
import amazon.fws.clicommando.exceptions.BadInputException;
import amazon.fws.clicommando.exceptions.ConfigurationErrorException;
import amazon.fws.clicommando.exceptions.InternalErrorException;
import amazon.fws.clicommando.exceptions.ServiceAccessException;
import amazon.fws.clicommando.messages.ErrorMessages;
import amazon.fws.clicommando.processors.service.HttpServiceResponseHandler;
import amazon.fws.clicommando.processors.service.ServiceCallConfig;
import amazon.fws.clicommando.processors.service.aws.AwsServiceCaller;
import amazon.fws.clicommando.security.AwsSignatureHelper;
import amazon.fws.clicommando.util.DateUtils;
import amazon.fws.clicommando.util.StringUtils;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AwsQueryCaller
extends AwsServiceCaller {
    public AwsQueryCaller(ServiceCallConfig awsCallConfig) {
        this.awsCallConfig = awsCallConfig;
    }

    @Override
    public void call(Command command) {
        Map<String, String> paramMap = this.awsCallConfig.getParameters();
        this.createBoilerplate(paramMap);
        String url = this.awsCallConfig.getServiceUrl();
        AwsSignatureHelper sigHelp = new AwsSignatureHelper(url);
        String accessId = command.getCurrentCommandConfig().getParameter("AWSAccessKeyId").getValue();
        String secretKey = command.getCurrentCommandConfig().getParameter("AWSSecretKey").getValue();
        paramMap.put("AWSAccessKeyId", accessId);
        String signature = sigHelp.signParameters(paramMap, secretKey);
        paramMap.put("Signature", signature);
        this.awsRequestUrl = this.createCall(url, command, paramMap);
        this.callService(this.awsRequestUrl, command);
    }

    private void createBoilerplate(Map<String, String> paramMap) {
        if (StringUtils.isEmpty(this.awsCallConfig.getServiceVersion())) {
            paramMap.remove("Version");
        } else {
            paramMap.put("Version", this.awsCallConfig.getServiceVersion());
        }
        paramMap.put("Action", this.awsCallConfig.getAction());
        paramMap.put("SignatureVersion", this.awsCallConfig.getSigVersion());
        if (this.awsCallConfig.getSigVersion().equals("1")) {
            paramMap.put("SignatureMethod", "HmacSHA1");
        } else if (this.awsCallConfig.getSigVersion().equals("2")) {
            paramMap.put("SignatureMethod", "HmacSHA256");
        } else {
            throw new ConfigurationErrorException("Unsupported signature version: got '" + this.awsCallConfig.getSigVersion() + "'");
        }
        String timeStamp = DateUtils.getFormattedTimestamp();
        paramMap.put("Timestamp", timeStamp);
    }

    void callService(String url, Command cmd) {
        HttpURLConnection connection = null;
        try {
            try {
                URL serverAddress = new URL(url);
                connection = (HttpURLConnection)serverAddress.openConnection();
                connection.setRequestMethod("GET");
                connection.setReadTimeout(this.awsCallConfig.getTimeout());
                cmd.getCurrentCommandConfig().setRequestUrl(url);
                connection.setRequestProperty("User-Agent", this.awsCallConfig.getUserAgent());
                connection.connect();
                connection.getResponseCode();
                this.responseHandler = new HttpServiceResponseHandler(url, connection, cmd);
            }
            catch (MalformedURLException e) {
                int loc = url.indexOf("/");
                String displayedUrl = loc <= 0 ? url.substring(0, 30) + "..." : url.substring(0, loc);
                throw new BadInputException(ErrorMessages.ErrorCode.MALFORMED_URL, displayedUrl);
            }
            catch (ProtocolException e) {
                throw new InternalErrorException("Some protocol problem reaching: " + url, e);
            }
            catch (SocketTimeoutException e) {
                throw new ServiceAccessException(e.getMessage(), ErrorMessages.ErrorCode.COMMAND_TIMEOUT, new String[0]);
            }
            catch (UnknownHostException uhe) {
                throw new BadInputException(ErrorMessages.ErrorCode.UNKNOWN_TARGET_URL, uhe.getLocalizedMessage());
            }
            catch (IOException e) {
                if (e.getMessage().contains("unable to find valid certification path to requested target") || e.getMessage().contains("No trusted certificate found")) {
                    throw new BadInputException(ErrorMessages.ErrorCode.SSL_NOT_AUTH, e.getLocalizedMessage());
                }
                if (e.getMessage().contains("Read timed out")) {
                    throw new ServiceAccessException(e.getMessage(), ErrorMessages.ErrorCode.COMMAND_TIMEOUT, new String[0]);
                }
                throw new ServiceAccessException(e.getMessage(), ErrorMessages.ErrorCode.ERROR_REACHING_AWS, e.getLocalizedMessage());
            }
            Object var8_10 = null;
            if (connection != null) {
                connection.disconnect();
            }
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            if (connection != null) {
                connection.disconnect();
            }
            throw throwable;
        }
    }

    private String createCall(String url, Command command, Map<String, String> paramMap) {
        StringBuilder urlBld = new StringBuilder(url + "/?");
        for (Map.Entry<String, String> entry : paramMap.entrySet()) {
            urlBld.append(entry.getKey() + "=" + AwsSignatureHelper.urlEncode(entry.getValue(), false) + "&");
        }
        if (urlBld.charAt(urlBld.length() - 1) == '&') {
            urlBld.deleteCharAt(urlBld.length() - 1);
        }
        return urlBld.toString();
    }
}

