/*
 * Decompiled with CFR 0.152.
 */
package amazon.fws.clicommando.processors.service;

import amazon.fws.clicommando.Command;
import amazon.fws.clicommando.config.ColumnConfig;
import amazon.fws.clicommando.config.CommandConfig;
import amazon.fws.clicommando.config.DefaultConfig;
import amazon.fws.clicommando.config.EnvironmentVariableConfig;
import amazon.fws.clicommando.config.ExampleConfig;
import amazon.fws.clicommando.config.OptionConfig;
import amazon.fws.clicommando.config.OutputDescriptionConfig;
import amazon.fws.clicommando.config.OutputFormatConfig;
import amazon.fws.clicommando.config.ParamConfig;
import amazon.fws.clicommando.exceptions.BadInputException;
import amazon.fws.clicommando.processors.service.ServiceScaffold;
import amazon.fws.clicommando.util.HelpUtils;
import amazon.fws.clicommando.util.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HelpCallProcessor
implements ServiceScaffold {
    @Override
    public void configureScaffold(Map<String, String> config) {
    }

    @Override
    public void processParameterMap(Command command) {
        command.loadHelp();
        String commandName = command.getCurrentCommandConfig().getParameter("CommandName").getValue();
        StringBuilder result = new StringBuilder();
        if (StringUtils.isEmpty(commandName)) {
            this.printCommandList(result, command);
        } else {
            this.printCommandHelp(result, command, commandName);
        }
        command.getCurrentCommandConfig().setResponse(result.toString());
    }

    private void printCommandList(StringBuilder result, Command command) {
        ArrayList<CommandConfig> cclist = new ArrayList<CommandConfig>();
        cclist.addAll(command.getCommandConfigs());
        Collections.sort(cclist, CommandConfig.NAME_COMPARE);
        int commandColSize = 35;
        int descriptionColSize = 55;
        for (CommandConfig cc : cclist) {
            int len = cc.getName().length();
            if (commandColSize < len) {
                commandColSize = len + 1;
            }
            if (descriptionColSize >= (len = cc.getName().length())) continue;
            descriptionColSize = len;
        }
        result.append(StringUtils.fixedLength("Command Name", commandColSize));
        result.append(StringUtils.fixedLength("   Description", descriptionColSize) + "\n");
        result.append(StringUtils.fixedLength("------------", commandColSize));
        result.append(StringUtils.fixedLength("-----------", descriptionColSize) + "\n");
        for (CommandConfig cc : cclist) {
            result.append(StringUtils.fixedLength(cc.getName(), commandColSize));
            if (StringUtils.notEmpty(cc.getShortDesc())) {
                result.append(StringUtils.fixedLength(cc.getShortDesc(), descriptionColSize) + "\n");
                continue;
            }
            result.append("\n");
        }
        result.append("\n" + StringUtils.formatTextColumn("For help on a specific command, type 'help <commandname>' or '<commandname> --help'"));
    }

    private void printCommandHelp(StringBuilder result, Command command, String commandName) {
        CommandConfig cmdConfig = null;
        try {
            cmdConfig = command.getCommandConfig(commandName);
        }
        catch (BadInputException e) {
            result.append("No help available for '" + commandName + "'.\n");
            return;
        }
        if (StringUtils.isEmpty(cmdConfig.getLongDesc())) {
            result.append("No help available for '" + commandName + "'.\n");
            return;
        }
        result.append("\nSYNOPSIS\n   " + HelpUtils.getSynopsis(cmdConfig) + "\n");
        result.append("\nDESCRIPTION\n   " + StringUtils.formatTextColumn(cmdConfig.getLongDesc()) + "\n");
        if (cmdConfig.getArgumentsSortedByIndex().size() > 0) {
            result.append("\nARGUMENTS\n");
            this.getInOrderArguments(result, cmdConfig);
        }
        this.printOptionHelp(result, cmdConfig);
        this.printExamples(result, cmdConfig.getInputExamples(), "\nINPUT EXAMPLES\n");
        if (cmdConfig.getOutputConfig() != null && StringUtils.notEmpty(cmdConfig.getOutputConfig().getDescriptor()) && command.getOutputDescriptionMap().containsKey(cmdConfig.getOutputConfig().getDescriptor()) && (command.getOutputDescription(cmdConfig.getOutputConfig().getDescriptor()).getColumns().size() > 0 || command.getOutputDescription(cmdConfig.getOutputConfig().getDescriptor()).getTables().size() > 0)) {
            OutputDescriptionConfig outDesc = command.getOutputDescription(cmdConfig.getOutputConfig().getDescriptor());
            result.append("\nOUTPUT\n");
            result.append(StringUtils.formatTextColumn("This command returns a table that contains the following:") + "\n");
            this.printColumnHelp(result, command, outDesc);
            this.printExamples(result, outDesc.getOutputExamples(), "\nOUTPUT EXAMPLES\n");
        }
    }

    private void printColumnHelp(StringBuilder result, Command command, OutputDescriptionConfig outDesc) {
        for (ColumnConfig column : outDesc.getColumns()) {
            String desc = column.getHelpDescription();
            if (StringUtils.isEmpty(desc)) {
                desc = "No description available for this column.";
            }
            String longText = "";
            if (column.getListColumn().equals((Object)ColumnConfig.ColumnListType.LONG)) {
                longText = " This column appears only in the --show-long view.";
            }
            if (desc.charAt(desc.length() - 1) != '.') {
                desc = desc + ".";
            }
            String colDesc = "* " + column.getHeader() + " - " + desc + longText;
            result.append(StringUtils.formatTextColumn(colDesc) + "\n");
        }
        for (OutputFormatConfig outForm : outDesc.getTables()) {
            OutputDescriptionConfig nextOutDesc = command.getOutputDescription(outForm.getDescriptor());
            this.printColumnHelp(result, command, nextOutDesc);
        }
    }

    private void printExamples(StringBuilder result, List<ExampleConfig> examples, String title) {
        if (!examples.isEmpty()) {
            result.append(title);
            for (ExampleConfig example : examples) {
                result.append("\n" + StringUtils.formatTextColumn(example.getDescription()) + "\n");
                result.append(example.getExampleText() + "\n");
            }
        }
    }

    private void printOptionHelp(StringBuilder result, CommandConfig cmdConfig) {
        HashMap<String, String> options = new HashMap<String, String>();
        for (ParamConfig pc : cmdConfig.getParamsSortedByOptions()) {
            String helpBlurb;
            if (pc.isUndocumented()) continue;
            switch (pc.getType()) {
                case SIMPLE: {
                    helpBlurb = this.formatSimple(pc);
                    break;
                }
                case SWITCH: {
                    helpBlurb = this.formatSwitch(pc);
                    break;
                }
                case MULTIPLE: {
                    helpBlurb = this.formatMulti(pc);
                    break;
                }
                case MAP: {
                    helpBlurb = this.formatMap(pc);
                    break;
                }
                default: {
                    helpBlurb = "";
                }
            }
            helpBlurb = helpBlurb + this.getParamHelpDesc(pc) + "\n";
            if (options.containsKey(pc.getContextTitle())) {
                options.put(pc.getContextTitle(), (String)options.get(pc.getContextTitle()) + helpBlurb);
                continue;
            }
            String newText = helpBlurb;
            options.put(pc.getContextTitle(), newText);
        }
        String general = "\nGENERAL OPTIONS\n";
        String specific = "\nSPECIFIC OPTIONS\n";
        StringBuilder others = new StringBuilder();
        general = options.containsKey("GENERAL OPTIONS") ? general + (String)options.remove("GENERAL OPTIONS") : "";
        specific = options.containsKey("SPECIFIC OPTIONS") ? specific + (String)options.remove("SPECIFIC OPTIONS") : "";
        for (Map.Entry optionCat : options.entrySet()) {
            others.append("\n" + StringUtils.formatTextColumn((String)optionCat.getKey(), "") + "\n" + (String)optionCat.getValue());
        }
        result.append(specific + others + general);
    }

    private void getInOrderArguments(StringBuilder result, CommandConfig cmdConfig) {
        for (ParamConfig pc : cmdConfig.getArgumentsSortedByIndex()) {
            if (pc.isUndocumented()) continue;
            result.append("   " + pc.getName() + "\n");
            result.append(this.getParamHelpDesc(pc));
        }
    }

    private String formatMap(ParamConfig pc) {
        String ret = "";
        OptionConfig opt = pc.getFirstOption();
        if (opt != null) {
            List<String> valueSetList = HelpUtils.getMapValueForOpt(pc);
            StringBuilder sb = new StringBuilder();
            sb.append(" ");
            for (String val : valueSetList) {
                sb.append(val + " ");
            }
            String valueSet = sb.toString();
            String longOpt = opt.getLongOpt();
            String shortOpt = opt.getShortOpt();
            ret = "   " + this.printLongAndShortValueOption(valueSet, longOpt, shortOpt) + "\n";
        }
        return ret;
    }

    private String printLongAndShortValueOption(String valueSet, String longOpt, String shortOpt) {
        String ret = "";
        if (StringUtils.notEmpty(longOpt) && StringUtils.notEmpty(shortOpt)) {
            ret = "-" + shortOpt + ", --" + longOpt + valueSet;
        } else if (StringUtils.notEmpty(longOpt)) {
            ret = "--" + longOpt + valueSet;
        } else if (StringUtils.notEmpty(shortOpt)) {
            ret = "-" + shortOpt + valueSet;
        }
        return ret;
    }

    private String formatMulti(ParamConfig pc) {
        String ret = "";
        OptionConfig opt = pc.getFirstOption();
        if (opt != null) {
            String listSeparator = opt.getValueSeparator();
            String longOpt = opt.getLongOpt();
            String shortOpt = opt.getShortOpt();
            String valueSet = " VALUE1" + listSeparator + "VALUE2" + listSeparator + "VALUE3...";
            ret = "   " + this.printLongAndShortValueOption(valueSet, longOpt, shortOpt) + "\n";
        }
        return ret;
    }

    private String formatSwitch(ParamConfig pc) {
        StringBuilder switchStr = new StringBuilder();
        StringBuilder ret = new StringBuilder();
        if (pc.getOptions() != null) {
            for (OptionConfig opt : pc.getOptions()) {
                String longOpt = opt.getLongOpt();
                String shortOpt = opt.getShortOpt();
                String valueSet = "";
                switchStr.append(this.printLongAndShortValueOption(valueSet, longOpt, shortOpt) + ", ");
            }
            ret.append("   " + switchStr.substring(0, switchStr.length() - 2) + "\n");
        }
        return ret.toString();
    }

    private String formatSimple(ParamConfig pc) {
        String ret = "";
        OptionConfig opt = pc.getFirstOption();
        if (opt != null) {
            String longOpt = opt.getLongOpt();
            String shortOpt = opt.getShortOpt();
            String valueSet = " VALUE";
            ret = "   " + this.printLongAndShortValueOption(valueSet, longOpt, shortOpt) + "\n";
        }
        return ret;
    }

    private String getParamHelpDesc(ParamConfig pc) {
        EnvironmentVariableConfig env;
        DefaultConfig def;
        String result = "";
        String helpDesc = pc.getHelpDescription();
        if (StringUtils.isEmpty(helpDesc)) {
            helpDesc = "No description available for this parameter.";
        }
        if (helpDesc.charAt(helpDesc.length() - 1) != '.') {
            helpDesc = helpDesc + ".";
        }
        if ((def = pc.getDefaultValue()) != null && !helpDesc.toLowerCase().contains("default")) {
            helpDesc = helpDesc + " The default value is '" + def.getValue() + "'.";
        }
        if ((env = pc.getEnvVarValue()) != null && !helpDesc.toLowerCase().contains("environment")) {
            helpDesc = helpDesc + " This value can be set by using the environment variable '" + env.getVariableName() + "'.";
        }
        if (pc.getType() == ParamConfig.Type.ARGUMENT && StringUtils.notEmpty(pc.getFirstOption().getLongOpt()) && !helpDesc.contains("--" + pc.getFirstOption().getLongOpt())) {
            helpDesc = helpDesc + " You can also set this value using \"--" + pc.getFirstOption().getLongOpt() + "\".";
        }
        if (pc.isRequired().booleanValue() && !helpDesc.toLowerCase().contains("required")) {
            helpDesc = helpDesc + " Required.";
        }
        result = result + StringUtils.formatTextColumn(helpDesc, "      ") + "\n";
        return result;
    }
}

