/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.problems.internal.transformers;

import org.gradle.api.problems.internal.ProblemReport;
import org.gradle.api.problems.internal.ProblemTransformer;
import org.gradle.internal.operations.OperationIdentifier;
import org.gradle.problems.Location;
import org.gradle.problems.ProblemDiagnostics;
import org.gradle.problems.buildtree.ProblemStream;

public class StackLocationTransformer
implements ProblemTransformer {
    private final ProblemStream problemStream;

    public StackLocationTransformer(ProblemStream problemStream) {
        this.problemStream = problemStream;
    }

    public ProblemReport transform(ProblemReport problem, OperationIdentifier id) {
        if (problem.getContext().getException() == null) {
            return problem;
        }
        ProblemDiagnostics problemDiagnostics = this.problemStream.forCurrentCaller((Throwable)problem.getContext().getException());
        Location loc = problemDiagnostics.getLocation();
        if (loc != null) {
            return problem.toBuilder().lineInFileLocation(loc.getSourceLongDisplayName().getDisplayName(), loc.getLineNumber()).build();
        }
        return problem;
    }
}

