/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.resourcemanager;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.internal.e4models.IContextRunnable;
import org.xmind.ui.internal.resourcemanager.ResourceManagerDialogPage;
import org.xmind.ui.internal.resourcemanager.ResourceManagerViewer;
import org.xmind.ui.internal.resourcemanager.TemplateResourceManagerViewer;
import org.xmind.ui.internal.utils.ResourceUtils;
import org.xmind.ui.mindmap.IResourceManagerListener;
import org.xmind.ui.mindmap.ITemplate;
import org.xmind.ui.mindmap.ITemplateGroup;
import org.xmind.ui.mindmap.MindMapUI;

public class TemplateResourceManagerPage
extends ResourceManagerDialogPage
implements IResourceManagerListener {
    private static final int IMPORT_BUTTON_ID = 1025;
    private static final String IMPORT_RESOURCE_BUNDLE_COMMAND_ID = "org.xmind.ui.command.importXMindResourceBundle";
    private TemplateResourceManagerViewer viewer;

    @Override
    protected ResourceManagerViewer createViewer() {
        this.viewer = new TemplateResourceManagerViewer();
        MindMapUI.getResourceManager().addResourceManagerListener(this);
        return this.viewer;
    }

    @Override
    public void dispose() {
        MindMapUI.getResourceManager().removeResourceManagerListener(this);
        super.dispose();
    }

    @Override
    public void userTemplateAdded(ITemplate template) {
        if (!(template instanceof ITemplate)) {
            return;
        }
        if (this.viewer == null || this.viewer.getControl() == null || this.viewer.getControl().isDisposed()) {
            return;
        }
        this.viewer.refresh();
        this.viewer.reveal(TemplateResourceManagerViewer.TemplateGalleryCore.getInstance().getGroupByName(TemplateResourceManagerViewer.TemplateGalleryCore.USER_GROUP_NAME));
        this.viewer.setSelection((ISelection)new StructuredSelection((Object)template));
    }

    @Override
    public void userTemplateRemoved(ITemplate template) {
        if (template instanceof ITemplate) {
            if (this.viewer == null || this.viewer.getControl() == null || this.viewer.getControl().isDisposed()) {
                return;
            }
            this.viewer.refresh();
        }
    }

    @Override
    protected void createButtonsForButtonBar(Composite composite) {
        Button importButton = this.createButton(composite, 1025, MindMapMessages.TemplateResourceManagerPage_Import_button, false);
        final IAction addTemplateAction = this.getAddTemplateAction();
        importButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                addTemplateAction.run();
            }
        });
    }

    private IAction getAddTemplateAction() {
        Action addTemplateAction = new Action(MindMapMessages.TemplateResourceManagerPage_AddTemplates_label){

            public void run() {
                FileDialog dialog = new FileDialog(Display.getCurrent().getActiveShell(), 4096);
                String ext = "*.xmt";
                dialog.setFilterExtensions(new String[]{ext});
                dialog.setFilterNames(new String[]{NLS.bind((String)"{0} ({1})", (Object)MindMapMessages.TemplateResourceManagerPage_TemplateFilterName_label, (Object)ext)});
                String path = dialog.open();
                if (path == null) {
                    return;
                }
                final File templateFile = new File(path);
                if (templateFile != null && templateFile.exists()) {
                    SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                        public void run() throws Exception {
                            MindMapUI.getResourceManager().addUserTemplateFromWorkbookURI(templateFile.toURI());
                        }
                    });
                }
            }
        };
        addTemplateAction.setToolTipText(MindMapMessages.TemplateResourceManagerPage_AddTemplates_tooltip);
        return addTemplateAction;
    }

    @Override
    protected void registerRunnable(IEclipseContext eclipseContext) {
        super.registerRunnable(eclipseContext);
        eclipseContext.set(String.valueOf(this.getId()) + "/" + "org.xmind.ui.modelPart.delete", (Object)new IContextRunnable(){

            public void run() {
                if (TemplateResourceManagerPage.this.viewer != null && TemplateResourceManagerPage.this.viewer.getControl() != null && !TemplateResourceManagerPage.this.viewer.getControl().isDisposed()) {
                    List templates = TemplateResourceManagerPage.this.getSelectedTemplates();
                    if (templates.isEmpty()) {
                        return;
                    }
                    StringBuilder sb = new StringBuilder(templates.size() * 10);
                    for (ITemplate template : templates) {
                        if (sb.length() > 0) {
                            sb.append(',');
                            sb.append(' ');
                        }
                        sb.append('\'');
                        sb.append(template.getName());
                        sb.append('\'');
                    }
                    if (!MessageDialog.openConfirm((Shell)TemplateResourceManagerPage.this.viewer.getControl().getShell(), (String)MindMapMessages.TemplateResourceManagerPage_Delete_ConfirmDialog_title, (String)NLS.bind((String)MindMapMessages.TemplateResourceManagerPage_Delete_ConfirmDialog_message, (Object)sb.toString()))) {
                        return;
                    }
                    ResourceUtils.deleteTemplates(templates);
                }
            }

            public boolean canExecute(IEclipseContext context, String contextKey) {
                List templates = TemplateResourceManagerPage.this.getSelectedTemplates();
                List<ITemplate> sysTemplates = MindMapUI.getResourceManager().getSystemTemplates();
                boolean canExecute = !templates.isEmpty();
                for (ITemplate template : templates) {
                    boolean bl = canExecute = canExecute && !sysTemplates.contains(template);
                }
                List<ITemplateGroup> sysGroups = MindMapUI.getResourceManager().getSystemTemplateGroups();
                for (ITemplateGroup group : sysGroups) {
                    List<ITemplate> gTemplates = group.getTemplates();
                    for (ITemplate template : templates) {
                        boolean bl = canExecute = canExecute && !gTemplates.contains(template);
                    }
                }
                return canExecute;
            }
        });
        eclipseContext.set(String.valueOf(this.getId()) + "/" + "org.xmind.ui.modelPart.duplicate", (Object)new IContextRunnable(){

            public void run() {
                List selectedTemplates;
                if (TemplateResourceManagerPage.this.viewer != null && TemplateResourceManagerPage.this.viewer.getControl() != null && !TemplateResourceManagerPage.this.viewer.getControl().isDisposed() && !(selectedTemplates = TemplateResourceManagerPage.this.getSelectedTemplates()).isEmpty()) {
                    ResourceUtils.duplicateTemplates(selectedTemplates);
                }
            }

            public boolean canExecute(IEclipseContext context, String contextKey) {
                List templates = TemplateResourceManagerPage.this.getSelectedTemplates();
                boolean canExecute = !templates.isEmpty();
                return canExecute;
            }
        });
        eclipseContext.set(String.valueOf(this.getId()) + "/" + "org.xmind.ui.modelPart.rename", (Object)new IContextRunnable(){

            public void run() {
                List selectedTemplates;
                if (TemplateResourceManagerPage.this.viewer != null && TemplateResourceManagerPage.this.viewer.getControl() != null && !TemplateResourceManagerPage.this.viewer.getControl().isDisposed() && (selectedTemplates = TemplateResourceManagerPage.this.getSelectedTemplates()).size() == 1) {
                    ITemplate template = (ITemplate)selectedTemplates.get(0);
                    TemplateResourceManagerPage.this.viewer.startEditing(template);
                }
            }

            public boolean canExecute(IEclipseContext context, String contextKey) {
                List selectedTemplates = TemplateResourceManagerPage.this.getSelectedTemplates();
                List<ITemplate> systemTemplates = MindMapUI.getResourceManager().getSystemTemplates();
                boolean canExecute = selectedTemplates.size() == 1;
                for (ITemplate template : selectedTemplates) {
                    boolean bl = canExecute = canExecute && !systemTemplates.contains(template);
                }
                List<ITemplateGroup> sysGroups = MindMapUI.getResourceManager().getSystemTemplateGroups();
                for (ITemplateGroup group : sysGroups) {
                    List<ITemplate> gTemplates = group.getTemplates();
                    for (ITemplate template : selectedTemplates) {
                        boolean bl = canExecute = canExecute && !gTemplates.contains(template);
                    }
                }
                return canExecute;
            }
        });
    }

    private List<ITemplate> getSelectedTemplates() {
        IStructuredSelection selection;
        ArrayList<ITemplate> templates = new ArrayList<ITemplate>();
        if (this.viewer != null && this.viewer.getControl() != null && !this.viewer.getControl().isDisposed() && (selection = this.viewer.getStructuredSelection()) instanceof IStructuredSelection) {
            for (Object element : selection.toList()) {
                templates.add((ITemplate)element);
            }
        }
        return templates;
    }

    @Override
    protected String getContextMenuId() {
        return "org.xmind.ui.dialogPart.resourceManager.template.popupMenu";
    }

    public String getModelPageId() {
        return "org.xmind.ui.dialogPart.resourceManager.template";
    }

    public String getModelPageTitle() {
        return null;
    }
}

