/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.resourcemanager;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.IParameter;
import org.eclipse.core.commands.Parameterization;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.handlers.IHandlerService;
import org.xmind.core.style.IStyle;
import org.xmind.core.style.IStyleSheet;
import org.xmind.gef.EditDomain;
import org.xmind.gef.IViewer;
import org.xmind.gef.part.IPart;
import org.xmind.gef.tool.ITool;
import org.xmind.gef.util.Properties;
import org.xmind.ui.gallery.GalleryEditTool;
import org.xmind.ui.gallery.GallerySelectTool;
import org.xmind.ui.gallery.GalleryViewer;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.internal.resourcemanager.ResourceManagerViewer;
import org.xmind.ui.internal.views.StyleFigure;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.texteditor.FloatingTextEditor;
import org.xmind.ui.viewers.IToolTipProvider;

public class StyleResourceManagerViewer
extends ResourceManagerViewer {
    private static final int FRAME_HEIGHT = 72;
    private static final int FRAME_WIDTH = 132;
    public static Map<String, ImageData> cachedImageData = new HashMap<String, ImageData>();
    private static final String EDIT_STYLE_COMMAND_ID = "org.xmind.ui.command.style.edit2";

    @Override
    public void createControl(Composite container) {
        super.createControl(container);
        this.setContentProvider((IContentProvider)new StyleCategorizedContentProvider());
        this.setLabelProvider((IBaseLabelProvider)new StyleCategorizedLabelProvider());
        EditDomain domain = new EditDomain();
        domain.installTool("select tool", (ITool)new ResourceManagerViewer.ResourceCategorizedSelectTool());
        this.setEditDomain(domain);
        this.initProperties();
        this.createControl(container, 64);
        this.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.setInput(StyleGalleryCore.getInstance());
    }

    @Override
    protected void initNestedGalleryViewer(GalleryViewer galleryViewerer) {
        super.initNestedGalleryViewer(galleryViewerer);
        Properties properties = galleryViewerer.getProperties();
        properties.set("org.xmind.ui.gallery.hideTitle", (Object)Boolean.FALSE);
        galleryViewerer.getEditDomain().installTool("edit tool", (ITool)new StyleNestedViewerNameEditTool());
    }

    @Override
    protected void initProperties() {
        super.initProperties();
        Properties properties = this.getProperties();
        properties.set("org.xmind.ui.gallery.frameContentSize", (Object)new Dimension(132, 72));
    }

    @Override
    protected void configureSection(Section section, Object category) {
        if (category instanceof StyleGroup) {
            this.createSectionTextClient(section, MindMapMessages.StyleResourceManagerViewer_AddSection_title, category);
        }
    }

    @Override
    protected void handleClickSectionTextClient(Object category) {
        if (category instanceof StyleGroup) {
            StyleGroup group = (StyleGroup)category;
            IStyle dummyStyle = MindMapUI.getResourceManager().getSystemStyleSheet().createStyle(group.type);
            this.openStyleEditDialog(dummyStyle);
        }
    }

    protected void editStyle() {
        IStructuredSelection selection = (IStructuredSelection)this.getSelection();
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            if (obj instanceof IStyle) {
                this.openStyleEditDialog((IStyle)obj);
            }
            ++n2;
        }
    }

    private void openStyleEditDialog(final IStyle style) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        final IHandlerService handlers = (IHandlerService)window.getService(IHandlerService.class);
        ICommandService commands = (ICommandService)window.getService(ICommandService.class);
        if (handlers == null || commands == null) {
            return;
        }
        final Command command = commands.getCommand(EDIT_STYLE_COMMAND_ID);
        if (command == null || !command.isDefined()) {
            return;
        }
        SafeRunner.run((ISafeRunnable)new SafeRunnable(){

            public void run() throws Exception {
                IParameter param = command.getParameter("org.xmind.ui.resource.uri");
                if (param == null) {
                    return;
                }
                ParameterizedCommand pc = new ParameterizedCommand(command, new Parameterization[]{new Parameterization(param, MindMapUI.getResourceManager().toResourceURI(style))});
                handlers.executeCommand(pc, null);
            }
        });
    }

    public void startEditing(IStyle style) {
        List styleGroups = StyleGalleryCore.getInstance().getElements();
        for (StyleGroup styleGroup : styleGroups) {
            List<IStyle> styles = styleGroup.getItems();
            if (!styles.contains(style)) continue;
            GalleryViewer galleryViewer = this.getNestedViewer(styleGroup);
            EditDomain domain = galleryViewer.getEditDomain();
            ITool tool = domain.getDefaultTool();
            ((GallerySelectTool)tool).getStatus().setStatus(1, true);
            domain.handleRequest("edit", (IViewer)galleryViewer);
            break;
        }
    }

    protected GalleryViewer createNestedViewer() {
        return new StyleGalleryViewer();
    }

    private static class StyleCategorizedContentProvider
    implements ITreeContentProvider {
        private StyleCategorizedContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof StyleGalleryCore) {
                return ((StyleGalleryCore)inputElement).getElements().toArray();
            }
            return null;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof StyleGalleryCore) {
                return ((StyleGalleryCore)parentElement).getElements().toArray();
            }
            if (parentElement instanceof StyleGroup) {
                return ((StyleGroup)parentElement).getItems().toArray();
            }
            return null;
        }

        public Object getParent(Object element) {
            StyleGalleryCore styleGalleryCore = StyleGalleryCore.getInstance();
            if (element instanceof IStyle) {
                return styleGalleryCore.getGroup((IStyle)element);
            }
            if (element instanceof StyleGroup) {
                return styleGalleryCore;
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof StyleGroup || element instanceof StyleGalleryCore;
        }
    }

    private class StyleCategorizedLabelProvider
    extends ResourceManagerViewer.CategorizedLabelProvider
    implements IToolTipProvider,
    IFontProvider {
        private StyleCategorizedLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof IStyle) {
                IStyle style = (IStyle)element;
                return style.getName();
            }
            if (element instanceof StyleGroup) {
                return ((StyleGroup)element).getName();
            }
            return super.getText(element);
        }

        public Image getImage(Object element) {
            if (element instanceof IStyle) {
                IStyle style = (IStyle)element;
                Properties properties = StyleResourceManagerViewer.this.getProperties();
                ImageData imageData = cachedImageData.get(style.getId());
                if (imageData == null) {
                    Dimension size = (Dimension)properties.get("org.xmind.ui.gallery.frameContentSize");
                    Image image = new Image((Device)Display.getDefault(), size.width, size.height);
                    GC gc = new GC((Drawable)image);
                    SWTGraphics graphics = new SWTGraphics(gc);
                    StyleFigure figure = new StyleFigure();
                    figure.setStyle(style);
                    figure.setSize(size);
                    figure.paint((Graphics)graphics);
                    imageData = image.getImageData();
                    cachedImageData.put(style.getId(), imageData);
                    image.dispose();
                    gc.dispose();
                    graphics.dispose();
                }
                ImageDescriptor imageDescriptor = ImageDescriptor.createFromImageData((ImageData)imageData);
                return StyleResourceManagerViewer.this.getResourceManager().createImage(imageDescriptor);
            }
            return super.getImage(element);
        }

        public String getToolTip(Object element) {
            if (element != null && element instanceof IStyle) {
                IStyle style = (IStyle)element;
                String typeName = style.getType();
                String styleName = this.getText(style);
                return String.valueOf(typeName) + "-" + styleName;
            }
            return "";
        }

        public Font getFont(Object element) {
            FontData data = StyleResourceManagerViewer.this.getContainer().getFont().getFontData()[0];
            if (Util.isMac()) {
                data.setHeight(12);
            } else {
                data.setHeight(9);
            }
            data.setStyle(0);
            FontDescriptor fontDescriptor = FontDescriptor.createFrom((FontData)data);
            return StyleResourceManagerViewer.this.getResourceManager().createFont(fontDescriptor);
        }
    }

    private static class StyleGalleryCore {
        private List<StyleGroup> groups = new ArrayList<StyleGroup>();
        private static StyleGalleryCore instance = new StyleGalleryCore();

        private StyleGroup getGroup(IStyle style) {
            StyleGroup group2;
            String type = style.getType();
            if (type != null) {
                for (StyleGroup group2 : this.groups) {
                    if (!type.equals(group2.type)) continue;
                    return group2;
                }
            }
            group2 = new StyleGroup(type);
            this.groups.add(group2);
            return group2;
        }

        private List<StyleGroup> getElements() {
            StyleGroup group;
            this.groups.clear();
            Set systemStyles = MindMapUI.getResourceManager().getSystemStyleSheet().getStyles("automatic-styles");
            Set userStyles = MindMapUI.getResourceManager().getUserStyleSheet().getAllStyles();
            for (IStyle style : systemStyles) {
                group = this.getGroup(style);
                group.addStyle(style);
            }
            for (IStyle style : userStyles) {
                group = this.getGroup(style);
                group.addStyle(style);
            }
            return this.groups;
        }

        public static StyleGalleryCore getInstance() {
            return instance;
        }
    }

    private class StyleGalleryViewer
    extends GalleryViewer {
        private StyleGalleryViewer() {
        }

        protected boolean isTitleEditable(IPart p) {
            IStyleSheet styleSheet = MindMapUI.getResourceManager().getUserStyleSheet();
            return styleSheet == null ? false : styleSheet.getAllStyles().contains(p.getModel());
        }
    }

    private static class StyleGroup {
        private String type;
        private List<IStyle> styles = new ArrayList<IStyle>();

        public StyleGroup(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }

        public String getName() {
            if ("topic".equals(this.type)) {
                return MindMapMessages.StyleResourceManagerViewer_Topic;
            }
            if ("boundary".equals(this.type)) {
                return MindMapMessages.StyleResourceManagerViewer_Boundary;
            }
            if ("map".equals(this.type)) {
                return MindMapMessages.StyleResourceManagerViewer_Map;
            }
            if ("paragraph".equals(this.type)) {
                return MindMapMessages.StyleResourceManagerViewer_Paragraph;
            }
            if ("relationship".equals(this.type)) {
                return MindMapMessages.StyleResourceManagerViewer_Relationship;
            }
            if ("summary".equals(this.type)) {
                return MindMapMessages.StyleResourceManagerViewer_Summary;
            }
            if ("text".equals(this.type)) {
                return MindMapMessages.StyleResourceManagerViewer_Text;
            }
            if ("theme".equals(this.type)) {
                return MindMapMessages.StyleResourceManagerViewer_Theme;
            }
            return "";
        }

        public List<IStyle> getItems() {
            return this.styles;
        }

        public void addStyle(IStyle style) {
            this.styles.add(style);
        }

        public int hashCode() {
            return this.type.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || !(obj instanceof StyleGroup)) {
                return false;
            }
            return ((StyleGroup)obj).type.equals(this.type);
        }
    }

    private class StyleNestedViewerNameEditTool
    extends GalleryEditTool {
        private StyleNestedViewerNameEditTool() {
        }

        protected IDocument getTextContents(IPart source) {
            return new Document(((IStyle)source.getModel()).getName());
        }

        protected void handleTextModified(IPart source, IDocument document) {
            ((IStyle)source.getModel()).setName(document.get());
            MindMapUI.getResourceManager().saveUserStyleSheet();
        }

        protected void hookEditor(FloatingTextEditor editor) {
            super.hookEditor(editor);
            this.getHelper().setPrefWidth(142);
        }
    }
}

