/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.decorations;

import org.eclipse.draw2d.IFigure;
import org.xmind.gef.draw2d.IAnchor;
import org.xmind.gef.draw2d.geometry.PrecisionPoint;
import org.xmind.gef.draw2d.graphics.Path;
import org.xmind.ui.decorations.AbstractRelationshipDecoration;

public class CurvedRelationshipDecoration
extends AbstractRelationshipDecoration {
    private static final double f1 = 0.125;
    private static final double f2 = 0.375;

    public CurvedRelationshipDecoration() {
    }

    public CurvedRelationshipDecoration(String id) {
        super(id);
    }

    protected void route(IFigure figure, Path shape) {
        PrecisionPoint sp = this.getSourcePosition(figure);
        PrecisionPoint tp = this.getTargetPosition(figure);
        PrecisionPoint cp1 = this.getSourceControlPoint(figure);
        PrecisionPoint cp2 = this.getTargetControlPoint(figure);
        shape.moveTo(sp);
        shape.cubicTo(cp1, cp2, tp);
    }

    @Override
    protected void calcTitlePosition(IFigure figure, PrecisionPoint titlePos, PrecisionPoint sourcePos, PrecisionPoint targetPos, PrecisionPoint sourceCP, PrecisionPoint targetCP) {
        double x = 0.125 * sourcePos.x + 0.375 * sourceCP.x + 0.375 * targetCP.x + 0.125 * targetPos.x;
        double y = 0.125 * sourcePos.y + 0.375 * sourceCP.y + 0.375 * targetCP.y + 0.125 * targetPos.y;
        titlePos.setLocation(x, y);
    }

    @Override
    protected void reroute(IFigure figure, PrecisionPoint sourcePos, PrecisionPoint targetPos, PrecisionPoint sourceCP, PrecisionPoint targetCP) {
        IAnchor sa = this.getSourceAnchor();
        IAnchor ta = this.getTargetAnchor();
        PrecisionPoint a1 = null;
        PrecisionPoint a2 = null;
        if (sa != null) {
            if (this.relativeSourceCP != null) {
                sourceCP.setLocation(sa.getReferencePoint()).translate((double)this.relativeSourceCP.x, (double)this.relativeSourceCP.y);
                sourcePos.setLocation(sa.getLocation(sourceCP, 0.0));
            } else if (ta != null) {
                if (a1 == null) {
                    a1 = sa.getLocation(ta.getReferencePoint(), 0.0);
                }
                sourcePos.setLocation(a1);
                if (a2 == null) {
                    a2 = ta.getLocation(sa.getReferencePoint(), 0.0);
                }
                sourceCP.setLocation(a1).move(a2, 0.4);
                if (this.sourceCPAngle != null && this.sourceCPAngle != 0.0 && !sa.getOwner().containsPoint(sourceCP.toDraw2DPoint()) && !sa.getOwner().intersects(ta.getOwner().getBounds())) {
                    this.updatePosAndCp(sa, sourcePos, sourceCP, this.sourceCPAngle);
                }
            }
            if (ta != null) {
                if (this.relativeTargetCP != null) {
                    targetCP.setLocation(ta.getReferencePoint()).translate((double)this.relativeTargetCP.x, (double)this.relativeTargetCP.y);
                    targetPos.setLocation(ta.getLocation(targetCP, 0.0));
                } else if (sa != null) {
                    if (a2 == null) {
                        a2 = ta.getLocation(sa.getReferencePoint(), 0.0);
                    }
                    targetPos.setLocation(a2);
                    if (a1 == null) {
                        a1 = sa.getLocation(ta.getReferencePoint(), 0.0);
                    }
                    targetCP.setLocation(a2).move(a1, 0.4);
                    if (this.targetCPAngle != null && this.targetCPAngle != 0.0 && !sa.getOwner().containsPoint(sourceCP.toDraw2DPoint()) && !sa.getOwner().intersects(ta.getOwner().getBounds())) {
                        this.updatePosAndCp(ta, targetPos, targetCP, this.targetCPAngle);
                    }
                }
            }
        }
    }
}

