/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.internal.share;

import java.util.Map;
import net.xmind.core.AccountManager;
import net.xmind.share.Uploader;
import org.eclipse.swt.widgets.Shell;
import org.xmind.core.ITopic;
import org.xmind.internal.share.Info;
import org.xmind.internal.share.dialogs.ShareToDialog;
import org.xmind.ui.mindmap.IMindMapViewer;
import org.xmind.ui.util.TextFormatter;

public class GeneralSharer {
    private Shell parentShell;
    private IMindMapViewer sourceViewer;
    private Uploader uploader;

    public GeneralSharer(Shell parentShell, IMindMapViewer sourceViewer) {
        this.parentShell = parentShell;
        this.sourceViewer = sourceViewer;
    }

    public void share(String shellTitle, String title, String description, String okButtonText, final ShareCallback callback) {
        final Info info = new Info();
        String mapTitle = this.getDefaultMapTitle(this.sourceViewer);
        final ShareToDialog dialog = new ShareToDialog(this.parentShell, info, shellTitle, title, description, okButtonText, mapTitle, this.sourceViewer);
        this.uploader = null;
        int result = dialog.open(new ShareToDialog.DialogCallback(){

            public void okPressed() {
                String title = info.getString("Title");
                String description = info.getString("Description");
                String languageChannel = info.getString("Share/LanguageChannel");
                String privacy = "1";
                GeneralSharer.this.uploader = new Uploader(GeneralSharer.this.parentShell, GeneralSharer.this.sourceViewer, title, description, languageChannel, privacy);
                GeneralSharer.this.uploader.upload(new Uploader.DoneCallback(){

                    public boolean signInSuccess() {
                        if (!GeneralSharer.this.isCnUser()) {
                            dialog.showUploading();
                            return true;
                        }
                        return false;
                    }

                    public void done(Map<Object, Object> dataMap) {
                        dialog.close();
                        callback.share(dataMap);
                    }

                    public void cancel() {
                        dialog.close();
                    }
                });
            }
        });
        if (result == 1 && this.uploader != null) {
            this.uploader.cancel();
        }
    }

    public void share2(String shellTitle, String title, String description, String okButtonText, final String privacy, final ShareCallback2 callback) {
        final Info info = new Info();
        String mapTitle = this.getDefaultMapTitle(this.sourceViewer);
        final ShareToDialog dialog = new ShareToDialog(this.parentShell, info, shellTitle, title, description, okButtonText, mapTitle, this.sourceViewer);
        this.uploader = null;
        int result = dialog.open(new ShareToDialog.DialogCallback(){

            public void okPressed() {
                String title = info.getString("Title");
                String description = info.getString("Description");
                String languageChannel = info.getString("Share/LanguageChannel");
                GeneralSharer.this.uploader = new Uploader(GeneralSharer.this.parentShell, GeneralSharer.this.sourceViewer, title, description, languageChannel, privacy);
                GeneralSharer.this.uploader.upload(new Uploader.DoneCallback(){

                    public boolean signInSuccess() {
                        if (!GeneralSharer.this.isCnUser()) {
                            dialog.showUploading();
                            return true;
                        }
                        return false;
                    }

                    public void done(Map<Object, Object> dataMap) {
                        callback.share(dialog, (String)dataMap.get("url"));
                    }

                    public void cancel() {
                        dialog.close();
                    }
                });
            }
        });
        if (result == 1 && this.uploader != null) {
            this.uploader.cancel();
        }
    }

    private String getDefaultMapTitle(IMindMapViewer viewer) {
        if (viewer != null) {
            ITopic rootTopic = viewer.getCentralTopic();
            return TextFormatter.removeNewLineCharacter((String)(rootTopic != null ? rootTopic.getTitleText() : ""));
        }
        return null;
    }

    private boolean isCnUser() {
        boolean isCnUser = AccountManager.getPrimaryAccount().isCnUser();
        return isCnUser;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ShareCallback {
        public void share(Map<Object, Object> var1);
    }

    public static interface ShareCallback2 {
        public void share(ShareToDialog var1, String var2);
    }
}

