/* machSpec.h was originally generated by the autoSql program, which also 
 * generated machSpec.c and machSpec.sql.  This header links the database and
 * the RAM representation of objects. */

#ifndef MACHSPEC_H
#define MACHSPEC_H

struct machSpec
/* Basic info about a machine */
    {
    struct machSpec *next;  /* Next in singly linked list. */
    char *name;	/* Network name */
    int cpus;	/* Number of CPUs we can use */
    int ramSize;	/* Megabytes of memory */
    char *tempDir;	/* Location of (local) temp dir */
    char *localDir;	/* Location of local data dir */
    int localSize;	/* Megabytes of local disk */
    char *switchName;	/* Name of switch this is on */
    };

void machSpecStaticLoad(char **row, struct machSpec *ret);
/* Load a row from machSpec table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct machSpec *machSpecLoad(char **row);
/* Load a machSpec from row fetched with select * from machSpec
 * from database.  Dispose of this with machSpecFree(). */

struct machSpec *machSpecLoadAll(char *fileName);
/* Load all machSpec from a tab-separated file.
 * Dispose of this with machSpecFreeList(). */

struct machSpec *machSpecCommaIn(char **pS, struct machSpec *ret);
/* Create a machSpec out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new machSpec */

void machSpecFree(struct machSpec **pEl);
/* Free a single dynamically allocated machSpec such as created
 * with machSpecLoad(). */

void machSpecFreeList(struct machSpec **pList);
/* Free a list of dynamically allocated machSpec's */

void machSpecOutput(struct machSpec *el, FILE *f, char sep, char lastSep);
/* Print out machSpec.  Separate fields with sep. Follow last field with lastSep. */

#define machSpecTabOut(el,f) machSpecOutput(el,f,'\t','\n');
/* Print out machSpec as a line in a tab-separated file. */

#define machSpecCommaOut(el,f) machSpecOutput(el,f,',',',');
/* Print out machSpec as a comma separated list including final comma. */

#endif /* MACHSPEC_H */

