/* splatAli.h was originally generated by the autoSql program, which also 
 * generated splatAli.c and splatAli.sql.  This header links the database and
 * the RAM representation of objects. */
/* This file is copyright 2008 Jim Kent, but license is hereby
 * granted for all use - public, private or commercial. */

#ifndef SPLATALI_H
#define SPLATALI_H

#define SPLATALI_NUM_COLS 7

struct splatAli
/* A parsed out splat format alignment. */
    {
    struct splatAli *next;  /* Next in singly linked list. */
    char *chrom;	/* Chromosome mapped to */
    int chromStart;	/* Start position in chromosome (zero based) */
    int chromEnd;	/* End position in genome (one based) */
    char *alignedBases;	/* Tag bases - in upper case for match, -/^ for insert/delete */
    int score;	/* Mapping score. 1000/placesMapped */
    char strand[2];	/* + or - for strand */
    char *readName;	/* Name of read */
    };

void splatAliStaticLoad(char **row, struct splatAli *ret);
/* Load a row from splatAli table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct splatAli *splatAliLoad(char **row);
/* Load a splatAli from row fetched with select * from splatAli
 * from database.  Dispose of this with splatAliFree(). */

struct splatAli *splatAliLoadAll(char *fileName);
/* Load all splatAli from whitespace-separated file.
 * Dispose of this with splatAliFreeList(). */

struct splatAli *splatAliLoadAllByChar(char *fileName, char chopper);
/* Load all splatAli from chopper separated file.
 * Dispose of this with splatAliFreeList(). */

#define splatAliLoadAllByTab(a) splatAliLoadAllByChar(a, '\t');
/* Load all splatAli from tab separated file.
 * Dispose of this with splatAliFreeList(). */

struct splatAli *splatAliCommaIn(char **pS, struct splatAli *ret);
/* Create a splatAli out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new splatAli */

void splatAliFree(struct splatAli **pEl);
/* Free a single dynamically allocated splatAli such as created
 * with splatAliLoad(). */

void splatAliFreeList(struct splatAli **pList);
/* Free a list of dynamically allocated splatAli's */

void splatAliOutput(struct splatAli *el, FILE *f, char sep, char lastSep);
/* Print out splatAli.  Separate fields with sep. Follow last field with lastSep. */

#define splatAliTabOut(el,f) splatAliOutput(el,f,'\t','\n');
/* Print out splatAli as a line in a tab-separated file. */

#define splatAliCommaOut(el,f) splatAliOutput(el,f,',',',');
/* Print out splatAli as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

int splatAliCmpReadName(const void *va, const void *vb);
/* Compare two based on readName. Also separate secondarily on chrom position. */

int splatAliScore(char *ali);
/* Score splat-encoded alignment. */

void splatAliLookForBest(struct splatAli *start, struct splatAli *end, 
	int *retBestScore, int *retBestCount);
/* Scan through list from start up to but not including end (which may be NULL)
 * and figure out best score and number of elements in list with that score. */

#endif /* SPLATALI_H */

