/* landmark.c was originally generated by the autoSql program, which also 
 * generated landmark.h and landmark.sql.  This module links the database and
 * the RAM representation of objects. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "landmark.h"


void landmarkStaticLoad(char **row, struct landmark *ret)
/* Load a row from landmark table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->bin = sqlUnsigned(row[0]);
ret->chrom = row[1];
ret->chromStart = sqlUnsigned(row[2]);
ret->chromEnd = sqlUnsigned(row[3]);
ret->name = row[4];
ret->landmarkId = sqlUnsigned(row[5]);
ret->landmarkType = row[6];
}

struct landmark *landmarkLoad(char **row)
/* Load a landmark from row fetched with select * from landmark
 * from database.  Dispose of this with landmarkFree(). */
{
struct landmark *ret;

AllocVar(ret);
ret->bin = sqlUnsigned(row[0]);
ret->chrom = cloneString(row[1]);
ret->chromStart = sqlUnsigned(row[2]);
ret->chromEnd = sqlUnsigned(row[3]);
ret->name = cloneString(row[4]);
ret->landmarkId = sqlUnsigned(row[5]);
ret->landmarkType = cloneString(row[6]);
return ret;
}

struct landmark *landmarkLoadAll(char *fileName) 
/* Load all landmark from a whitespace-separated file.
 * Dispose of this with landmarkFreeList(). */
{
struct landmark *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[7];

while (lineFileRow(lf, row))
    {
    el = landmarkLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct landmark *landmarkLoadAllByChar(char *fileName, char chopper) 
/* Load all landmark from a chopper separated file.
 * Dispose of this with landmarkFreeList(). */
{
struct landmark *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[7];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = landmarkLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct landmark *landmarkLoadByQuery(struct sqlConnection *conn, char *query)
/* Load all landmark from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with landmarkFreeList(). */
{
struct landmark *list = NULL, *el;
struct sqlResult *sr;
char **row;

sr = sqlGetResult(conn, query);
while ((row = sqlNextRow(sr)) != NULL)
    {
    el = landmarkLoad(row);
    slAddHead(&list, el);
    }
slReverse(&list);
sqlFreeResult(&sr);
return list;
}

void landmarkSaveToDb(struct sqlConnection *conn, struct landmark *el, char *tableName, int updateSize)
/* Save landmark as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. Note that strings must be escaped to allow insertion into the database.
 * For example "autosql's features include" --> "autosql\'s features include" 
 * If worried about this use landmarkSaveToDbEscaped() */
{
struct dyString *update = newDyString(updateSize);
dyStringPrintf(update, "insert into %s values ( %u,'%s',%u,%u,'%s',%u,'%s')", 
	tableName,  el->bin,  el->chrom,  el->chromStart,  el->chromEnd,  el->name,  el->landmarkId,  el->landmarkType);
sqlUpdate(conn, update->string);
freeDyString(&update);
}

void landmarkSaveToDbEscaped(struct sqlConnection *conn, struct landmark *el, char *tableName, int updateSize)
/* Save landmark as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size.
 * of a string that would contain the entire query. Automatically 
 * escapes all simple strings (not arrays of string) but may be slower than landmarkSaveToDb().
 * For example automatically copies and converts: 
 * "autosql's features include" --> "autosql\'s features include" 
 * before inserting into database. */ 
{
struct dyString *update = newDyString(updateSize);
char  *chrom, *name, *landmarkType;
chrom = sqlEscapeString(el->chrom);
name = sqlEscapeString(el->name);
landmarkType = sqlEscapeString(el->landmarkType);

dyStringPrintf(update, "insert into %s values ( %u,'%s',%u,%u,'%s',%u,'%s')", 
	tableName, el->bin ,  chrom, el->chromStart , el->chromEnd ,  name, el->landmarkId ,  landmarkType);
sqlUpdate(conn, update->string);
freeDyString(&update);
freez(&chrom);
freez(&name);
freez(&landmarkType);
}

struct landmark *landmarkCommaIn(char **pS, struct landmark *ret)
/* Create a landmark out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new landmark */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->bin = sqlUnsignedComma(&s);
ret->chrom = sqlStringComma(&s);
ret->chromStart = sqlUnsignedComma(&s);
ret->chromEnd = sqlUnsignedComma(&s);
ret->name = sqlStringComma(&s);
ret->landmarkId = sqlUnsignedComma(&s);
ret->landmarkType = sqlStringComma(&s);
*pS = s;
return ret;
}

void landmarkFree(struct landmark **pEl)
/* Free a single dynamically allocated landmark such as created
 * with landmarkLoad(). */
{
struct landmark *el;

if ((el = *pEl) == NULL) return;
freeMem(el->chrom);
freeMem(el->name);
freeMem(el->landmarkType);
freez(pEl);
}

void landmarkFreeList(struct landmark **pList)
/* Free a list of dynamically allocated landmark's */
{
struct landmark *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    landmarkFree(&el);
    }
*pList = NULL;
}

void landmarkOutput(struct landmark *el, FILE *f, char sep, char lastSep) 
/* Print out landmark.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%u", el->bin);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->chrom);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->chromStart);
fputc(sep,f);
fprintf(f, "%u", el->chromEnd);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->landmarkId);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->landmarkType);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

void landmarkAttrStaticLoad(char **row, struct landmarkAttr *ret)
/* Load a row from landmarkAttr table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->landmarkId = sqlUnsigned(row[0]);
ret->linkId = sqlUnsigned(row[1]);
ret->attribute = row[2];
ret->attrVal = row[3];
}

struct landmarkAttr *landmarkAttrLoad(char **row)
/* Load a landmarkAttr from row fetched with select * from landmarkAttr
 * from database.  Dispose of this with landmarkAttrFree(). */
{
struct landmarkAttr *ret;

AllocVar(ret);
ret->landmarkId = sqlUnsigned(row[0]);
ret->linkId = sqlUnsigned(row[1]);
ret->attribute = cloneString(row[2]);
ret->attrVal = cloneString(row[3]);
return ret;
}

struct landmarkAttr *landmarkAttrLoadAll(char *fileName) 
/* Load all landmarkAttr from a whitespace-separated file.
 * Dispose of this with landmarkAttrFreeList(). */
{
struct landmarkAttr *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[4];

while (lineFileRow(lf, row))
    {
    el = landmarkAttrLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct landmarkAttr *landmarkAttrLoadAllByChar(char *fileName, char chopper) 
/* Load all landmarkAttr from a chopper separated file.
 * Dispose of this with landmarkAttrFreeList(). */
{
struct landmarkAttr *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[4];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = landmarkAttrLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct landmarkAttr *landmarkAttrLoadByQuery(struct sqlConnection *conn, char *query)
/* Load all landmarkAttr from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with landmarkAttrFreeList(). */
{
struct landmarkAttr *list = NULL, *el;
struct sqlResult *sr;
char **row;

sr = sqlGetResult(conn, query);
while ((row = sqlNextRow(sr)) != NULL)
    {
    el = landmarkAttrLoad(row);
    slAddHead(&list, el);
    }
slReverse(&list);
sqlFreeResult(&sr);
return list;
}

void landmarkAttrSaveToDb(struct sqlConnection *conn, struct landmarkAttr *el, char *tableName, int updateSize)
/* Save landmarkAttr as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. Note that strings must be escaped to allow insertion into the database.
 * For example "autosql's features include" --> "autosql\'s features include" 
 * If worried about this use landmarkAttrSaveToDbEscaped() */
{
struct dyString *update = newDyString(updateSize);
dyStringPrintf(update, "insert into %s values ( %u,%u,'%s','%s')", 
	tableName,  el->landmarkId,  el->linkId,  el->attribute,  el->attrVal);
sqlUpdate(conn, update->string);
freeDyString(&update);
}

void landmarkAttrSaveToDbEscaped(struct sqlConnection *conn, struct landmarkAttr *el, char *tableName, int updateSize)
/* Save landmarkAttr as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size.
 * of a string that would contain the entire query. Automatically 
 * escapes all simple strings (not arrays of string) but may be slower than landmarkAttrSaveToDb().
 * For example automatically copies and converts: 
 * "autosql's features include" --> "autosql\'s features include" 
 * before inserting into database. */ 
{
struct dyString *update = newDyString(updateSize);
char  *attribute, *attrVal;
attribute = sqlEscapeString(el->attribute);
attrVal = sqlEscapeString(el->attrVal);

dyStringPrintf(update, "insert into %s values ( %u,%u,'%s','%s')", 
	tableName, el->landmarkId , el->linkId ,  attribute,  attrVal);
sqlUpdate(conn, update->string);
freeDyString(&update);
freez(&attribute);
freez(&attrVal);
}

struct landmarkAttr *landmarkAttrCommaIn(char **pS, struct landmarkAttr *ret)
/* Create a landmarkAttr out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new landmarkAttr */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->landmarkId = sqlUnsignedComma(&s);
ret->linkId = sqlUnsignedComma(&s);
ret->attribute = sqlStringComma(&s);
ret->attrVal = sqlStringComma(&s);
*pS = s;
return ret;
}

void landmarkAttrFree(struct landmarkAttr **pEl)
/* Free a single dynamically allocated landmarkAttr such as created
 * with landmarkAttrLoad(). */
{
struct landmarkAttr *el;

if ((el = *pEl) == NULL) return;
freeMem(el->attribute);
freeMem(el->attrVal);
freez(pEl);
}

void landmarkAttrFreeList(struct landmarkAttr **pList)
/* Free a list of dynamically allocated landmarkAttr's */
{
struct landmarkAttr *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    landmarkAttrFree(&el);
    }
*pList = NULL;
}

void landmarkAttrOutput(struct landmarkAttr *el, FILE *f, char sep, char lastSep) 
/* Print out landmarkAttr.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%u", el->landmarkId);
fputc(sep,f);
fprintf(f, "%u", el->linkId);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->attribute);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->attrVal);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

void landmarkAttrLinkStaticLoad(char **row, struct landmarkAttrLink *ret)
/* Load a row from landmarkAttrLink table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->attrId = sqlUnsigned(row[0]);
ret->raKey = row[1];
ret->attrAcc = row[2];
ret->displayVal = row[3];
}

struct landmarkAttrLink *landmarkAttrLinkLoad(char **row)
/* Load a landmarkAttrLink from row fetched with select * from landmarkAttrLink
 * from database.  Dispose of this with landmarkAttrLinkFree(). */
{
struct landmarkAttrLink *ret;

AllocVar(ret);
ret->attrId = sqlUnsigned(row[0]);
ret->raKey = cloneString(row[1]);
ret->attrAcc = cloneString(row[2]);
ret->displayVal = cloneString(row[3]);
return ret;
}

struct landmarkAttrLink *landmarkAttrLinkLoadAll(char *fileName) 
/* Load all landmarkAttrLink from a whitespace-separated file.
 * Dispose of this with landmarkAttrLinkFreeList(). */
{
struct landmarkAttrLink *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[4];

while (lineFileRow(lf, row))
    {
    el = landmarkAttrLinkLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct landmarkAttrLink *landmarkAttrLinkLoadAllByChar(char *fileName, char chopper) 
/* Load all landmarkAttrLink from a chopper separated file.
 * Dispose of this with landmarkAttrLinkFreeList(). */
{
struct landmarkAttrLink *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[4];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = landmarkAttrLinkLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct landmarkAttrLink *landmarkAttrLinkLoadByQuery(struct sqlConnection *conn, char *query)
/* Load all landmarkAttrLink from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with landmarkAttrLinkFreeList(). */
{
struct landmarkAttrLink *list = NULL, *el;
struct sqlResult *sr;
char **row;

sr = sqlGetResult(conn, query);
while ((row = sqlNextRow(sr)) != NULL)
    {
    el = landmarkAttrLinkLoad(row);
    slAddHead(&list, el);
    }
slReverse(&list);
sqlFreeResult(&sr);
return list;
}

void landmarkAttrLinkSaveToDb(struct sqlConnection *conn, struct landmarkAttrLink *el, char *tableName, int updateSize)
/* Save landmarkAttrLink as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. Note that strings must be escaped to allow insertion into the database.
 * For example "autosql's features include" --> "autosql\'s features include" 
 * If worried about this use landmarkAttrLinkSaveToDbEscaped() */
{
struct dyString *update = newDyString(updateSize);
dyStringPrintf(update, "insert into %s values ( %u,'%s','%s','%s')", 
	tableName,  el->attrId,  el->raKey,  el->attrAcc,  el->displayVal);
sqlUpdate(conn, update->string);
freeDyString(&update);
}

void landmarkAttrLinkSaveToDbEscaped(struct sqlConnection *conn, struct landmarkAttrLink *el, char *tableName, int updateSize)
/* Save landmarkAttrLink as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size.
 * of a string that would contain the entire query. Automatically 
 * escapes all simple strings (not arrays of string) but may be slower than landmarkAttrLinkSaveToDb().
 * For example automatically copies and converts: 
 * "autosql's features include" --> "autosql\'s features include" 
 * before inserting into database. */ 
{
struct dyString *update = newDyString(updateSize);
char  *raKey, *attrAcc, *displayVal;
raKey = sqlEscapeString(el->raKey);
attrAcc = sqlEscapeString(el->attrAcc);
displayVal = sqlEscapeString(el->displayVal);

dyStringPrintf(update, "insert into %s values ( %u,'%s','%s','%s')", 
	tableName, el->attrId ,  raKey,  attrAcc,  displayVal);
sqlUpdate(conn, update->string);
freeDyString(&update);
freez(&raKey);
freez(&attrAcc);
freez(&displayVal);
}

struct landmarkAttrLink *landmarkAttrLinkCommaIn(char **pS, struct landmarkAttrLink *ret)
/* Create a landmarkAttrLink out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new landmarkAttrLink */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->attrId = sqlUnsignedComma(&s);
ret->raKey = sqlStringComma(&s);
ret->attrAcc = sqlStringComma(&s);
ret->displayVal = sqlStringComma(&s);
*pS = s;
return ret;
}

void landmarkAttrLinkFree(struct landmarkAttrLink **pEl)
/* Free a single dynamically allocated landmarkAttrLink such as created
 * with landmarkAttrLinkLoad(). */
{
struct landmarkAttrLink *el;

if ((el = *pEl) == NULL) return;
freeMem(el->raKey);
freeMem(el->attrAcc);
freeMem(el->displayVal);
freez(pEl);
}

void landmarkAttrLinkFreeList(struct landmarkAttrLink **pList)
/* Free a list of dynamically allocated landmarkAttrLink's */
{
struct landmarkAttrLink *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    landmarkAttrLinkFree(&el);
    }
*pList = NULL;
}

void landmarkAttrLinkOutput(struct landmarkAttrLink *el, FILE *f, char sep, char lastSep) 
/* Print out landmarkAttrLink.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%u", el->attrId);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->raKey);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->attrAcc);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->displayVal);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

