# ispyTables.sql was originally generated by the autoSql program, which also 
# generated ispyTables.c and ispyTables.h.  This creates the database representation of
# an object which can be loaded and saved from RAM in a fairly 
# automatic way.

#Table patient
CREATE TABLE patient (
    ispyId varchar(255),	# I-SPY identifier uniquely corresponds 1 to 1 to the CALGB patient identifier
    DataExtractDt varchar(255),	# Date data was downloaded from the CALGB database
    Inst_ID varchar(255),	# Registering Institution
              #Indices
    PRIMARY KEY(ispyId)
);

#Table patientInfo
CREATE TABLE patientInfo (
    ispyId varchar(255),	# I-SPY identifier uniquely corresponds 1 to 1 to the CALGB patient identifier
    DataExtractDt varchar(255),	# Date data was downloaded from the CALGB database
    Inst_ID varchar(255),	# Registering Institution
    AgeCat varchar(255),	# Patient Age Category
    Age float,	# Patient Age
    Race_id varchar(255),	# Patient Race (1 case is 136 for white, black and American Indian or Alaska Native)
    Sstat varchar(255),	# Survival Status
    SurvDtD int,	# Survival date (time from study entry to death or last follow-up)
              #Indices
    PRIMARY KEY(ispyId)
);

#Table chemo
CREATE TABLE chemo (
    ispyId varchar(255),	# I-SPY identifier uniquely corresponds 1 to 1 to the CALGB patient identifier
    Chemo varchar(255),	# Neo-Adjuvant Chemotherapy Regimen
    ChemoCat varchar(255),	# Chemotherapy Group Category
    DoseDenseAnthra varchar(255),	# Dose Dense Anthracycline Therapy?
    DoseDenseTaxane varchar(255),	# Dose Dense Taxane Therapy?
    Tam varchar(255),	# Tamoxifen received
    Herceptin varchar(255),	# Herceptin received
              #Indices
    PRIMARY KEY(ispyId)
);

#Table onStudy
CREATE TABLE onStudy (
    ispyId varchar(255),	# I-SPY identifier uniquely corresponds 1 to 1 to the CALGB patient identifier
    MenoStatus varchar(255),	# Menopausal Status
    SentinelNodeSample varchar(255),	# Was Sentinel node sampling performed pre-treatment?
    SentinelNodeResult varchar(255),	# Sentinel Node Biopsy Results pretreatment
    HistTypeInvOS varchar(255),	# Histologic Type of Invasive Tumor (On-Study)
    HistologicGradeOS varchar(255),	# Combined Histologic Grade - On-study (According to SBR/Elston Classification)
    ER_TS int,	# Estrogen Receptor Status - Total Score Total Score = ER_PS+ ER_IS Considered Allred Score; 3 is positive
    PgR_TS int,	# Progesterone Receptor Status - Total Score Total Score = PgR_PgS+ PgR_IS Considered Allred Score; 3 is positive
    Her2CommunityPos varchar(255),	# Her2 Summary as measured in the Community
    Her2CommunityMethod varchar(255),	# Her2 Summary method as measured in the Community
              #Indices
    PRIMARY KEY(ispyId)
);

#Table postSurgery
CREATE TABLE postSurgery (
    ispyId varchar(255),	# I-SPY identifier uniquely corresponds 1 to 1 to the CALGB patient identifier
    SurgeryLumpectomy varchar(255),	# Surgery Procedure Performed was Partial mastectomy/lumpectomy/excisional biopsy
    SurgeryMastectomy varchar(255),	# SurgeryMastectomy Surgery Procedure Performed was Mastectomy, NOS
    InitLump_FupMast varchar(255),	# Initial Lumpectomy Surgery followed by Mastectomy Surgery at a later date
    Surgery varchar(255),	# Did patient have extensive Primary Surgery immediately following chemotherapy?
    DCISonly varchar(255),	# DCIS only thing left following surgery
    PTumor1Szcm_Micro float,	# Primary Tumor Pathological Tumor
    HistologicTypePS varchar(255),	# Histologic Type of Primary Tumor (Post-Surgery)
    HistologicGradePS int,	# Combined Histologic Grade -Post-Surgery (According to SBR/Elston Classification)
    NumPosNodes int,	# Total Number positive Axillary + Sentinel (post) Nodes, post-chemotherapy
    NodesExamined varchar(255),	# Total Number of Axillary + Sentinel (post) nodes Examined, postchemotherapy
    PathologyStage varchar(255),	# Pathology Assessment Staging
    ReasonNoSurg varchar(255),	# Principal Reason Breast Conserving Surgery Not Performed
              #Indices
    PRIMARY KEY(ispyId)
);

#Table followUp
CREATE TABLE followUp (
    ispyId varchar(255),	# I-SPY identifier uniquely corresponds 1 to 1 to the CALGB patient identifier
    RtTherapy varchar(255),	# Has patient received adjuvant radiation therapy (prior to treatment failure or second primary cancer)? 
    RtBreast varchar(255),	# Radiation to Breast
    RtBoost varchar(255),	# Radiation to Boost
    RtAxilla varchar(255),	# Radiation to Axilla
    RtSNode varchar(255),	# Radiation to Supraclavicular node
    RtIMamNode varchar(255),	# Radiation to Internal Mammary node
    RTChestW varchar(255),	# Radiation to Chest Wall
    RtOther varchar(255),	# Radiation to Other Site
              #Indices
    PRIMARY KEY(ispyId)
);

#Table respEval
CREATE TABLE respEval (
    ispyId varchar(255),	# I-SPY identifier uniquely corresponds 1 to 1 to the CALGB patient identifier
    TSizeClinical float,	# Size of Primary Tumor (cm) - Clinical Assessment at Baseline
    NSizeClinical float,	# Size of Largest Palpable Node (cm) - Clinical Assessment at Baseline
    StageTe varchar(255),	# Disease Stage T (metastasis) Baseline
    StageNe varchar(255),	# Disease Stage N (metastasis) Baseline
    StageMe varchar(255),	# Disease Stage M (metastasis) Baseline
    ClinicalStage varchar(255),	# Clinical Staging at Baseline
    ClinRespT1_T2 varchar(255),	# Clinical Response Baseline to Early Treatment
    ClinRespT1_T3 varchar(255),	# Clinical Response Baseline to Inter-Regimen
    ClinRespT1_T4 varchar(255),	# Clinical Response Baseline to Pre-Surgery
              #Indices
    PRIMARY KEY(ispyId)
);

#Table mr
CREATE TABLE mr (
    ispyId varchar(255),	# I-SPY identifier uniquely corresponds 1 to 1 to the CALGB patient identifier
    ChemoCat varchar(255),	# CHEMOCAT
    DoseDenseAnthra varchar(255),	# DOSEDENSEANTHRA
    DoseDenseTaxane varchar(255),	# DOSEDENSETAXANE
    LES_T1 varchar(255),	# Lesion type at T1 Pre-Treatment - Baseline.
    LES_T2 varchar(255),	# Lesion type at the T2 Early Treatment timepoint (as indicated on the M4 form).
    LES_T3 varchar(255),	# Lesion type at the T3 Between Treatment Regimes timepoint (as indicated on the M4 form).
    LES_T4 varchar(255),	# Lesion type at the T4 Pre-Surgery timepoint (as indicated on the M4 form).
    LD_T1 int,	# Longest Diameter (LD) in the cancer mass at T1 Pre-Treatment - Baseline.
    LD_T2 int,	# Longest Diameter (LD) in the cancer mass at the T2 Early Treatment timepoint.
    LD_T3 int,	# Longest Diameter (LD) in the cancer mass at the T3 Between Treatment Regimes timepoint.
    LD_T4 int,	# Longest Diameter (LD) in the cancer mass at the T4 Pre-Surgery timepoint.
    LD_T1_T2_PERCT float,	# The percentage of Longest Dimension (LD) change between T1 and T2
    LD_T1_T3_PERCT float,	# The percentage of Longest Dimension (LD) change between T1 and T3
    LD_T1_T4_PERCT float,	# The percentage of Longest Dimension (LD) change between T1 and T4
    LD_T2_T3_PERCT float,	# The percentage of Longest Dimension (LD) change between T2 and T3
    LD_T2_T4_PERCT float,	# The percentage of Longest Dimension (LD) change between T2 and T4
    LD_T3_T4_PERCT float,	# The percentage of Longest Dimension (LD) change between T3 and T4
    Mri_Pattern_Code varchar(255),	# MRI Pattern Code
    Mri_Pattern_Desc varchar(255),	# MRI Pattern Description
              #Indices
    PRIMARY KEY(ispyId)
);

#Table cdna
CREATE TABLE cdna (
    ispyId varchar(255),	# I-SPY identifier uniquely corresponds 1 to 1 to the CALGB patient identifier
    Cdna_T1 varchar(255),	# CDNA at T1
    Cdna_T2 varchar(255),	# CDNA at T2
    Cdna_T3 varchar(255),	# CDNA at T3
    Cdna_T4 varchar(255),	# CDNA at T4
              #Indices
    PRIMARY KEY(ispyId)
);

#Table agi
CREATE TABLE agi (
    ispyId varchar(255),	# I-SPY identifier uniquely corresponds 1 to 1 to the CALGB patient identifier
    Agi_T1 varchar(255),	# AGI at T1
    Agi_T2 varchar(255),	# AGI at T2
    Agi_T3 varchar(255),	# AGI at T3
    Agi_T4 varchar(255),	# AGI at T4
              #Indices
    PRIMARY KEY(ispyId)
);

#Table ihc
CREATE TABLE ihc (
    ispyId varchar(255),	# I-SPY identifier uniquely corresponds 1 to 1 to the CALGB patient identifier
    Ihc_T1 varchar(255),	# IHC at T1
    Ihc_T2 varchar(255),	# IHC at T2
    Ihc_T3 varchar(255),	# IHC at T3
    Ihc_T4 varchar(255),	# IHC at T4
              #Indices
    PRIMARY KEY(ispyId)
);

#Table fish
CREATE TABLE fish (
    ispyId varchar(255),	# I-SPY identifier uniquely corresponds 1 to 1 to the CALGB patient identifier
    Fish_T1 varchar(255),	# FISH at T1
    Fish_T2 varchar(255),	# FISH at T2
    Fish_T3 varchar(255),	# FISH at T3
    Fish_T4 varchar(255),	# FISH at T4
              #Indices
    PRIMARY KEY(ispyId)
);

#Table labTrack
CREATE TABLE labTrack (
    ispyId varchar(255),	# I-SPY identifier uniquely corresponds 1 to 1 to the CALGB patient identifier
    trackId varchar(255),	# Lab Track ID
    coreType varchar(255),	# Core Type
    timePoint varchar(255),	# Time Point
    section varchar(255),	# Section
              #Indices
    PRIMARY KEY(ispyId)
);
