/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.cmd;

import tim.prune.cmd.Command;
import tim.prune.cmd.InsertPointCmd;
import tim.prune.data.DataPoint;
import tim.prune.data.TrackInfo;

public class DeletePointCmd
extends Command {
    private final int _pointIndex;

    public DeletePointCmd(int n, String string) {
        this(null, n);
    }

    protected DeletePointCmd(Command command, int n) {
        super(command);
        this._pointIndex = n;
    }

    @Override
    public int getUpdateFlags() {
        return 1;
    }

    @Override
    protected boolean executeCommand(TrackInfo trackInfo) {
        int n = this._pointIndex < 0 ? trackInfo.getTrack().getNumPoints() - 1 : this._pointIndex;
        return trackInfo.deletePoint(n);
    }

    @Override
    protected Command makeInverse(TrackInfo trackInfo) {
        DataPoint dataPoint = trackInfo.getTrack().getPoint(this._pointIndex);
        DataPoint dataPoint2 = trackInfo.getTrack().getNextTrackPoint(this._pointIndex + 1);
        boolean bl = dataPoint2 != null && dataPoint2.getSegmentStart();
        return new InsertPointCmd(this, dataPoint, this._pointIndex, bl);
    }
}

