/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.cmdline.libclone;

import java.util.Enumeration;
import java.util.HashSet;
import org.hsqldb.cmdline.libclone.RefCapablePropertyResourceBundle;

public class ValidatingResourceBundle {
    protected boolean validated = false;
    protected Class<? extends Enum<?>> enumType;
    public static final int THROW_BEHAVIOR = 0;
    public static final int EMPTYSTRING_BEHAVIOR = 1;
    public static final int NOOP_BEHAVIOR = 2;
    protected RefCapablePropertyResourceBundle wrappedRCPRB;
    private int missingPropertyBehavior = 0;
    private int missingPosValueBehavior = 0;

    public static String resourceKeyFor(Enum<?> enum_) {
        return enum_.name().replace('_', '.');
    }

    public ValidatingResourceBundle(String string, Class<? extends Enum<?>> clazz) {
        this.enumType = clazz;
        try {
            this.wrappedRCPRB = RefCapablePropertyResourceBundle.getBundle(string, clazz.getClassLoader(), clazz);
            this.validate();
        }
        catch (RuntimeException runtimeException) {
            System.err.println("Failed to initialize resource bundle: " + runtimeException);
            throw runtimeException;
        }
    }

    public String getString(Enum<?> enum_) {
        if (!this.enumType.isInstance(enum_)) {
            throw new IllegalArgumentException("Key is a " + enum_.getClass().getName() + ",not a " + this.enumType.getName() + ":  " + enum_);
        }
        return this.wrappedRCPRB.getString(enum_.toString());
    }

    public String getString(Enum<?> enum_, String ... stringArray) {
        if (!this.enumType.isInstance(enum_)) {
            throw new IllegalArgumentException("Key is a " + enum_.getClass().getName() + ",not a " + this.enumType.getName() + ":  " + enum_);
        }
        return this.wrappedRCPRB.getString(enum_.toString(), stringArray, this.missingPosValueBehavior);
    }

    public String getExpandedString(Enum<?> enum_) {
        if (!this.enumType.isInstance(enum_)) {
            throw new IllegalArgumentException("Key is a " + enum_.getClass().getName() + ",not a " + this.enumType.getName() + ":  " + enum_);
        }
        return this.wrappedRCPRB.getExpandedString(enum_.toString(), this.missingPropertyBehavior);
    }

    public String getExpandedString(Enum<?> enum_, String ... stringArray) {
        if (!this.enumType.isInstance(enum_)) {
            throw new IllegalArgumentException("Key is a " + enum_.getClass().getName() + ",not a " + this.enumType.getName() + ":  " + enum_);
        }
        return this.wrappedRCPRB.getExpandedString(enum_.toString(), stringArray, this.missingPropertyBehavior, this.missingPosValueBehavior);
    }

    public void setMissingPropertyBehavior(int n) {
        this.missingPropertyBehavior = n;
    }

    public void setMissingPosValueBehavior(int n) {
        this.missingPosValueBehavior = n;
    }

    public int getMissingPropertyBehavior() {
        return this.missingPropertyBehavior;
    }

    public int getMissingPosValueBehavior() {
        return this.missingPosValueBehavior;
    }

    public void validate() {
        if (this.validated) {
            return;
        }
        this.validated = true;
        HashSet<String> hashSet = new HashSet<String>();
        for (Enum<?> enum_ : this.enumType.getEnumConstants()) {
            hashSet.add(enum_.toString());
        }
        Enumeration<String> enumeration = this.wrappedRCPRB.getKeys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.wrappedRCPRB.getString(string);
            hashSet.remove(string);
        }
        if (hashSet.size() > 0) {
            throw new RuntimeException("Resource Bundle pre-validation failed.  Missing property with key:  " + hashSet);
        }
    }

    public String getString(Enum<?> enum_, int n) {
        if (!this.enumType.isInstance(enum_)) {
            throw new IllegalArgumentException("Key is a " + enum_.getClass().getName() + ",not a " + this.enumType.getName() + ":  " + enum_);
        }
        return this.getString(enum_, Integer.toString(n));
    }

    public String getString(Enum<?> enum_, int n, int n2) {
        if (!this.enumType.isInstance(enum_)) {
            throw new IllegalArgumentException("Key is a " + enum_.getClass().getName() + ",not a " + this.enumType.getName() + ":  " + enum_);
        }
        return this.getString(enum_, Integer.toString(n), Integer.toString(n2));
    }

    public String getString(Enum<?> enum_, int n, int n2, int n3) {
        if (!this.enumType.isInstance(enum_)) {
            throw new IllegalArgumentException("Key is a " + enum_.getClass().getName() + ",not a " + this.enumType.getName() + ":  " + enum_);
        }
        return this.getString(enum_, Integer.toString(n), Integer.toString(n2), Integer.toString(n3));
    }

    public String getString(Enum<?> enum_, int n, String string) {
        if (!this.enumType.isInstance(enum_)) {
            throw new IllegalArgumentException("Key is a " + enum_.getClass().getName() + ",not a " + this.enumType.getName() + ":  " + enum_);
        }
        return this.getString(enum_, Integer.toString(n), string);
    }

    public String getString(Enum<?> enum_, String string, int n) {
        if (!this.enumType.isInstance(enum_)) {
            throw new IllegalArgumentException("Key is a " + enum_.getClass().getName() + ",not a " + this.enumType.getName() + ":  " + enum_);
        }
        return this.getString(enum_, string, Integer.toString(n));
    }

    public String getString(Enum<?> enum_, int n, int n2, String string) {
        if (!this.enumType.isInstance(enum_)) {
            throw new IllegalArgumentException("Key is a " + enum_.getClass().getName() + ",not a " + this.enumType.getName() + ":  " + enum_);
        }
        return this.getString(enum_, Integer.toString(n), Integer.toString(n2), string);
    }

    public String getString(Enum<?> enum_, int n, String string, int n2) {
        if (!this.enumType.isInstance(enum_)) {
            throw new IllegalArgumentException("Key is a " + enum_.getClass().getName() + ",not a " + this.enumType.getName() + ":  " + enum_);
        }
        return this.getString(enum_, Integer.toString(n), string, Integer.toString(n2));
    }

    public String getString(Enum<?> enum_, String string, int n, int n2) {
        if (!this.enumType.isInstance(enum_)) {
            throw new IllegalArgumentException("Key is a " + enum_.getClass().getName() + ",not a " + this.enumType.getName() + ":  " + enum_);
        }
        return this.getString(enum_, string, Integer.toString(n), Integer.toString(n2));
    }

    public String getString(Enum<?> enum_, int n, String string, String string2) {
        if (!this.enumType.isInstance(enum_)) {
            throw new IllegalArgumentException("Key is a " + enum_.getClass().getName() + ",not a " + this.enumType.getName() + ":  " + enum_);
        }
        return this.getString(enum_, Integer.toString(n), string, string2);
    }

    public String getString(Enum<?> enum_, String string, String string2, int n) {
        if (!this.enumType.isInstance(enum_)) {
            throw new IllegalArgumentException("Key is a " + enum_.getClass().getName() + ",not a " + this.enumType.getName() + ":  " + enum_);
        }
        return this.getString(enum_, string, string2, Integer.toString(n));
    }

    public String getString(Enum<?> enum_, String string, int n, String string2) {
        if (!this.enumType.isInstance(enum_)) {
            throw new IllegalArgumentException("Key is a " + enum_.getClass().getName() + ",not a " + this.enumType.getName() + ":  " + enum_);
        }
        return this.getString(enum_, string, Integer.toString(n), string2);
    }
}

