/******************************************************************************
 *{@C
 *      Copyright:      2005-2022 Paul Obermeier (obermeier@tcl3d.org)
 *
 *                      See the file "Tcl3D_License.txt" for information on
 *                      usage and redistribution of this file, and for a
 *                      DISCLAIMER OF ALL WARRANTIES.
 *
 *      Module:         Tcl3D
 *      Filename:       tcl3dTypemaps.i
 *
 *      Author:         Paul Obermeier
 *
 *      Description:    SWIG file defining typemaps needed for OpenGL wrapping.
 *
 *                      Note: tcl3dVectors of type "char", "unsigned char", 
 *                      GLchar and GLcharARB are not supported, because the
 *                      corresponding typemaps would collide with the standard
 *                      SWIG mapping for C strings.
 *                      Use types GLbyte and GLubyte, if you need tcl3dVectors
 *                      with element sizes of 1 byte.
 *
 *****************************************************************************/

%typemap(in) const double * (double *tmp) {
    if ((tmp = GetDoubleList (interp, $input)) == NULL) {
        return TCL_ERROR;
    } else {
        $1 = tmp;
    }
}

%typemap(freearg) const double * (double *tmp) {
    if ($1) { 
        free ($1);
    }
}

%typemap(in) const float * (float *tmp) {
    if ((tmp = GetFloatList (interp, $input)) == NULL) {
        return TCL_ERROR;
    } else {
        $1 = tmp;
    }
}

%typemap(freearg) const float * (float *tmp) {
    if ($1) { 
        free ($1);
    }
}



%typemap(in) const int * (int *tmp) {
    if ((tmp = GetIntList (interp, $input)) == NULL) {
        return TCL_ERROR;
    } else {
        $1 = tmp;
    }
}

%typemap(freearg) const int * (int *tmp) {
    if ($1) { 
        free ($1);
    }
}

%typemap(in) const unsigned int * (unsigned int *tmp) {
    if ((tmp = GetUIntList (interp, $input)) == NULL) {
        return TCL_ERROR;
    } else {
        $1 = tmp;
    }
}

%typemap(freearg) const unsigned int * (unsigned int *tmp) {
    if ($1) { 
        free ($1);
    }
}



%typemap(in) const short * (short *tmp) {
    if ((tmp = GetShortList (interp, $input)) == NULL) {
        return TCL_ERROR;
    } else {
        $1 = tmp;
    }
}

%typemap(freearg) const short * (short *tmp) {
    if ($1) { 
        free ($1);
    }
}

%typemap(in) const unsigned short * (unsigned short *tmp) {
    if ((tmp = GetUShortList (interp, $input)) == NULL) {
        return TCL_ERROR;
    } else {
        $1 = tmp;
    }
}

%typemap(freearg) const unsigned short * (unsigned short *tmp) {
    if ($1) { 
        free ($1);
    }
}



%typemap(in) const GLint * (GLint *tmp) {
    if ((tmp = (GLint *)GetIntList (interp, $input)) == NULL) {
        return TCL_ERROR;
    } else {
        $1 = tmp;
    }
}

%typemap(freearg) const GLint * (GLint *tmp) {
    if ($1) { 
        free ($1);
    }
}

%typemap(in) const GLuint * (GLuint *tmp) {
    if ((tmp = (GLuint *)GetUIntList (interp, $input)) == NULL) {
        return TCL_ERROR;
    } else {
        $1 = tmp;
    }
}

%typemap(freearg) const GLuint * (GLuint *tmp) {
    if ($1) { 
        free ($1);
    }
}



%typemap(in) const GLshort * (GLshort *tmp) {
    if ((tmp = (GLshort *)GetShortList (interp, $input)) == NULL) {
        return TCL_ERROR;
    } else {
        $1 = tmp;
    }
}

%typemap(freearg) const GLshort * (GLshort *tmp) {
    if ($1) { 
        free ($1);
    }
}

%typemap(in) const GLushort * (GLushort *tmp) {
    if ((tmp = (GLushort *)GetUShortList (interp, $input)) == NULL) {
        return TCL_ERROR;
    } else {
        $1 = tmp;
    }
}

%typemap(freearg) const GLushort * (GLushort *tmp) {
    if ($1) { 
        free ($1);
    }
}



%typemap(in) const GLbyte * (GLbyte *tmp) {
    if ((tmp = (GLbyte *)GetByteList (interp, $input)) == NULL) {
        return TCL_ERROR;
    } else {
        $1 = tmp;
    }
}

%typemap(freearg) const GLbyte * (GLbyte *tmp) {
    if ($1) { 
        free ($1);
    }
}

%typemap(in) const GLubyte * (GLubyte *tmp) {
    if ((tmp = (GLubyte *)GetUByteList (interp, $input)) == NULL) {
        return TCL_ERROR;
    } else {
        $1 = tmp;
    }
}

%typemap(freearg) const GLubyte * (GLubyte *tmp) {
    if ($1) { 
        free ($1);
    }
}

%typemap(in) const GLboolean * (GLboolean *tmp) {
    if ((tmp = (GLboolean *)GetUByteList (interp, $input)) == NULL) {
        return TCL_ERROR;
    } else {
        $1 = tmp;
    }
}

%typemap(freearg) const GLboolean * (GLboolean *tmp) {
    if ($1) { 
        free ($1);
    }
}

%typemap(in) const GLbitfield * (GLbitfield *tmp) {
    if ((tmp = (GLbitfield *)GetUIntList (interp, $input)) == NULL) {
        return TCL_ERROR;
    } else {
        $1 = tmp;
    }
}

%typemap(freearg) const GLbitfield * (GLbitfield *tmp) {
    if ($1) { 
        free ($1);
    }
}

%typemap(in) const GLenum * (GLenum *tmp) {
    if ((tmp = (GLenum *)GetUIntList (interp, $input)) == NULL) {
        return TCL_ERROR;
    } else {
        $1 = tmp;
    }
}

%typemap(freearg) const GLenum * (GLenum *tmp) {
    if ($1) { 
        free ($1);
    }
}
