/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.encryption.impl;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.util.Set;
import javax.crypto.SecretKey;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.GradleException;
import org.gradle.api.InvalidUserDataException;
import org.gradle.cache.scopes.GlobalScopedCacheBuilderFactory;
import org.gradle.internal.buildoption.InternalOptions;
import org.gradle.internal.encryption.EncryptionService;
import org.gradle.internal.encryption.impl.DefaultEncryptionService;
import org.gradle.internal.encryption.impl.EncryptionKind;
import org.gradle.internal.encryption.impl.EnvironmentVarKeySource;
import org.gradle.internal.encryption.impl.KeyStoreKeySource;
import org.gradle.internal.encryption.impl.NoEncryptionKeySource;
import org.gradle.internal.encryption.impl.SecretKeySource;
import org.gradle.internal.extensions.core.InternalOptionsExtensionsKt;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.hash.Hashing;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;
import org.gradle.util.internal.EncryptionAlgorithm;
import org.gradle.util.internal.SupportedEncryptionAlgorithm;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ServiceScope(value={Scope.BuildTree.class})
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0001\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001aH\u0002J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"H\u0016J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020%H\u0016J\u0012\u0010'\u001a\u0004\u0018\u00010\u001a2\u0006\u0010(\u001a\u00020)H\u0002J\u0012\u0010*\u001a\u0004\u0018\u00010\u001a2\u0006\u0010+\u001a\u00020,H\u0002J\u0010\u0010-\u001a\u00020,2\u0006\u0010.\u001a\u00020)H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0007\u001a\u00020\b8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000f\u001a\u00020\u00108VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\f\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0019\u001a\u0004\u0018\u00010\u001a8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\f\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006/"}, d2={"Lorg/gradle/internal/encryption/impl/DefaultEncryptionService;", "Lorg/gradle/internal/encryption/EncryptionService;", "options", "Lorg/gradle/internal/buildoption/InternalOptions;", "cacheBuilderFactory", "Lorg/gradle/cache/scopes/GlobalScopedCacheBuilderFactory;", "(Lorg/gradle/internal/buildoption/InternalOptions;Lorg/gradle/cache/scopes/GlobalScopedCacheBuilderFactory;)V", "encryptionAlgorithm", "Lorg/gradle/util/internal/EncryptionAlgorithm;", "getEncryptionAlgorithm", "()Lorg/gradle/util/internal/EncryptionAlgorithm;", "encryptionAlgorithm$delegate", "Lkotlin/Lazy;", "encryptionAlgorithmOption", "", "encryptionKeyHashCode", "Lorg/gradle/internal/hash/HashCode;", "getEncryptionKeyHashCode", "()Lorg/gradle/internal/hash/HashCode;", "encryptionKeyHashCode$delegate", "encryptionRequestedOption", "", "isEncrypting", "()Z", "keystoreDirOption", "secretKey", "Ljavax/crypto/SecretKey;", "getSecretKey", "()Ljavax/crypto/SecretKey;", "secretKey$delegate", "assertKeyLength", "", "key", "inputStream", "Ljava/io/InputStream;", "input", "outputStream", "Ljava/io/OutputStream;", "output", "produceSecretKey", "encryptionKind", "Lorg/gradle/internal/encryption/impl/EncryptionKind;", "secretKeyFrom", "keySource", "Lorg/gradle/internal/encryption/impl/SecretKeySource;", "secretKeySource", "kind", "encryption-services"})
@SourceDebugExtension(value={"SMAP\nDefaultEncryptionService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultEncryptionService.kt\norg/gradle/internal/encryption/impl/DefaultEncryptionService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,137:1\n1#2:138\n*E\n"})
public final class DefaultEncryptionService
implements EncryptionService {
    @NotNull
    private final GlobalScopedCacheBuilderFactory cacheBuilderFactory;
    private final boolean encryptionRequestedOption;
    @Nullable
    private final String keystoreDirOption;
    @NotNull
    private final String encryptionAlgorithmOption;
    @NotNull
    private final Lazy secretKey$delegate;
    @NotNull
    private final Lazy encryptionAlgorithm$delegate;
    @NotNull
    private final Lazy encryptionKeyHashCode$delegate;

    public DefaultEncryptionService(@NotNull InternalOptions options, @NotNull GlobalScopedCacheBuilderFactory cacheBuilderFactory) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)cacheBuilderFactory, (String)"cacheBuilderFactory");
        this.cacheBuilderFactory = cacheBuilderFactory;
        this.encryptionRequestedOption = InternalOptionsExtensionsKt.getInternalFlag((InternalOptions)options, (String)"org.gradle.configuration-cache.internal.encryption", (boolean)true);
        this.keystoreDirOption = InternalOptionsExtensionsKt.getInternalString((InternalOptions)options, (String)"org.gradle.configuration-cache.internal.key-store-dir", null);
        String string = InternalOptionsExtensionsKt.getInternalString((InternalOptions)options, (String)"org.gradle.configuration-cache.internal.encryption-alg", (String)SupportedEncryptionAlgorithm.getDefault().getTransformation());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"options.getInternalStrin\u2026Default().transformation)");
        this.encryptionAlgorithmOption = string;
        this.secretKey$delegate = LazyKt.lazy((Function0)((Function0)new Function0<SecretKey>(this){
            final /* synthetic */ DefaultEncryptionService this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final SecretKey invoke() {
                return DefaultEncryptionService.access$produceSecretKey(this.this$0, EncryptionKind.Companion.select(DefaultEncryptionService.access$getEncryptionRequestedOption$p(this.this$0)));
            }
        }));
        this.encryptionAlgorithm$delegate = LazyKt.lazy((Function0)((Function0)new Function0<EncryptionAlgorithm>(this){
            final /* synthetic */ DefaultEncryptionService this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final EncryptionAlgorithm invoke() {
                Object v1;
                block2: {
                    Set set = SupportedEncryptionAlgorithm.getAll();
                    Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getAll()");
                    Iterable iterable = set;
                    DefaultEncryptionService defaultEncryptionService = this.this$0;
                    Iterable iterable2 = iterable;
                    for (T t : iterable2) {
                        EncryptionAlgorithm it = (EncryptionAlgorithm)t;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getTransformation(), (Object)DefaultEncryptionService.access$getEncryptionAlgorithmOption$p(defaultEncryptionService))) continue;
                        v1 = t;
                        break block2;
                    }
                    v1 = null;
                }
                EncryptionAlgorithm encryptionAlgorithm2 = v1;
                if (encryptionAlgorithm2 == null) {
                    StringBuilder stringBuilder = new StringBuilder().append("Unsupported encryption algorithm: ").append(DefaultEncryptionService.access$getEncryptionAlgorithmOption$p(this.this$0)).append(". Supported algorithms are: ");
                    Set set = SupportedEncryptionAlgorithm.getAll();
                    Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getAll()");
                    throw new InvalidUserDataException(stringBuilder.append(CollectionsKt.joinToString$default((Iterable)set, null, null, null, (int)0, null, (Function1)encryptionAlgorithm.2.INSTANCE, (int)31, null)).toString());
                }
                return encryptionAlgorithm2;
            }
        }));
        this.encryptionKeyHashCode$delegate = LazyKt.lazy((Function0)((Function0)new Function0<HashCode>(this){
            final /* synthetic */ DefaultEncryptionService this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final HashCode invoke() {
                SecretKey secretKey2;
                block3: {
                    block2: {
                        Hasher hasher;
                        secretKey2 = DefaultEncryptionService.access$getSecretKey(this.this$0);
                        if (secretKey2 == null) break block2;
                        SecretKey secretKey3 = secretKey2;
                        DefaultEncryptionService defaultEncryptionService = this.this$0;
                        SecretKey it = secretKey3;
                        boolean bl = false;
                        Hasher $this$invoke_u24lambda_u241_u24lambda_u240 = hasher = Hashing.sha512().newHasher();
                        boolean bl2 = false;
                        $this$invoke_u24lambda_u241_u24lambda_u240.putBytes(it.getEncoded());
                        $this$invoke_u24lambda_u241_u24lambda_u240.putString((CharSequence)defaultEncryptionService.getEncryptionAlgorithm().getTransformation());
                        HashCode hashCode = hasher.hash();
                        secretKey2 = hashCode;
                        if (hashCode != null) break block3;
                    }
                    secretKey2 = Hashing.newHasher().hash();
                }
                Intrinsics.checkNotNullExpressionValue((Object)secretKey2, (String)"secretKey?.let {\n       \u2026ashing.newHasher().hash()");
                return secretKey2;
            }
        }));
    }

    private final SecretKey getSecretKey() {
        Lazy lazy = this.secretKey$delegate;
        return (SecretKey)lazy.getValue();
    }

    private final SecretKey produceSecretKey(EncryptionKind encryptionKind) {
        SecretKey secretKey2;
        SecretKeySource keySource = this.secretKeySource(encryptionKind);
        boolean bl = false;
        try {
            SecretKey secretKey3;
            SecretKey secretKey4 = this.secretKeyFrom(keySource);
            if (secretKey4 != null) {
                SecretKey secretKey5;
                SecretKey key = secretKey5 = secretKey4;
                boolean bl2 = false;
                this.assertKeyLength(key);
                secretKey3 = secretKey5;
            } else {
                secretKey3 = null;
            }
            secretKey2 = secretKey3;
        }
        catch (Exception e) {
            throw new GradleException("Error loading encryption key from " + keySource.getSourceDescription(), (Throwable)e);
        }
        return secretKey2;
    }

    private final SecretKey secretKeyFrom(SecretKeySource keySource) {
        return keySource.getKey();
    }

    private final void assertKeyLength(SecretKey key) {
        int keyLength = key.getEncoded().length;
        if (keyLength < 16) {
            throw new InvalidKeyException("Encryption key length is " + keyLength + " bytes, but must be at least 16 bytes long");
        }
    }

    @Override
    @NotNull
    public EncryptionAlgorithm getEncryptionAlgorithm() {
        Lazy lazy = this.encryptionAlgorithm$delegate;
        return (EncryptionAlgorithm)lazy.getValue();
    }

    @Override
    public boolean isEncrypting() {
        return this.getSecretKey() != null;
    }

    @Override
    @NotNull
    public HashCode getEncryptionKeyHashCode() {
        Lazy lazy = this.encryptionKeyHashCode$delegate;
        return (HashCode)lazy.getValue();
    }

    @Override
    @NotNull
    public OutputStream outputStream(@NotNull OutputStream output) {
        OutputStream outputStream;
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        if (this.isEncrypting()) {
            OutputStream outputStream2 = this.getEncryptionAlgorithm().encryptedStream(output, this.getSecretKey());
            outputStream = outputStream2;
            Intrinsics.checkNotNullExpressionValue((Object)outputStream2, (String)"encryptionAlgorithm.encr\u2026Stream(output, secretKey)");
        } else {
            outputStream = output;
        }
        return outputStream;
    }

    @Override
    @NotNull
    public InputStream inputStream(@NotNull InputStream input) {
        InputStream inputStream;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        if (this.isEncrypting()) {
            InputStream inputStream2 = this.getEncryptionAlgorithm().decryptedStream(input, this.getSecretKey());
            inputStream = inputStream2;
            Intrinsics.checkNotNullExpressionValue((Object)inputStream2, (String)"encryptionAlgorithm.decr\u2026dStream(input, secretKey)");
        } else {
            inputStream = input;
        }
        return inputStream;
    }

    /*
     * WARNING - void declaration
     */
    private final SecretKeySource secretKeySource(EncryptionKind kind) {
        SecretKeySource secretKeySource;
        switch (WhenMappings.$EnumSwitchMapping$0[kind.ordinal()]) {
            case 1: {
                File file;
                String string = this.getEncryptionAlgorithm().getAlgorithm();
                String string2 = string;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encryptionAlgorithm.algorithm");
                String string3 = this.keystoreDirOption;
                if (string3 != null) {
                    void it;
                    String string4 = string3;
                    String string5 = string2;
                    boolean bl = false;
                    file = new File((String)it);
                    string2 = string5;
                } else {
                    file = null;
                }
                GlobalScopedCacheBuilderFactory globalScopedCacheBuilderFactory = this.cacheBuilderFactory;
                String string6 = "gradle-secret";
                File file2 = file;
                String string7 = string2;
                secretKeySource = new KeyStoreKeySource(string7, file2, string6, globalScopedCacheBuilderFactory);
                break;
            }
            case 2: {
                String string = this.getEncryptionAlgorithm().getAlgorithm();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encryptionAlgorithm.algorithm");
                secretKeySource = new EnvironmentVarKeySource(string);
                break;
            }
            case 3: {
                secretKeySource = new NoEncryptionKeySource();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return secretKeySource;
    }

    public static final /* synthetic */ SecretKey access$produceSecretKey(DefaultEncryptionService $this, EncryptionKind encryptionKind) {
        return $this.produceSecretKey(encryptionKind);
    }

    public static final /* synthetic */ boolean access$getEncryptionRequestedOption$p(DefaultEncryptionService $this) {
        return $this.encryptionRequestedOption;
    }

    public static final /* synthetic */ String access$getEncryptionAlgorithmOption$p(DefaultEncryptionService $this) {
        return $this.encryptionAlgorithmOption;
    }

    public static final /* synthetic */ SecretKey access$getSecretKey(DefaultEncryptionService $this) {
        return $this.getSecretKey();
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[EncryptionKind.values().length];
            try {
                nArray[EncryptionKind.KEYSTORE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EncryptionKind.ENV_VAR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EncryptionKind.NONE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

