/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.Transformer;
import org.gradle.api.internal.provider.AbstractMinimalProvider;
import org.gradle.api.internal.provider.AbstractProperty;
import org.gradle.api.internal.provider.EvaluationContext;
import org.gradle.api.internal.provider.ManagedFactories;
import org.gradle.api.internal.provider.MapCollector;
import org.gradle.api.internal.provider.MapCollectors;
import org.gradle.api.internal.provider.MapEntryCollector;
import org.gradle.api.internal.provider.MapPropertyInternal;
import org.gradle.api.internal.provider.MapProviderInternal;
import org.gradle.api.internal.provider.MapSupplier;
import org.gradle.api.internal.provider.PropertyHost;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.internal.provider.Providers;
import org.gradle.api.internal.provider.ValidatingMapEntryCollector;
import org.gradle.api.internal.provider.ValidatingValueCollector;
import org.gradle.api.internal.provider.ValueCollector;
import org.gradle.api.internal.provider.ValueSanitizers;
import org.gradle.api.internal.provider.ValueSupplier;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Provider;
import org.gradle.internal.Cast;
import org.jetbrains.annotations.Nullable;

public class DefaultMapProperty<K, V>
extends AbstractProperty<Map<K, V>, MapSupplier<K, V>>
implements MapProperty<K, V>,
MapProviderInternal<K, V>,
MapPropertyInternal<K, V> {
    private static final String NULL_KEY_FORBIDDEN_MESSAGE = String.format("Cannot add an entry with a null key to a property of type %s.", Map.class.getSimpleName());
    private static final String NULL_VALUE_FORBIDDEN_MESSAGE = String.format("Cannot add an entry with a null value to a property of type %s.", Map.class.getSimpleName());
    private final Class<K> keyType;
    private final Class<V> valueType;
    private final ValueCollector<K> keyCollector;
    private final MapEntryCollector<K, V> entryCollector;
    private MapSupplier<K, V> defaultValue = this.emptySupplier();

    public DefaultMapProperty(PropertyHost propertyHost, Class<K> keyType, Class<V> valueType) {
        super(propertyHost);
        this.keyType = keyType;
        this.valueType = valueType;
        this.keyCollector = new ValidatingValueCollector<K>(Set.class, keyType, ValueSanitizers.forType(keyType));
        this.entryCollector = new ValidatingMapEntryCollector<K, V>(keyType, valueType, ValueSanitizers.forType(keyType), ValueSanitizers.forType(valueType));
        this.init();
    }

    private void init() {
        this.defaultValue = this.emptySupplier();
        this.init(this.defaultValue, this.noValueSupplier());
    }

    @Override
    public MapSupplier<K, V> getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    protected MapSupplier<K, V> getDefaultConvention() {
        return this.noValueSupplier();
    }

    @Override
    protected boolean isDefaultConvention() {
        return this.isNoValueSupplier((MapSupplier)this.getConventionSupplier());
    }

    private MapSupplier<K, V> emptySupplier() {
        return new EmptySupplier();
    }

    private MapSupplier<K, V> noValueSupplier() {
        return (MapSupplier)Cast.uncheckedCast((Object)new NoValueSupplier(ValueSupplier.Value.missing()));
    }

    @Override
    @javax.annotation.Nullable
    public Class<Map<K, V>> getType() {
        return Map.class;
    }

    @Override
    public Class<K> getKeyType() {
        return this.keyType;
    }

    @Override
    public Class<V> getValueType() {
        return this.valueType;
    }

    @Override
    public Class<?> publicType() {
        return MapProperty.class;
    }

    @Override
    public int getFactoryId() {
        return ManagedFactories.MapPropertyManagedFactory.FACTORY_ID;
    }

    public Provider<V> getting(K key) {
        return new EntryProvider(key);
    }

    public MapProperty<K, V> empty() {
        this.setSupplier(this.emptySupplier());
        return this;
    }

    @Override
    public void setFromAnyValue(@javax.annotation.Nullable Object object) {
        if (object == null || object instanceof Map) {
            this.set((Map)object);
        } else if (object instanceof Provider) {
            this.set((Provider)object);
        } else {
            throw new IllegalArgumentException(String.format("Cannot set the value of a property of type %s using an instance of type %s.", Map.class.getName(), object.getClass().getName()));
        }
    }

    public void set(@javax.annotation.Nullable Map<? extends K, ? extends V> entries) {
        if (entries == null) {
            this.unsetValueAndDefault();
        } else {
            this.setSupplier(new CollectingSupplier(new MapCollectors.EntriesFromMap<K, V>(entries), false));
        }
    }

    public void set(Provider<? extends Map<? extends K, ? extends V>> provider) {
        this.setSupplier(new CollectingSupplier(new MapCollectors.EntriesFromMapProvider<K, V>(this.checkMapProvider(provider)), false));
    }

    public MapProperty<K, V> value(@javax.annotation.Nullable Map<? extends K, ? extends V> entries) {
        this.set(entries);
        return this;
    }

    public MapProperty<K, V> value(Provider<? extends Map<? extends K, ? extends V>> provider) {
        this.set(provider);
        return this;
    }

    public void put(K key, V value) {
        this.getConfigurer().put(key, value);
    }

    public void put(K key, Provider<? extends V> providerOfValue) {
        this.getConfigurer().put(key, providerOfValue);
    }

    public void putAll(Map<? extends K, ? extends V> entries) {
        this.getConfigurer().putAll(entries);
    }

    public void putAll(Provider<? extends Map<? extends K, ? extends V>> provider) {
        this.getConfigurer().putAll(provider);
    }

    @Override
    public void insert(K key, Provider<? extends V> providerOfValue) {
        this.withActualValue((Action<Configurer>)((Action)it -> it.put(key, providerOfValue)));
    }

    @Override
    public void insert(K key, V value) {
        this.withActualValue((Action<Configurer>)((Action)it -> it.put(key, value)));
    }

    @Override
    public void insertAll(Provider<? extends Map<? extends K, ? extends V>> provider) {
        this.withActualValue((Action<Configurer>)((Action)it -> it.putAll(provider)));
    }

    @Override
    public void insertAll(Map<? extends K, ? extends V> entries) {
        this.withActualValue((Action<Configurer>)((Action)it -> it.putAll(entries)));
    }

    private void addExplicitCollector(MapCollector<K, V> collector, boolean ignoreAbsent) {
        this.assertCanMutate();
        MapSupplier<K, V> explicitValue = this.getExplicitValue(this.defaultValue).absentIgnoringIfNeeded(ignoreAbsent);
        this.setSupplier(explicitValue.plus(collector.absentIgnoringIfNeeded(ignoreAbsent)));
    }

    private Configurer getConfigurer() {
        return this.getConfigurer(false);
    }

    private Configurer getConfigurer(boolean ignoreAbsent) {
        return new Configurer(ignoreAbsent);
    }

    protected void withActualValue(Action<Configurer> action) {
        this.setToConventionIfUnset();
        action.execute((Object)this.getConfigurer(true));
    }

    private boolean isNoValueSupplier(MapSupplier<K, V> valueSupplier) {
        return valueSupplier instanceof NoValueSupplier;
    }

    private ProviderInternal<? extends Map<? extends K, ? extends V>> checkMapProvider(@javax.annotation.Nullable Provider<? extends Map<? extends K, ? extends V>> provider) {
        return this.checkMapProvider("value", provider);
    }

    private ProviderInternal<? extends Map<? extends K, ? extends V>> checkMapProvider(String valueKind, @javax.annotation.Nullable Provider<? extends Map<? extends K, ? extends V>> provider) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Cannot set the %s of a property using a null provider.", valueKind));
        }
        ProviderInternal<Map<K, V>> p = Providers.internal(provider);
        if (p.getType() != null && !Map.class.isAssignableFrom(p.getType())) {
            throw new IllegalArgumentException(String.format("Cannot set the %s of a property of type %s using a provider of type %s.", valueKind, Map.class.getName(), p.getType().getName()));
        }
        if (p instanceof MapProviderInternal) {
            Class providerKeyType = ((MapProviderInternal)p).getKeyType();
            Class providerValueType = ((MapProviderInternal)p).getValueType();
            if (!this.keyType.isAssignableFrom(providerKeyType) || !this.valueType.isAssignableFrom(providerValueType)) {
                throw new IllegalArgumentException(String.format("Cannot set the %s of a property of type %s with key type %s and value type %s using a provider with key type %s and value type %s.", valueKind, Map.class.getName(), this.keyType.getName(), this.valueType.getName(), providerKeyType.getName(), providerValueType.getName()));
            }
        }
        return p;
    }

    public MapProperty<K, V> convention(@javax.annotation.Nullable Map<? extends K, ? extends V> value) {
        if (value == null) {
            this.setConvention(this.noValueSupplier());
        } else {
            this.setConvention(new CollectingSupplier(new MapCollectors.EntriesFromMap<K, V>(value), false));
        }
        return this;
    }

    public MapProperty<K, V> convention(Provider<? extends Map<? extends K, ? extends V>> valueProvider) {
        this.setConvention(new CollectingSupplier(new MapCollectors.EntriesFromMapProvider(Providers.internal(valueProvider)), false));
        return this;
    }

    public MapProperty<K, V> unsetConvention() {
        this.discardConvention();
        return this;
    }

    public MapProperty<K, V> unset() {
        return (MapProperty)Cast.uncheckedNonnullCast((Object)super.unset());
    }

    private void unsetValueAndDefault() {
        this.defaultValue = this.noValueSupplier();
        this.unset();
    }

    public void fromState(ValueSupplier.ExecutionTimeValue<? extends Map<? extends K, ? extends V>> value) {
        if (value.isMissing()) {
            this.setSupplier(this.noValueSupplier());
        } else if (value.hasFixedValue()) {
            this.setSupplier(new FixedSupplier((Map)Cast.uncheckedNonnullCast(value.getFixedValue()), (ValueSupplier.SideEffect)Cast.uncheckedCast(value.getSideEffect())));
        } else {
            CollectingProvider asCollectingProvider = (CollectingProvider)Cast.uncheckedNonnullCast(value.getChangingValue());
            this.setSupplier(new CollectingSupplier(new MapCollectors.EntriesFromMapProvider(asCollectingProvider)));
        }
    }

    public Provider<Set<K>> keySet() {
        return new KeySetProvider();
    }

    public void replace(Transformer<? extends @Nullable Provider<? extends Map<? extends K, ? extends V>>, ? super Provider<Map<K, V>>> transformation) {
        Provider newValue = (Provider)transformation.transform(this.shallowCopy());
        if (newValue != null) {
            this.set(newValue);
        } else {
            this.set((Map)null);
        }
    }

    @Override
    protected String describeContents() {
        return String.format("Map(%s->%s, %s)", this.keyType.getSimpleName(), this.valueType.getSimpleName(), this.describeValue());
    }

    @Override
    protected ValueSupplier.Value<? extends Map<K, V>> calculateValueFrom(EvaluationContext.ScopeContext context, MapSupplier<K, V> value, ValueSupplier.ValueConsumer consumer) {
        return value.calculateValue(consumer);
    }

    @Override
    protected MapSupplier<K, V> finalValue(EvaluationContext.ScopeContext context, MapSupplier<K, V> value, ValueSupplier.ValueConsumer consumer) {
        ValueSupplier.Value<Map<K, V>> result = value.calculateValue(consumer);
        if (!result.isMissing()) {
            return new FixedSupplier<K, V>(result.getWithoutSideEffect(), (ValueSupplier.SideEffect)Cast.uncheckedCast(result.getSideEffect()));
        }
        if (result.getPathToOrigin().isEmpty()) {
            return this.noValueSupplier();
        }
        return new NoValueSupplier(result);
    }

    @Override
    protected ValueSupplier.ExecutionTimeValue<? extends Map<K, V>> calculateOwnExecutionTimeValue(EvaluationContext.ScopeContext context, MapSupplier<K, V> value) {
        return value.calculateExecutionTimeValue();
    }

    private static class AbsentIgnoringPlusCollector<K, V>
    extends AbstractPlusCollector<K, V> {
        private AbsentIgnoringPlusCollector(MapCollector<K, V> left, MapCollector<K, V> right) {
            super(left, right);
        }

        @Override
        public boolean calculatePresence(ValueSupplier.ValueConsumer consumer) {
            return true;
        }

        @Override
        public MapCollector<K, V> absentIgnoring() {
            return this;
        }

        @Override
        public ValueSupplier.Value<Void> collectEntries(ValueSupplier.ValueConsumer consumer, MapEntryCollector<K, V> collector, Map<K, V> dest) {
            LinkedHashMap candidates = new LinkedHashMap();
            ValueSupplier.Value<Void> leftValue = this.left.collectEntries(consumer, collector, candidates);
            if (leftValue.isMissing()) {
                return ValueSupplier.Value.present();
            }
            ValueSupplier.Value<Void> rightValue = this.right.collectEntries(consumer, collector, candidates);
            if (rightValue.isMissing()) {
                return ValueSupplier.Value.present();
            }
            dest.putAll(candidates);
            return ValueSupplier.Value.present().withSideEffect(ValueSupplier.SideEffect.fixedFrom(leftValue)).withSideEffect(ValueSupplier.SideEffect.fixedFrom(rightValue));
        }

        @Override
        public ValueSupplier.Value<Void> collectKeys(ValueSupplier.ValueConsumer consumer, ValueCollector<K> collector, ImmutableCollection.Builder<K> dest) {
            ImmutableSet.Builder candidateKeys = ImmutableSet.builder();
            ValueSupplier.Value<Void> leftResult = this.left.collectKeys(consumer, collector, candidateKeys);
            if (leftResult.isMissing()) {
                return ValueSupplier.Value.present();
            }
            ValueSupplier.Value<Void> rightResult = this.right.collectKeys(consumer, collector, candidateKeys);
            if (rightResult.isMissing()) {
                return ValueSupplier.Value.present();
            }
            dest.addAll((Iterable)candidateKeys.build());
            return rightResult;
        }

        @Override
        public void calculateExecutionTimeValue(Action<ValueSupplier.ExecutionTimeValue<? extends Map<? extends K, ? extends V>>> visitor) {
            boolean[] anyMissing = new boolean[]{false};
            ImmutableList.Builder toVisit = ImmutableList.builder();
            Action safeVisitor = value -> {
                if (value.isMissing()) {
                    anyMissing[0] = true;
                } else {
                    toVisit.add(value);
                }
            };
            this.left.calculateExecutionTimeValue(safeVisitor);
            this.right.calculateExecutionTimeValue(safeVisitor);
            if (!anyMissing[0]) {
                toVisit.build().forEach(it -> visitor.execute(it));
            }
        }
    }

    private static class PlusCollector<K, V>
    extends AbstractPlusCollector<K, V> {
        public PlusCollector(MapCollector<K, V> left, MapCollector<K, V> right) {
            super(left, right);
        }

        @Override
        public MapCollector<K, V> absentIgnoring() {
            return new AbsentIgnoringPlusCollector(this.left, this.right);
        }

        @Override
        public boolean calculatePresence(ValueSupplier.ValueConsumer consumer) {
            return this.left.calculatePresence(consumer) && this.right.calculatePresence(consumer);
        }

        @Override
        public ValueSupplier.Value<Void> collectEntries(ValueSupplier.ValueConsumer consumer, MapEntryCollector<K, V> collector, Map<K, V> dest) {
            ValueSupplier.Value<Void> leftValue = this.left.collectEntries(consumer, collector, dest);
            if (leftValue.isMissing()) {
                return leftValue;
            }
            ValueSupplier.Value<Void> rightValue = this.right.collectEntries(consumer, collector, dest);
            if (rightValue.isMissing()) {
                return rightValue;
            }
            return ValueSupplier.Value.present().withSideEffect(ValueSupplier.SideEffect.fixedFrom(leftValue)).withSideEffect(ValueSupplier.SideEffect.fixedFrom(rightValue));
        }

        @Override
        public ValueSupplier.Value<Void> collectKeys(ValueSupplier.ValueConsumer consumer, ValueCollector<K> collector, ImmutableCollection.Builder<K> dest) {
            ValueSupplier.Value<Void> result = this.left.collectKeys(consumer, collector, dest);
            if (result.isMissing()) {
                return result;
            }
            return this.right.collectKeys(consumer, collector, dest);
        }

        @Override
        public void calculateExecutionTimeValue(Action<ValueSupplier.ExecutionTimeValue<? extends Map<? extends K, ? extends V>>> visitor) {
            this.left.calculateExecutionTimeValue(visitor);
            this.right.calculateExecutionTimeValue(visitor);
        }
    }

    private static abstract class AbstractPlusCollector<K, V>
    implements MapCollector<K, V> {
        protected final MapCollector<K, V> left;
        protected final MapCollector<K, V> right;

        private AbstractPlusCollector(MapCollector<K, V> left, MapCollector<K, V> right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public ValueSupplier.ValueProducer getProducer() {
            return this.left.getProducer().plus(this.right.getProducer());
        }

        public String toString() {
            return this.left + " + " + this.right;
        }
    }

    private class Configurer {
        private final boolean ignoreAbsent;

        public Configurer(boolean ignoreAbsent) {
            this.ignoreAbsent = ignoreAbsent;
        }

        void addCollector(MapCollector<K, V> collector) {
            DefaultMapProperty.this.addExplicitCollector(collector, this.ignoreAbsent);
        }

        public void put(K key, V value) {
            Preconditions.checkNotNull(key, (Object)NULL_KEY_FORBIDDEN_MESSAGE);
            Preconditions.checkNotNull(value, (Object)NULL_VALUE_FORBIDDEN_MESSAGE);
            this.addCollector(new MapCollectors.SingleEntry(key, value));
        }

        public void put(K key, Provider<? extends V> providerOfValue) {
            Preconditions.checkNotNull(key, (Object)NULL_KEY_FORBIDDEN_MESSAGE);
            Preconditions.checkNotNull(providerOfValue, (Object)NULL_VALUE_FORBIDDEN_MESSAGE);
            ProviderInternal p = Providers.internal(providerOfValue);
            if (p.getType() != null && !DefaultMapProperty.this.valueType.isAssignableFrom(p.getType())) {
                throw new IllegalArgumentException(String.format("Cannot add an entry to a property of type %s with values of type %s using a provider of type %s.", Map.class.getName(), DefaultMapProperty.this.valueType.getName(), p.getType().getName()));
            }
            this.addCollector(new MapCollectors.EntryWithValueFromProvider(key, Providers.internal(providerOfValue)));
        }

        public void putAll(Map<? extends K, ? extends V> entries) {
            this.addCollector(new MapCollectors.EntriesFromMap(entries));
        }

        public void putAll(Provider<? extends Map<? extends K, ? extends V>> provider) {
            this.addCollector(new MapCollectors.EntriesFromMapProvider(DefaultMapProperty.this.checkMapProvider(provider)));
        }
    }

    private static class CollectingProvider<K, V>
    extends AbstractMinimalProvider<Map<K, V>> {
        private final List<ValueSupplier.ExecutionTimeValue<? extends Map<? extends K, ? extends V>>> values;

        public CollectingProvider(List<ValueSupplier.ExecutionTimeValue<? extends Map<? extends K, ? extends V>>> values) {
            this.values = values;
        }

        @Override
        @javax.annotation.Nullable
        public Class<Map<K, V>> getType() {
            return (Class)Cast.uncheckedCast(Map.class);
        }

        @Override
        public ValueSupplier.ExecutionTimeValue<? extends Map<K, V>> calculateExecutionTimeValue() {
            return ValueSupplier.ExecutionTimeValue.changingValue(this);
        }

        @Override
        protected ValueSupplier.Value<? extends Map<K, V>> calculateOwnValue(ValueSupplier.ValueConsumer consumer) {
            LinkedHashMap<? extends K, ? extends V> entries = new LinkedHashMap<K, V>();
            ValueSupplier.SideEffectBuilder sideEffectBuilder = ValueSupplier.SideEffect.builder();
            for (ValueSupplier.ExecutionTimeValue<Map<K, V>> executionTimeValue : this.values) {
                ValueSupplier.Value<Map<K, V>> value = executionTimeValue.toProvider().calculateValue(consumer);
                if (value.isMissing()) {
                    return ValueSupplier.Value.missing();
                }
                entries.putAll(value.getWithoutSideEffect());
                sideEffectBuilder.add(ValueSupplier.SideEffect.fixedFrom(value));
            }
            return ValueSupplier.Value.of(ImmutableMap.copyOf(entries)).withSideEffect(sideEffectBuilder.build());
        }
    }

    private class CollectingSupplier
    implements MapSupplier<K, V> {
        private final MapCollector<K, V> collector;
        private final boolean ignoreAbsent;

        public CollectingSupplier(MapCollector<K, V> collector, boolean ignoreAbsent) {
            this.collector = collector;
            this.ignoreAbsent = ignoreAbsent;
        }

        public CollectingSupplier(MapCollector<K, V> collector) {
            this(collector, false);
        }

        @Override
        public MapSupplier<K, V> absentIgnoring() {
            return this.ignoreAbsent ? this : new CollectingSupplier(this.collector, true);
        }

        @Override
        public boolean calculatePresence(ValueSupplier.ValueConsumer consumer) {
            return this.collector.calculatePresence(consumer);
        }

        @Override
        public ValueSupplier.Value<? extends Set<K>> calculateKeys(ValueSupplier.ValueConsumer consumer) {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            ValueSupplier.Value<Void> result = this.collector.collectKeys(consumer, DefaultMapProperty.this.keyCollector, (ImmutableCollection.Builder)builder);
            if (result.isMissing()) {
                return result.asType();
            }
            return ValueSupplier.Value.of(ImmutableSet.copyOf((Collection)builder.build())).withSideEffect(ValueSupplier.SideEffect.fixedFrom(result));
        }

        @Override
        public ValueSupplier.Value<? extends Map<K, V>> calculateValue(ValueSupplier.ValueConsumer consumer) {
            LinkedHashMap entries = new LinkedHashMap();
            ValueSupplier.Value<Void> result = this.collector.collectEntries(consumer, DefaultMapProperty.this.entryCollector, entries);
            if (result.isMissing()) {
                return result.asType();
            }
            return ValueSupplier.Value.of(ImmutableMap.copyOf(entries)).withSideEffect(ValueSupplier.SideEffect.fixedFrom(result));
        }

        @Override
        public MapSupplier<K, V> plus(MapCollector<K, V> addedCollector) {
            MapCollector left = this.collector.absentIgnoringIfNeeded(this.ignoreAbsent);
            MapCollector right = addedCollector;
            PlusCollector newCollector = new PlusCollector(left, right);
            return new CollectingSupplier(newCollector);
        }

        @Override
        public ValueSupplier.ExecutionTimeValue<? extends Map<K, V>> calculateExecutionTimeValue() {
            List execTimeValues = this.collectExecutionTimeValues();
            ValueSupplier.ExecutionTimeValue fixedOrMissing = this.fixedOrMissingValueOf(execTimeValues);
            return fixedOrMissing != null ? fixedOrMissing : ValueSupplier.ExecutionTimeValue.changingValue(new CollectingProvider(execTimeValues));
        }

        @javax.annotation.Nullable
        private ValueSupplier.ExecutionTimeValue<Map<K, V>> fixedOrMissingValueOf(List<ValueSupplier.ExecutionTimeValue<? extends Map<? extends K, ? extends V>>> values) {
            boolean fixed = true;
            boolean changingContent = false;
            for (ValueSupplier.ExecutionTimeValue value : values) {
                if (value.isMissing()) {
                    return ValueSupplier.ExecutionTimeValue.missing();
                }
                if (value.isChangingValue()) {
                    fixed = false;
                    continue;
                }
                if (!value.hasChangingContent()) continue;
                changingContent = true;
            }
            if (fixed) {
                ValueSupplier.SideEffectBuilder sideEffectBuilder = ValueSupplier.SideEffect.builder();
                ImmutableMap entries = this.collectEntries(values, sideEffectBuilder);
                return this.maybeChangingContent(ValueSupplier.ExecutionTimeValue.fixedValue(entries), changingContent).withSideEffect(sideEffectBuilder.build());
            }
            return null;
        }

        private List<ValueSupplier.ExecutionTimeValue<? extends Map<? extends K, ? extends V>>> collectExecutionTimeValues() {
            ArrayList values = new ArrayList();
            this.collector.calculateExecutionTimeValue(values::add);
            return values;
        }

        private ImmutableMap<K, V> collectEntries(List<ValueSupplier.ExecutionTimeValue<? extends Map<? extends K, ? extends V>>> values, ValueSupplier.SideEffectBuilder<? super Map<K, V>> sideEffectBuilder) {
            LinkedHashMap entries = new LinkedHashMap();
            for (ValueSupplier.ExecutionTimeValue value : values) {
                DefaultMapProperty.this.entryCollector.addAll(value.getFixedValue().entrySet(), entries);
                sideEffectBuilder.add(ValueSupplier.SideEffect.fixedFrom(value));
            }
            return ImmutableMap.copyOf(entries);
        }

        private ValueSupplier.ExecutionTimeValue<Map<K, V>> maybeChangingContent(ValueSupplier.ExecutionTimeValue<Map<K, V>> value, boolean changingContent) {
            return changingContent ? value.withChangingContent() : value;
        }

        @Override
        public ValueSupplier.ValueProducer getProducer() {
            return this.collector.getProducer();
        }

        public String toString() {
            return this.collector.toString();
        }
    }

    private static class FixedSupplier<K, V>
    implements MapSupplier<K, V> {
        private final Map<K, V> entries;
        private final ValueSupplier.SideEffect<? super Map<K, V>> sideEffect;

        public FixedSupplier(Map<K, V> entries, @javax.annotation.Nullable ValueSupplier.SideEffect<? super Map<K, V>> sideEffect) {
            this.entries = entries;
            this.sideEffect = sideEffect;
        }

        @Override
        public boolean calculatePresence(ValueSupplier.ValueConsumer consumer) {
            return true;
        }

        @Override
        public ValueSupplier.Value<? extends Map<K, V>> calculateValue(ValueSupplier.ValueConsumer consumer) {
            return ValueSupplier.Value.of(this.entries).withSideEffect(this.sideEffect);
        }

        @Override
        public ValueSupplier.Value<? extends Set<K>> calculateKeys(ValueSupplier.ValueConsumer consumer) {
            return ValueSupplier.Value.of(this.entries.keySet());
        }

        @Override
        public MapSupplier<K, V> plus(MapCollector<K, V> collector) {
            throw new UnsupportedOperationException();
        }

        @Override
        public MapSupplier<K, V> absentIgnoring() {
            return this;
        }

        @Override
        public ValueSupplier.ExecutionTimeValue<? extends Map<K, V>> calculateExecutionTimeValue() {
            return ValueSupplier.ExecutionTimeValue.fixedValue(this.entries).withSideEffect(this.sideEffect);
        }

        @Override
        public ValueSupplier.ValueProducer getProducer() {
            return ValueSupplier.ValueProducer.unknown();
        }

        public String toString() {
            return this.entries.toString();
        }
    }

    private class EmptySupplier
    implements MapSupplier<K, V> {
        private EmptySupplier() {
        }

        @Override
        public MapSupplier<K, V> absentIgnoring() {
            return this;
        }

        @Override
        public boolean calculatePresence(ValueSupplier.ValueConsumer consumer) {
            return true;
        }

        @Override
        public ValueSupplier.Value<? extends Map<K, V>> calculateValue(ValueSupplier.ValueConsumer consumer) {
            return ValueSupplier.Value.of(ImmutableMap.of());
        }

        @Override
        public ValueSupplier.Value<? extends Set<K>> calculateKeys(ValueSupplier.ValueConsumer consumer) {
            return ValueSupplier.Value.of(ImmutableSet.of());
        }

        @Override
        public MapSupplier<K, V> plus(MapCollector<K, V> collector) {
            return new CollectingSupplier(collector);
        }

        @Override
        public ValueSupplier.ExecutionTimeValue<? extends Map<K, V>> calculateExecutionTimeValue() {
            return ValueSupplier.ExecutionTimeValue.fixedValue(ImmutableMap.of());
        }

        @Override
        public ValueSupplier.ValueProducer getProducer() {
            return ValueSupplier.ValueProducer.noProducer();
        }

        public String toString() {
            return "{}";
        }
    }

    private class NoValueSupplier
    implements MapSupplier<K, V> {
        private final ValueSupplier.Value<? extends Map<K, V>> value;

        public NoValueSupplier(ValueSupplier.Value<? extends Map<K, V>> value) {
            this.value = value.asType();
            assert (value.isMissing());
        }

        @Override
        public MapSupplier<K, V> absentIgnoring() {
            return DefaultMapProperty.this.emptySupplier();
        }

        @Override
        public boolean calculatePresence(ValueSupplier.ValueConsumer consumer) {
            return false;
        }

        @Override
        public ValueSupplier.Value<? extends Map<K, V>> calculateValue(ValueSupplier.ValueConsumer consumer) {
            return this.value;
        }

        @Override
        public ValueSupplier.Value<? extends Set<K>> calculateKeys(ValueSupplier.ValueConsumer consumer) {
            return this.value.asType();
        }

        @Override
        public MapSupplier<K, V> plus(MapCollector<K, V> collector) {
            return this;
        }

        @Override
        public ValueSupplier.ExecutionTimeValue<? extends Map<K, V>> calculateExecutionTimeValue() {
            return ValueSupplier.ExecutionTimeValue.missing();
        }

        @Override
        public ValueSupplier.ValueProducer getProducer() {
            return ValueSupplier.ValueProducer.unknown();
        }

        public String toString() {
            return this.value.toString();
        }
    }

    private class KeySetProvider
    extends AbstractMinimalProvider<Set<K>> {
        private KeySetProvider() {
        }

        @Override
        @javax.annotation.Nullable
        public Class<Set<K>> getType() {
            return Set.class;
        }

        @Override
        protected ValueSupplier.Value<? extends Set<K>> calculateOwnValue(ValueSupplier.ValueConsumer consumer) {
            try (EvaluationContext.ScopeContext context = DefaultMapProperty.this.openScope();){
                DefaultMapProperty.this.beforeRead(context, consumer);
                ValueSupplier.Value value = ((MapSupplier)DefaultMapProperty.this.getSupplier(context)).calculateKeys(consumer);
                return value;
            }
        }
    }

    private class EntryProvider
    extends AbstractMinimalProvider<V> {
        private final K key;

        public EntryProvider(K key) {
            this.key = key;
        }

        @Override
        @javax.annotation.Nullable
        public Class<V> getType() {
            return DefaultMapProperty.this.valueType;
        }

        @Override
        protected ValueSupplier.Value<? extends V> calculateOwnValue(ValueSupplier.ValueConsumer consumer) {
            ValueSupplier.Value result = DefaultMapProperty.this.calculateOwnValue(consumer);
            if (result.isMissing()) {
                return result.asType();
            }
            ValueSupplier.Value resultValue = ValueSupplier.Value.ofNullable(((Map)result.getWithoutSideEffect()).get(this.key));
            return resultValue.withSideEffect(ValueSupplier.SideEffect.fixedFrom(result));
        }
    }
}

